/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.media.MediaExtractor;
import android.net.Uri;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.MediaFormatHolder;
import com.google.android.exoplayer.SampleHolder;
import com.google.android.exoplayer.SampleSource;
import com.google.android.exoplayer.drm.DrmInitData;
import com.google.android.exoplayer.extractor.mp4.PsshAtomUtil;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.Util;
import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;

@Deprecated
@TargetApi(value=16)
public final class FrameworkSampleSource
implements SampleSource,
SampleSource.SampleSourceReader {
    private static final int ALLOWED_FLAGS_MASK = 3;
    private static final int TRACK_STATE_DISABLED = 0;
    private static final int TRACK_STATE_ENABLED = 1;
    private static final int TRACK_STATE_FORMAT_SENT = 2;
    private final Context context;
    private final Uri uri;
    private final Map<String, String> headers;
    private final FileDescriptor fileDescriptor;
    private final long fileDescriptorOffset;
    private final long fileDescriptorLength;
    private IOException preparationError;
    private MediaExtractor extractor;
    private MediaFormat[] trackFormats;
    private boolean prepared;
    private int remainingReleaseCount;
    private int[] trackStates;
    private boolean[] pendingDiscontinuities;
    private long lastSeekPositionUs;
    private long pendingSeekPositionUs;

    public FrameworkSampleSource(Context context, Uri uri, Map<String, String> map) {
        Assertions.checkState(Util.SDK_INT >= 16);
        this.context = Assertions.checkNotNull(context);
        this.uri = Assertions.checkNotNull(uri);
        this.headers = map;
        this.fileDescriptor = null;
        this.fileDescriptorOffset = 0L;
        this.fileDescriptorLength = 0L;
    }

    public FrameworkSampleSource(FileDescriptor fileDescriptor, long l, long l2) {
        Assertions.checkState(Util.SDK_INT >= 16);
        this.fileDescriptor = Assertions.checkNotNull(fileDescriptor);
        this.fileDescriptorOffset = l;
        this.fileDescriptorLength = l2;
        this.context = null;
        this.uri = null;
        this.headers = null;
    }

    @Override
    public SampleSource.SampleSourceReader register() {
        ++this.remainingReleaseCount;
        return this;
    }

    @Override
    public boolean prepare(long l) {
        if (!this.prepared) {
            if (this.preparationError != null) {
                return false;
            }
            this.extractor = new MediaExtractor();
            try {
                if (this.context != null) {
                    this.extractor.setDataSource(this.context, this.uri, this.headers);
                } else {
                    this.extractor.setDataSource(this.fileDescriptor, this.fileDescriptorOffset, this.fileDescriptorLength);
                }
            }
            catch (IOException iOException) {
                this.preparationError = iOException;
                return false;
            }
            this.trackStates = new int[this.extractor.getTrackCount()];
            this.pendingDiscontinuities = new boolean[this.trackStates.length];
            this.trackFormats = new MediaFormat[this.trackStates.length];
            for (int i = 0; i < this.trackStates.length; ++i) {
                this.trackFormats[i] = FrameworkSampleSource.createMediaFormat(this.extractor.getTrackFormat(i));
            }
            this.prepared = true;
        }
        return true;
    }

    @Override
    public int getTrackCount() {
        Assertions.checkState(this.prepared);
        return this.trackStates.length;
    }

    @Override
    public MediaFormat getFormat(int n) {
        Assertions.checkState(this.prepared);
        return this.trackFormats[n];
    }

    @Override
    public void enable(int n, long l) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[n] == 0);
        this.trackStates[n] = 1;
        this.extractor.selectTrack(n);
        this.seekToUsInternal(l, l != 0L);
    }

    @Override
    public boolean continueBuffering(int n, long l) {
        return true;
    }

    @Override
    public long readDiscontinuity(int n) {
        if (this.pendingDiscontinuities[n]) {
            this.pendingDiscontinuities[n] = false;
            return this.lastSeekPositionUs;
        }
        return Long.MIN_VALUE;
    }

    @Override
    public int readData(int n, long l, MediaFormatHolder mediaFormatHolder, SampleHolder sampleHolder) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[n] != 0);
        if (this.pendingDiscontinuities[n]) {
            return -2;
        }
        if (this.trackStates[n] != 2) {
            mediaFormatHolder.format = this.trackFormats[n];
            mediaFormatHolder.drmInitData = Util.SDK_INT >= 18 ? this.getDrmInitDataV18() : null;
            this.trackStates[n] = 2;
            return -4;
        }
        int n2 = this.extractor.getSampleTrackIndex();
        if (n2 == n) {
            if (sampleHolder.data != null) {
                int n3 = sampleHolder.data.position();
                sampleHolder.size = this.extractor.readSampleData(sampleHolder.data, n3);
                sampleHolder.data.position(n3 + sampleHolder.size);
            } else {
                sampleHolder.size = 0;
            }
            sampleHolder.timeUs = this.extractor.getSampleTime();
            sampleHolder.flags = this.extractor.getSampleFlags() & 3;
            if (sampleHolder.isEncrypted()) {
                sampleHolder.cryptoInfo.setFromExtractorV16(this.extractor);
            }
            this.pendingSeekPositionUs = -1L;
            this.extractor.advance();
            return -3;
        }
        return n2 < 0 ? -1 : -2;
    }

    @Override
    public void disable(int n) {
        Assertions.checkState(this.prepared);
        Assertions.checkState(this.trackStates[n] != 0);
        this.extractor.unselectTrack(n);
        this.pendingDiscontinuities[n] = false;
        this.trackStates[n] = 0;
    }

    @Override
    public void maybeThrowError() throws IOException {
        if (this.preparationError != null) {
            throw this.preparationError;
        }
    }

    @Override
    public void seekToUs(long l) {
        Assertions.checkState(this.prepared);
        this.seekToUsInternal(l, false);
    }

    @Override
    public long getBufferedPositionUs() {
        Assertions.checkState(this.prepared);
        long l = this.extractor.getCachedDuration();
        if (l == -1L) {
            return -1L;
        }
        long l2 = this.extractor.getSampleTime();
        return l2 == -1L ? -3L : l2 + l;
    }

    @Override
    public void release() {
        Assertions.checkState(this.remainingReleaseCount > 0);
        if (--this.remainingReleaseCount == 0 && this.extractor != null) {
            this.extractor.release();
            this.extractor = null;
        }
    }

    @TargetApi(value=18)
    private DrmInitData getDrmInitDataV18() {
        Map map = this.extractor.getPsshInfo();
        if (map == null || map.isEmpty()) {
            return null;
        }
        DrmInitData.Mapped mapped = new DrmInitData.Mapped();
        for (UUID uUID : map.keySet()) {
            byte[] byArray = PsshAtomUtil.buildPsshAtom(uUID, (byte[])map.get(uUID));
            mapped.put(uUID, new DrmInitData.SchemeInitData("video/mp4", byArray));
        }
        return mapped;
    }

    private void seekToUsInternal(long l, boolean bl) {
        if (bl || this.pendingSeekPositionUs != l) {
            this.lastSeekPositionUs = l;
            this.pendingSeekPositionUs = l;
            this.extractor.seekTo(l, 0);
            for (int i = 0; i < this.trackStates.length; ++i) {
                if (this.trackStates[i] == 0) continue;
                this.pendingDiscontinuities[i] = true;
            }
        }
    }

    @SuppressLint(value={"InlinedApi"})
    private static MediaFormat createMediaFormat(android.media.MediaFormat mediaFormat) {
        Object object;
        String string = mediaFormat.getString("mime");
        String string2 = FrameworkSampleSource.getOptionalStringV16(mediaFormat, "language");
        int n = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "max-input-size");
        int n2 = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "width");
        int n3 = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "height");
        int n4 = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "rotation-degrees");
        int n5 = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "channel-count");
        int n6 = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "sample-rate");
        int n7 = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "encoder-delay");
        int n8 = FrameworkSampleSource.getOptionalIntegerV16(mediaFormat, "encoder-padding");
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        int n9 = 0;
        while (mediaFormat.containsKey("csd-" + n9)) {
            ByteBuffer byteBuffer = mediaFormat.getByteBuffer("csd-" + n9);
            object = new byte[byteBuffer.limit()];
            byteBuffer.get((byte[])object);
            arrayList.add((byte[])object);
            byteBuffer.flip();
            ++n9;
        }
        long l = mediaFormat.containsKey("durationUs") ? mediaFormat.getLong("durationUs") : -1L;
        object = new MediaFormat(null, string, -1, n, l, n2, n3, n4, -1.0f, n5, n6, string2, Long.MAX_VALUE, arrayList, false, -1, -1, n7, n8);
        ((MediaFormat)object).setFrameworkFormatV16(mediaFormat);
        return object;
    }

    @TargetApi(value=16)
    private static final String getOptionalStringV16(android.media.MediaFormat mediaFormat, String string) {
        return mediaFormat.containsKey(string) ? mediaFormat.getString(string) : null;
    }

    @TargetApi(value=16)
    private static final int getOptionalIntegerV16(android.media.MediaFormat mediaFormat, String string) {
        return mediaFormat.containsKey(string) ? mediaFormat.getInteger(string) : -1;
    }
}

