/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.MediaClock;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.StandaloneMediaClock;
import com.google.android.exoplayer.TrackRenderer;
import com.google.android.exoplayer.util.Assertions;
import com.google.android.exoplayer.util.PriorityHandlerThread;
import com.google.android.exoplayer.util.TraceUtil;
import com.google.android.exoplayer.util.Util;
import com.vcc.playerwrappersdk.a;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

final class ExoPlayerImplInternal
implements Handler.Callback {
    private static final String TAG = "ExoPlayerImplInternal";
    public static final int MSG_PREPARED = 1;
    public static final int MSG_STATE_CHANGED = 2;
    public static final int MSG_SET_PLAY_WHEN_READY_ACK = 3;
    public static final int MSG_ERROR = 4;
    private static final int MSG_PREPARE = 1;
    private static final int MSG_INCREMENTAL_PREPARE = 2;
    private static final int MSG_SET_PLAY_WHEN_READY = 3;
    private static final int MSG_STOP = 4;
    private static final int MSG_RELEASE = 5;
    private static final int MSG_SEEK_TO = 6;
    private static final int MSG_DO_SOME_WORK = 7;
    private static final int MSG_SET_RENDERER_SELECTED_TRACK = 8;
    private static final int MSG_CUSTOM = 9;
    private static final int PREPARE_INTERVAL_MS = 10;
    private static final int RENDERING_INTERVAL_MS = 10;
    private static final int IDLE_INTERVAL_MS = 1000;
    private final Handler handler;
    private final HandlerThread internalPlaybackThread;
    private final Handler eventHandler;
    private final StandaloneMediaClock standaloneMediaClock;
    private final AtomicInteger pendingSeekCount;
    private final List<TrackRenderer> enabledRenderers;
    private final MediaFormat[][] trackFormats;
    private final int[] selectedTrackIndices;
    private final long minBufferUs;
    private final long minRebufferUs;
    private TrackRenderer[] renderers;
    private TrackRenderer rendererMediaClockSource;
    private MediaClock rendererMediaClock;
    private boolean released;
    private boolean playWhenReady;
    private boolean rebuffering;
    private int state;
    private int customMessagesSent = 0;
    private int customMessagesProcessed = 0;
    private long lastSeekPositionMs;
    private long elapsedRealtimeUs;
    private volatile long durationUs;
    private volatile long positionUs;
    private volatile long bufferedPositionUs;

    public ExoPlayerImplInternal(Handler handler, boolean bl, int[] nArray, int n, int n2) {
        this.eventHandler = handler;
        this.playWhenReady = bl;
        this.minBufferUs = (long)n * 1000L;
        this.minRebufferUs = (long)n2 * 1000L;
        this.selectedTrackIndices = Arrays.copyOf(nArray, nArray.length);
        this.state = 1;
        this.durationUs = -1L;
        this.bufferedPositionUs = -1L;
        this.standaloneMediaClock = new StandaloneMediaClock();
        this.pendingSeekCount = new AtomicInteger();
        this.enabledRenderers = new ArrayList<TrackRenderer>(nArray.length);
        this.trackFormats = new MediaFormat[nArray.length][];
        this.internalPlaybackThread = new PriorityHandlerThread("ExoPlayerImplInternal:Handler", -16);
        this.internalPlaybackThread.start();
        this.handler = new Handler(this.internalPlaybackThread.getLooper(), (Handler.Callback)this);
    }

    public Looper getPlaybackLooper() {
        return this.internalPlaybackThread.getLooper();
    }

    public long getCurrentPosition() {
        return this.pendingSeekCount.get() > 0 ? this.lastSeekPositionMs : this.positionUs / 1000L;
    }

    public long getBufferedPosition() {
        return this.bufferedPositionUs == -1L ? -1L : this.bufferedPositionUs / 1000L;
    }

    public long getDuration() {
        return this.durationUs == -1L ? -1L : this.durationUs / 1000L;
    }

    public void prepare(TrackRenderer ... trackRendererArray) {
        this.handler.obtainMessage(1, (Object)trackRendererArray).sendToTarget();
    }

    public void setPlayWhenReady(boolean bl) {
        this.handler.obtainMessage(3, bl ? 1 : 0, 0).sendToTarget();
    }

    public void seekTo(long l) {
        this.lastSeekPositionMs = l;
        this.pendingSeekCount.incrementAndGet();
        this.handler.obtainMessage(6, Util.getTopInt(l), Util.getBottomInt(l)).sendToTarget();
    }

    public void stop() {
        this.handler.sendEmptyMessage(4);
    }

    public void setRendererSelectedTrack(int n, int n2) {
        this.handler.obtainMessage(8, n, n2).sendToTarget();
    }

    public void sendMessage(ExoPlayer.ExoPlayerComponent exoPlayerComponent, int n, Object object) {
        ++this.customMessagesSent;
        this.handler.obtainMessage(9, n, 0, (Object)Pair.create((Object)exoPlayerComponent, (Object)object)).sendToTarget();
    }

    public synchronized void blockingSendMessage(ExoPlayer.ExoPlayerComponent exoPlayerComponent, int n, Object object) {
        if (this.released) {
            a.b(TAG, "Sent message(" + n + ") after release. Message ignored.");
            return;
        }
        int n2 = this.customMessagesSent++;
        this.handler.obtainMessage(9, n, 0, (Object)Pair.create((Object)exoPlayerComponent, (Object)object)).sendToTarget();
        while (this.customMessagesProcessed <= n2) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public synchronized void release() {
        if (this.released) {
            return;
        }
        this.handler.sendEmptyMessage(5);
        while (!this.released) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        this.internalPlaybackThread.quit();
    }

    public boolean handleMessage(Message message) {
        try {
            switch (message.what) {
                case 1: {
                    this.prepareInternal((TrackRenderer[])message.obj);
                    return true;
                }
                case 2: {
                    this.incrementalPrepareInternal();
                    return true;
                }
                case 3: {
                    this.setPlayWhenReadyInternal(message.arg1 != 0);
                    return true;
                }
                case 7: {
                    this.doSomeWork();
                    return true;
                }
                case 6: {
                    this.seekToInternal(Util.getLong(message.arg1, message.arg2));
                    return true;
                }
                case 4: {
                    this.stopInternal();
                    return true;
                }
                case 5: {
                    this.releaseInternal();
                    return true;
                }
                case 9: {
                    this.sendMessageInternal(message.arg1, message.obj);
                    return true;
                }
                case 8: {
                    this.setRendererSelectedTrackInternal(message.arg1, message.arg2);
                    return true;
                }
            }
            return false;
        }
        catch (ExoPlaybackException exoPlaybackException) {
            a.b(TAG, "Internal track renderer error.", exoPlaybackException);
            this.eventHandler.obtainMessage(4, (Object)exoPlaybackException).sendToTarget();
            this.stopInternal();
            return true;
        }
        catch (RuntimeException runtimeException) {
            a.b(TAG, "Internal runtime error.", runtimeException);
            this.eventHandler.obtainMessage(4, (Object)new ExoPlaybackException(runtimeException, true)).sendToTarget();
            this.stopInternal();
            return true;
        }
    }

    private void setState(int n) {
        if (this.state != n) {
            this.state = n;
            this.eventHandler.obtainMessage(2, n, 0).sendToTarget();
        }
    }

    private void prepareInternal(TrackRenderer[] trackRendererArray) throws ExoPlaybackException {
        this.resetInternal();
        this.renderers = trackRendererArray;
        Arrays.fill((Object[])this.trackFormats, null);
        this.setState(2);
        this.incrementalPrepareInternal();
    }

    private void incrementalPrepareInternal() throws ExoPlaybackException {
        int n;
        long l = SystemClock.elapsedRealtime();
        boolean bl = true;
        for (int i = 0; i < this.renderers.length; ++i) {
            TrackRenderer trackRenderer = this.renderers[i];
            if (trackRenderer.getState() != 0 || (n = trackRenderer.prepare(this.positionUs)) != 0) continue;
            trackRenderer.maybeThrowError();
            bl = false;
        }
        if (!bl) {
            this.scheduleNextOperation(2, l, 10L);
            return;
        }
        long l2 = 0L;
        n = 1;
        boolean bl2 = true;
        for (int i = 0; i < this.renderers.length; ++i) {
            int n2;
            TrackRenderer trackRenderer = this.renderers[i];
            int n3 = trackRenderer.getTrackCount();
            MediaFormat[] mediaFormatArray = new MediaFormat[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                mediaFormatArray[n2] = trackRenderer.getFormat(n2);
            }
            this.trackFormats[i] = mediaFormatArray;
            if (n3 <= 0) continue;
            if (l2 != -1L) {
                long l3 = trackRenderer.getDurationUs();
                if (l3 == -1L) {
                    l2 = -1L;
                } else if (l3 != -2L) {
                    l2 = Math.max(l2, l3);
                }
            }
            if (0 > (n2 = this.selectedTrackIndices[i]) || n2 >= mediaFormatArray.length) continue;
            this.enableRenderer(trackRenderer, n2, false);
            n = n != 0 && trackRenderer.isEnded() ? 1 : 0;
            bl2 = bl2 && this.rendererReadyOrEnded(trackRenderer);
        }
        this.durationUs = l2;
        this.state = n != 0 && (l2 == -1L || l2 <= this.positionUs) ? 5 : (bl2 ? 4 : 3);
        this.eventHandler.obtainMessage(1, this.state, 0, (Object)this.trackFormats).sendToTarget();
        if (this.playWhenReady && this.state == 4) {
            this.startRenderers();
        }
        this.handler.sendEmptyMessage(7);
    }

    private void enableRenderer(TrackRenderer trackRenderer, int n, boolean bl) throws ExoPlaybackException {
        trackRenderer.enable(n, this.positionUs, bl);
        this.enabledRenderers.add(trackRenderer);
        MediaClock mediaClock = trackRenderer.getMediaClock();
        if (mediaClock != null) {
            Assertions.checkState(this.rendererMediaClock == null);
            this.rendererMediaClock = mediaClock;
            this.rendererMediaClockSource = trackRenderer;
        }
    }

    private boolean rendererReadyOrEnded(TrackRenderer trackRenderer) {
        if (trackRenderer.isEnded()) {
            return true;
        }
        if (!trackRenderer.isReady()) {
            return false;
        }
        if (this.state == 4) {
            return true;
        }
        long l = trackRenderer.getDurationUs();
        long l2 = trackRenderer.getBufferedPositionUs();
        long l3 = this.rebuffering ? this.minRebufferUs : this.minBufferUs;
        return l3 <= 0L || l2 == -1L || l2 == -3L || l2 >= this.positionUs + l3 || l != -1L && l != -2L && l2 >= l;
    }

    private void setPlayWhenReadyInternal(boolean bl) throws ExoPlaybackException {
        try {
            this.rebuffering = false;
            this.playWhenReady = bl;
            if (!bl) {
                this.stopRenderers();
                this.updatePositionUs();
            } else if (this.state == 4) {
                this.startRenderers();
                this.handler.sendEmptyMessage(7);
            } else if (this.state == 3) {
                this.handler.sendEmptyMessage(7);
            }
        }
        finally {
            this.eventHandler.obtainMessage(3).sendToTarget();
        }
    }

    private void startRenderers() throws ExoPlaybackException {
        this.rebuffering = false;
        this.standaloneMediaClock.start();
        for (int i = 0; i < this.enabledRenderers.size(); ++i) {
            this.enabledRenderers.get(i).start();
        }
    }

    private void stopRenderers() throws ExoPlaybackException {
        this.standaloneMediaClock.stop();
        for (int i = 0; i < this.enabledRenderers.size(); ++i) {
            this.ensureStopped(this.enabledRenderers.get(i));
        }
    }

    private void updatePositionUs() {
        if (this.rendererMediaClock != null && this.enabledRenderers.contains(this.rendererMediaClockSource) && !this.rendererMediaClockSource.isEnded()) {
            this.positionUs = this.rendererMediaClock.getPositionUs();
            this.standaloneMediaClock.setPositionUs(this.positionUs);
        } else {
            this.positionUs = this.standaloneMediaClock.getPositionUs();
        }
        this.elapsedRealtimeUs = SystemClock.elapsedRealtime() * 1000L;
    }

    private void doSomeWork() throws ExoPlaybackException {
        TraceUtil.beginSection("doSomeWork");
        long l = SystemClock.elapsedRealtime();
        long l2 = this.durationUs != -1L ? this.durationUs : Long.MAX_VALUE;
        boolean bl = true;
        boolean bl2 = true;
        this.updatePositionUs();
        for (int i = 0; i < this.enabledRenderers.size(); ++i) {
            TrackRenderer trackRenderer = this.enabledRenderers.get(i);
            trackRenderer.doSomeWork(this.positionUs, this.elapsedRealtimeUs);
            bl = bl && trackRenderer.isEnded();
            boolean bl3 = this.rendererReadyOrEnded(trackRenderer);
            if (!bl3) {
                trackRenderer.maybeThrowError();
            }
            boolean bl4 = bl2 = bl2 && bl3;
            if (l2 == -1L) continue;
            long l3 = trackRenderer.getDurationUs();
            long l4 = trackRenderer.getBufferedPositionUs();
            if (l4 == -1L) {
                l2 = -1L;
                continue;
            }
            if (l4 == -3L || l3 != -1L && l3 != -2L && l4 >= l3) continue;
            l2 = Math.min(l2, l4);
        }
        this.bufferedPositionUs = l2;
        if (bl && (this.durationUs == -1L || this.durationUs <= this.positionUs)) {
            this.setState(5);
            this.stopRenderers();
        } else if (this.state == 3 && bl2) {
            this.setState(4);
            if (this.playWhenReady) {
                this.startRenderers();
            }
        } else if (this.state == 4 && !bl2) {
            this.rebuffering = this.playWhenReady;
            this.setState(3);
            this.stopRenderers();
        }
        this.handler.removeMessages(7);
        if (this.playWhenReady && this.state == 4 || this.state == 3) {
            this.scheduleNextOperation(7, l, 10L);
        } else if (!this.enabledRenderers.isEmpty()) {
            this.scheduleNextOperation(7, l, 1000L);
        }
        TraceUtil.endSection();
    }

    private void scheduleNextOperation(int n, long l, long l2) {
        long l3 = l + l2;
        long l4 = l3 - SystemClock.elapsedRealtime();
        if (l4 <= 0L) {
            this.handler.sendEmptyMessage(n);
        } else {
            this.handler.sendEmptyMessageDelayed(n, l4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void seekToInternal(long l) throws ExoPlaybackException {
        try {
            if (l == this.positionUs / 1000L) {
                return;
            }
            this.rebuffering = false;
            this.positionUs = l * 1000L;
            this.standaloneMediaClock.stop();
            this.standaloneMediaClock.setPositionUs(this.positionUs);
            if (this.state == 1 || this.state == 2) {
                return;
            }
            for (int i = 0; i < this.enabledRenderers.size(); ++i) {
                TrackRenderer trackRenderer = this.enabledRenderers.get(i);
                this.ensureStopped(trackRenderer);
                trackRenderer.seekTo(this.positionUs);
            }
            this.setState(3);
            this.handler.sendEmptyMessage(7);
        }
        finally {
            this.pendingSeekCount.decrementAndGet();
        }
    }

    private void stopInternal() {
        this.resetInternal();
        this.setState(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInternal() {
        this.resetInternal();
        this.setState(1);
        ExoPlayerImplInternal exoPlayerImplInternal = this;
        synchronized (exoPlayerImplInternal) {
            this.released = true;
            this.notifyAll();
        }
    }

    private void resetInternal() {
        this.handler.removeMessages(7);
        this.handler.removeMessages(2);
        this.rebuffering = false;
        this.standaloneMediaClock.stop();
        if (this.renderers == null) {
            return;
        }
        for (int i = 0; i < this.renderers.length; ++i) {
            TrackRenderer trackRenderer = this.renderers[i];
            this.stopAndDisable(trackRenderer);
            this.release(trackRenderer);
        }
        this.renderers = null;
        this.rendererMediaClock = null;
        this.rendererMediaClockSource = null;
        this.enabledRenderers.clear();
    }

    private void stopAndDisable(TrackRenderer trackRenderer) {
        try {
            this.ensureDisabled(trackRenderer);
        }
        catch (ExoPlaybackException exoPlaybackException) {
            a.b(TAG, "Stop failed.", exoPlaybackException);
        }
        catch (RuntimeException runtimeException) {
            a.b(TAG, "Stop failed.", runtimeException);
        }
    }

    private void release(TrackRenderer trackRenderer) {
        try {
            trackRenderer.release();
        }
        catch (ExoPlaybackException exoPlaybackException) {
            a.b(TAG, "Release failed.", exoPlaybackException);
        }
        catch (RuntimeException runtimeException) {
            a.b(TAG, "Release failed.", runtimeException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void sendMessageInternal(int n, Object object) throws ExoPlaybackException {
        Object object2;
        try {
            object2 = (Pair)object;
            ((ExoPlayer.ExoPlayerComponent)object2.first).handleMessage(n, object2.second);
            if (this.state != 1 && this.state != 2) {
                this.handler.sendEmptyMessage(7);
            }
        }
        finally {
            object2 = this;
            synchronized (object2) {
                ++this.customMessagesProcessed;
                this.notifyAll();
            }
        }
    }

    private void setRendererSelectedTrackInternal(int n, int n2) throws ExoPlaybackException {
        boolean bl;
        if (this.selectedTrackIndices[n] == n2) {
            return;
        }
        this.selectedTrackIndices[n] = n2;
        if (this.state == 1 || this.state == 2) {
            return;
        }
        TrackRenderer trackRenderer = this.renderers[n];
        int n3 = trackRenderer.getState();
        if (n3 == 0 || n3 == -1 || trackRenderer.getTrackCount() == 0) {
            return;
        }
        boolean bl2 = n3 == 2 || n3 == 3;
        boolean bl3 = bl = 0 <= n2 && n2 < this.trackFormats[n].length;
        if (bl2) {
            if (!bl && trackRenderer == this.rendererMediaClockSource) {
                this.standaloneMediaClock.setPositionUs(this.rendererMediaClock.getPositionUs());
            }
            this.ensureDisabled(trackRenderer);
            this.enabledRenderers.remove(trackRenderer);
        }
        if (bl) {
            boolean bl4 = this.playWhenReady && this.state == 4;
            boolean bl5 = !bl2 && bl4;
            this.enableRenderer(trackRenderer, n2, bl5);
            if (bl4) {
                trackRenderer.start();
            }
            this.handler.sendEmptyMessage(7);
        }
    }

    private void ensureStopped(TrackRenderer trackRenderer) throws ExoPlaybackException {
        if (trackRenderer.getState() == 3) {
            trackRenderer.stop();
        }
    }

    private void ensureDisabled(TrackRenderer trackRenderer) throws ExoPlaybackException {
        this.ensureStopped(trackRenderer);
        if (trackRenderer.getState() == 2) {
            trackRenderer.disable();
            if (trackRenderer == this.rendererMediaClockSource) {
                this.rendererMediaClock = null;
                this.rendererMediaClockSource = null;
            }
        }
    }
}

