/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.android.exoplayer.ExoPlaybackException;
import com.google.android.exoplayer.ExoPlayer;
import com.google.android.exoplayer.ExoPlayerImplInternal;
import com.google.android.exoplayer.MediaFormat;
import com.google.android.exoplayer.TrackRenderer;
import com.vcc.playerwrappersdk.a;
import java.util.Arrays;
import java.util.concurrent.CopyOnWriteArraySet;

final class ExoPlayerImpl
implements ExoPlayer {
    private static final String TAG = "ExoPlayerImpl";
    private final Handler eventHandler;
    private final ExoPlayerImplInternal internalPlayer;
    private final CopyOnWriteArraySet<ExoPlayer.Listener> listeners;
    private final MediaFormat[][] trackFormats;
    private final int[] selectedTrackIndices;
    private boolean playWhenReady;
    private int playbackState;
    private int pendingPlayWhenReadyAcks;

    @SuppressLint(value={"HandlerLeak"})
    public ExoPlayerImpl(int n, int n2, int n3) {
        a.a(TAG, "Init 1.5.7");
        this.playWhenReady = false;
        this.playbackState = 1;
        this.listeners = new CopyOnWriteArraySet();
        this.trackFormats = new MediaFormat[n][];
        this.selectedTrackIndices = new int[n];
        this.eventHandler = new Handler(){

            public void handleMessage(Message message) {
                ExoPlayerImpl.this.handleEvent(message);
            }
        };
        this.internalPlayer = new ExoPlayerImplInternal(this.eventHandler, this.playWhenReady, this.selectedTrackIndices, n2, n3);
    }

    @Override
    public Looper getPlaybackLooper() {
        return this.internalPlayer.getPlaybackLooper();
    }

    @Override
    public void addListener(ExoPlayer.Listener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ExoPlayer.Listener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public int getPlaybackState() {
        return this.playbackState;
    }

    @Override
    public void prepare(TrackRenderer ... trackRendererArray) {
        Arrays.fill((Object[])this.trackFormats, null);
        this.internalPlayer.prepare(trackRendererArray);
    }

    @Override
    public int getTrackCount(int n) {
        return this.trackFormats[n] != null ? this.trackFormats[n].length : 0;
    }

    @Override
    public MediaFormat getTrackFormat(int n, int n2) {
        return this.trackFormats[n][n2];
    }

    @Override
    public void setSelectedTrack(int n, int n2) {
        if (this.selectedTrackIndices[n] != n2) {
            this.selectedTrackIndices[n] = n2;
            this.internalPlayer.setRendererSelectedTrack(n, n2);
        }
    }

    @Override
    public int getSelectedTrack(int n) {
        return this.selectedTrackIndices[n];
    }

    @Override
    public void setPlayWhenReady(boolean bl) {
        if (this.playWhenReady != bl) {
            this.playWhenReady = bl;
            ++this.pendingPlayWhenReadyAcks;
            this.internalPlayer.setPlayWhenReady(bl);
            for (ExoPlayer.Listener listener : this.listeners) {
                listener.onPlayerStateChanged(bl, this.playbackState);
            }
        }
    }

    @Override
    public boolean getPlayWhenReady() {
        return this.playWhenReady;
    }

    @Override
    public boolean isPlayWhenReadyCommitted() {
        return this.pendingPlayWhenReadyAcks == 0;
    }

    @Override
    public void seekTo(long l) {
        this.internalPlayer.seekTo(l);
    }

    @Override
    public void stop() {
        this.internalPlayer.stop();
    }

    @Override
    public void release() {
        this.internalPlayer.release();
        this.eventHandler.removeCallbacksAndMessages(null);
    }

    @Override
    public void sendMessage(ExoPlayer.ExoPlayerComponent exoPlayerComponent, int n, Object object) {
        this.internalPlayer.sendMessage(exoPlayerComponent, n, object);
    }

    @Override
    public void blockingSendMessage(ExoPlayer.ExoPlayerComponent exoPlayerComponent, int n, Object object) {
        this.internalPlayer.blockingSendMessage(exoPlayerComponent, n, object);
    }

    @Override
    public long getDuration() {
        return this.internalPlayer.getDuration();
    }

    @Override
    public long getCurrentPosition() {
        return this.internalPlayer.getCurrentPosition();
    }

    @Override
    public long getBufferedPosition() {
        return this.internalPlayer.getBufferedPosition();
    }

    @Override
    public int getBufferedPercentage() {
        long l = this.getBufferedPosition();
        long l2 = this.getDuration();
        return l == -1L || l2 == -1L ? 0 : (int)(l2 == 0L ? 100L : l * 100L / l2);
    }

    void handleEvent(Message message) {
        switch (message.what) {
            case 1: {
                System.arraycopy(message.obj, 0, this.trackFormats, 0, this.trackFormats.length);
                this.playbackState = message.arg1;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerStateChanged(this.playWhenReady, this.playbackState);
                }
                break;
            }
            case 2: {
                this.playbackState = message.arg1;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerStateChanged(this.playWhenReady, this.playbackState);
                }
                break;
            }
            case 3: {
                --this.pendingPlayWhenReadyAcks;
                if (this.pendingPlayWhenReadyAcks != 0) break;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayWhenReadyCommitted();
                }
                break;
            }
            case 4: {
                ExoPlaybackException exoPlaybackException = (ExoPlaybackException)message.obj;
                for (ExoPlayer.Listener listener : this.listeners) {
                    listener.onPlayerError(exoPlaybackException);
                }
                break;
            }
        }
    }
}

