package com.vcc.playerwrappersdk.utils;

import org.greenrobot.eventbus.EventBus;

/**
 * Created by TAKASHI20 on 7/16/2016.
 * Class owned by upstream_android at package ${PACKAGE_NAME}
 */
public class EBusData {

    private static EBusData ebusData;
    private EventBus eventBus;

    public EBusData() {
        eventBus = EventBus.getDefault();
    }

    public static EBusData getInstance() {
        if (ebusData == null)
            ebusData = new EBusData();
        return ebusData;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EventBus getEventBus() {
        return eventBus;
    }

    public void registerEventBus(Object object) {
        eventBus.register(object);
    }

    public void unregisterEventBus(Object object) {
        eventBus.unregister(object);
    }

    public void postEvent(Object object) {
        eventBus.post(object);
    }

    /**
     * @param object register event
     */
    public void postEventSticky(Object object) {
        eventBus.postSticky(object);
    }


}
