package com.vcc.playerads.manager;

import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.webkit.MimeTypeMap;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.DefaultRenderersFactory;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.ExoPlayerFactory;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.offline.FilteringManifestParser;
import com.google.android.exoplayer2.source.ExtractorMediaSource;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.dash.DashMediaSource;
import com.google.android.exoplayer2.source.dash.manifest.DashManifestParser;
import com.google.android.exoplayer2.source.hls.HlsMediaSource;
import com.google.android.exoplayer2.source.hls.playlist.DefaultHlsPlaylistParserFactory;
import com.google.android.exoplayer2.source.smoothstreaming.SsMediaSource;
import com.google.android.exoplayer2.source.smoothstreaming.manifest.SsManifestParser;
import com.google.android.exoplayer2.trackselection.AdaptiveTrackSelection;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelection;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DefaultBandwidthMeter;
import com.google.android.exoplayer2.upstream.DefaultDataSourceFactory;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSource;
import com.google.android.exoplayer2.upstream.DefaultHttpDataSourceFactory;
import com.google.android.exoplayer2.upstream.FileDataSourceFactory;
import com.google.android.exoplayer2.upstream.HttpDataSource;
import com.google.android.exoplayer2.upstream.cache.Cache;
import com.google.android.exoplayer2.upstream.cache.CacheDataSource;
import com.google.android.exoplayer2.upstream.cache.CacheDataSourceFactory;
import com.google.android.exoplayer2.upstream.cache.NoOpCacheEvictor;
import com.google.android.exoplayer2.upstream.cache.SimpleCache;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoListener;
import com.vcc.playerads.R;
import com.vcc.playerads.customviews.AspectRatioFrameLayout;
import com.vcc.playerads.customviews.CircularProgressBar;
import com.vcc.playerads.events.AdsEvent;
import com.vcc.playerads.events.IPlayer;
import com.vcc.playerads.events.OnAdsEventListener;
import com.vcc.playerads.models.AdsModel;
import com.vcc.playerads.models.VASTMediaFile;
import com.vcc.playerads.models.VMAPModel;
import com.vcc.playerads.natives.APIRequest;
import com.vcc.playerads.utils.Constants;
import com.vcc.playerads.utils.Log;
import com.vcc.playerads.utils.Utilities;
import com.vcc.playerads.utils.XmlTools;

import org.w3c.dom.Document;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

import static com.vcc.playerads.utils.Constants.PROCESS_MAX_VALUES;
import static com.vcc.playerads.utils.Constants.TIME_CHECK_ADS_BEFORE;
import static com.vcc.playerads.utils.Constants.TIME_MILISECOND;
import static com.vcc.playerads.utils.Log.LOGD;

class VASTLayout extends RelativeLayout implements Player.EventListener {

    //region Variable
    @SuppressLint("StaticFieldLeak")
    static final DefaultBandwidthMeter BANDWIDTH_METER = new DefaultBandwidthMeter();
    static final String DOWNLOAD_TRACKER_ACTION_FILE = "tracked_actions";
    static final String DOWNLOAD_CONTENT_DIRECTORY = "Addownloads";
    private static final String FOLDER_DOWNLOAD_VCC = "Downloaded/vccplayer-ads/ads/";
    private static final String TAG = VASTLayout.class.getName();
    private static final String THREAD_NAME_REQUEST_ADVERT = "ThreadRequestAds";
    private DataSource.Factory dataSourceFactory;
    private SimpleExoPlayer playerAds;
    private AspectRatioFrameLayout textureViewPlayer;
    private ProgressBar progressBarCurrentPosition;
    private LinearLayout linearProgressShowAds;
    private TextView textSkipAds;
    private TextView textLearnMore;
    private TextView textNumberOfAds;
    private TextView textAdsTitle;
    private TextView textAdsWillShowAfter;
    private ImageView imageMuteAds;
    private CircularProgressBar progessAdsWillShowSeconds;
    private FrameLayout layoutVideoAds;
    private IPlayer iPlayer;
    private Runnable runnableUpdateProgressAds;
    private Runnable runnableCheckAds;
    private long timeCanskip = Constants.SKIP_ADS_DEFAULT;
    private List<String> listTimeOfSetShowed = new ArrayList<>();
    private boolean isPrepared;
    private boolean isCheckAds = false;
    private boolean isWillShowAfter;
    private int numberAdsShow;
    private boolean isMute = false;
    private float musicVolumeLevel;
    private boolean isPlayingAds;
    private String urlRequestAds;
    private String stringSkipAdsAfter;
    private Map<String, List<AdsModel>> mapListVAST = new HashMap<>();
    private List<AdsModel> currentListVast = new CopyOnWriteArrayList<>();
    private int timePrepare = TIME_CHECK_ADS_BEFORE;
    private ProgressBar progressLoadAds;
    private OnAdsEventListener adsEventListener;
    private boolean isProgressAdsThirdQuartile;
    private boolean isProgressAdsMidPoint;
    private boolean isProgressAdsFirstQuartile;
    private boolean isProgressAdsStart;
    private boolean isRequestAds;
    private Thread threadRequestAds;
    private String timeOfSetPrepare = "";
    private boolean skipMultiAds = true;
    private boolean playMultible = true;
    private boolean isVast;

    private AdsModel currentAdsModel;
    private String keyTimOffset = "start";
    private Cache downloadCache;
    private File downloadDirectory;
    private PlayerEventListener playerEventListener;
    private boolean isSeekVideo = false;
    private int timeBeforeSeek = 0;
    private ArrayList<Object> arrListAdsAfterSeek;
    private String adsAfterSeek;
    private Runnable runableRequestAds = new Runnable() {
        @Override
        public void run() {
            if (isRequestAds)
                return;
            isRequestAds = true;
            if (!TextUtils.isEmpty(urlRequestAds)) {
                String xmlData = APIRequest.getRequest(urlRequestAds);
                if (!TextUtils.isEmpty(xmlData)) {
                    LOGD(TAG, "runableRequestAds xml " + xmlData);
                    try {
                        processingXMLData(xmlData);
                    } catch (Exception ignored) {
                        releaseVideoView();
                    }
//                    iPlayer.resume();

                } else {
                    LOGD(TAG, "runableRequestAds xml isEmpty");
                    pushEvent(AdsEvent.AdsEventType.noAdsToShow);
//                    iPlayer.resume();
                }
            } else {
                pushEvent(AdsEvent.AdsEventType.linkRequestEmpty);
//                iPlayer.resume();
                LOGD(TAG, "runableRequestAds xml isEmpty");
            }
            isRequestAds = false;
        }
    };
    //endregion

    //region Constructor
    VASTLayout(Context context) {
        this(context, null);
    }

    VASTLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    VASTLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
        pushEvent(AdsEvent.AdsEventType.creativeView);

    }

    private static int compare(VASTMediaFile lhs, VASTMediaFile rhs) {
        if ((lhs.width * lhs.height) >= (rhs.width * rhs.height)) {
            return 1;
        } else {
            return -1;
        }
    }
    //endregion

    private static CacheDataSourceFactory buildReadOnlyCacheDataSource(
            DefaultDataSourceFactory upstreamFactory, Cache cache) {
        return new CacheDataSourceFactory(
                cache,
                upstreamFactory,
                new FileDataSourceFactory(),
                /* cacheWriteDataSinkFactory= */ null,
                CacheDataSource.FLAG_IGNORE_CACHE_ON_ERROR,
                /* eventListener= */ null);
    }

    //region InitViews
    private void initView() {
        inflate(getContext(), R.layout.video_player_vast, this);
        bindView();
        setListener();
    }

    private void setListener() {

        createPlayer();

        progressLoadAds.getIndeterminateDrawable()
                .setColorFilter(getResources().getColor(R.color.color_progress_ads), PorterDuff.Mode.SRC_IN);

        progressBarCurrentPosition.setMax(PROCESS_MAX_VALUES);
        progressBarCurrentPosition.setProgress(0);

        progessAdsWillShowSeconds.setmMaxProgress(TIME_CHECK_ADS_BEFORE);
        progessAdsWillShowSeconds.setTextColor(Color.WHITE);
        progessAdsWillShowSeconds.setProgress(TIME_CHECK_ADS_BEFORE);

        textLearnMore.setOnClickListener(v -> clickThroughVideo());
        textSkipAds.setOnClickListener(v -> clickSkipAds());
        imageMuteAds.setOnClickListener(v -> clickMute());

        runnableUpdateProgressAds = this::updateProgressAdverts;
        runnableCheckAds = this::checkAdsRealTime;
    }

    private void createViewPlayerAds() {

        textureViewPlayer = new AspectRatioFrameLayout(getContext());
        FrameLayout.LayoutParams layoutParamsVideo = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        layoutParamsVideo.gravity = Gravity.CENTER;
        layoutVideoAds.addView(textureViewPlayer, layoutParamsVideo);

        playerAds.setVideoTextureView(textureViewPlayer);

        imageMuteAds.setImageResource(R.drawable.icon_unmute);
    }

    private void createPlayer() {
        Context context = getContext();

        dataSourceFactory = buildDataSourceFactory();

        TrackSelection.Factory trackSelectionFactory = new AdaptiveTrackSelection.Factory(BANDWIDTH_METER);

        @DefaultRenderersFactory.ExtensionRendererMode int extensionRendererMode = DefaultRenderersFactory.EXTENSION_RENDERER_MODE_ON;
        DefaultRenderersFactory renderersFactory =
                new DefaultRenderersFactory(context, extensionRendererMode);

        DefaultTrackSelector.Parameters trackSelectorParameters = new DefaultTrackSelector.ParametersBuilder().build();
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(trackSelectionFactory);
        trackSelector.setParameters(trackSelectorParameters);

        playerAds = ExoPlayerFactory.newSimpleInstance(context, renderersFactory, trackSelector, new DefaultLoadControl());
        playerEventListener = new VASTLayout.PlayerEventListener();
        playerAds.addListener(playerEventListener);
        playerAds.addVideoListener(playerEventListener);
//        playerAds.setVideoScalingMode(C.VIDEO_SCALING_MODE_SCALE_TO_FIT); /
    }
    //endregion

    //region Request ads and processing

    private void bindView() {
        textAdsWillShowAfter = findViewById(R.id.text_ads_will_show);
        progressLoadAds = findViewById(R.id.prgress_loading_ads);
        imageMuteAds = findViewById(R.id.image_mute);
        textNumberOfAds = findViewById(R.id.text_number_of_ads);
        textAdsTitle = findViewById(R.id.text_ads_title);
        progessAdsWillShowSeconds = findViewById(R.id.progress_time_before);
        textLearnMore = findViewById(R.id.text_learn_more);
        layoutVideoAds = findViewById(R.id.view_container_ads);
        linearProgressShowAds = findViewById(R.id.linear_progress_show_ads_before);
        textSkipAds = findViewById(R.id.text_skip_ads);
        progressBarCurrentPosition = findViewById(R.id.progress_current_position);
        stringSkipAdsAfter = getResources().getString(R.string.string_can_skip_after);
    }

    void setSkipAllAds(boolean skipAllAds) {
        this.skipMultiAds = skipAllAds;
    }

    void requestAds(String url) {
        requestAds(url, true);
    }

    void requestAds(String url, boolean resetAds) {
        this.urlRequestAds = url;

        if (resetAds) {
            resetAllAds();
            createPlayer();
        }
//        iPlayer.pause();

        try {
            layoutVideoAds.removeCallbacks(runnableCheckAds);
            removeCallbacks(runnableUpdateProgressAds);
        } catch (Exception ignored) {
        }

        threadRequestAds = new Thread(runableRequestAds, THREAD_NAME_REQUEST_ADVERT);
        threadRequestAds.start();
    }

    private void processingXMLData(String xml) {
        Document mainDoc = XmlTools.stringToDocument(xml);
        AdsModel adsModel = new AdsModel(mainDoc);

        List<AdsModel> listAllAds = adsModel.getAllVASTModels();
        if (listAllAds == null) {
            pushEvent(AdsEvent.AdsEventType.noAdsToShow);
            return;
        }
        //VMAP Type
        if (listAllAds.isEmpty()) {
            isVast = false;
            VMAPModel vmapModel = new VMAPModel(mainDoc);
            List<AdsModel> listAdsModel = vmapModel.getVASTModels();
            if (listAdsModel.size() <= 0) {
                pushEvent(AdsEvent.AdsEventType.noAdsToShow);
                return;
            }
            for (AdsModel adsModel1 : listAdsModel) {
                String key = checkKeyTimeOfSet(adsModel1.getTimeOffset());
                if (mapListVAST.containsKey(key)) {
                    List<AdsModel> listVast = mapListVAST.get(key);
                    if (listVast == null)
                        listVast = new CopyOnWriteArrayList<>();
                    listVast.add(adsModel1);
                    mapListVAST.remove(key);
                    mapListVAST.put(key, listVast);
                } else {
                    List<AdsModel> listVast = new CopyOnWriteArrayList<>();
                    listVast.add(adsModel1);
                    mapListVAST.put(key, listVast);

                }
            }

            //VAST Type
        } else {
            isVast = true;
            String key = checkKeyTimeOfSet(keyTimOffset);
            mapListVAST.put(key, listAllAds);
            LOGD(TAG, "getMediaFiles keyTimOffset " + keyTimOffset);
        }
        if (!mapListVAST.isEmpty()) {
            pushEvent(AdsEvent.AdsEventType.gotAds);
        } else {
            pushEvent(AdsEvent.AdsEventType.noAdsToShow);
        }
        layoutVideoAds.post(runnableCheckAds);
    }

    public String checkKeyTimeOfSet(String key) {
        String prepareDuration = Utilities.convertTimeToString((iPlayer.getDurationPlayer() / 1000));
        if (key.equals(prepareDuration)) {
            return "end";
        }
        return key;
    }

    protected void resetAllAds() {
        try {
            threadRequestAds.stop();
        } catch (Exception ignored) {
        }
        isRequestAds = false;
        layoutVideoAds.removeCallbacks(runnableCheckAds);

        removeCallbacks(runnableUpdateProgressAds);
        if (arrListAdsAfterSeek != null) {
            arrListAdsAfterSeek.clear();
        }
        listTimeOfSetShowed.clear();
        mapListVAST.clear();
        if (currentListVast != null) {
            currentListVast.clear();
        }
        isPlayingAds = false;
        isCheckAds = false;
        numberAdsShow = 0;
        timeOfSetPrepare = "";
        timePrepare = TIME_CHECK_ADS_BEFORE;
        if (textureViewPlayer != null) {
            try {
                layoutVideoAds.removeView(textureViewPlayer);
                layoutVideoAds.removeAllViews();
                textureViewPlayer = null;
            } catch (Exception ignored) {
            }

        }
        isVast = false;
        isPrepared = false;
        isWillShowAfter = false;
        timeCanskip = Constants.SKIP_ADS_DEFAULT;
        isPlayingAds = false;


        isProgressAdsStart = false;
        isProgressAdsThirdQuartile = false;
        isProgressAdsMidPoint = false;
        isProgressAdsFirstQuartile = false;


        setVisibilityAllView(GONE);

        if (playerAds != null) {
            playerAds.removeListener(playerEventListener);
            playerAds.removeVideoListener(playerEventListener);
            playerAds.setPlayWhenReady(false);
            playerAds.stop(true);
            playerAds.release();
            try {
                downloadCache.release();
            } catch (Exception ignored) {
            }
            downloadCache = null;
            playerAds = null;
        }
    }

    private void checkScreenForAdsAndShow(AdsModel adsModel) {
        // check Screen and show ads
        String adsUrl = getUrlVideoScreenForAds(adsModel);
        LOGD(TAG, "checkScreenForAdsAndShow: " + adsUrl);
        String timeOfSet = adsModel.getTimeOffset();
        // check Ads Available or not
//        if (!checkAdsShowed(timeOfSet)) {
//        iPlayer.pause();
        hideSkipAds();
        if (!checkAdsShowed(timeOfSet)) {
            listTimeOfSetShowed.add(timeOfSet);
        }

        showAds(adsModel, adsUrl);
        isPlayingAds = true;
//        } else {
//            if (!iPlayer.isPlaying())
//                clickSkipAds();
//        }

    }

    private String getUrlVideoScreenForAds(AdsModel adsModel) {
        if (!isVast) {
            int widthScreen = getWidth();
            int heightScreen = getHeight();
            //return a Screen for Ads
            VASTMediaFile vastMediaFile = selectViewForAds(widthScreen, heightScreen, adsModel.getMediaFiles());
            return vastMediaFile.getValue();
        } else {
            return adsModel.getMediaFiles().get(0).getValue();
        }
    }

    private boolean checkAdsShowed(String value) {
        if (listTimeOfSetShowed != null) {
            return listTimeOfSetShowed.contains(value);
        } else
            listTimeOfSetShowed = new CopyOnWriteArrayList<>();
        return false;
    }

    void setIPlayerContent(IPlayer iPlayer) {
        this.iPlayer = iPlayer;
    }

    private void checkAdsRealTime() {
        if (isPlayingAds) {
            layoutVideoAds.postDelayed(runnableCheckAds, Constants.TIME_DELAY);
            return;
        }


        if (!isCheckAds && iPlayer != null) {
            boolean isEnded = false;
            isCheckAds = true;

            int duration = iPlayer.getDurationPlayer();
            int currentPosition = iPlayer.getCurentTime();
            String preparePosition = Utilities.convertTimeToString((iPlayer.getCurentTime() / 1000) + TIME_CHECK_ADS_BEFORE);
            //check ads video


            if (mapListVAST.get("start") != null && !listTimeOfSetShowed.contains("start")) {
                isWillShowAfter = false;
                currentListVast = mapListVAST.get("start");

            }
//            if (currentPosition <= Constants.TIME_MILISECOND) {
//                isWillShowAfter = false;
//                currentListVast = mapListVAST.get("start");
//                if (currentListVast != null && !currentListVast.isEmpty()) {
//                    iPlayer.pause();
//                }
//            }
            else if ((currentPosition / Constants.TIME_MILISECOND) >= (duration / Constants.TIME_MILISECOND) && duration != -1) {
                isWillShowAfter = false;
                currentListVast = mapListVAST.get("end");

            } else if (mapListVAST.containsKey(preparePosition)) {
                isWillShowAfter = true;
                currentListVast = mapListVAST.get(preparePosition);
            } else if (arrListAdsAfterSeek != null && arrListAdsAfterSeek.size() > 0 && linearProgressShowAds.getVisibility() != View.VISIBLE) {
                isWillShowAfter = false;
                currentListVast = mapListVAST.get(adsAfterSeek);
            }


//            LOGD(TAG, "currentListVast:  " + (currentListVast == null ? "No Ads to show" : currentListVast.size()));

            if (currentListVast != null && !currentListVast.isEmpty()) {
                if (isWillShowAfter) {
                    showAfterSeconds();
                } else {
                    checkAds();
                }
            }

            isCheckAds = false;
            if (currentListVast == null || numberAdsShow >= currentListVast.size() && listTimeOfSetShowed != null) {

                if (listTimeOfSetShowed.size() >= mapListVAST.keySet().size()) {
                    isEnded = true;
                    layoutVideoAds.removeCallbacks(runnableCheckAds);
                    if (currentListVast != null && !currentListVast.isEmpty()) {
                        Log.LOGD(TAG, "checkAdsRealTime alladscompleted 1 ");
                        pushEvent(AdsEvent.AdsEventType.alladscompleted);
                    } else {
                        Log.LOGD(TAG, "currentListVast nul");
                        pushEvent(AdsEvent.AdsEventType.alladscompleted);
                    }
//                    iPlayer.resume();
                }

            }
            if (isEnded)
                return;
        }

        layoutVideoAds.postDelayed(runnableCheckAds, Constants.TIME_DELAY);
    }

    private void checkAds() {
        if (!isShowAds() && currentListVast != null ||
                (numberAdsShow < currentListVast.size() && currentListVast.size() > 0)) {
            try {
                LOGD(TAG, "checkAds numberOfAds multi " + numberAdsShow + " of " + currentListVast.size());
                AdsModel adsModel = currentListVast.get(numberAdsShow);
                if (adsModel != null) {
                    checkScreenForAdsAndShow(adsModel);
                }
            } catch (Exception e) {
                hideAds();
                e.getMessage();
            }

        }

    }

    @SuppressLint("SetTextI18n")
    private void showAfterSeconds() {
        if (linearProgressShowAds.getVisibility() != VISIBLE) {
            linearProgressShowAds.setVisibility(View.VISIBLE);
        }
        progessAdsWillShowSeconds.setProgress(timePrepare);
        LOGD(TAG, "checkAdsBefore TIME_CHECK_ADS_BEFORE: " + timePrepare);

        if (timePrepare == TIME_CHECK_ADS_BEFORE) {
            Animation tranLeftToRight = AnimationUtils.loadAnimation(getContext(), R.anim.translate_left_right);
            linearProgressShowAds.startAnimation(tranLeftToRight);

            if (playerAds == null) {
                createViewPlayerAds();
            }

            if (playerAds != null) {
                playerAds.setPlayWhenReady(false);
                playerAds.removeListener(playerEventListener);
                playerAds.stop(true);
                playerAds.addListener(playerEventListener);
            }
            isPrepared = false;
            numberAdsShow = 0;
            prepareAds();
        }
        if (timePrepare < 0) {
            Animation tranRightToLeft = AnimationUtils.loadAnimation(getContext(), R.anim.translate_right_left);
            linearProgressShowAds.startAnimation(tranRightToLeft);
            if (textureViewPlayer == null) {
                createViewPlayerAds();
            }
            isWillShowAfter = false;
            if (!checkAdsShowed(timeOfSetPrepare)) {
                listTimeOfSetShowed.add(timeOfSetPrepare);
            }

            timePrepare = TIME_CHECK_ADS_BEFORE;
            hideAfterSeconds();
            if (isPrepared && textureViewPlayer != null) {
                iPlayer.pause();
                setVisibilityAllView(VISIBLE);
                progressLoadAds.setVisibility(GONE);
                setTextForMultiAds();
                isPlayingAds = true;
//                pushEvent(AdsEvent.AdsEventType.start);
                post(runnableUpdateProgressAds);
                playerAds.setPlayWhenReady(true);
            }
            linearProgressShowAds.setVisibility(View.GONE);
            return;
        }
        timePrepare--;
    }

    private void setTextForMultiAds() {
        if (currentListVast != null && currentListVast.size() > 1) {
            if (playMultible) {
                textNumberOfAds.setVisibility(VISIBLE);
                textNumberOfAds.setText(String.format("%d of %d Ads", numberAdsShow + 1, currentListVast.size()));
            } else {
                textNumberOfAds.setVisibility(GONE);
            }
        } else {
            textNumberOfAds.setVisibility(GONE);
            textNumberOfAds.setText("");

        }
    }

    private void prepareAds() {
        if (currentListVast != null && numberAdsShow < currentListVast.size()) {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            currentAdsModel = adsModel;
            timeOfSetPrepare = adsModel.getTimeOffset();
            String urlTimeOfSetPrepare = getUrlVideoScreenForAds(adsModel);
            if (!TextUtils.isEmpty(urlTimeOfSetPrepare)) {
                MediaSource mediaSource = createMediaSource(urlTimeOfSetPrepare);
                playerAds.prepare(mediaSource);

                pushEvent(AdsEvent.AdsEventType.adbreakready);
            }

        }
    }

    private MediaSource createMediaSource(String url) {

        if (TextUtils.isEmpty(url))
            return null;
        Uri uri = Uri.parse(url);
        String extension = MimeTypeMap.getFileExtensionFromUrl(url);

        @C.ContentType int type = Util.inferContentType(uri, extension);
        switch (type) {
            case C.TYPE_DASH:
                return new DashMediaSource.Factory(dataSourceFactory)
                        .setManifestParser(
                                new FilteringManifestParser<>(new DashManifestParser(), Collections.emptyList()))
                        .createMediaSource(uri);
            case C.TYPE_SS:
                return new SsMediaSource.Factory(dataSourceFactory)
                        .setManifestParser(
                                new FilteringManifestParser<>(new SsManifestParser(), Collections.emptyList()))
                        .createMediaSource(uri);
            case C.TYPE_HLS:
                return new HlsMediaSource.Factory(dataSourceFactory)
                        .setPlaylistParserFactory(
                                new DefaultHlsPlaylistParserFactory())
                        .createMediaSource(uri);
            case C.TYPE_OTHER:
                return new ExtractorMediaSource.Factory(dataSourceFactory).createMediaSource(uri);
            default: {
                throw new IllegalStateException("Unsupported type: " + type);
            }
        }
    }

    private File getDownloadDirectory() {
        if (downloadDirectory == null) {
            downloadDirectory = getContext().getExternalFilesDir(FOLDER_DOWNLOAD_VCC);
            if (downloadDirectory == null) {
                downloadDirectory = getContext().getFilesDir();
            }
        }
        return downloadDirectory;
    }

    private synchronized Cache getDownloadCache() {
        if (downloadCache == null) {

            File downloadContentDirectory = new File(getDownloadDirectory(), DOWNLOAD_CONTENT_DIRECTORY);
            downloadCache = new SimpleCache(downloadContentDirectory, new NoOpCacheEvictor());


        }
        return downloadCache;
    }

    private DataSource.Factory buildDataSourceFactory() {
        DefaultDataSourceFactory upstreamFactory =
                new DefaultDataSourceFactory(getContext(), null, buildHttpDataSourceFactory());
        return buildReadOnlyCacheDataSource(upstreamFactory, getDownloadCache());
    }

    /**
     * Returns a {@link HttpDataSource.Factory}.
     */
    private HttpDataSource.Factory buildHttpDataSourceFactory() {
        return new DefaultHttpDataSourceFactory(Util.getUserAgent(getContext(), "VCCPlayer-AdsPlugin"),
                null,
                DefaultHttpDataSource.DEFAULT_CONNECT_TIMEOUT_MILLIS,
                DefaultHttpDataSource.DEFAULT_READ_TIMEOUT_MILLIS,
                true
        );
    }


    void hideAfterSeconds() {
        linearProgressShowAds.setVisibility(View.GONE);
    }
    //endregion

    //region Custom show/hide components

    void showSkipAds() {
        textSkipAds.setVisibility(VISIBLE);
    }


    void hideSkipAds() {
        textSkipAds.setVisibility(View.GONE);
    }

    @SuppressLint("DefaultLocale")
    private void showAds(AdsModel adsModel, String adsUrl) {
        adsModel.setCurrentUrlVideo(adsUrl);
        currentAdsModel = adsModel;
        if (textureViewPlayer == null) {
            createViewPlayerAds();

        }

        if (playerAds != null) {
            playerAds.setPlayWhenReady(false);

            playerAds.removeListener(playerEventListener);
            playerAds.stop(true);
            playerAds.addListener(playerEventListener);
        }

        Uri adsUri;
        try {
            adsUri = Uri.parse(adsUrl);
            if (adsUri == null)
                throw new NullPointerException("Adverts uri is null.");
        } catch (Exception e) {
            hideAds();
            return;
        }

        MediaSource mediaSource = createMediaSource(adsUrl);
        playerAds.prepare(mediaSource);

        //get From vastmodel
        try {
            String skipOfSet = adsModel.getSkipOffset();//hh:mm:ss
            String[] units = skipOfSet.split(":"); //will break the string up into an array
            int hours = Integer.parseInt(units[0]); //first element
            int minutes = Integer.parseInt(units[1]); //first element
            int seconds = Integer.parseInt(units[2]); //second element

            Constants.SKIP_ADS_DEFAULT = 3600 * hours + 60 * minutes + seconds;
        } catch (Exception e) {
            Constants.SKIP_ADS_DEFAULT = 6;
        }

        timeCanskip = Constants.SKIP_ADS_DEFAULT;
//        if (adsEventListener != null) {
//            pushEvent(AdsEvent.AdsEventType.loaded);
//        }
    }

    private void showViewAdsWhenReady() {
        pushEvent(AdsEvent.AdsEventType.contentpauserequested);
        progressBarCurrentPosition.setProgress(0);
        progressBarCurrentPosition.setVisibility(VISIBLE);
        progressLoadAds.setVisibility(GONE);
        imageMuteAds.setVisibility(GONE);
        textLearnMore.setVisibility(VISIBLE);
//        textSkipAds.setVisibility(VISIBLE);
        layoutVideoAds.setVisibility(View.VISIBLE);
        textureViewPlayer.setVisibility(VISIBLE);
        textAdsTitle.setVisibility(VISIBLE);
        textAdsTitle.setText(currentListVast.get(numberAdsShow).getAdsTitles());
    }

    private void pushEvent(AdsEvent.AdsEventType eventType) {
        try {
            AdsEvent adsEvent = new AdsEvent() {
                @Override
                public AdsEventType getType() {
                    return eventType;
                }

                @Override
                public AdsModel getAds() {
                    return null;
                }
            };
            if (adsEventListener != null) {
                adsEventListener.onAdsEventListener(adsEvent);
            }
        } catch (Exception e) {
        }
//        sendTracking(ads, eventType);
    }

    private void sendTracking(AdsModel ads, AdsEvent.AdsEventType eventType) {
//        if (ads == null) {
//            return;
//        }
//        Map<AdsEvent.AdsEventType, List<String>> mapTracking = ads.getTrackingUrls();
//        if (mapTracking != null && mapTracking.containsKey(eventType) && mapTracking.get(eventType) != null) {
//            if (mapTracking.get(eventType).size() > 0) {
//                try {
//                    APIRequest.postRequest((mapTracking.get(eventType)).get(0));
//                } catch (Exception ignored) {
//                }
//            }
//        }
    }


    void hideAds() {
        numberAdsShow++;
        if (currentListVast != null && numberAdsShow >= currentListVast.size()) {
            currentListVast.clear();
            currentListVast = null;
            numberAdsShow = 0;
            seekVideoPlayer2Second();
            releaseVideoView();

            Animation aniFade = AnimationUtils.loadAnimation(getContext(), R.anim.fade_out_ads);
            layoutVideoAds.startAnimation(aniFade);

            setVisibilityAllView(GONE);
            playerAds.setPlayWhenReady(false);
            playerAds.removeListener(playerEventListener);
            isPlayingAds = false;
            isWillShowAfter = false;
            isPrepared = false;
            return;
        }

        if (playerAds != null) {
            playerAds.setPlayWhenReady(false);
            playerAds.removeListener(playerEventListener);
            playerAds.stop(true);
            playerAds.addListener(playerEventListener);
        }

        isPrepared = false;
        isPlayingAds = false;
        isProgressAdsStart = false;
        isProgressAdsThirdQuartile = false;
        isProgressAdsMidPoint = false;
        isProgressAdsFirstQuartile = false;

        LOGD(TAG, "checkProgressAds : >= 99 : " + "99%   currentListVast: "
                + currentListVast.get(0).getAdsTitles());


    }

    private void setVisibilityAllView(int visibilityAllView) {

        progressLoadAds.setVisibility(visibilityAllView);
        progressBarCurrentPosition.setVisibility(visibilityAllView);
        linearProgressShowAds.setVisibility(visibilityAllView);
        imageMuteAds.setVisibility(GONE);
        textLearnMore.setVisibility(visibilityAllView);
        textSkipAds.setVisibility(visibilityAllView);
        textNumberOfAds.setVisibility(visibilityAllView);
        layoutVideoAds.setVisibility(visibilityAllView);
        textAdsTitle.setVisibility(visibilityAllView);
    }

    private void releaseVideoView() {

        try {
            playerAds.setVideoTextureView(null);
            layoutVideoAds.removeView(textureViewPlayer);
            layoutVideoAds.removeAllViews();
            textureViewPlayer = null;
        } catch (Exception ignored) {
        }
    }

    private void seekVideoPlayer2Second() {
        int currentTime = iPlayer.getCurentTime();
        int durationPlayer = iPlayer.getDurationPlayer();
        if (currentTime - 2000 <= 0)
            currentTime = 0;
        else if ((currentTime / Constants.TIME_MILISECOND) < (durationPlayer / Constants.TIME_MILISECOND))
            currentTime -= 2000;
        else
            currentTime = -1000;
        if (currentTime != -1000) {
            iPlayer.seekTo(currentTime);
            pushEvent(AdsEvent.AdsEventType.contentresumerequested);
        }

    }


    boolean isShowAds() {
        return layoutVideoAds.getVisibility() == View.VISIBLE;
    }

    private VASTMediaFile selectViewForAds(int screenWidth, int screenHeight, List<VASTMediaFile> listSizeSupport) {
        Collections.sort(listSizeSupport, VASTLayout::compare);
        VASTMediaFile sizeSelected = new VASTMediaFile();
        for (VASTMediaFile size : listSizeSupport) {
            if (size.width >= screenWidth && size.height >= screenHeight) {
                sizeSelected = size;
                return sizeSelected;
            }
        }
        if (sizeSelected.getValue() == null && listSizeSupport.size() > 0) {
            try {
                sizeSelected = listSizeSupport.get(listSizeSupport.size() - 1);
            } catch (Exception ignored) {
            }
        }
        return sizeSelected;
    }
    //endregion

    //region Handle video player ads
    public void onPrepared() {
        setVolumeAds();
        if (isPrepared)
            return;

        isPrepared = true;

        if (!isWillShowAfter) {
            setTextForMultiAds();
            progressLoadAds.setVisibility(GONE);
            if (playerAds != null) {
                iPlayer.pause();
                if (numberAdsShow <= 0) {
                    Animation aniFadeIn = AnimationUtils.loadAnimation(getContext(), R.anim.fade_in_ads);
                    layoutVideoAds.startAnimation(aniFadeIn);
                }
                showViewAdsWhenReady();
                playerAds.setPlayWhenReady(true);
            }
            pushEvent(AdsEvent.AdsEventType.loaded);
        }

        postDelayed(runnableUpdateProgressAds, Constants.TIME_DELAY);
    }

    public void onCompletion() {
        if (!playMultible && currentListVast != null) {
            numberAdsShow = currentListVast.size();
        }
        removeCallbacks(runnableUpdateProgressAds);
        if (currentListVast != null) {
            hideAds();
        }
    }


    int getProgressAds() {
        if (playerAds != null) {
            return (int) (((float) playerAds.getCurrentPosition() / playerAds.getDuration()) * PROCESS_MAX_VALUES);
        }
        return 0;
    }

    @SuppressLint("SetTextI18n")
    private void updateProgressAdverts() {
        //TODO update current time of ad
        if (textureViewPlayer == null) {
            return;
        }

        int time = getProgressAds();
        if (progressBarCurrentPosition.getProgress() > time) {
            progressBarCurrentPosition.setProgress(0);
        }
        checkProgressAds(time);
        ObjectAnimator animation = ObjectAnimator.ofInt(progressBarCurrentPosition, "progress", time);
        animation.setDuration(1000); // 0.5 second

        animation.setInterpolator(new LinearInterpolator());
        animation.start();
        timeCanskip = Constants.SKIP_ADS_DEFAULT - playerAds.getCurrentPosition() / 1000;
        if (timeCanskip > 0) {
            if (isPlaying())
                showSkipAds();
            else
                hideSkipAds();
            textSkipAds.setText(stringSkipAdsAfter + " " + timeCanskip);
            textSkipAds.setEnabled(false);
        } else {
            textSkipAds.setText(getContext().getString(R.string.string_skipable));
            textSkipAds.setEnabled(true);
        }

        postDelayed(runnableUpdateProgressAds, Constants.TIME_DELAY);

    }

    private boolean isPlaying() {
        return playerAds != null && playerAds.getPlayWhenReady()
                && playerAds.getPlaybackState() != Player.STATE_ENDED
                && playerAds.getPlaybackState() != Player.STATE_IDLE;
    }

    private void checkProgressAds(int progressVideo) {
        pushEvent(AdsEvent.AdsEventType.adprogress);
        if (progressVideo >= 75 && !isProgressAdsThirdQuartile) {

            LOGD(TAG, "checkProgressAds : >= 75 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
            pushEvent(AdsEvent.AdsEventType.thirdQuartile);
            isProgressAdsThirdQuartile = true;
        }
        if (progressVideo >= 50 && !isProgressAdsMidPoint) {
            LOGD(TAG, "checkProgressAds : >= 50 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
            pushEvent(AdsEvent.AdsEventType.midpoint);
            isProgressAdsMidPoint = true;
        }
        if (progressVideo >= 25 && !isProgressAdsFirstQuartile) {

            LOGD(TAG, "checkProgressAds : >= 25 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
            pushEvent(AdsEvent.AdsEventType.firstQuartile);
            isProgressAdsFirstQuartile = true;
        }
        if (progressVideo >= 0 && !isProgressAdsStart) {
            LOGD(TAG, "checkProgressAds : >= 0 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
            pushEvent(AdsEvent.AdsEventType.start);
            isProgressAdsStart = true;
        }

    }
    //endregion

    //region Action click view
    private void clickMute() {
        AdsModel adsModel;
        if (currentListVast != null && currentListVast.size() > 0) {
            adsModel = currentListVast.get(numberAdsShow);
        } else {
            adsModel = null;
        }
        if (textureViewPlayer == null)
            return;
        if (isPrepared) {

            if (!isMute) {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_mute));
                playerAds.setVolume(0.0f);
                pushEvent(AdsEvent.AdsEventType.mute);
            } else {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_unmute));
                playerAds.setVolume(musicVolumeLevel);
                pushEvent(AdsEvent.AdsEventType.unmute);

            }
            isMute = !isMute;
        }

    }

    private void setMute(boolean mute) {
        if (textureViewPlayer == null) {
            isMute = mute;
            return;
        }
        if (isPrepared) {
            if (mute) {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_mute));
                playerAds.setVolume(0.0f);
                pushEvent(AdsEvent.AdsEventType.mute);
            } else {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_unmute));
                playerAds.setVolume(musicVolumeLevel);
                pushEvent(AdsEvent.AdsEventType.unmute);

            }
        }
        isMute = mute;

    }


    void clickThroughVideo() {
        try {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            if (!TextUtils.isEmpty(adsModel.getVideoClicks().getClickThrough())) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW,
                        Uri.parse(adsModel.getVideoClicks().getClickThrough()));
                getContext().startActivity(browserIntent);
                pushEvent(AdsEvent.AdsEventType.clicked);
            }

        } catch (Exception e) {

        }
    }

    void clickSkipAds() {
        //TODO an ad hien tai dang choi hay la an het so luong ads co the choi tai thoi diem hien tai
        if (skipMultiAds && currentListVast != null) {
            numberAdsShow = currentListVast.size();
        }
        pushEvent(AdsEvent.AdsEventType.skipped);
        hideAds();
    }

    public boolean onError(Exception e) {
        try {
            hideAds();
            pushEvent(AdsEvent.AdsEventType.playError);
            LOGD(TAG, "onError Exception: " + e.getMessage());
        } catch (Exception ignored) {


        }


        return true;
    }

    void setAdsEventListener(OnAdsEventListener adsEventListener) {
        this.adsEventListener = adsEventListener;
    }

    List<String> getListMarkerAds() {

        List<String> mapValues = new ArrayList<>(mapListVAST.keySet());
        Collections.sort(mapValues, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                if (o1.equals("start"))
                    o1 = "00:00:00";
                if (o2.equals("start"))
                    o2 = "00:00:00";
                return o1.compareTo(o2);
            }
        });

        return mapListVAST == null ? new CopyOnWriteArrayList<>() : mapValues;
    }

    List<String> getListAdsShowed() {

        Collections.sort(listTimeOfSetShowed, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                if (o1.equals("start"))
                    o1 = "00:00:00";
                if (o2.equals("start"))
                    o2 = "00:00:00";
                return o1.compareTo(o2);
            }
        });
        return listTimeOfSetShowed;
    }

    boolean isPlayingAds() {
        return isPlayingAds;
    }

    boolean isPrepareAds() {
        return isWillShowAfter;
    }

    void resumeAds() {
        post(runnableUpdateProgressAds);
        layoutVideoAds.post(runnableCheckAds);
        if (timePrepare != TIME_CHECK_ADS_BEFORE) {
            timePrepare = timePrepare + 1;
        }
        Log.LOGD(TAG, "TIME_CHECK_ADS_BEFORE: resumeAds " + isWillShowAfter + " time : " + timePrepare);

        if (textureViewPlayer != null && currentListVast != null) {
            pushEvent(AdsEvent.AdsEventType.resume);
            playerAds.setPlayWhenReady(true);
        }

    }

    void pauseAds() {
        try {
            layoutVideoAds.removeCallbacks(runnableCheckAds);
            removeCallbacks(runnableUpdateProgressAds);
        } catch (Exception ignored) {
        }
        Log.LOGD(TAG, "TIME_CHECK_ADS_BEFORE: pauseAds " + isWillShowAfter + " time : " + timePrepare);
        if (textureViewPlayer != null && currentListVast != null) {
            playerAds.setPlayWhenReady(false);
            pushEvent(AdsEvent.AdsEventType.pause);
        }


    }

    void muteAds(boolean mute) {
        setMute(mute);
    }

    //endregion
    //region get set

    void setTextLearnMore(TextView textLearnMore) {
        this.textLearnMore = textLearnMore;
    }


    void setTextSkipAds(TextView textSkipAds) {
        this.textSkipAds = textSkipAds;
    }


    void setTextAdsWillShowAfter(TextView textAdsWillShowAfter) {
        this.textAdsWillShowAfter = textAdsWillShowAfter;
    }


    void setStringSkipAdsAfter(String stringSkipAdsAfter) {
        this.stringSkipAdsAfter = stringSkipAdsAfter;
    }

    float getMusicVolumeLevel() {
        if (playerAds != null) {
            return playerAds.getVolume();
        }
        return 1.0f;
    }

    String getDurationAds() {

        if (currentListVast != null && currentListVast.size() > 0) {
            try {
                return String.valueOf(Utilities.convertStringToTime(currentListVast.get(numberAdsShow).getDuration()));
            } catch (Exception ignored) {
            }
        }
        return "0";
    }

    String getAdsId() {
        if (currentListVast != null && currentListVast.size() > 0) {
            try {
                return currentListVast.get(numberAdsShow).getIdAds();
            } catch (Exception ignored) {
            }
        }
        return "";
    }

    String getTypeOfAds() {
        if (currentListVast != null && currentListVast.size() > 0) {
            try {
                return currentListVast.get(numberAdsShow).getTimeOffset();
            } catch (Exception ignored) {
            }
        }
        return "";
    }

    public void setPlayMultiAds(boolean isPlayMultiAds) {
        this.playMultible = isPlayMultiAds;
    }

    public AdsModel getCurrentAdsModel() {
        if (currentAdsModel != null) {
            return currentAdsModel;
        } else {
            if (currentListVast != null && currentListVast.size() > 0) {
                return currentListVast.get(numberAdsShow);
            }
        }
        return null;
    }

    public int getCurrentTime() {

        if (currentListVast != null && currentListVast.size() > 0) {
            try {
                return (int) playerAds.getCurrentPosition() / TIME_MILISECOND;
            } catch (Exception ignored) {
            }
        }
        return 0;

    }

    public int getTimeOffsetAdsDefault() {
        return Constants.TIME_OFFSET_DEFAULT;
    }

    public void setTimeOfSetKey(int seconds) {
        if (seconds < 6) {
            keyTimOffset = "start";
        } else {
            keyTimOffset = Utilities.convertTimeToString(seconds);
        }
    }

    public void setVolumeAds() {
        if (iPlayer == null)
            return;
        try {
            musicVolumeLevel = iPlayer.getCurrentVolumePlayer();
        } catch (AbstractMethodError ignored) {
        }

        if (playerAds != null) {
            playerAds.setVolume(musicVolumeLevel);
        }
    }

    public void updateViewPlayer() {
        if (textureViewPlayer != null) {
            try {
                layoutVideoAds.removeView(textureViewPlayer);
                layoutVideoAds.removeAllViews();
            } catch (Exception ignored) {
            }

            textureViewPlayer = new AspectRatioFrameLayout(getContext());
            FrameLayout.LayoutParams layoutParamsVideo = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            layoutParamsVideo.gravity = Gravity.CENTER;
            layoutVideoAds.addView(textureViewPlayer, layoutParamsVideo);

            playerAds.setVideoTextureView(textureViewPlayer);
        }
    }

    public void seekVideoPlayer(int curentTime) {
        if (arrListAdsAfterSeek != null) {
            arrListAdsAfterSeek.clear();
        } else {
            arrListAdsAfterSeek = new ArrayList<>();
        }

        isSeekVideo = true;
        timeBeforeSeek = curentTime;

        int timeBefore = timeBeforeSeek / 1000;
        int timeAfter = iPlayer.getCurentTime() / 1000;
        while (timeAfter >= timeBefore) {
            String time = Utilities.convertTimeToString(timeAfter);
            for (int i = 0; i < mapListVAST.size(); i++) {
                if (Objects.requireNonNull(mapListVAST.keySet().toArray())[i].equals(time)) {
                    arrListAdsAfterSeek.add(Utilities.convertTimeToString(timeAfter));
                    break;
                }
            }
            timeAfter--;

        }
        if (arrListAdsAfterSeek != null && arrListAdsAfterSeek.size() > 0) {
            adsAfterSeek = arrListAdsAfterSeek.get(0).toString();
        }
        isSeekVideo = false;
    }

    //endregion

    //region Event Player advert
    private class PlayerEventListener implements Player.EventListener, VideoListener {

        @Override
        public void onVideoSizeChanged(int width, int height, int unappliedRotationDegrees, float pixelWidthHeightRatio) {
            if (textureViewPlayer != null) {
                float videoAspectRatio =
                        (height == 0 || width == 0) ? 1 : (width * pixelWidthHeightRatio) / height;
                // Try to apply rotation transformation when our surface is a TextureView.
                if (unappliedRotationDegrees == 90 || unappliedRotationDegrees == 270) {
                    // We will apply a rotation 90/270 degree to the output texture of the TextureView.
                    // In this case, the output video's width and height will be swapped.
                    videoAspectRatio = 1 / videoAspectRatio;
                }
                textureViewPlayer.setAspectRatio(videoAspectRatio);
            }
        }

        @Override
        public void onPlayerStateChanged(boolean playWhenReady, int playbackState) {
            switch (playbackState) {
                case Player.STATE_ENDED:
                    pushEvent(AdsEvent.AdsEventType.complete);
                    onCompletion();
                    break;
                case Player.STATE_READY:

                    onPrepared();
                    break;
                case Player.STATE_BUFFERING:
                    pushEvent(AdsEvent.AdsEventType.adbuffering);
                    break;
            }
        }

        @Override
        public void onPlayerError(ExoPlaybackException error) {
            if (error != null) {
                LOGD(TAG, "onPlayerError: " + error.getLocalizedMessage());
                onError(error);
            }
        }
    }
    //endregion
}

