//
//  AdsModel.java
//
//  Copyright (c) 2016 AdsPlay. All rights reserved.
//

package com.vcc.playerads.models;


import android.text.TextUtils;

import com.vcc.playerads.events.AdsEvent;
import com.vcc.playerads.utils.HttpGetUtil;
import com.vcc.playerads.utils.XmlTools;

import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import static com.vcc.playerads.utils.Log.LOGD;

public class AdsModel implements Serializable {

    // Tracking xpath expressions
    private static final String inlineLinearTrackingXPATH = "/VAST/Ad/InLine/Creatives/Creative/Linear/TrackingEvents/Tracking";
    private static final String inlineNonLinearTrackingXPATH = "/VAST/Ad/InLine/Creatives/Creative/NonLinearAds/TrackingEvents/Tracking";
    private static final String wrapperLinearTrackingXPATH = "/VAST/Ad/Wrapper/Creatives/Creative/Linear/TrackingEvents/Tracking";
    private static final String wrapperNonLinearTrackingXPATH = "/VAST/Ad/Wrapper/Creatives/Creative/NonLinearAds/TrackingEvents/Tracking";
    private static final String combinedTrackingXPATH = inlineLinearTrackingXPATH
            + "|"
            + inlineNonLinearTrackingXPATH
            + "|"
            + wrapperLinearTrackingXPATH + "|" + wrapperNonLinearTrackingXPATH;
    // Mediafile xpath expression
    private static final String mediaFileXPATH = "//MediaFile";
    // VASTAdTagURI xpath expression
    private static final String vastAdTagURIXPATH = "//VASTAdTagURI";
    // Ad xpath expression
    private static final String adsXPATH = "//Ad";
    // Duration xpath expression
    private static final String durationXPATH = "//Duration";
    // Duration xpath expression
    private static final String adsTitleXPATH = "//AdTitle";
    // Videoclicks xpath expression
    private static final String videoClicksXPATH = "//VideoClicks";
    // Videoclicks xpath expression
    private static final String impressionXPATH = "//Impression";
    // Error url  xpath expression
    private static final String errorUrlXPATH = "//Error";
    private static final String linearXPATH = "//Linear";
    private static String TAG = "AdsModel";
    private List<String> listAdID = new ArrayList<>();
    private String idAds;
    private String adTagURI;
    private String currentUrlVideo = "";
    private transient Document vastsDocument;
    private String pickedMediaFileURL = null;
    private String timeOffset = "";
    private String adsTitles = "";
    private List<VASTMediaFile> listMediaFile = new CopyOnWriteArrayList<>();

    public AdsModel(Document vasts) {
        this.vastsDocument = vasts;
    }

    private static String nodeListToString(NodeList nodes) {
        if (nodes != null) {
            try {
                DOMSource source = new DOMSource();
                StringWriter writer = new StringWriter();
                StreamResult result = new StreamResult(writer);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "yes");

                for (int i = 0; i < nodes.getLength(); ++i) {
                    source.setNode(nodes.item(i));
                    transformer.transform(source, result);
                }

                return writer.toString();
            } catch (Exception e) {
            }
        }

        return "";
    }

    public String getCurrentUrlVideo() {
        return currentUrlVideo;
    }

    public void setCurrentUrlVideo(String currentUrlVideo) {
        this.currentUrlVideo = currentUrlVideo;
    }

    public String getTimeOffset() {
        if (timeOffset.contains(".")) {
            timeOffset = timeOffset.substring(0, timeOffset.lastIndexOf("."));
        }
        return timeOffset;
    }

    public void setTimeOffset(String timeOffset) {
        this.timeOffset = timeOffset;
    }

    public String getAdsTitles() {

        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList) xpath.evaluate(adsTitleXPATH, vastsDocument, XPathConstants.NODESET);
            Node node;
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    node = nodes.item(i);
                    adsTitles = XmlTools.getElementValue(node);
                }
            }
        } catch (Exception e) {

            return null;
        }

        return adsTitles;
    }

    public String getTagURI() {

        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList) xpath.evaluate(vastAdTagURIXPATH, vastsDocument, XPathConstants.NODESET);
            Node node;
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    node = nodes.item(i);
                    adTagURI = XmlTools.getElementValue(node);
                }
            }
        } catch (Exception e) {

            return null;
        }

        return adTagURI;
    }

    public Document getVastsDocument() {
        return vastsDocument;
    }

    public HashMap<AdsEvent.AdsEventType, List<String>> getTrackingUrls() {

        List<String> tracking;

        HashMap<AdsEvent.AdsEventType, List<String>> trackings = new HashMap<AdsEvent.AdsEventType, List<String>>();

        XPath xpath = XPathFactory.newInstance().newXPath();

        try {
            NodeList nodes = (NodeList) xpath.evaluate(combinedTrackingXPATH, vastsDocument, XPathConstants.NODESET);
            Node node;
            String trackingURL;
            String eventName;
            AdsEvent.AdsEventType key = null;

            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    node = nodes.item(i);
                    NamedNodeMap attributes = node.getAttributes();
                    eventName = (attributes.getNamedItem("event")).getNodeValue();
                    try {
                        key = AdsEvent.AdsEventType.valueOf(eventName);
                    } catch (IllegalArgumentException e) {
                        continue;
                    }
                    trackingURL = XmlTools.getElementValue(node);

                    if (trackings.containsKey(key)) {
                        tracking = trackings.get(key);
                        tracking.add(trackingURL);
                    } else {
                        tracking = new ArrayList<String>();
                        tracking.add(trackingURL);
                        trackings.put(key, tracking);

                    }
                }
            }
        } catch (Exception e) {

            return null;
        }

        return trackings;
    }

    public List<VASTMediaFile> getMediaFiles() {
        ArrayList<VASTMediaFile> mediaFiles = new ArrayList<VASTMediaFile>();
        XPath xpath = XPathFactory.newInstance().newXPath();

        try {
            NodeList nodes = (NodeList) xpath.evaluate(mediaFileXPATH,
                    vastsDocument, XPathConstants.NODESET);
            Node node;
            VASTMediaFile mediaFile;
            String mediaURL;
            Node attributeNode;

            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    mediaFile = new VASTMediaFile();
                    node = nodes.item(i);
                    NamedNodeMap attributes = node.getAttributes();
                    if (attributes == null)
                        continue;
                    attributeNode = attributes.getNamedItem("apiFramework");
                    mediaFile.setApiFramework((attributeNode == null) ? null
                            : attributeNode.getNodeValue());

                    attributeNode = attributes.getNamedItem("bitrate");
                    mediaFile.setBitrate((attributeNode == null) ? null
                            : new BigInteger(attributeNode.getNodeValue()));

                    attributeNode = attributes.getNamedItem("delivery");
                    mediaFile.setDelivery((attributeNode == null) ? null
                            : attributeNode.getNodeValue());

                    attributeNode = attributes.getNamedItem("height");
                    mediaFile.setHeight((attributeNode == null) ? null
                            : Integer.parseInt((attributeNode.getNodeValue())));

                    attributeNode = attributes.getNamedItem("id");
                    mediaFile.setId((attributeNode == null) ? null
                            : attributeNode.getNodeValue());

                    attributeNode = attributes
                            .getNamedItem("maintainAspectRatio");
                    mediaFile
                            .setMaintainAspectRatio((attributeNode == null) ? null
                                    : Boolean.valueOf(attributeNode
                                    .getNodeValue()));

                    attributeNode = attributes.getNamedItem("scalable");
                    mediaFile.setScalable((attributeNode == null) ? null
                            : Boolean.valueOf(attributeNode.getNodeValue()));

                    attributeNode = attributes.getNamedItem("type");
                    mediaFile.setType((attributeNode == null) ? null
                            : attributeNode.getNodeValue());

                    attributeNode = attributes.getNamedItem("width");
                    mediaFile.setWidth((attributeNode == null) ? null
                            : Integer.parseInt(attributeNode.getNodeValue()));

                    mediaURL = XmlTools.getElementValue(node);
                    mediaFile.setValue(mediaURL);

                    mediaFiles.add(mediaFile);
                }
            }

        } catch (Exception e) {

            return null;
        }

        return mediaFiles;
    }

    public String getDuration() {

        String duration = null;
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList) xpath.evaluate(durationXPATH, vastsDocument, XPathConstants.NODESET);
            Node node;
            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    node = nodes.item(i);
                    duration = XmlTools.getElementValue(node);
                }
            }
        } catch (Exception e) {

            return null;
        }

        return duration;
    }

    public VideoClicks getVideoClicks() {

        VideoClicks videoClicks = new VideoClicks();

        XPath xpath = XPathFactory.newInstance().newXPath();

        try {
            NodeList nodes = (NodeList) xpath.evaluate(videoClicksXPATH, vastsDocument, XPathConstants.NODESET);
            Node node;

            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    node = nodes.item(i);

                    NodeList childNodes = node.getChildNodes();

                    Node child;
                    String value;

                    for (int childIndex = 0; childIndex < childNodes
                            .getLength(); childIndex++) {

                        child = childNodes.item(childIndex);
                        String nodeName = child.getNodeName();

                        if (nodeName.equalsIgnoreCase("ClickTracking")) {
                            value = XmlTools.getElementValue(child);
                            videoClicks.getClickTracking().add(value);

                        } else if (nodeName.equalsIgnoreCase("ClickThrough")) {
                            value = XmlTools.getElementValue(child);
                            videoClicks.setClickThrough(value);

                        } else if (nodeName.equalsIgnoreCase("CustomClick")) {
                            value = XmlTools.getElementValue(child);
                            videoClicks.getCustomClick().add(value);
                        }
                    }
                }
            }

        } catch (Exception e) {

            return null;
        }

        return videoClicks;
    }

    public List<String> getImpressions() {
        List<String> list = getListFromXPath(impressionXPATH);
        if (list != null) {
            return list;
        }
        return new ArrayList<>();
    }

    public String getSkipOffset() {
        String skipoffset = "00:00:06";
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList) xpath.evaluate(linearXPATH, vastsDocument, XPathConstants.NODESET);
            Node node;
            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    node = nodes.item(i);
                    skipoffset = XmlTools.getAttributeValue(node, "skipoffset");
                }
            }
        } catch (Exception e) {

            return null;
        }
        return skipoffset;
    }

    public List<String> getErrorUrl() {
        return getListFromXPath(errorUrlXPATH);
    }

    private List<String> getListFromXPath(String xPath) {
        ArrayList<String> list = new ArrayList<String>();
        XPath xpath = XPathFactory.newInstance().newXPath();
        try {
            NodeList nodes = (NodeList) xpath.evaluate(xPath,
                    vastsDocument, XPathConstants.NODESET);
            Node node;
            if (nodes != null && nodes.getLength() > 0) {
                for (int i = 0; i < nodes.getLength(); i++) {
                    node = nodes.item(i);
                    list.add(XmlTools.getElementValue(node));
                }
            }

        } catch (Exception e) {

            return null;
        }

        return list;
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();

        String data = XmlTools.xmlDocumentToString(vastsDocument);
        // oos.writeChars();
        oos.writeObject(data);

    }

    private void readObject(ObjectInputStream ois)
            throws ClassNotFoundException, IOException {
        ois.defaultReadObject();

        String vastString = (String) ois.readObject();

        vastsDocument = XmlTools.stringToDocument(vastString);

    }

    public String getPickedMediaFileURL() {
        return pickedMediaFileURL;
    }

    public void setPickedMediaFileURL(String pickedMediaFileURL) {
        this.pickedMediaFileURL = pickedMediaFileURL;
    }

    public List<AdsModel> getAllVASTModels() {
        List<AdsModel> models = new ArrayList<>();
        if (vastsDocument == null)
            return models;
        NodeList adbreakNodes = vastsDocument.getElementsByTagName("Ad");
        if (adbreakNodes == null || (adbreakNodes.getLength() == 0))
            return models;
        int l = adbreakNodes.getLength();
        LOGD(TAG, "models adbreakNodes : " + l);

        for (int i = 0; i < l; i++) {
            Node node = adbreakNodes.item(i);
            if (node == null)
                continue;
            String id = XmlTools.getAttributeValue(node, "id");
            String timeOffset = XmlTools.getAttributeValue(node, "timeOffset");
            LOGD(TAG, "models id  : " + id);
            NodeList childs = node.getChildNodes();
            if (childs == null) {
                continue;
            }
            for (int j = 0; j < childs.getLength(); j++) {
                Node item = childs.item(j);
                if (item == null)
                    continue;
                String nodeName = item.getNodeName();
                if (TextUtils.isEmpty(nodeName))
                    continue;
                if (nodeName.equalsIgnoreCase("Wrapper")) {
                    String xmlWrapper = "<Wrapper>" + nodeListToString(item.getChildNodes()) + "</Wrapper>";
                    Document document = XmlTools.stringToDocument(xmlWrapper);
                    if (document == null)
                        continue;
                    NodeList nodeVastAdTags = document.getElementsByTagName("VASTAdTagURI");
                    if (nodeVastAdTags != null && nodeVastAdTags.getLength() > 0) {
                        Node nodeVast = nodeVastAdTags.item(0);
                        if (nodeVast != null) {
                            String vastUrl = nodeVast.getTextContent().trim();
                            String vastXml = HttpGetUtil.get(vastUrl);
                            AdsModel adsModel = new AdsModel(XmlTools.stringToDocument(vastXml));
                            if (adsModel.getMediaFiles() != null) {
                                adsModel.setIdAds(id);
                                adsModel.setTimeOffset(timeOffset);
                                models.add(adsModel);
                                LOGD(TAG, "models1: " + adsModel.getMediaFiles().get(0).getValue());
                            }
                        }
                    }

                } else if (nodeName.equalsIgnoreCase("InLine")) {
                    String xml = "<InLine>" + nodeListToString(item.getChildNodes()) + "</InLine>";
                    AdsModel adsModel = new AdsModel(XmlTools.stringToDocument(xml));

                    if (adsModel.getMediaFiles() != null) {
                        LOGD(TAG, "models1: " + adsModel.getMediaFiles().get(0).getValue());
//                        Log.d(TAG, "models2: " + adsModel.getMediaFiles().get(1).getValue());
                        adsModel.setIdAds(id);
                        adsModel.setTimeOffset(timeOffset);
                        models.add(adsModel);
                    }

                }
            }

        }
        return models;
    }

    public String getIdAds() {
        return idAds;
    }

    public void setIdAds(String idAds) {
        this.idAds = idAds;
    }
}
