package com.vcc.playerads.events;

import android.widget.FrameLayout;

public interface IPlayer {
    /**
     * get use Ads Container
     *
     * @return Frame Layout
     */
    FrameLayout getAdsContainer();

    /**
     * Gets the duration of the video.
     *
     * @return the duration in milliseconds, if no duration is available
     * (for example, if streaming live content), -1 is returned.
     */
    int getDurationPlayer();

    /**
     * Gets the duration of the video.
     *
     * @return the duration in milliseconds, if no duration is available
     * (for example, if streaming live content), -1 is returned.
     */
    int getCurentTime();

    /**
     * Pause Video call from Ads View
     */
    void pause();

    /**
     * resume Video call from Ads View
     */
    void resume();

    /**
     * Seek video to current time as second
     *
     * @param miliSeconds time video playing at second
     */
    void seekTo(int miliSeconds);

    /**
     * @return State of Video player
     */
    boolean isPlaying();

}
