package com.vcc.playerads.manager;

import android.animation.ObjectAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.vcc.playerads.customviews.CircularProgressBar;
import com.vcc.playerads.events.AdsEvent;
import com.vcc.playerads.events.IPlayer;
import com.vcc.playerads.events.OnAdsEventListener;
import com.vcc.playerads.models.AdsModel;
import com.vcc.playerads.models.VASTMediaFile;
import com.vcc.playerads.models.VMAPModel;
import com.vcc.playerads.natives.APIRequest;
import com.vcc.playerads.utils.Constants;
import com.vcc.playerads.utils.Utilities;
import com.vcc.playerads.utils.XmlTools;
import com.ynsuper.parservast.R;

import org.w3c.dom.Document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

import static com.vcc.playerads.utils.Constants.PROCESS_MAX_VALUES;
import static com.vcc.playerads.utils.Constants.TIME_CHECK_ADS_BEFORE;
import static com.vcc.playerads.utils.Log.LOGD;

class VASTLayout extends RelativeLayout implements
        OnPreparedListener, OnCompletionListener, OnErrorListener {

    //region Variable
    private static final String TAG = VASTLayout.class.getName();
    private static final String THREAD_NAME_REQUEST_ADVERT = "ThreadRequestAds";

    private VideoView videoViewAds;
    private ProgressBar progressBarCurrentPosition;
    private LinearLayout linearProgressShowAds;
    private TextView textSkipAds;
    private TextView textLearnMore;
    private TextView textNumberOfAds;
    private TextView textAdsTitle;
    private TextView textAdsWillShowAfter;
    private ImageView imageMuteAds;
    private CircularProgressBar progessAdsWillShowSeconds;
    private FrameLayout layoutVideoAds;
    private IPlayer iPlayer;
    private Runnable runnableUpdateProgressAds;
    private Runnable runnableCheckAds;
    private long timeCanskip = Constants.SKIP_ADS_DEFAULT;
    private List<String> listTimeOfSetShowed = new ArrayList<>();
    private boolean isPrepared;
    private boolean isCheckAds = false;
    private boolean isWillShowAfter;
    private int numberAdsShow;
    private boolean isMute = false;
    private float musicVolumeLevel;
    private boolean isPlayingAds;
    private String urlRequestAds;
    private String stringSkipAdsAfter;
    private Map<String, List<AdsModel>> mapListVAST = new HashMap<>();
    private List<AdsModel> currentListVast = new CopyOnWriteArrayList<>();
    private int timePrepare = TIME_CHECK_ADS_BEFORE;
    private ProgressBar progressLoadAds;
    private OnAdsEventListener adsEventListener;
    private boolean isProgressAdsThirdQuartile;
    private boolean isProgressAdsMidPoint;
    private boolean isProgressAdsFirstQuartile;
    private boolean isProgressAdsStart;
    private boolean isRequestAds;
    private Thread threadRequestAds;
    private String timeOfSetPrepare = "";
    private boolean skipMultiAds = true;
    private boolean playMultible = true;
    private boolean isVast;

    private AdsModel currentAdsModel;
    private Runnable runableRequestAds = new Runnable() {
        @Override
        public void run() {
            if (isRequestAds)
                return;
            isRequestAds = true;
            if (!TextUtils.isEmpty(urlRequestAds)) {
                String xmlData = APIRequest.getRequest(urlRequestAds);
                if (!TextUtils.isEmpty(xmlData)) {
                    LOGD(TAG, "runableRequestAds xml ");
                    processingXMLData(xmlData);
                    try {
                        pushEvent(null, AdsEvent.AdsEventType.gotAds);
                    } catch (Exception ignored) {
                        releaseVideoView();
                    }
                } else {
                    LOGD(TAG, "runableRequestAds xml isEmpty");
                    try {
                        pushEvent(null, AdsEvent.AdsEventType.noAdsToShow);
                    } catch (Exception ignored) {

                    }
                    LOGD(TAG, "vastModel2 onResponse: null");
                    iPlayer.resume();
                }
            } else {
                iPlayer.resume();
                LOGD(TAG, "runableRequestAds xml isEmpty");
                pushEvent(null, AdsEvent.AdsEventType.loadError);
                pushEvent(null, AdsEvent.AdsEventType.noAdsToShow);
                LOGD(TAG, "vastModel2 onResponse: null");
            }
            isRequestAds = false;
        }
    };
    //endregion

    //region Constructor
    VASTLayout(Context context) {
        this(context, null);
    }

    VASTLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    VASTLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
        pushEvent(null, AdsEvent.AdsEventType.creativeView);

    }

    private static int compare(VASTMediaFile lhs, VASTMediaFile rhs) {
        if ((lhs.width * lhs.height) >= (rhs.width * rhs.height)) {
            return 1;
        } else {
            return -1;
        }
    }
    //endregion

    //region InitViews
    private void initView() {
        inflate(getContext(), R.layout.video_player_vast, this);
        bindView();
        setListener();
    }


    private void setListener() {

        progressLoadAds.getIndeterminateDrawable()
                .setColorFilter(getResources().getColor(R.color.color_progress_ads), PorterDuff.Mode.SRC_IN);

        progressBarCurrentPosition.setMax(PROCESS_MAX_VALUES);
        progressBarCurrentPosition.setProgress(0);

        progessAdsWillShowSeconds.setmMaxProgress(TIME_CHECK_ADS_BEFORE);
        progessAdsWillShowSeconds.setTextColor(Color.WHITE);
        progessAdsWillShowSeconds.setProgress(TIME_CHECK_ADS_BEFORE);

        textLearnMore.setOnClickListener(v -> clickThroughVideo());
        textSkipAds.setOnClickListener(v -> clickSkipAds());
        imageMuteAds.setOnClickListener(v -> clickMute());

        runnableUpdateProgressAds = this::updateProgressAdverts;
        runnableCheckAds = this::checkAdsRealTime;
    }

    private void initAudioSession() {
        videoViewAds.setOnPreparedListener(this);
        videoViewAds.setOnCompletionListener(this);
        videoViewAds.setOnErrorListener(this);
        musicVolumeLevel = videoViewAds.getVolume();
        if (musicVolumeLevel <= 0) {
            musicVolumeLevel = 0.5f;
        }
        imageMuteAds.setImageResource(R.drawable.icon_unmute);
    }

    private void bindView() {
        textAdsWillShowAfter = findViewById(R.id.text_ads_will_show);
        progressLoadAds = findViewById(R.id.prgress_loading_ads);
        imageMuteAds = findViewById(R.id.image_mute);
        textNumberOfAds = findViewById(R.id.text_number_of_ads);
        textAdsTitle = findViewById(R.id.text_ads_title);
        progessAdsWillShowSeconds = findViewById(R.id.progress_time_before);
        textLearnMore = findViewById(R.id.text_learn_more);
        layoutVideoAds = findViewById(R.id.view_container_ads);
        linearProgressShowAds = findViewById(R.id.linear_progress_show_ads_before);
        textSkipAds = findViewById(R.id.text_skip_ads);
        progressBarCurrentPosition = findViewById(R.id.progress_current_position);
        stringSkipAdsAfter = getResources().getString(R.string.string_can_skip_after);
    }
    //endregion

    //region Request ads and processing

    void setSkipAllAds(boolean skipAllAds) {
        this.skipMultiAds = skipAllAds;
    }

    void requestAds(String url) {
        requestAds(url, true);
    }

    void requestAds(String url, boolean resetAds) {
        this.urlRequestAds = url;

        if (resetAds) {
            resetAllAds();
        }
        iPlayer.pause();

        try {
            layoutVideoAds.removeCallbacks(runnableCheckAds);
            removeCallbacks(runnableUpdateProgressAds);
        } catch (Exception ignored) {
        }

        threadRequestAds = new Thread(runableRequestAds, THREAD_NAME_REQUEST_ADVERT);
        threadRequestAds.start();
    }

    private void processingXMLData(String xml) {
        Document mainDoc = XmlTools.stringToDocument(xml);
        AdsModel adsModel = new AdsModel(mainDoc);
        List<AdsModel> listAllAds = adsModel.getAllVASTModels();
        //VMAP Type
        if (listAllAds.size() == 0) {
            isVast = false;
            VMAPModel vmapModel = new VMAPModel(mainDoc);
            List<AdsModel> listAdsModel = vmapModel.getVASTModels();
            for (AdsModel adsModel1 : listAdsModel) {
                String key = adsModel1.getTimeOffset();
                if (mapListVAST.containsKey(key)) {
                    List<AdsModel> listVast = mapListVAST.get(key);
                    if (listVast == null)
                        listVast = new CopyOnWriteArrayList<>();
                    listVast.add(adsModel1);
                    mapListVAST.remove(key);
                    mapListVAST.put(key, listVast);
                } else {
                    List<AdsModel> listVast = new CopyOnWriteArrayList<>();
                    listVast.add(adsModel1);
                    mapListVAST.put(key, listVast);

                }
            }

            //VAST Type
        } else {
            isVast = true;
            int currentPlayer = iPlayer.getCurentTime() / 1000;
            String key = setTimeOfSetForVAST(currentPlayer, adsModel);

            if (listAllAds.size() > 0) {
                mapListVAST.put(key, listAllAds);
                LOGD(TAG, "getMediaFiles key " + key);
            }

        }
        layoutVideoAds.post(runnableCheckAds);
    }

    private String setTimeOfSetForVAST(int currentPlayer, AdsModel adsModel) {
        String currentTimePlayer;
        if (currentPlayer <= 0)
            currentTimePlayer = Utilities.convertTimeToString(currentPlayer);
        else
            currentTimePlayer = Utilities.convertTimeToString(currentPlayer + TIME_CHECK_ADS_BEFORE);
        String key = adsModel.getTimeOffset();
        if (TextUtils.isEmpty(key)) {
            if (currentTimePlayer.equals("00:00:00")) {
                key = "start";
            } else {
                key = currentTimePlayer;
            }
        }
        if (key.equals("00:00:00"))
            key = "start";
        return key;
    }

    protected void resetAllAds() {
        try {
            threadRequestAds.stop();
        } catch (Exception e) {

        }
        isRequestAds = false;
        layoutVideoAds.removeCallbacks(runnableCheckAds);

        removeCallbacks(runnableUpdateProgressAds);

        listTimeOfSetShowed.clear();
        mapListVAST.clear();
        if (currentListVast != null) {
            currentListVast.clear();
        }
        isPlayingAds = false;
        isCheckAds = false;
        numberAdsShow = 0;
        timeOfSetPrepare = "";
        timePrepare = TIME_CHECK_ADS_BEFORE;
        if (videoViewAds != null) {
            try {
                layoutVideoAds.removeView(videoViewAds);
                layoutVideoAds.removeAllViews();
                videoViewAds = null;
            } catch (Exception ignored) {
            }

        }
        isVast = false;
        isPrepared = false;
        isWillShowAfter = false;
        timeCanskip = Constants.SKIP_ADS_DEFAULT;
        isPlayingAds = false;

        setVisibilityAllView(GONE);


    }

    private void checkScreenForAdsAndShow(AdsModel adsModel) {
        // check Screen and show ads
        String adsUrl = getUrlVideoScreenForAds(adsModel);
        LOGD(TAG, "checkScreenForAdsAndShow: " + adsUrl);
        String timeOfSet = adsModel.getTimeOffset();
        // check Ads Available or not
//        if (!checkAdsShowed(timeOfSet)) {
        iPlayer.pause();
        hideSkipAds();
        if (!checkAdsShowed(timeOfSet)) {
            listTimeOfSetShowed.add(timeOfSet);
        }

        showAds(adsModel, adsUrl);
        isPlayingAds = true;
        pushEvent(adsModel, AdsEvent.AdsEventType.contentpauserequested);
//        } else {
//            if (!iPlayer.isPlaying())
//                clickSkipAds();
//        }

    }

    private String getUrlVideoScreenForAds(AdsModel adsModel) {
        if (!isVast) {
            int widthScreen = getWidth();
            int heightScreen = getHeight();
            //return a Screen for Ads
            VASTMediaFile vastMediaFile = selectViewForAds(widthScreen, heightScreen, adsModel.getMediaFiles());
            return vastMediaFile.getValue();
        } else {
            return adsModel.getMediaFiles().get(0).getValue();
        }
    }

    private boolean checkAdsShowed(String value) {
        if (listTimeOfSetShowed != null) {
            return listTimeOfSetShowed.contains(value);
        } else
            listTimeOfSetShowed = new CopyOnWriteArrayList<>();
        return false;
    }

    void setIPlayerContent(IPlayer iPlayer) {
        this.iPlayer = iPlayer;
    }

    private void checkAdsRealTime() {

        if (isPlayingAds) {
            layoutVideoAds.postDelayed(runnableCheckAds, Constants.TIME_DELAY);
            return;
        }
        if (!isCheckAds && iPlayer != null) {
            boolean isEnded = false;
            isCheckAds = true;

            int duration = iPlayer.getDurationPlayer();
            int currentPosition = iPlayer.getCurentTime();
            String preparePosition = Utilities.convertTimeToString((iPlayer.getCurentTime() / 1000) + TIME_CHECK_ADS_BEFORE);
            //check ads video
            LOGD(TAG, "currentPosition):  " + currentPosition
                    + " duration:  " + duration + " | listTimeOfSetShowed" + listTimeOfSetShowed.size()
                    + "   | mapListVAST:  " + mapListVAST.keySet().size() + " skipMultiAds: " + skipMultiAds);
            if (currentPosition <= Constants.TIME_MILISECOND) {
                isWillShowAfter = false;
                currentListVast = mapListVAST.get("start");
                if (currentListVast != null && !currentListVast.isEmpty()) {
                    iPlayer.pause();
                }
            } else if ((currentPosition / Constants.TIME_MILISECOND) >= (duration / Constants.TIME_MILISECOND)) {
                isWillShowAfter = false;
                currentListVast = mapListVAST.get("end");

            } else if (mapListVAST.containsKey(preparePosition)) {
                isWillShowAfter = true;
                currentListVast = mapListVAST.get(preparePosition);
            }


            if (currentListVast != null && !currentListVast.isEmpty()) {
                if (isWillShowAfter) {
                    showAfterSeconds();
                } else {
                    checkAds();
                }
            }

            isCheckAds = false;
            if (currentListVast == null || numberAdsShow >= currentListVast.size()) {

                if (listTimeOfSetShowed.size() >= mapListVAST.keySet().size()) {
                    isEnded = true;
                    layoutVideoAds.removeCallbacks(runnableCheckAds);
                    if (currentListVast != null && !currentListVast.isEmpty()) {
                        try {
                            AdsModel adsModel = currentListVast.get(numberAdsShow);
                            pushEvent(adsModel, AdsEvent.AdsEventType.alladscompleted);
                        } catch (Exception ignored) {
                        }
                    } else
                        pushEvent(null, AdsEvent.AdsEventType.alladscompleted);
                    iPlayer.resume();
                }

            }
            if (isEnded)
                return;
        }

        layoutVideoAds.postDelayed(runnableCheckAds, Constants.TIME_DELAY);
    }

    private void checkAds() {
        if (!isShowAds() && currentListVast != null || (numberAdsShow < currentListVast.size())) {
            try {
                LOGD(TAG, "checkAds numberOfAds multi " + numberAdsShow + " of " + currentListVast.size());
                AdsModel adsModel = currentListVast.get(numberAdsShow);
                checkScreenForAdsAndShow(adsModel);
            } catch (Exception e) {
                clickSkipAds();
                e.getMessage();
            }

        }

    }

    @SuppressLint("SetTextI18n")
    private void showAfterSeconds() {
        if (linearProgressShowAds.getVisibility() != VISIBLE) {
            linearProgressShowAds.setVisibility(View.VISIBLE);
        }
        progessAdsWillShowSeconds.setProgress(timePrepare);
        LOGD(TAG, "checkAdsBefore TIME_CHECK_ADS_BEFORE: " + timePrepare);

        if (timePrepare == TIME_CHECK_ADS_BEFORE) {
            Animation tranLeftToRight = AnimationUtils.loadAnimation(getContext(), R.anim.translate_left_right);
            linearProgressShowAds.startAnimation(tranLeftToRight);

            if (videoViewAds == null) {
                videoViewAds = new VideoView(getContext());

                initAudioSession();
                FrameLayout.LayoutParams layoutParamsVideo = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
                layoutVideoAds.addView(videoViewAds, layoutParamsVideo);
            }

            if (videoViewAds != null) {
                videoViewAds.stopPlayback();
            }
            isPrepared = false;
            numberAdsShow = 0;
            prepareAds();
        }
        if (timePrepare < 0) {
            Animation tranRightToLeft = AnimationUtils.loadAnimation(getContext(), R.anim.translate_right_left);
            linearProgressShowAds.startAnimation(tranRightToLeft);
            isWillShowAfter = false;
            if (!checkAdsShowed(timeOfSetPrepare)) {
                listTimeOfSetShowed.add(timeOfSetPrepare);
            }

            timePrepare = TIME_CHECK_ADS_BEFORE;
            hideAfterSeconds();

            if (isPrepared && videoViewAds != null) {
                iPlayer.pause();

                setVisibilityAllView(VISIBLE);
                progressLoadAds.setVisibility(GONE);
                setTextForMultiAds();
                isPlayingAds = true;
                videoViewAds.start();
            }
            linearProgressShowAds.setVisibility(View.GONE);
            return;
        }
        timePrepare--;
    }

    private void setTextForMultiAds() {
        if (currentListVast != null && currentListVast.size() > 1) {
            if (playMultible) {
                textNumberOfAds.setVisibility(VISIBLE);
                textNumberOfAds.setText(String.format("%d of %d Ads", numberAdsShow + 1, currentListVast.size()));
            } else {
                textNumberOfAds.setVisibility(GONE);
            }
        } else {
            textNumberOfAds.setVisibility(GONE);
            textNumberOfAds.setText("");

        }
    }

    private void prepareAds() {
        if (currentListVast != null && numberAdsShow < currentListVast.size()) {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            currentAdsModel = adsModel;
            timeOfSetPrepare = adsModel.getTimeOffset();
            String urlTimeOfSetPrepare = getUrlVideoScreenForAds(adsModel);
            if (!TextUtils.isEmpty(urlTimeOfSetPrepare)) {
                videoViewAds.setVideoURI(Uri.parse(urlTimeOfSetPrepare));
                pushEvent(adsModel, AdsEvent.AdsEventType.adbreakready);
            }

        }
    }


    void hideAfterSeconds() {
        linearProgressShowAds.setVisibility(View.GONE);
    }
    //endregion

    //region Custom show/hide components

    void showSkipAds() {
        textSkipAds.setVisibility(VISIBLE);
    }


    void hideSkipAds() {
        textSkipAds.setVisibility(View.GONE);
    }


    @SuppressLint("DefaultLocale")
    private void showAds(AdsModel adsModel, String adsUrl) {
        adsModel.setCurrentUrlVideo(adsUrl);
        currentAdsModel = adsModel;
        if (videoViewAds == null) {
            videoViewAds = new VideoView(getContext());

            initAudioSession();
            FrameLayout.LayoutParams layoutParamsVideo = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            layoutVideoAds.addView(videoViewAds, layoutParamsVideo);
        }
        if (numberAdsShow <= 0) {
            Animation aniFadeIn = AnimationUtils.loadAnimation(getContext(), R.anim.fade_in_ads);
            layoutVideoAds.startAnimation(aniFadeIn);
        }

        progressBarCurrentPosition.setProgress(0);
        progressBarCurrentPosition.setVisibility(VISIBLE);
        progressLoadAds.setVisibility(VISIBLE);
        imageMuteAds.setVisibility(VISIBLE);
        textLearnMore.setVisibility(VISIBLE);
//        textSkipAds.setVisibility(VISIBLE);
        layoutVideoAds.setVisibility(View.VISIBLE);
        videoViewAds.setVisibility(VISIBLE);
        textAdsTitle.setVisibility(VISIBLE);


        textAdsTitle.setText(adsModel.getAdsTitles());
        if (videoViewAds != null) {
            try {
                videoViewAds.stopPlayback();
            } catch (Exception ignored) {
            }
        }

        Uri adsUri;
        try {
            adsUri = Uri.parse(adsUrl);
            if (adsUri == null)
                throw new NullPointerException("Adverts uri is null.");
        } catch (Exception e) {
            clickSkipAds();
            return;
        }
        videoViewAds.setVideoURI(adsUri);
        pushEvent(adsModel, AdsEvent.AdsEventType.adbuffering);

        //get From vastmodel
        try {
            String skipOfSet = adsModel.getSkipOffset();//hh:mm:ss
            String[] units = skipOfSet.split(":"); //will break the string up into an array
            int hours = Integer.parseInt(units[0]); //first element
            int minutes = Integer.parseInt(units[1]); //first element
            int seconds = Integer.parseInt(units[2]); //second element

            Constants.SKIP_ADS_DEFAULT = 3600 * hours + 60 * minutes + seconds;
        } catch (Exception e) {
            Constants.SKIP_ADS_DEFAULT = 6;
        }

        timeCanskip = Constants.SKIP_ADS_DEFAULT;

        setTextForMultiAds();
        if (adsEventListener != null) {
            pushEvent(adsModel, AdsEvent.AdsEventType.loaded);
        }
    }

    private void pushEvent(AdsModel ads, AdsEvent.AdsEventType eventType) {
        AdsEvent adsEvent = new AdsEvent() {
            @Override
            public AdsEventType getType() {
                return eventType;
            }

            @Override
            public AdsModel getAds() {
                return ads;
            }

        };
        if (adsEventListener != null) {
            adsEventListener.onAdsEventListener(adsEvent);
        }
//        sendTracking(ads, eventType);
    }

    private void sendTracking(AdsModel ads, AdsEvent.AdsEventType eventType) {
//        if (ads == null) {
//            return;
//        }
//        Map<AdsEvent.AdsEventType, List<String>> mapTracking = ads.getTrackingUrls();
//        if (mapTracking != null && mapTracking.containsKey(eventType) && mapTracking.get(eventType) != null) {
//            if (mapTracking.get(eventType).size() > 0) {
//                try {
//                    APIRequest.postRequest((mapTracking.get(eventType)).get(0));
//                } catch (Exception ignored) {
//                }
//            }
//        }
    }


    void hideAds() {
        numberAdsShow++;
        if (currentListVast != null && numberAdsShow >= currentListVast.size()) {
            currentListVast.clear();
            numberAdsShow = 0;
            seekVideoPlayer2Second();
            if (videoViewAds != null)
                videoViewAds.reset();
            releaseVideoView();

            Animation aniFade = AnimationUtils.loadAnimation(getContext(), R.anim.fade_out_ads);
            layoutVideoAds.startAnimation(aniFade);

            setVisibilityAllView(GONE);

            isPlayingAds = false;
            isWillShowAfter = false;
            return;
        }
        if (videoViewAds != null)
            videoViewAds.stopPlayback();


        isPlayingAds = false;
        isProgressAdsStart = false;
        isProgressAdsThirdQuartile = false;
        isProgressAdsMidPoint = false;
        isProgressAdsFirstQuartile = false;

        LOGD(TAG, "checkProgressAds : >= 99 : " + "99%   currentListVast: "
                + currentListVast.get(0).getAdsTitles());
        pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.complete);


    }

    private void setVisibilityAllView(int visibilityAllView) {

        progressLoadAds.setVisibility(visibilityAllView);
        progressBarCurrentPosition.setVisibility(visibilityAllView);
        linearProgressShowAds.setVisibility(visibilityAllView);
        imageMuteAds.setVisibility(visibilityAllView);
        textLearnMore.setVisibility(visibilityAllView);
        textSkipAds.setVisibility(visibilityAllView);
        textNumberOfAds.setVisibility(visibilityAllView);
        layoutVideoAds.setVisibility(visibilityAllView);
        textAdsTitle.setVisibility(visibilityAllView);
    }

    private void releaseVideoView() {
        try {
            layoutVideoAds.removeView(videoViewAds);
            layoutVideoAds.removeAllViews();
            videoViewAds = null;
        } catch (Exception ignored) {
        }
    }

    private void seekVideoPlayer2Second() {
        int currentTime = iPlayer.getCurentTime();
        int durationPlayer = iPlayer.getDurationPlayer();
        if (currentTime - 2000 <= 0)
            currentTime = 0;
        else if ((currentTime / Constants.TIME_MILISECOND) < (durationPlayer / Constants.TIME_MILISECOND))
            currentTime -= 2000;
        else
            currentTime = -1000;
        if (currentTime != -1000) {
            iPlayer.seekTo(currentTime);
            pushEvent(getCurrentAdsModel(), AdsEvent.AdsEventType.contentresumerequested);
        }

    }


    boolean isShowAds() {
        return layoutVideoAds.getVisibility() == View.VISIBLE;
    }

    private VASTMediaFile selectViewForAds(int screenWidth, int screenHeight, List<VASTMediaFile> listSizeSupport) {
        Collections.sort(listSizeSupport, VASTLayout::compare);
        VASTMediaFile sizeSelected = new VASTMediaFile();
        for (VASTMediaFile size : listSizeSupport) {
            if (size.width >= screenWidth && size.height >= screenHeight) {
                sizeSelected = size;
                return sizeSelected;
            }
        }
        if (sizeSelected.getValue() == null && listSizeSupport.size() > 0) {
            try {
                sizeSelected = listSizeSupport.get(listSizeSupport.size() - 1);
            } catch (Exception ignored) {
            }
        }
        return sizeSelected;
    }
    //endregion

    //region Handle video player ads
    @Override
    public void onPrepared() {
        if (!isMute && videoViewAds != null)
            videoViewAds.setVolume(musicVolumeLevel);
        isPrepared = true;
        if (!isWillShowAfter) {
            pushEvent(getCurrentAdsModel(), AdsEvent.AdsEventType.start);
            progressLoadAds.setVisibility(GONE);
            if (videoViewAds != null) {
                videoViewAds.start();
            }
            setMute(isMute);
            AdsModel adsModel = null;
            if (currentListVast != null && currentListVast.size() > 0)
                try {
                    adsModel = currentListVast.get(numberAdsShow);
                } catch (Exception ignored) {
                }
            pushEvent(adsModel, AdsEvent.AdsEventType.loaded);
        }

        postDelayed(runnableUpdateProgressAds, Constants.TIME_DELAY);
    }

    @Override
    public void onCompletion() {
        if (!playMultible && currentListVast != null) {
            numberAdsShow = currentListVast.size();
        }
        removeCallbacks(runnableUpdateProgressAds);
        if (currentListVast != null) {
            hideAds();
        }
    }


    int getProgressAds() {
        if (videoViewAds != null) {
            return (int) (((float) videoViewAds.getCurrentPosition() / videoViewAds.getDuration()) * PROCESS_MAX_VALUES);
        }
        return 0;
    }

    @SuppressLint("SetTextI18n")
    private void updateProgressAdverts() {

        //TODO update current time of ad
        if (videoViewAds == null)
            return;

        int time = getProgressAds();
        if (progressBarCurrentPosition.getProgress() > time) {
            progressBarCurrentPosition.setProgress(0);
        }
        checkProgressAds(time);
        ObjectAnimator animation = ObjectAnimator.ofInt(progressBarCurrentPosition, "progress", time);
        animation.setDuration(1000); // 0.5 second

        animation.setInterpolator(new LinearInterpolator());
        animation.start();
        timeCanskip = Constants.SKIP_ADS_DEFAULT - videoViewAds.getCurrentPosition() / 1000;
        if (timeCanskip > 0) {
            if (videoViewAds.isPlaying())
                showSkipAds();
            else
                hideSkipAds();
            textSkipAds.setText(stringSkipAdsAfter + " " + timeCanskip);
            textSkipAds.setEnabled(false);
        } else {
            textSkipAds.setText(getContext().getString(R.string.string_skipable));
            textSkipAds.setEnabled(true);
        }

        postDelayed(runnableUpdateProgressAds, Constants.TIME_DELAY);

    }

    private void checkProgressAds(int progressVideo) {
        AdsModel adsModel;
        if (currentListVast != null && currentListVast.size() > 0) {
            adsModel = currentListVast.get(numberAdsShow);
        } else {
            adsModel = null;
        }
        if (!isWillShowAfter) {
            try {
                pushEvent(adsModel, AdsEvent.AdsEventType.adprogress);
            } catch (Exception e) {

            }
        }
        if (progressVideo >= 75) {
            if (!isProgressAdsThirdQuartile) {
                LOGD(TAG, "checkProgressAds : >= 75 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(adsModel, AdsEvent.AdsEventType.thirdQuartile);
                isProgressAdsThirdQuartile = true;
            }
        } else if (progressVideo >= 50) {
            if (!isProgressAdsMidPoint) {
                LOGD(TAG, "checkProgressAds : >= 50 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(adsModel, AdsEvent.AdsEventType.midpoint);
                isProgressAdsMidPoint = true;
            }
        } else if (progressVideo >= 25) {
            if (!isProgressAdsFirstQuartile) {
                LOGD(TAG, "checkProgressAds : >= 25 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(adsModel, AdsEvent.AdsEventType.firstQuartile);
                isProgressAdsFirstQuartile = true;
            }
        } else if (progressVideo >= 0) {
            if (!isProgressAdsStart) {
                LOGD(TAG, "checkProgressAds : >= 0 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(adsModel, AdsEvent.AdsEventType.start);
                isProgressAdsStart = true;
            }
        }

    }
    //endregion

    //region Action click view
    private void clickMute() {
        AdsModel adsModel;
        if (currentListVast != null && currentListVast.size() > 0) {
            adsModel = currentListVast.get(numberAdsShow);
        } else {
            adsModel = null;
        }
        if (videoViewAds == null)
            return;
        if (isPrepared) {

            if (!isMute) {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_mute));
                videoViewAds.setVolume(0.0f);
                pushEvent(adsModel, AdsEvent.AdsEventType.mute);
            } else {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_unmute));
                videoViewAds.setVolume(musicVolumeLevel);
                pushEvent(adsModel, AdsEvent.AdsEventType.unmute);

            }
            isMute = !isMute;
        }

    }

    private void setMute(boolean mute) {
        if (videoViewAds == null) {
            isMute = mute;
            return;
        }
        if (isPrepared) {
            if (mute) {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_mute));
                videoViewAds.setVolume(0.0f);
                pushEvent(null, AdsEvent.AdsEventType.mute);
            } else {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_unmute));
                videoViewAds.setVolume(musicVolumeLevel);
                pushEvent(null, AdsEvent.AdsEventType.unmute);

            }
        }
        isMute = mute;

    }


    void clickThroughVideo() {
        try {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            if (!TextUtils.isEmpty(adsModel.getVideoClicks().getClickThrough())) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW,
                        Uri.parse(adsModel.getVideoClicks().getClickThrough()));
                getContext().startActivity(browserIntent);
                pushEvent(getCurrentAdsModel(), AdsEvent.AdsEventType.clicked);
            }

        } catch (Exception e) {

        }
    }

    void clickSkipAds() {
        //TODO an ad hien tai dang choi hay la an het so luong ads co the choi tai thoi diem hien tai
        if (skipMultiAds) {
            numberAdsShow = currentListVast.size();
        }
        try {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            pushEvent(adsModel, AdsEvent.AdsEventType.skipped);
        } catch (Exception ignored) {
        }
        hideAds();
    }

    @Override
    public boolean onError(Exception e) {
        clickSkipAds();

        try {
            pushEvent(null, AdsEvent.AdsEventType.playError);
        } catch (Exception ignored) {

        }

        LOGD(TAG, "onError Exception: " + e.getMessage());

        return true;
    }

    void setAdsEventListener(OnAdsEventListener adsEventListener) {
        this.adsEventListener = adsEventListener;
    }

    List<String> getListMarkerAds() {

        List<String> mapValues = new ArrayList<>(mapListVAST.keySet());
        Collections.sort(mapValues, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                if (o1.equals("start"))
                    o1 = "00:00:00";
                if (o2.equals("start"))
                    o2 = "00:00:00";
                return o1.compareTo(o2);
            }
        });

        return mapListVAST == null ? new CopyOnWriteArrayList<>() : mapValues;
    }

    List<String> getListAdsShowed() {

        Collections.sort(listTimeOfSetShowed, new Comparator<String>() {
            @Override
            public int compare(String o1, String o2) {
                if (o1.equals("start"))
                    o1 = "00:00:00";
                if (o2.equals("start"))
                    o2 = "00:00:00";
                return o1.compareTo(o2);
            }
        });
        return listTimeOfSetShowed;
    }

    boolean isPlayingAds() {
        return isPlayingAds;
    }

    void resumeAds() {
        if (videoViewAds != null && currentListVast != null) {
            try {
                pushEvent(getCurrentAdsModel(), AdsEvent.AdsEventType.resume);
            } catch (Exception ignored) {

            }
            videoViewAds.start();
        }

    }

    void pauseAds() {
        if (videoViewAds != null && currentListVast != null) {
            try {
                pushEvent(getCurrentAdsModel(), AdsEvent.AdsEventType.pause);
            } catch (Exception ignored) {

            }

            videoViewAds.pause();
        }


    }

    void muteAds(boolean mute) {
        setMute(mute);
    }

    //endregion

    //region get set

    void setTextLearnMore(TextView textLearnMore) {
        this.textLearnMore = textLearnMore;
    }


    void setTextSkipAds(TextView textSkipAds) {
        this.textSkipAds = textSkipAds;
    }


    void setTextAdsWillShowAfter(TextView textAdsWillShowAfter) {
        this.textAdsWillShowAfter = textAdsWillShowAfter;
    }


    void setStringSkipAdsAfter(String stringSkipAdsAfter) {
        this.stringSkipAdsAfter = stringSkipAdsAfter;
    }

    float getMusicVolumeLevel() {
        if (videoViewAds != null) {
            return videoViewAds.getVolume();
        }
        return 1.0f;
    }

    String getDurationAds() {

        if (currentListVast != null && currentListVast.size() > 0) {
            try {
                return currentListVast.get(numberAdsShow).getDuration();
            } catch (Exception ignored) {
            }
        }
        return "";
    }

    String getAdsId() {
        if (currentListVast != null && currentListVast.size() > 0) {
            try {
                return currentListVast.get(numberAdsShow).getIdAds();
            } catch (Exception ignored) {
            }
        }
        return "";
    }

    String getTypeOfAds() {
        if (currentListVast != null && currentListVast.size() > 0) {
            try {
                return currentListVast.get(numberAdsShow).getTimeOffset();
            } catch (Exception ignored) {
            }
        }
        return "";
    }

    public void setPlayMultiAds(boolean isPlayMultiAds) {
        this.playMultible = isPlayMultiAds;
    }

    public View getViewAdsLayout() {
        RelativeLayout currentView = (RelativeLayout) findViewById(R.id.relative_root_view);
        return currentView;
    }

    public AdsModel getCurrentAdsModel() {
        if (currentAdsModel != null) {
            return currentAdsModel;
        } else {
            if (currentListVast != null && currentListVast.size() > 0) {
                return currentListVast.get(numberAdsShow);
            }
        }
        return null;
    }
    //endregion
}

