package com.vcc.playerads.events;

import com.vcc.playerads.models.AdsModel;

public interface AdsEvent {

    /**
     * getType Of Event
     *
     * @return type
     */
    AdsEvent.AdsEventType getType();

    /**
     * get Ad Object ( maybe null)
     *
     * @return
     */
    AdsModel getAds();

    /**
     * AdsEventType
     * createView : when user initView for Ad
     * start : start video Ad
     * <p>
     * firstQuartile: progress of Ads = 25%
     * midpoint : progress of Ads = 50%
     * thirdQuartile: prgress of Ads = 75%
     * complete : complete play  Ads
     * <p>
     * mute: mute Ad
     * unmute: unmute Ad
     * pause : pause Ad
     * resume: resume Ad
     */

    public enum AdsEventType {
        creativeView,
        start,

        midpoint,
        firstQuartile,
        thirdQuartile,
        complete,

        mute,
        unmute,
        pause,
        resume,

//        rewind,
//        fullscreen,
//        expand,
//        collapse,
//        acceptInvitation,
//        close,

        loadError,

        alladscompleted,
        noAdsToShow,
        playError,
        clicked,
        //        cuepointschanged,
        contentpauserequested,
        contentresumerequested,

        log,
        adbreakready,
        //        skippablestatechanged,
        skipped,
        //        tapped,
//        icontapped,
        loaded,
        adprogress,
        adbuffering,
        //        adbreakstarted,
//        adbreakended,
//        adperiodstarted,
//        adperiodended,
        linkRequestEmpty;

        AdsEventType() {
        }

    }
}
