package com.vcc.playerads.models;


import com.vcc.playerads.utils.HttpGetUtil;
import com.vcc.playerads.utils.XmlTools;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class VMAPModel implements Serializable {

    public static String TAG = "VMAPModel";

    private static final long serialVersionUID = -4060497826275236955L;

    String adBreakXPATH = "/AdBreak";

    private transient Document vmapDocument;

    public VMAPModel(Document xmlDoc) {
        this.vmapDocument = xmlDoc;
    }

    public Document getVmapDocument() {
        return vmapDocument;
    }


    public List<AdsModel> getVASTModels() {
        final List<AdsModel> models = new ArrayList<>(5);

        NodeList adbreakNodes = vmapDocument.getElementsByTagName("vmap:AdBreak");
        int l = adbreakNodes.getLength();
        for (int i = 0; i < l; i++) {
            Node node = adbreakNodes.item(i);

            String timeOffset = XmlTools.getAttributeValue(node, "timeOffset");
            //String breakId = XmlTools.getAttributeValue(node, "breakId");

            NodeList childs = node.getChildNodes();
            for (int j = 0; j < childs.getLength(); j++) {
                Node item = childs.item(j);
                if (item.getNodeName().equalsIgnoreCase("vmap:AdSource")) {
                     String vastUrl = item.getTextContent().trim();
                    String vastXml = HttpGetUtil.get(vastUrl);
                    AdsModel adsModel = new AdsModel(XmlTools.stringToDocument(vastXml));
//                    if (timeOffset.equals())
                    adsModel.setTimeOffset(timeOffset);
                    models.add(adsModel);
                }
            }

        }
        return models;
    }

}
