package com.vcc.playerads.manager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.devbrackets.android.exomedia.listener.OnCompletionListener;
import com.devbrackets.android.exomedia.listener.OnErrorListener;
import com.devbrackets.android.exomedia.listener.OnPreparedListener;
import com.devbrackets.android.exomedia.ui.widget.VideoView;
import com.vcc.playerads.customviews.CircularProgressBar;
import com.vcc.playerads.events.AdsEvent;
import com.vcc.playerads.events.IPlayer;
import com.vcc.playerads.events.OnAdsEventListener;
import com.vcc.playerads.models.AdsModel;
import com.vcc.playerads.models.VASTMediaFile;
import com.vcc.playerads.models.VMAPModel;
import com.vcc.playerads.natives.APIRequest;
import com.vcc.playerads.utils.Constants;
import com.vcc.playerads.utils.Utilities;
import com.vcc.playerads.utils.XmlTools;
import com.ynsuper.parservast.R;

import org.w3c.dom.Document;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

import static com.vcc.playerads.utils.Constants.PROCESS_MAX_VALUES;
import static com.vcc.playerads.utils.Constants.TIME_CHECK_ADS_BEFORE;

class VASTLayout extends RelativeLayout implements
        OnPreparedListener, OnCompletionListener, OnErrorListener {

    //region Variable
    private static final String TAG = VASTLayout.class.getName();
    private static final String THREAD_NAME_REQUEST_ADVERT = "ThreadRequestAds";

    private VideoView videoViewAds;
    private ProgressBar progressBarCurrentPosition;
    private LinearLayout linearProgressShowAds;
    private TextView textSkipAds;
    private TextView textLearnMore;
    private TextView textNumberOfAds;
    private TextView textAdsTitle;
    private TextView textAdsWillShowAfter;
    private ImageView imageMuteAds;
    private CircularProgressBar progessAdsWillShowSeconds;
    private FrameLayout layoutVideoAds;
    private IPlayer iPlayer;
    private Runnable runnableUpdateProgressAds;
    private Runnable runnableCheckAds;
    private long timeCanskip = Constants.SKIP_ADS_DEFAULT;
    private List<String> listAdsShowed = new ArrayList<>();
    private boolean isPrepared;
    private boolean isCheckAds = false;
    private boolean isWillShowAfter;
    private int numberAdsShow;
    private boolean isMute = false;
    private float musicVolumeLevel;
    private boolean isPlayingAds;
    private String urlRequestAds;
    private String stringSkipAdsAfter;
    private Map<String, List<AdsModel>> mapListVAST = new HashMap<>();
    private List<AdsModel> currentListVast = new CopyOnWriteArrayList<>();
    private int timePrepare = TIME_CHECK_ADS_BEFORE;
    private ProgressBar progressLoadAds;
    private OnAdsEventListener adsEventListener;
    private boolean isProgressAdsThirdQuartile;
    private boolean isProgressAdsMidPoint;
    private boolean isProgressAdsFirstQuartile;
    private boolean isProgressAdsStart;
    private boolean isRequestAds;
    private Thread threadRequestAds;
    private Runnable runableRequestAds = new Runnable() {
        @Override
        public void run() {
            if (isRequestAds)
                return;
            isRequestAds = true;
            if (!TextUtils.isEmpty(urlRequestAds)) {
                String xmlData = APIRequest.getRequest(urlRequestAds);
                if (!TextUtils.isEmpty(xmlData)) {
                    Log.d(TAG, "runableRequestAds xml ");
                    processingXMLData(xmlData);
                } else {
                    Log.d(TAG, "runableRequestAds xml isEmpty");
                    pushEvent(null, AdsEvent.AdsEventType.noAdsToShow);
                    Log.d(TAG, "vastModel2 onResponse: null");
                    iPlayer.resume();
                }
            } else {
                iPlayer.resume();
                Log.d(TAG, "runableRequestAds xml isEmpty");
                pushEvent(null, AdsEvent.AdsEventType.noAdsToShow);
                Log.d(TAG, "vastModel2 onResponse: null");
            }
            isRequestAds = false;
        }
    };

    //endregion

    //region Constructor
    VASTLayout(Context context) {
        this(context, null);
    }

    VASTLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    VASTLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        initView();
        pushEvent(null, AdsEvent.AdsEventType.creativeView);

    }

    private static int compare(VASTMediaFile lhs, VASTMediaFile rhs) {
        if ((lhs.width * lhs.height) >= (rhs.width * rhs.height)) {
            return 1;
        } else {
            return -1;
        }
    }
    //endregion

    //region InitViews
    private void initView() {
        inflate(getContext(), R.layout.video_player_vast, this);
        bindView();
        setListener();
    }


    private void setListener() {

        progressLoadAds.getIndeterminateDrawable()
                .setColorFilter(getResources().getColor(R.color.color_progress_ads), PorterDuff.Mode.SRC_IN);

        progressBarCurrentPosition.setMax(PROCESS_MAX_VALUES);
        progressBarCurrentPosition.setProgress(0);

        progessAdsWillShowSeconds.setmMaxProgress(TIME_CHECK_ADS_BEFORE);
        progessAdsWillShowSeconds.setTextColor(Color.WHITE);
        progessAdsWillShowSeconds.setProgress(TIME_CHECK_ADS_BEFORE);

        textLearnMore.setOnClickListener(v -> clickThroughVideo());
        textSkipAds.setOnClickListener(v -> clickSkipAds());
        imageMuteAds.setOnClickListener(v -> clickMute());
        runnableUpdateProgressAds = this::updateProgressAdverts;
        runnableCheckAds = this::checkAdsRealTime;
    }

    private void initAudioSession() {
        videoViewAds.setOnPreparedListener(this);
        videoViewAds.setOnCompletionListener(this);
        videoViewAds.setOnErrorListener(this);
        musicVolumeLevel = videoViewAds.getVolume();
        if (musicVolumeLevel <= 0) {
            musicVolumeLevel = 0.5f;
        }
        imageMuteAds.setImageResource(R.drawable.icon_unmute);
    }

    private void bindView() {
        textAdsWillShowAfter = findViewById(R.id.text_ads_will_show);
        progressLoadAds = findViewById(R.id.prgress_loading_ads);
        imageMuteAds = findViewById(R.id.image_mute);
        textNumberOfAds = findViewById(R.id.text_number_of_ads);
        textAdsTitle = findViewById(R.id.text_ads_title);
        progessAdsWillShowSeconds = findViewById(R.id.progress_time_before);
        textLearnMore = findViewById(R.id.text_learn_more);
        layoutVideoAds = findViewById(R.id.view_container_ads);
        linearProgressShowAds = findViewById(R.id.linear_progress_show_ads_before);
        textSkipAds = findViewById(R.id.text_skip_ads);
        progressBarCurrentPosition = findViewById(R.id.progress_current_position);
        stringSkipAdsAfter = getResources().getString(R.string.string_can_skip_after);
    }
    //endregion

    //region Request ads and processing
    void requestAds(String url) {
        requestAds(url, true);
    }

    void requestAds(String url, boolean resetAds) {
        this.urlRequestAds = url;
        if (resetAds) {
            resetAllAds();
        }
        iPlayer.pause();

        try {
            layoutVideoAds.removeCallbacks(runnableCheckAds);
            removeCallbacks(runnableUpdateProgressAds);
        } catch (Exception ignored) {
        }

        threadRequestAds = new Thread(runableRequestAds, THREAD_NAME_REQUEST_ADVERT);
        threadRequestAds.start();
    }

    private void processingXMLData(String xml) {
        Document mainDoc = XmlTools.stringToDocument(xml);
        AdsModel adsModel = new AdsModel(mainDoc);
//        Log.d(TAG, "vastModel2: " + adsModel.getVideoClicks());

        //VMAP Type
        if (adsModel.getMediaFiles().size() == 0) {
            VMAPModel vmapModel = new VMAPModel(mainDoc);
            for (AdsModel adsModel1 : vmapModel.getVASTModels()) {
                String key = adsModel1.getTimeOffset();
                if (mapListVAST.containsKey(key)) {
                    List<AdsModel> listVast = mapListVAST.get(key);
                    if (listVast == null)
                        listVast = new CopyOnWriteArrayList<>();
                    listVast.add(adsModel1);
                    mapListVAST.remove(key);
                    mapListVAST.put(key, listVast);
                } else {
                    List<AdsModel> listVast = new CopyOnWriteArrayList<>();
                    listVast.add(adsModel1);
                    mapListVAST.put(key, listVast);

                }
            }
//                          //VAST Type
        } else {
            int currentPlayer = iPlayer.getCurentTime() / 1000;
            String currentTimePlayer;
            if (currentPlayer <= 0)
                currentTimePlayer = Utilities.convertTimeToString(currentPlayer);
            else
                currentTimePlayer = Utilities.convertTimeToString(currentPlayer + TIME_CHECK_ADS_BEFORE);
            String key = adsModel.getTimeOffset();
            if (TextUtils.isEmpty(key)) {
                if (currentTimePlayer.equals("00:00:00")) {
                    key = "start";
                } else {
                    key = currentTimePlayer;
                }
            }
            if (key.equals("00:00:00"))
                key = "start";

            if (mapListVAST.containsKey(key)) {
                List<AdsModel> listVast = mapListVAST.get(key);
                if (listVast == null)
                    listVast = new CopyOnWriteArrayList<>();
                listVast.add(adsModel);
                mapListVAST.remove(key);
                mapListVAST.put(key, listVast);
            } else {
                List<AdsModel> listVast = new CopyOnWriteArrayList<>();
                listVast.add(adsModel);
                mapListVAST.put(key, listVast);
            }
            Log.d(TAG, "vastModel2 onResponse: " + key);
        }
        layoutVideoAds.post(runnableCheckAds);
    }

    protected void resetAllAds() {
        try {
            threadRequestAds.stop();
        } catch (Exception e) {
            e.printStackTrace();
        }
        isRequestAds = false;
        layoutVideoAds.removeCallbacks(runnableCheckAds);
        removeCallbacks(runnableUpdateProgressAds);

        listAdsShowed.clear();
        mapListVAST.clear();
        if (currentListVast != null) {
            currentListVast.clear();
        }
        isPlayingAds = false;
        isCheckAds = false;
        numberAdsShow = 0;

        timePrepare = TIME_CHECK_ADS_BEFORE;
        if (videoViewAds != null) {
            try {
                layoutVideoAds.removeView(videoViewAds);
                layoutVideoAds.removeAllViews();
                videoViewAds = null;
            } catch (Exception ignored) {
            }

        }
        isPrepared = false;
        isWillShowAfter = false;
        timeCanskip = Constants.SKIP_ADS_DEFAULT;
        isPlayingAds = false;

        setVisibilityAllView(GONE);


    }

    private void checkScreenForAdsAndShow(AdsModel adsModel) {
        // check Screen and show ads
        String adsUrl = getScreenForAds(adsModel);
        // check Ads Available or not
        if (!checkAdsShowed(adsUrl)) {
            iPlayer.pause();
            listAdsShowed.add(adsUrl);
            hideSkipAds();
            showAds(adsModel, adsUrl);
            isPlayingAds = true;
            pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.contentpauserequested);
        } else {
            Log.d(TAG, "Available Ads loaded");
            if (!iPlayer.isPlaying())
                clickSkipAds();
        }

    }

    private String getScreenForAds(AdsModel adsModel) {
        int widthScreen = getWidth();
        int heightScreen = getHeight();
        //return a Screen for Ads
        VASTMediaFile vastMediaFile = selectViewForAds(widthScreen, heightScreen, adsModel.getMediaFiles());
        return vastMediaFile.getValue();
    }

    private boolean checkAdsShowed(String value) {
        if (listAdsShowed != null) {
            return listAdsShowed.contains(value);
        } else
            listAdsShowed = new CopyOnWriteArrayList<>();
        return false;
    }

    void setIPlayerContent(IPlayer iPlayer) {
        this.iPlayer = iPlayer;
    }

    private void checkAdsRealTime() {
        if (isPlayingAds) {
            layoutVideoAds.postDelayed(runnableCheckAds, Constants.TIME_DELAY);
            return;
        }
        if (!isCheckAds && iPlayer != null) {
            boolean isEnded = false;
            isCheckAds = true;

            int duration = iPlayer.getDuration();
            int currentPosition = iPlayer.getCurentTime();
            String preparePosition = Utilities.convertTimeToString((iPlayer.getCurentTime() / 1000) + TIME_CHECK_ADS_BEFORE);
            //check ads video
            Log.d(TAG, "currentPosition):  " + currentPosition + " duration:  " + duration);
            if (currentPosition <= Constants.TIME_MILISECOND) {
                isWillShowAfter = false;
                currentListVast = mapListVAST.get("start");
                if (currentListVast != null && !currentListVast.isEmpty()) {
                    iPlayer.pause();
                }
            } else if ((currentPosition / Constants.TIME_MILISECOND) >= (duration / Constants.TIME_MILISECOND)) {
                isWillShowAfter = false;
                currentListVast = mapListVAST.get("end");
                Log.d(TAG, "currentPosition):  " + currentPosition + " duration end :  " + duration);

            } else if (mapListVAST.containsKey(preparePosition)) {
                isWillShowAfter = true;
                currentListVast = mapListVAST.get(preparePosition);

            }


            if (currentListVast != null && !currentListVast.isEmpty()) {
                if (isWillShowAfter) {
                    showAfterSeconds();
                } else {
                    checkAds();
                }
            }

            isCheckAds = false;
            if (currentListVast == null || numberAdsShow >= currentListVast.size()) {
                if (listAdsShowed.size() >= mapListVAST.keySet().size()) {
                    isEnded = true;
                    layoutVideoAds.removeCallbacks(runnableCheckAds);
                    if (currentListVast != null && !currentListVast.isEmpty()) {
                        try {
                            AdsModel adsModel = currentListVast.get(numberAdsShow);
                            pushEvent(adsModel, AdsEvent.AdsEventType.alladscompleted);
                        } catch (Exception ignored) {
                        }
                    } else
                        pushEvent(null, AdsEvent.AdsEventType.alladscompleted);
                    iPlayer.resume();
                }

            }
            if (isEnded)
                return;
        }

        layoutVideoAds.postDelayed(runnableCheckAds, Constants.TIME_DELAY);
    }


    private void checkAds() {
        if (!isShowAds() || (numberAdsShow < currentListVast.size())) {
            try {
                Log.d(TAG, "checkAds numberOfAds multi " + numberAdsShow + " of " + currentListVast.size());
                AdsModel adsModel = currentListVast.get(numberAdsShow);
                checkScreenForAdsAndShow(adsModel);
            } catch (Exception e) {
                clickSkipAds();
                e.getMessage();
            }

        }

    }

    @SuppressLint("SetTextI18n")
    private void showAfterSeconds() {
        if (linearProgressShowAds.getVisibility() != VISIBLE) {
            linearProgressShowAds.setVisibility(View.VISIBLE);
        }
        progessAdsWillShowSeconds.setProgress(timePrepare);
        Log.d(TAG, "checkAdsBefore TIME_CHECK_ADS_BEFORE: " + timePrepare);

        if (timePrepare == TIME_CHECK_ADS_BEFORE) {
            Animation tranLeftToRight = AnimationUtils.loadAnimation(getContext(), R.anim.translate_left_right);
            linearProgressShowAds.startAnimation(tranLeftToRight);

            if (videoViewAds == null) {
                videoViewAds = new VideoView(getContext());

                initAudioSession();
                FrameLayout.LayoutParams layoutParamsVideo = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
                layoutVideoAds.addView(videoViewAds, layoutParamsVideo);
            }

            if (videoViewAds != null) {
                videoViewAds.stopPlayback();
            }
            isPrepared = false;
            numberAdsShow = 0;
            prepareAds();
        }
        if (timePrepare < 0) {
            Animation tranRightToLeft = AnimationUtils.loadAnimation(getContext(), R.anim.translate_right_left);
            linearProgressShowAds.startAnimation(tranRightToLeft);
            isWillShowAfter = false;
            timePrepare = TIME_CHECK_ADS_BEFORE;
            hideAfterSeconds();

            if (isPrepared && videoViewAds != null) {
                setVisibilityAllView(VISIBLE);
                progressLoadAds.setVisibility(GONE);


                isPlayingAds = true;
                videoViewAds.start();
            }
            linearProgressShowAds.setVisibility(View.GONE);
        }
        timePrepare--;
    }

    private void prepareAds() {
        if (currentListVast != null && numberAdsShow < currentListVast.size()) {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            String adsUrl = getScreenForAds(adsModel);
            if (!TextUtils.isEmpty(adsUrl)) {
                videoViewAds.setVideoURI(Uri.parse(getScreenForAds(adsModel)));
                pushEvent(adsModel, AdsEvent.AdsEventType.adbreakready);
            }

        }
    }


    void hideAfterSeconds() {
        linearProgressShowAds.setVisibility(View.GONE);
    }
    //endregion

    //region Custom show/hide components

    void showSkipAds() {
        textSkipAds.setVisibility(VISIBLE);
    }


    void hideSkipAds() {
        textSkipAds.setVisibility(View.GONE);
    }


    @SuppressLint("DefaultLocale")
    private void showAds(AdsModel adsModel, String adsUrl) {
        adsModel.setCurrentUrlVideo(adsUrl);
        if (videoViewAds == null) {
            videoViewAds = new VideoView(getContext());

            initAudioSession();
            FrameLayout.LayoutParams layoutParamsVideo = new FrameLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
            layoutVideoAds.addView(videoViewAds, layoutParamsVideo);
        }
        if (numberAdsShow <= 0) {
            Animation aniFadeIn = AnimationUtils.loadAnimation(getContext(), R.anim.fade_in_ads);
            layoutVideoAds.startAnimation(aniFadeIn);
        }


        progressBarCurrentPosition.setVisibility(VISIBLE);
        progressLoadAds.setVisibility(VISIBLE);
        imageMuteAds.setVisibility(VISIBLE);
        textLearnMore.setVisibility(VISIBLE);
//        textSkipAds.setVisibility(VISIBLE);
        layoutVideoAds.setVisibility(View.VISIBLE);
        videoViewAds.setVisibility(VISIBLE);
        textAdsTitle.setVisibility(VISIBLE);


        textAdsTitle.setText(adsModel.getAdsTitles());
        if (videoViewAds != null) {
            try {
                videoViewAds.stopPlayback();
            } catch (Exception ignored) {
            }
        }

        Uri adsUri;
        try {
            adsUri = Uri.parse(adsUrl);
            if (adsUri == null)
                throw new NullPointerException("Adverts uri is null.");
        } catch (Exception e) {
            clickSkipAds();
            return;
        }
        videoViewAds.setVideoURI(adsUri);
        pushEvent(adsModel, AdsEvent.AdsEventType.adbuffering);

        //get From vastmodel
        try {
            String skipOfSet = adsModel.getSkipOffset();//hh:mm:ss
            String[] units = skipOfSet.split(":"); //will break the string up into an array
            int hours = Integer.parseInt(units[0]); //first element
            int minutes = Integer.parseInt(units[1]); //first element
            int seconds = Integer.parseInt(units[2]); //second element

            Constants.SKIP_ADS_DEFAULT = 3600 * hours + 60 * minutes + seconds;
        } catch (Exception e) {
            Constants.SKIP_ADS_DEFAULT = 6;
        }

        timeCanskip = Constants.SKIP_ADS_DEFAULT;

        if (currentListVast.size() > 1) {
            textNumberOfAds.setVisibility(VISIBLE);
            textNumberOfAds.setText(String.format("%d of %d Ads", numberAdsShow + 1, currentListVast.size()));
        } else {
            textNumberOfAds.setVisibility(GONE);
            textNumberOfAds.setText("");

        }
        if (adsEventListener != null) {
            pushEvent(adsModel, AdsEvent.AdsEventType.loaded);
        }
    }

    private void pushEvent(AdsModel ads, AdsEvent.AdsEventType eventType) {
        AdsEvent adsEvent = new AdsEvent() {
            @Override
            public AdsEventType getType() {
                return eventType;
            }

            @Override
            public AdsModel getAds() {
                return ads;
            }

        };
        if (adsEventListener != null) {
            adsEventListener.onAdsEventListener(adsEvent);
        }
        sendTracking(ads, eventType);
    }

    private void sendTracking(AdsModel ads, AdsEvent.AdsEventType eventType) {
        if (ads == null) {
            return;
        }
        Map<AdsEvent.AdsEventType, List<String>> mapTracking = ads.getTrackingUrls();
        if (mapTracking != null && mapTracking.containsKey(eventType) && mapTracking.get(eventType) != null) {
            if (mapTracking.get(eventType).size() > 0) {
                try {
                    APIRequest.postRequest((mapTracking.get(eventType)).get(0));
                } catch (Exception ignored) {
                }
            }
        }
    }


    void hideAds() {
        numberAdsShow++;
        if (numberAdsShow >= currentListVast.size()) {
            currentListVast.clear();
            numberAdsShow = 0;
            seekVideoPlayer2Second();
            if (videoViewAds != null)
                videoViewAds.reset();
            releaseVideoView();

            Animation aniFade = AnimationUtils.loadAnimation(getContext(), R.anim.fade_out_ads);
            layoutVideoAds.startAnimation(aniFade);

            setVisibilityAllView(GONE);

            isPlayingAds = false;
            isWillShowAfter = false;
            return;
        }
        if (videoViewAds != null)
            videoViewAds.stopPlayback();


        isPlayingAds = false;
        isProgressAdsStart = false;
        isProgressAdsThirdQuartile = false;
        isProgressAdsMidPoint = false;
        isProgressAdsFirstQuartile = false;

        Log.i(TAG, "checkProgressAds : >= 99 : " + "99%   currentListVast: " + currentListVast.get(0).getAdsTitles());
        pushEvent(null, AdsEvent.AdsEventType.complete);


    }

    private void setVisibilityAllView(int visibilityAllView) {

        progressLoadAds.setVisibility(visibilityAllView);
        progressBarCurrentPosition.setVisibility(visibilityAllView);
        linearProgressShowAds.setVisibility(visibilityAllView);
        imageMuteAds.setVisibility(visibilityAllView);
        textLearnMore.setVisibility(visibilityAllView);
        textSkipAds.setVisibility(visibilityAllView);
        textNumberOfAds.setVisibility(visibilityAllView);
        layoutVideoAds.setVisibility(visibilityAllView);
        textAdsTitle.setVisibility(visibilityAllView);
    }

    private void releaseVideoView() {
        try {
            layoutVideoAds.removeView(videoViewAds);
            layoutVideoAds.removeAllViews();
            videoViewAds = null;
        } catch (Exception ignored) {
        }
    }

    private void seekVideoPlayer2Second() {
        int currentTime = iPlayer.getCurentTime();
        int durationPlayer = iPlayer.getDuration();
        if (currentTime - 2000 <= 0)
            currentTime = 0;
        else if (currentTime < durationPlayer)
            currentTime -= 2000;
        else
            currentTime = -1000;
        if (currentTime != -1000) {
            iPlayer.seekTo(currentTime);
            pushEvent(null, AdsEvent.AdsEventType.contentresumerequested);
        }

    }


    boolean isShowAds() {
        return layoutVideoAds.getVisibility() == View.VISIBLE;
    }

    private VASTMediaFile selectViewForAds(int screenWidth, int screenHeight, List<VASTMediaFile> listSizeSupport) {
        Collections.sort(listSizeSupport, VASTLayout::compare);
        VASTMediaFile sizeSelected = new VASTMediaFile();
        for (VASTMediaFile size : listSizeSupport) {
            if (size.width >= screenWidth && size.height >= screenHeight) {
                sizeSelected = size;
                return sizeSelected;
            }
        }
        if (sizeSelected.getValue() == null && listSizeSupport.size() > 0) {
            try {
                sizeSelected = listSizeSupport.get(listSizeSupport.size() - 1);
            } catch (Exception ignored) {
            }
        }
        return sizeSelected;
    }
    //endregion

    //region Handle video player ads
    @Override
    public void onPrepared() {
        isPrepared = true;
        if (!isWillShowAfter) {
            progressLoadAds.setVisibility(GONE);
            videoViewAds.start();
            setMute(isMute);
            AdsModel adsModel = null;
            if (currentListVast != null && currentListVast.size() > 0)
                try {
                    adsModel = currentListVast.get(numberAdsShow);
                } catch (Exception ignored) {
                }
            pushEvent(adsModel, AdsEvent.AdsEventType.loaded);
        }

        postDelayed(runnableUpdateProgressAds, Constants.TIME_DELAY);
    }

    @Override
    public void onCompletion() {
        removeCallbacks(runnableUpdateProgressAds);
        if (currentListVast != null) {
            hideAds();
        }
    }


    protected int getProgressVideo() {
        return (int) (((float) videoViewAds.getCurrentPosition() / videoViewAds.getDuration()) * PROCESS_MAX_VALUES);
    }

    @SuppressLint("SetTextI18n")
    private void updateProgressAdverts() {
        //TODO update current time of ad
        if (videoViewAds == null)
            return;
        int time = getProgressVideo();
        checkProgressAds(time);

        progressBarCurrentPosition.setProgress(time);
        timeCanskip = Constants.SKIP_ADS_DEFAULT - videoViewAds.getCurrentPosition() / 1000;
        if (timeCanskip > 0) {
            if (videoViewAds.isPlaying())
                showSkipAds();
            else
                hideSkipAds();
            textSkipAds.setText(stringSkipAdsAfter + " " + timeCanskip);
            textSkipAds.setEnabled(false);
        } else {
            textSkipAds.setText(getContext().getString(R.string.string_skipable));
            textSkipAds.setEnabled(true);
        }

        postDelayed(runnableUpdateProgressAds, Constants.TIME_DELAY);

    }

    private void checkProgressAds(int progressVideo) {

        try {
            pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.adprogress);
        } catch (Exception e) {
            e.printStackTrace();
        }
        if (progressVideo >= 75) {
            if (!isProgressAdsThirdQuartile) {
                Log.i(TAG, "checkProgressAds : >= 75 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.thirdQuartile);
                isProgressAdsThirdQuartile = true;
            }
        } else if (progressVideo >= 50) {
            if (!isProgressAdsMidPoint) {
                Log.i(TAG, "checkProgressAds : >= 50 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.midpoint);
                isProgressAdsMidPoint = true;
            }
        } else if (progressVideo >= 25) {
            if (!isProgressAdsFirstQuartile) {
                Log.i(TAG, "checkProgressAds : >= 25 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.firstQuartile);
                isProgressAdsFirstQuartile = true;
            }
        } else if (progressVideo >= 0) {
            if (!isProgressAdsStart) {
                Log.i(TAG, "checkProgressAds : >= 0 : " + progressVideo + "%   numberAdsShow: " + numberAdsShow);
                pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.start);
                isProgressAdsStart = true;
            }
        }

    }
    //endregion

    //region Action click view
    private void clickMute() {

        if (videoViewAds == null)
            return;
        if (isPrepared) {

            if (!isMute) {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_mute));
                videoViewAds.setVolume(0.0f);
                pushEvent(null, AdsEvent.AdsEventType.mute);
            } else {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_unmute));
                videoViewAds.setVolume(musicVolumeLevel);
                pushEvent(null, AdsEvent.AdsEventType.unmute);

            }
            isMute = !isMute;
        }

    }

    private void setMute(boolean mute) {
        if (videoViewAds == null) {
            isMute = mute;
            return;
        }
        if (isPrepared) {
            if (mute) {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_mute));
                videoViewAds.setVolume(0.0f);
                pushEvent(null, AdsEvent.AdsEventType.mute);
            } else {
                imageMuteAds.setImageDrawable(getResources().getDrawable(R.drawable.icon_unmute));
                videoViewAds.setVolume(musicVolumeLevel);
                pushEvent(null, AdsEvent.AdsEventType.unmute);

            }
        }
        isMute = mute;

    }


    void clickThroughVideo() {
        try {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            if (!TextUtils.isEmpty(adsModel.getVideoClicks().getClickThrough())) {
                Intent browserIntent = new Intent(Intent.ACTION_VIEW, Uri.parse(adsModel.getVideoClicks().getClickThrough()));
                getContext().startActivity(browserIntent);
                pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.clicked);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    void clickSkipAds() {
        //TODO an ad hien tai dang choi hay la an het so luong ads co the choi tai thoi diem hien tai
        try {
            AdsModel adsModel = currentListVast.get(numberAdsShow);
            pushEvent(adsModel, AdsEvent.AdsEventType.skipped);
        } catch (Exception ignored) {
        }
        hideAds();
    }

    @Override
    public boolean onError(Exception e) {
        clickSkipAds();

        pushEvent(null, AdsEvent.AdsEventType.playError);

        Log.d(TAG, "onError Exception: " + e.getMessage());

        return true;
    }

    void setAdsEventListener(OnAdsEventListener adsEventListener) {
        this.adsEventListener = adsEventListener;
    }

    List<String> getListMarkerAds() {
        return mapListVAST == null ? new CopyOnWriteArrayList<>() : new ArrayList<>(mapListVAST.keySet());
    }

    boolean isPlayingAds() {
        return isPlayingAds;
    }

    void resumeAds() {
        if (videoViewAds != null) {
            pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.resume);
            videoViewAds.start();
        }

    }

    void pauseAds() {
        if (videoViewAds != null) {
            pushEvent(currentListVast.get(numberAdsShow), AdsEvent.AdsEventType.pause);
            videoViewAds.pause();
        }


    }

    public void muteAds(boolean mute) {
        setMute(mute);
    }

    //endregion

    //region get set
    public TextView getTextLearnMore() {
        return textLearnMore;
    }

    public void setTextLearnMore(TextView textLearnMore) {
        this.textLearnMore = textLearnMore;
    }

    public TextView getTextSkipAds() {
        return textSkipAds;
    }

    public void setTextSkipAds(TextView textSkipAds) {
        this.textSkipAds = textSkipAds;
    }

    public TextView getTextAdsWillShowAfter() {
        return textAdsWillShowAfter;
    }

    public void setTextAdsWillShowAfter(TextView textAdsWillShowAfter) {
        this.textAdsWillShowAfter = textAdsWillShowAfter;
    }

    public String getStringSkipAdsAfter() {
        return stringSkipAdsAfter;
    }

    public void setStringSkipAdsAfter(String stringSkipAdsAfter) {
        this.stringSkipAdsAfter = stringSkipAdsAfter;
    }
    //endregion
}
