package com.vcc.playerads.manager;

import android.content.Context;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.FrameLayout;

import com.vcc.playerads.events.AdsEvent;
import com.vcc.playerads.events.IPlayer;
import com.vcc.playerads.events.OnAdsEventListener;
import com.vcc.playerads.models.AdsModel;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class SHAdsManager implements ISHAdsManager {
    private Context context;
    private String urlRequest;
    private FrameLayout adsGroupContainer;
    private IPlayer iPlayer;
    private VASTLayout vastLayout;
    private OnAdsEventListener onAdsEventListener;

    public SHAdsManager(Context context, IPlayer iPlayer, OnAdsEventListener onAdsEventListener) {
        this(context, "", iPlayer, onAdsEventListener);
    }

    private SHAdsManager(Context context, String url, IPlayer iPlayer, OnAdsEventListener onAdsEventListener) {
        try {
            System.loadLibrary("APIRequest");
        } catch (Exception | UnsatisfiedLinkError e) {
            if (onAdsEventListener != null) {
                AdsEvent adsEvent = new AdsEvent() {
                    @Override
                    public AdsEventType getType() {
                        return AdsEventType.loadError;
                    }

                    @Override
                    public AdsModel getAds() {
                        return null;
                    }
                };
                onAdsEventListener.onAdsEventListener(adsEvent);
            }
            return;
        }
        if (iPlayer != null)
            this.adsGroupContainer = iPlayer.getAdsContainer();
        this.iPlayer = iPlayer;
        this.context = context;
        this.urlRequest = url;
        setOnAdsEventListener(onAdsEventListener);
        initAdsView();
    }

    @Override
    public void setUrlRequest(String urlRequest) {
        this.urlRequest = urlRequest;
    }

    private void initAdsView() {
        if (adsGroupContainer == null)
            return;
        if (vastLayout == null) {
            vastLayout = new VASTLayout(context);
            vastLayout.setIPlayerContent(iPlayer);
            vastLayout.setLayoutParams(new FrameLayout.LayoutParams(
                    ViewGroup.LayoutParams.MATCH_PARENT,
                    ViewGroup.LayoutParams.MATCH_PARENT
            ));

            adsGroupContainer.addView(vastLayout);
            if (onAdsEventListener != null)
                vastLayout.setAdsEventListener(onAdsEventListener);
        }
    }


    @Override
    public void requestAds() {
        requestAds(true);
    }

    @Override
    public void requestAds(boolean resetAds) {
        if (TextUtils.isEmpty(urlRequest)) {
            if (onAdsEventListener != null) {
                AdsEvent adsEvent = new AdsEvent() {
                    @Override
                    public AdsEventType getType() {
                        return AdsEventType.linkRequestEmpty;
                    }

                    @Override
                    public AdsModel getAds() {
                        return null;
                    }
                };
                onAdsEventListener.onAdsEventListener(adsEvent);
            }
            return;
        }

        if (vastLayout != null)
            vastLayout.requestAds(urlRequest);

    }

    @Override
    public void resumeAds() {
        if (vastLayout != null)
            vastLayout.resumeAds();
    }

    @Override
    public void pauseAds() {
        if (vastLayout != null)
            vastLayout.pauseAds();
    }

    @Override
    public void skipAds() {
        if (vastLayout != null)
            vastLayout.clickSkipAds();
    }

    @Override
    public void releaseAds() {
        if (vastLayout != null)
            vastLayout.resetAllAds();
    }

    @Override
    public List<String> getMarkerShowAds() {
        if (vastLayout != null) {
            return vastLayout.getListMarkerAds();
        }
        return new CopyOnWriteArrayList<>();
    }

    @Override
    public boolean isPlayingAds() {
        return vastLayout != null && vastLayout.isPlayingAds();
    }

    public OnAdsEventListener getOnAdsEventListener() {
        return onAdsEventListener;
    }

    @Override
    public void setOnAdsEventListener(OnAdsEventListener onAdsEventListener) {
        if (vastLayout != null)
            vastLayout.setAdsEventListener(onAdsEventListener);
        this.onAdsEventListener = onAdsEventListener;
    }

    @Override
    public void muteAds(boolean mute) {
        if (vastLayout != null)
            vastLayout.muteAds(mute);
    }
}
