/*
 * Decompiled with CFR 0.152.
 */
package me.lake.librestreaming.filterpackage.hardfilter.extra;

import android.opengl.GLES20;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import me.lake.librestreaming.b.a.a;
import me.lake.librestreaming.d.c;

public class GPUImageCompatibleFilter<T extends GPUImageFilter>
extends a {
    private T f;
    private FloatBuffer g;
    private FloatBuffer h;
    public static final float[] TEXTURE_NO_ROTATION = new float[]{1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f};
    public static final float[] TEXTURE_ROTATED_90 = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 0.0f};
    public static final float[] TEXTURE_ROTATED_180 = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    public static final float[] TEXTURE_ROTATED_270 = new float[]{1.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    static final float[] e = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};

    public GPUImageCompatibleFilter(T t) {
        this.f = t;
    }

    public T getGPUImageFilter() {
        return this.f;
    }

    @Override
    public void onInit(int n, int n2) {
        super.onInit(n, n2);
        this.f.init();
        this.f.onOutputSizeChanged(n, n2);
    }

    @Override
    public void onDraw(int n, int n2, FloatBuffer floatBuffer, FloatBuffer floatBuffer2) {
        GLES20.glBindFramebuffer((int)36160, (int)n2);
        this.f.onDraw(n, this.g, this.h);
        GLES20.glBindFramebuffer((int)36160, (int)0);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.f.destroy();
    }

    @Override
    public void onDirectionUpdate(int n) {
        if (this.c != n) {
            this.g = GPUImageCompatibleFilter.getGPUImageCompatShapeVerticesBuffer();
            this.h = GPUImageCompatibleFilter.getGPUImageCompatTextureVerticesBuffer(this.c);
        }
    }

    public static FloatBuffer getGPUImageCompatShapeVerticesBuffer() {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(me.lake.librestreaming.d.c.a * e.length).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(e);
        floatBuffer.position(0);
        return floatBuffer;
    }

    public static FloatBuffer getGPUImageCompatTextureVerticesBuffer(int n) {
        float[] fArray;
        switch (n & 0xF0) {
            case 32: {
                fArray = (float[])TEXTURE_ROTATED_90.clone();
                break;
            }
            case 64: {
                fArray = (float[])TEXTURE_ROTATED_180.clone();
                break;
            }
            case 128: {
                fArray = (float[])TEXTURE_ROTATED_270.clone();
                break;
            }
            default: {
                fArray = (float[])TEXTURE_NO_ROTATION.clone();
            }
        }
        if ((n & 1) != 0) {
            fArray[0] = GPUImageCompatibleFilter.a(fArray[0]);
            fArray[2] = GPUImageCompatibleFilter.a(fArray[2]);
            fArray[4] = GPUImageCompatibleFilter.a(fArray[4]);
            fArray[6] = GPUImageCompatibleFilter.a(fArray[6]);
        }
        if ((n & 2) != 0) {
            fArray[1] = GPUImageCompatibleFilter.a(fArray[1]);
            fArray[3] = GPUImageCompatibleFilter.a(fArray[3]);
            fArray[5] = GPUImageCompatibleFilter.a(fArray[5]);
            fArray[7] = GPUImageCompatibleFilter.a(fArray[7]);
        }
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(me.lake.librestreaming.d.c.a * fArray.length).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray);
        floatBuffer.position(0);
        return floatBuffer;
    }

    private static float a(float f2) {
        return f2 == 0.0f ? 1.0f : 0.0f;
    }
}

