package me.lake.librestreaming.filterpackage;

import android.content.Context;
import android.util.Log;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

import jp.co.cyberagent.android.gpuimage.GPUImageCrosshatchFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImagePixelationFilter;
import me.lake.librestreaming.client.RESClient;
import me.lake.librestreaming.filterbase.hardvideofilter.BaseHardVideoFilter;
import me.lake.librestreaming.filterbase.softvideofilter.BaseSoftVideoFilter;
import me.lake.librestreaming.filterpackage.hardfilter.ColorMixHardFilter;
import me.lake.librestreaming.filterpackage.hardfilter.FilterItemHard;
import me.lake.librestreaming.filterpackage.hardfilter.extra.GPUImageCompatibleFilter;
import me.lake.librestreaming.filterpackage.softfilter.AnimationFilterSoft;
import me.lake.librestreaming.filterpackage.softfilter.BlackWhiteFilterSoft;
import me.lake.librestreaming.filterpackage.softfilter.BlurFilterSoft;
import me.lake.librestreaming.filterpackage.softfilter.FilterItemSoft;
import me.lake.librestreaming.filterpackage.softfilter.FixYFilterSoft;
import me.lake.librestreaming.filterpackage.softfilter.IconFilterSoft;
import me.lake.librestreaming.filterpackage.softfilter.SkinBlurFilterSoft;

/**
 * Created by Admin on 8/12/2016.
 */
public class FilterManagers {
    //region Initial sketch filter
    private static FilterManagers ourInstance;
    private static Context mContext;
    //endregion
    private List<FilterItemHard> filterHard = new CopyOnWriteArrayList<FilterItemHard>();
    private List<FilterItemSoft> filterSoft = new CopyOnWriteArrayList<FilterItemSoft>();

    private FilterManagers() {
    }

    public static FilterManagers getInstance(Context context) {
        mContext = context;
        if (ourInstance == null)
            ourInstance = new FilterManagers();
        return ourInstance;
    }

    public List<FilterItemHard> getFilterHard() {
        return filterHard;
    }

    public void setFilterHard(List<FilterItemHard> filterHard) {
        this.filterHard = filterHard;
    }

    public List<FilterItemSoft> getFilterSoft() {
        return filterSoft;
    }

    public void setFilterSoft(List<FilterItemSoft> filterSoft) {
        this.filterSoft = filterSoft;
    }

    public boolean nextFilterHard(RESClient resClient, int currentFilter) {
        if (filterHard == null || filterHard.isEmpty())
            return false;
        BaseHardVideoFilter effect;
        if (currentFilter < filterHard.size())
            effect = filterHard.get(currentFilter).getFilter();
        else
            effect = filterHard.get(0).getFilter();
        return setFilterHard(resClient, effect, 5);

    }

    public boolean nextFilterSoft(RESClient resClient, int currentFilter) {
        if (filterSoft == null || filterSoft.isEmpty())
            return false;
        BaseSoftVideoFilter effect;
        if (currentFilter < filterSoft.size()) {
            FilterItemSoft filterItem = filterSoft.get(currentFilter);
            Log.d("FILTER: ", "Debug filter: " + filterItem.getName());
            effect = filterItem.getFilter();
        } else {
            FilterItemSoft filterItem = filterSoft.get(0);
            Log.d("FILTER: ", "Debug filter: " + filterItem.getName());
            effect = filterItem.getFilter();
        }
        return setFilterSoft(resClient, effect, 2);
    }

    public boolean setFilterHard(RESClient resClient, BaseHardVideoFilter effect, int progress) {
        try {
            resClient.setHardVideoFilter(effect);
            BaseHardVideoFilter filter = resClient.acquireHardVideoFilter();
            if (filter != null) {
                if (filter instanceof GPUImageCompatibleFilter) {
                    GPUImageFilter gpufilter = ((GPUImageCompatibleFilter) filter).getGPUImageFilter();
                    if (gpufilter instanceof GPUImagePixelationFilter) {
                        ((GPUImagePixelationFilter) gpufilter).setPixel(progress / 5.0f);
                    }
                    if (gpufilter instanceof GPUImageCrosshatchFilter) {
                        ((GPUImageCrosshatchFilter) gpufilter).setCrossHatchSpacing(range(progress, 0.0f, 0.06f));
                        ((GPUImageCrosshatchFilter) gpufilter).setLineWidth(range(progress, 0.0f, 0.006f));
                    }
                }
                if (filter instanceof ColorMixHardFilter) {
                    ((ColorMixHardFilter) filter).setMixColor((float) (0.5 + 0.5 * Math.sin(Math.PI * 5 * (progress / 100.0))), (float) (0.5 + 0.5 * Math.sin(Math.PI * 2 * (progress / 100.0))), (float) (0.5 + 0.5 * Math.sin(Math.PI * 7 * (progress / 100.0))), 0.3f);
                }
            }
            resClient.releaseHardVideoFilter();
            return true;
        } catch (Exception ex) {
            Log.e("STREAMING ERROR: ", "Error: " + ex.getMessage());
            return false;
        }

    }

    public boolean setFilterSoft(RESClient resClient, BaseSoftVideoFilter effect, int progress) {
        try {
            resClient.setSoftVideoFilter(effect);
            BaseSoftVideoFilter filter = resClient.acquireSoftVideoFilter();
            if (filter != null) {
                if (filter instanceof BlackWhiteFilterSoft) {
                    BlackWhiteFilterSoft blackWhiteFilter = (BlackWhiteFilterSoft) filter;
                    blackWhiteFilter.setGap((byte) ((255 * progress) / 100));
                }
                if (filter instanceof IconFilterSoft) {
                    IconFilterSoft iconFilter = (IconFilterSoft) filter;
                    iconFilter.setXPos(progress * 5);
                }
                if (filter instanceof FixYFilterSoft) {
                    FixYFilterSoft fixYFilter = (FixYFilterSoft) filter;
                    fixYFilter.setY((byte) ((progress / 100.0) * 255));
                }
                if (filter instanceof BlurFilterSoft) {
                    BlurFilterSoft blurFilter = (BlurFilterSoft) filter;
                    blurFilter.setRadius(progress / 4);
                }
                if (filter instanceof SkinBlurFilterSoft) {
                    SkinBlurFilterSoft skinBlurFilter = (SkinBlurFilterSoft) filter;
                    skinBlurFilter.setRadius(progress / 4);
                }
                if (filter instanceof AnimationFilterSoft) {
                    AnimationFilterSoft animationFilter = (AnimationFilterSoft) filter;
                    animationFilter.setXPos(progress * 5);
                }
            }
            resClient.releaseSoftVideoFilter();
            return true;
        } catch (Exception ex) {
            Log.e("STREAMING ERROR: ", "Error: " + ex.getMessage());
            return false;
        }
    }

    //========GPUImage suff==============
    protected float range(final int percentage, final float start, final float end) {
        return (end - start) * percentage / 100.0f + start;
    }

    protected int range(final int percentage, final int start, final int end) {
        return (end - start) * percentage / 100 + start;
    }

}
