package me.lake.librestreaming.customview;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;

import java.util.TimeZone;

/**
 * Created by TAKASHI20 on 10/13/2016.
 * Class owned by upstream_android at package me.lake.librestreaming.customview
 */

public class Utils {

    public static int dpiDevice;

    private static Utils utils;
    private static Context mContext;

    public Utils() {
    }

    public static Utils getInstance(Context context) {
        mContext = context;
        if (utils == null)
            utils = new Utils();
        return utils;
    }

    public int convertPxToDp(int size) {
        if (dpiDevice == 0) {
            WindowManager windowManager = (WindowManager) mContext
                    .getSystemService(Context.WINDOW_SERVICE);
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            dpiDevice = dm.densityDpi;
        }
        return size * dpiDevice / 160;
    }

    public float convertPxToDp(float size) {
        if (dpiDevice == 0) {
            WindowManager windowManager = (WindowManager) mContext
                    .getSystemService(Context.WINDOW_SERVICE);
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            dpiDevice = dm.densityDpi;
        }
        return size * dpiDevice / 160.0f;
    }

    public int convertDpToPx(int size) {
        if (dpiDevice == 0) {
            WindowManager windowManager = (WindowManager) mContext
                    .getSystemService(Context.WINDOW_SERVICE);
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            dpiDevice = dm.densityDpi;
        }
        return size * 160 / dpiDevice;
    }

    public float convertDpToPx(float size) {
        if (dpiDevice == 0) {
            WindowManager windowManager = (WindowManager) mContext
                    .getSystemService(Context.WINDOW_SERVICE);
            Display display = windowManager.getDefaultDisplay();
            DisplayMetrics dm = new DisplayMetrics();
            display.getMetrics(dm);
            dpiDevice = dm.densityDpi;
        }
        return (1.0f) * (size * 160.0f / dpiDevice);
    }

}
