/*
 * Decompiled with CFR 0.152.
 */
package com.vaynberg.wicket.select2;

import com.vaynberg.wicket.select2.AbstractSelect2Choice;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.JQuery;
import com.vaynberg.wicket.select2.json.JsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.json.JSONException;

public class Select2MultiChoice<T>
extends AbstractSelect2Choice<T, Collection<T>> {
    public Select2MultiChoice(String id, IModel<Collection<T>> model, ChoiceProvider<T> provider) {
        super(id, model, provider);
    }

    public Select2MultiChoice(String id, IModel<Collection<T>> model) {
        super(id, model);
    }

    public Select2MultiChoice(String id) {
        super(id);
    }

    public void convertInput() {
        Collection<Object> choices;
        String input = this.getWebRequest().getRequestParameters().getParameterValue(this.getInputName()).toString();
        if (Strings.isEmpty((CharSequence)input)) {
            choices = new ArrayList();
        } else {
            List<String> ids = Select2MultiChoice.splitInput(input);
            choices = this.getProvider().toChoices(ids);
        }
        this.setConvertedInput(choices);
    }

    static List<String> splitInput(String input) {
        if (input.startsWith("{") && input.endsWith("}")) {
            ArrayList<String> result = new ArrayList<String>();
            int openBracket = 0;
            Integer lastStartIdx = null;
            for (int i = 0; i < input.length(); ++i) {
                char c = input.charAt(i);
                if (c == '{') {
                    ++openBracket;
                    if (lastStartIdx == null) {
                        lastStartIdx = i;
                    }
                }
                if (c != '}' || --openBracket != 0) continue;
                String substring = input.substring(lastStartIdx, i + 1);
                result.add(substring);
                lastStartIdx = null;
            }
            return result;
        }
        return Arrays.asList(input.split(","));
    }

    public void updateModel() {
        FormComponent.updateCollectionModel((FormComponent)this);
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.getSettings().setMultiple(true);
    }

    protected String getModelValue() {
        Collection values = (Collection)this.getModelObject();
        if (values == null || values.isEmpty()) {
            return "";
        }
        return super.getModelValue();
    }

    @Override
    protected void renderInitializationScript(IHeaderResponse response) {
        Collection choices;
        if (this.hasRawInput()) {
            this.convertInput();
            choices = (Collection)this.getConvertedInput();
        } else {
            choices = (Collection)this.getModelObject();
        }
        if (choices != null && !choices.isEmpty()) {
            JsonBuilder selection = new JsonBuilder();
            try {
                selection.array();
                for (Object choice : choices) {
                    selection.object();
                    this.getProvider().toJson(choice, selection);
                    selection.endObject();
                }
                selection.endArray();
            }
            catch (JSONException e) {
                throw new RuntimeException("Error converting model object to Json", e);
            }
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute("$('#%s').select2('data', %s);", this.getJquerySafeMarkupId(), selection.toJson())));
        }
    }
}

