/*
 * Decompiled with CFR 0.152.
 */
package com.vaynberg.wicket.select2;

import com.vaynberg.wicket.select2.AjaxSettings;
import com.vaynberg.wicket.select2.JQuery;
import com.vaynberg.wicket.select2.Select2ResourcesBehavior;
import com.vaynberg.wicket.select2.Settings;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

public abstract class Select2ChoiceBaseComponent<M>
extends HiddenField<M> {
    private final Settings settings = new Settings();

    public Select2ChoiceBaseComponent(String id) {
        this(id, null);
    }

    public Select2ChoiceBaseComponent(String id, IModel<M> model) {
        super(id, model);
        this.add(new Behavior[]{new Select2ResourcesBehavior()});
        this.setOutputMarkupId(true);
    }

    public final Settings getSettings() {
        return this.settings;
    }

    protected String getJquerySafeMarkupId() {
        return this.getMarkupId().replace(".", "\\\\.");
    }

    protected String getEscapedJsString(String key) {
        String value = this.getString(key);
        return Strings.replaceAll((CharSequence)value, (CharSequence)"'", (CharSequence)"\\'").toString();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute("$('#%s').select2(%s);", this.getJquerySafeMarkupId(), this.settings.toJson())));
        this.renderInitializationScript(response);
    }

    protected void onInitialize() {
        super.onInitialize();
        AjaxSettings ajax = this.settings.getAjax(true);
        ajax.setData(String.format("function(term, page) { return { term: term, page:page, '%s':true, '%s':[window.location.protocol, '//', window.location.host, window.location.pathname].join('')}; }", "wicket-ajax", "wicket-ajax-baseurl"));
        ajax.setResults("function(data, page) { return data; }");
        this.getSettings().setFormatNoMatches("function() { return '" + this.getEscapedJsString("noMatches") + "';}");
        this.getSettings().setFormatInputTooShort("function(input, min) { return min - input.length == 1 ? '" + this.getEscapedJsString("inputTooShortSingular") + "' : '" + this.getEscapedJsString("inputTooShortPlural") + "'.replace('{number}', min - input.length); }");
        this.getSettings().setFormatSelectionTooBig("function(limit) { return limit == 1 ? '" + this.getEscapedJsString("selectionTooBigSingular") + "' : '" + this.getEscapedJsString("selectionTooBigPlural") + "'.replace('{limit}', limit); }");
        this.getSettings().setFormatLoadMore("function() { return '" + this.getEscapedJsString("loadMore") + "';}");
        this.getSettings().setFormatSearching("function() { return '" + this.getEscapedJsString("searching") + "';}");
    }

    protected abstract void renderInitializationScript(IHeaderResponse var1);

    public void onEvent(IEvent<?> event) {
        AjaxRequestTarget target;
        super.onEvent(event);
        if (event.getPayload() instanceof AjaxRequestTarget && (target = (AjaxRequestTarget)event.getPayload()).getComponents().contains((Object)this)) {
            target.prependJavaScript((CharSequence)JQuery.execute("$('#%s').select2('destroy');", this.getJquerySafeMarkupId()));
        }
    }

    protected void onRemove() {
        super.onRemove();
        AjaxRequestTarget target = (AjaxRequestTarget)this.getRequestCycle().find(AjaxRequestTarget.class);
        if (target != null) {
            target.prependJavaScript((CharSequence)String.format("$('#%s').select2('close');", this.getJquerySafeMarkupId()));
        }
    }
}

