/*
 * Decompiled with CFR 0.152.
 */
package com.vaynberg.wicket.select2;

import com.vaynberg.wicket.select2.AbstractSelect2Choice;
import com.vaynberg.wicket.select2.ChoiceProvider;
import com.vaynberg.wicket.select2.JQuery;
import com.vaynberg.wicket.select2.json.JsonBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;
import org.json.JSONException;

public class Select2MultiChoice<T>
extends AbstractSelect2Choice<T, Collection<T>> {
    public Select2MultiChoice(String id, IModel<Collection<T>> model, ChoiceProvider<T> provider) {
        super(id, model, provider);
    }

    public Select2MultiChoice(String id, IModel<Collection<T>> model) {
        super(id, model);
    }

    public Select2MultiChoice(String id) {
        super(id);
    }

    protected void convertInput() {
        String input = this.getWebRequest().getRequestParameters().getParameterValue(this.getInputName()).toString();
        Collection<Object> choices = Strings.isEmpty((CharSequence)input) ? new ArrayList() : this.getProvider().toChoices(Arrays.asList(input.split(",")));
        this.setConvertedInput(choices);
    }

    public void updateModel() {
        Collection choices = (Collection)this.getModelObject();
        Collection selection = (Collection)this.getConvertedInput();
        if (choices == null) {
            this.getModel().setObject((Object)selection);
        } else {
            choices.clear();
            choices.addAll(selection);
            this.getModel().setObject((Object)choices);
        }
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.getSettings().setMultiple(true);
    }

    protected String getModelValue() {
        Collection values = (Collection)this.getModelObject();
        if (values == null || values.isEmpty()) {
            return "";
        }
        return super.getModelValue();
    }

    @Override
    protected void renderInitializationScript(IHeaderResponse response) {
        Collection choices;
        if (this.getWebRequest().getRequestParameters().getParameterNames().contains(this.getInputName())) {
            this.convertInput();
            choices = (Collection)this.getConvertedInput();
        } else {
            choices = (Collection)this.getModelObject();
        }
        if (choices != null && !choices.isEmpty()) {
            JsonBuilder selection = new JsonBuilder();
            try {
                selection.array();
                for (Object choice : choices) {
                    selection.object();
                    this.getProvider().toJson(choice, selection);
                    selection.endObject();
                }
                selection.endArray();
            }
            catch (JSONException e) {
                throw new RuntimeException("Error converting model object to Json", e);
            }
            response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)JQuery.execute("$('#%s').select2('data', %s);", this.getJquerySafeMarkupId(), selection.toJson())));
        }
    }
}

