/*
 * Decompiled with CFR 0.152.
 */
package com.varunjohn1990.audio_record_view;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.v4.widget.TextViewCompat;
import android.text.Editable;
import android.text.TextWatcher;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.varunjohn1990.audio_record_view.AttachmentOption;
import com.varunjohn1990.audio_record_view.AttachmentOptionsListener;
import com.varunjohn1990.audio_record_view.R;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Timer;
import java.util.TimerTask;

public class AudioRecordView {
    private String TAG = "AudioRecordView";
    private LinearLayout viewContainer;
    private LinearLayout layoutAttachmentOptions;
    private View imageViewAudio;
    private View imageViewLockArrow;
    private View imageViewLock;
    private View imageViewMic;
    private View dustin;
    private View dustin_cover;
    private View imageViewStop;
    private View imageViewSend;
    private View layoutAttachment;
    private View layoutDustin;
    private View layoutMessage;
    private View imageViewAttachment;
    private View imageViewCamera;
    private View imageViewEmoji;
    private View layoutSlideCancel;
    private View layoutLock;
    private View layoutEffect1;
    private View layoutEffect2;
    private EditText editTextMessage;
    private TextView timeText;
    private TextView textViewSlide;
    private ImageView stop;
    private ImageView audio;
    private ImageView send;
    private Animation animBlink;
    private Animation animJump;
    private Animation animJumpFast;
    private boolean isDeleting;
    private boolean stopTrackingAction;
    private Handler handler;
    private int audioTotalTime;
    private TimerTask timerTask;
    private Timer audioTimer;
    private SimpleDateFormat timeFormatter;
    private float lastX;
    private float lastY;
    private float firstX;
    private float firstY;
    private float directionOffset;
    private float cancelOffset;
    private float lockOffset;
    private float dp = 0.0f;
    private boolean isLocked = false;
    private UserBehaviour userBehaviour = UserBehaviour.NONE;
    private RecordingListener recordingListener;
    boolean isLayoutDirectionRightToLeft;
    int screenWidth;
    int screenHeight;
    private List<AttachmentOption> attachmentOptionList;
    private AttachmentOptionsListener attachmentOptionsListener;
    private List<LinearLayout> layoutAttachments;
    private Context context;
    private boolean showCameraIcon = true;
    private boolean showAttachmentIcon = true;
    private boolean showEmojiIcon = true;
    private boolean removeAttachmentOptionAnimation;

    public void initView(ViewGroup view) {
        if (view == null) {
            this.showErrorLog("initView ViewGroup can't be NULL");
            return;
        }
        this.context = view.getContext();
        view.removeAllViews();
        view.addView(LayoutInflater.from((Context)view.getContext()).inflate(R.layout.record_view, null));
        this.timeFormatter = new SimpleDateFormat("m:ss", Locale.getDefault());
        DisplayMetrics displayMetrics = view.getContext().getResources().getDisplayMetrics();
        this.screenHeight = displayMetrics.heightPixels;
        this.screenWidth = displayMetrics.widthPixels;
        this.isLayoutDirectionRightToLeft = view.getContext().getResources().getBoolean(R.bool.is_right_to_left);
        this.viewContainer = (LinearLayout)view.findViewById(R.id.layoutContainer);
        this.layoutAttachmentOptions = (LinearLayout)view.findViewById(R.id.layoutAttachmentOptions);
        this.imageViewAttachment = view.findViewById(R.id.imageViewAttachment);
        this.imageViewCamera = view.findViewById(R.id.imageViewCamera);
        this.imageViewEmoji = view.findViewById(R.id.imageViewEmoji);
        this.editTextMessage = (EditText)view.findViewById(R.id.editTextMessage);
        this.send = (ImageView)view.findViewById(R.id.imageSend);
        this.stop = (ImageView)view.findViewById(R.id.imageStop);
        this.audio = (ImageView)view.findViewById(R.id.imageAudio);
        this.imageViewAudio = view.findViewById(R.id.imageViewAudio);
        this.imageViewStop = view.findViewById(R.id.imageViewStop);
        this.imageViewSend = view.findViewById(R.id.imageViewSend);
        this.imageViewLock = view.findViewById(R.id.imageViewLock);
        this.imageViewLockArrow = view.findViewById(R.id.imageViewLockArrow);
        this.layoutDustin = view.findViewById(R.id.layoutDustin);
        this.layoutMessage = view.findViewById(R.id.layoutMessage);
        this.layoutAttachment = view.findViewById(R.id.layoutAttachment);
        this.textViewSlide = (TextView)view.findViewById(R.id.textViewSlide);
        this.timeText = (TextView)view.findViewById(R.id.textViewTime);
        this.layoutSlideCancel = view.findViewById(R.id.layoutSlideCancel);
        this.layoutEffect2 = view.findViewById(R.id.layoutEffect2);
        this.layoutEffect1 = view.findViewById(R.id.layoutEffect1);
        this.layoutLock = view.findViewById(R.id.layoutLock);
        this.imageViewMic = view.findViewById(R.id.imageViewMic);
        this.dustin = view.findViewById(R.id.dustin);
        this.dustin_cover = view.findViewById(R.id.dustin_cover);
        this.handler = new Handler(Looper.getMainLooper());
        this.dp = TypedValue.applyDimension((int)1, (float)1.0f, (DisplayMetrics)view.getContext().getResources().getDisplayMetrics());
        this.animBlink = AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.blink);
        this.animJump = AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.jump);
        this.animJumpFast = AnimationUtils.loadAnimation((Context)view.getContext(), (int)R.anim.jump_fast);
        this.setupRecording();
        this.setupAttachmentOptions();
    }

    public void changeSlideToCancelText(int textResourceId) {
        this.textViewSlide.setText(textResourceId);
    }

    public boolean isShowCameraIcon() {
        return this.showCameraIcon;
    }

    public void showCameraIcon(boolean showCameraIcon) {
        this.showCameraIcon = showCameraIcon;
        if (showCameraIcon) {
            this.imageViewCamera.setVisibility(0);
        } else {
            this.imageViewCamera.setVisibility(8);
        }
    }

    public boolean isShowAttachmentIcon() {
        return this.showAttachmentIcon;
    }

    public void showAttachmentIcon(boolean showAttachmentIcon) {
        this.showAttachmentIcon = showAttachmentIcon;
        if (showAttachmentIcon) {
            this.imageViewAttachment.setVisibility(0);
        } else {
            this.imageViewAttachment.setVisibility(4);
        }
    }

    public boolean isShowEmojiIcon() {
        return this.showEmojiIcon;
    }

    public void showEmojiIcon(boolean showEmojiIcon) {
        this.showEmojiIcon = showEmojiIcon;
        if (showEmojiIcon) {
            this.imageViewEmoji.setVisibility(0);
        } else {
            this.imageViewEmoji.setVisibility(4);
        }
    }

    public void setAttachmentOptions(List<AttachmentOption> attachmentOptionList, AttachmentOptionsListener attachmentOptionsListener) {
        this.attachmentOptionList = attachmentOptionList;
        this.attachmentOptionsListener = attachmentOptionsListener;
        if (this.attachmentOptionList != null && !this.attachmentOptionList.isEmpty()) {
            this.layoutAttachmentOptions.removeAllViews();
            int count = 0;
            LinearLayout linearLayoutMain = null;
            this.layoutAttachments = new ArrayList<LinearLayout>();
            for (final AttachmentOption attachmentOption : this.attachmentOptionList) {
                if (count == 6) break;
                if (count == 0 || count == 3) {
                    linearLayoutMain = new LinearLayout(this.context);
                    linearLayoutMain.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                    linearLayoutMain.setOrientation(0);
                    linearLayoutMain.setGravity(17);
                    this.layoutAttachmentOptions.addView((View)linearLayoutMain);
                }
                LinearLayout linearLayout = new LinearLayout(this.context);
                linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)(this.dp * 84.0f), -2));
                linearLayout.setPadding((int)(this.dp * 4.0f), (int)(this.dp * 12.0f), (int)(this.dp * 4.0f), (int)(this.dp * 0.0f));
                linearLayout.setOrientation(1);
                linearLayout.setGravity(17);
                this.layoutAttachments.add(linearLayout);
                ImageView imageView = new ImageView(this.context);
                imageView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams((int)(this.dp * 48.0f), (int)(this.dp * 48.0f)));
                imageView.setImageResource(attachmentOption.getResourceImage());
                TextView textView = new TextView(this.context);
                TextViewCompat.setTextAppearance((TextView)textView, (int)R.style.TextAttachmentOptions);
                textView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
                textView.setPadding((int)(this.dp * 4.0f), (int)(this.dp * 4.0f), (int)(this.dp * 4.0f), (int)(this.dp * 0.0f));
                textView.setMaxLines(1);
                textView.setText((CharSequence)attachmentOption.getTitle());
                linearLayout.addView((View)imageView);
                linearLayout.addView((View)textView);
                linearLayoutMain.addView((View)linearLayout);
                linearLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        AudioRecordView.this.hideAttachmentOptionView();
                        AudioRecordView.this.attachmentOptionsListener.onClick(attachmentOption);
                    }
                });
                ++count;
            }
        }
    }

    public void hideAttachmentOptionView() {
        if (this.layoutAttachment.getVisibility() == 0) {
            this.imageViewAttachment.performClick();
        }
    }

    public void showAttachmentOptionView() {
        if (this.layoutAttachment.getVisibility() != 0) {
            this.imageViewAttachment.performClick();
        }
    }

    private void setupAttachmentOptions() {
        this.imageViewAttachment.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (AudioRecordView.this.layoutAttachment.getVisibility() == 0) {
                    int x = AudioRecordView.this.isLayoutDirectionRightToLeft ? (int)(AudioRecordView.this.dp * 118.0f) : (int)((float)AudioRecordView.this.screenWidth - AudioRecordView.this.dp * 118.0f);
                    int y = (int)(AudioRecordView.this.dp * 220.0f);
                    boolean startRadius = false;
                    int endRadius = (int)Math.hypot((float)AudioRecordView.this.screenWidth - AudioRecordView.this.dp * 16.0f, AudioRecordView.this.dp * 220.0f);
                    Animator anim2 = ViewAnimationUtils.createCircularReveal((View)AudioRecordView.this.layoutAttachment, (int)x, (int)y, (float)endRadius, (float)((float)startRadius));
                    anim2.addListener(new Animator.AnimatorListener(){

                        public void onAnimationStart(Animator animator) {
                        }

                        public void onAnimationEnd(Animator animator) {
                            AudioRecordView.this.layoutAttachment.setVisibility(8);
                        }

                        public void onAnimationCancel(Animator animator) {
                        }

                        public void onAnimationRepeat(Animator animator) {
                        }
                    });
                    anim2.start();
                } else {
                    if (!AudioRecordView.this.removeAttachmentOptionAnimation) {
                        int count = 0;
                        if (AudioRecordView.this.layoutAttachments != null && !AudioRecordView.this.layoutAttachments.isEmpty()) {
                            int[] arr = new int[]{5, 4, 2, 3, 1, 0};
                            if (AudioRecordView.this.isLayoutDirectionRightToLeft) {
                                arr = new int[]{3, 4, 0, 5, 1, 2};
                            }
                            for (int i = 0; i < AudioRecordView.this.layoutAttachments.size(); ++i) {
                                if (arr[i] >= AudioRecordView.this.layoutAttachments.size()) continue;
                                LinearLayout layout2 = (LinearLayout)AudioRecordView.this.layoutAttachments.get(arr[i]);
                                layout2.setScaleX(0.4f);
                                layout2.setAlpha(0.0f);
                                layout2.setScaleY(0.4f);
                                layout2.setTranslationY(AudioRecordView.this.dp * 48.0f * 2.0f);
                                layout2.setVisibility(4);
                                layout2.animate().scaleX(1.0f).scaleY(1.0f).alpha(1.0f).translationY(0.0f).setStartDelay((long)(count * 25 + 50)).setDuration(300L).setInterpolator((TimeInterpolator)new OvershootInterpolator()).start();
                                layout2.setVisibility(0);
                                ++count;
                            }
                        }
                    }
                    int x = AudioRecordView.this.isLayoutDirectionRightToLeft ? (int)(AudioRecordView.this.dp * 118.0f) : (int)((float)AudioRecordView.this.screenWidth - AudioRecordView.this.dp * 118.0f);
                    int y = (int)(AudioRecordView.this.dp * 220.0f);
                    boolean startRadius = false;
                    int endRadius = (int)Math.hypot((float)AudioRecordView.this.screenWidth - AudioRecordView.this.dp * 16.0f, AudioRecordView.this.dp * 220.0f);
                    Animator anim3 = ViewAnimationUtils.createCircularReveal((View)AudioRecordView.this.layoutAttachment, (int)x, (int)y, (float)((float)startRadius), (float)endRadius);
                    anim3.setDuration(500L);
                    AudioRecordView.this.layoutAttachment.setVisibility(0);
                    anim3.start();
                }
            }
        });
    }

    public void removeAttachmentOptionAnimation(boolean removeAttachmentOptionAnimation) {
        this.removeAttachmentOptionAnimation = removeAttachmentOptionAnimation;
    }

    public View setContainerView(int layoutResourceID) {
        View view = LayoutInflater.from((Context)this.viewContainer.getContext()).inflate(layoutResourceID, null);
        if (view == null) {
            this.showErrorLog("Unable to create the Container View from the layoutResourceID");
            return null;
        }
        this.viewContainer.removeAllViews();
        this.viewContainer.addView(view);
        return view;
    }

    public void setAudioRecordButtonImage(int imageResource) {
        this.audio.setImageResource(imageResource);
    }

    public void setStopButtonImage(int imageResource) {
        this.stop.setImageResource(imageResource);
    }

    public void setSendButtonImage(int imageResource) {
        this.send.setImageResource(imageResource);
    }

    public RecordingListener getRecordingListener() {
        return this.recordingListener;
    }

    public void setRecordingListener(RecordingListener recordingListener) {
        this.recordingListener = recordingListener;
    }

    public View getSendView() {
        return this.imageViewSend;
    }

    public View getAttachmentView() {
        return this.imageViewAttachment;
    }

    public View getEmojiView() {
        return this.imageViewEmoji;
    }

    public View getCameraView() {
        return this.imageViewCamera;
    }

    public EditText getMessageView() {
        return this.editTextMessage;
    }

    private void setupRecording() {
        this.imageViewSend.animate().scaleX(0.0f).scaleY(0.0f).setDuration(100L).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
        this.editTextMessage.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (s.toString().trim().isEmpty()) {
                    if (AudioRecordView.this.imageViewSend.getVisibility() != 8) {
                        AudioRecordView.this.imageViewSend.setVisibility(8);
                        AudioRecordView.this.imageViewSend.animate().scaleX(0.0f).scaleY(0.0f).setDuration(100L).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
                    }
                    if (AudioRecordView.this.showCameraIcon && AudioRecordView.this.imageViewCamera.getVisibility() != 0 && !AudioRecordView.this.isLocked) {
                        AudioRecordView.this.imageViewCamera.setVisibility(0);
                        AudioRecordView.this.imageViewCamera.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
                    }
                } else {
                    if (AudioRecordView.this.imageViewSend.getVisibility() != 0 && !AudioRecordView.this.isLocked) {
                        AudioRecordView.this.imageViewSend.setVisibility(0);
                        AudioRecordView.this.imageViewSend.animate().scaleX(1.0f).scaleY(1.0f).setDuration(100L).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
                    }
                    if (AudioRecordView.this.showCameraIcon && AudioRecordView.this.imageViewCamera.getVisibility() != 8) {
                        AudioRecordView.this.imageViewCamera.setVisibility(8);
                        AudioRecordView.this.imageViewCamera.animate().scaleX(0.0f).scaleY(0.0f).setDuration(100L).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
                    }
                }
            }
        });
        this.imageViewAudio.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (AudioRecordView.this.isDeleting) {
                    return true;
                }
                if (motionEvent.getAction() == 0) {
                    AudioRecordView.this.cancelOffset = (float)((double)AudioRecordView.this.screenWidth / 2.8);
                    AudioRecordView.this.lockOffset = (float)((double)AudioRecordView.this.screenWidth / 2.5);
                    if (AudioRecordView.this.firstX == 0.0f) {
                        AudioRecordView.this.firstX = motionEvent.getRawX();
                    }
                    if (AudioRecordView.this.firstY == 0.0f) {
                        AudioRecordView.this.firstY = motionEvent.getRawY();
                    }
                    AudioRecordView.this.startRecord();
                } else if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
                    if (motionEvent.getAction() == 1) {
                        AudioRecordView.this.stopRecording(RecordingBehaviour.RELEASED);
                    }
                } else if (motionEvent.getAction() == 2) {
                    if (AudioRecordView.this.stopTrackingAction) {
                        return true;
                    }
                    UserBehaviour direction = UserBehaviour.NONE;
                    float motionX = Math.abs(AudioRecordView.this.firstX - motionEvent.getRawX());
                    float motionY = Math.abs(AudioRecordView.this.firstY - motionEvent.getRawY());
                    if (AudioRecordView.this.isLayoutDirectionRightToLeft ? motionX > AudioRecordView.this.directionOffset && AudioRecordView.this.lastX > AudioRecordView.this.firstX && AudioRecordView.this.lastY > AudioRecordView.this.firstY : motionX > AudioRecordView.this.directionOffset && AudioRecordView.this.lastX < AudioRecordView.this.firstX && AudioRecordView.this.lastY < AudioRecordView.this.firstY) {
                        if (AudioRecordView.this.isLayoutDirectionRightToLeft ? motionX > motionY && AudioRecordView.this.lastX > AudioRecordView.this.firstX : motionX > motionY && AudioRecordView.this.lastX < AudioRecordView.this.firstX) {
                            direction = UserBehaviour.CANCELING;
                        } else if (motionY > motionX && AudioRecordView.this.lastY < AudioRecordView.this.firstY) {
                            direction = UserBehaviour.LOCKING;
                        }
                    } else if (AudioRecordView.this.isLayoutDirectionRightToLeft ? motionX > motionY && motionX > AudioRecordView.this.directionOffset && AudioRecordView.this.lastX > AudioRecordView.this.firstX : motionX > motionY && motionX > AudioRecordView.this.directionOffset && AudioRecordView.this.lastX < AudioRecordView.this.firstX) {
                        direction = UserBehaviour.CANCELING;
                    } else if (motionY > motionX && motionY > AudioRecordView.this.directionOffset && AudioRecordView.this.lastY < AudioRecordView.this.firstY) {
                        direction = UserBehaviour.LOCKING;
                    }
                    if (direction == UserBehaviour.CANCELING) {
                        if (AudioRecordView.this.userBehaviour == UserBehaviour.NONE || motionEvent.getRawY() + (float)(AudioRecordView.this.imageViewAudio.getWidth() / 2) > AudioRecordView.this.firstY) {
                            AudioRecordView.this.userBehaviour = UserBehaviour.CANCELING;
                        }
                        if (AudioRecordView.this.userBehaviour == UserBehaviour.CANCELING) {
                            AudioRecordView.this.translateX(-(AudioRecordView.this.firstX - motionEvent.getRawX()));
                        }
                    } else if (direction == UserBehaviour.LOCKING) {
                        if (AudioRecordView.this.userBehaviour == UserBehaviour.NONE || motionEvent.getRawX() + (float)(AudioRecordView.this.imageViewAudio.getWidth() / 2) > AudioRecordView.this.firstX) {
                            AudioRecordView.this.userBehaviour = UserBehaviour.LOCKING;
                        }
                        if (AudioRecordView.this.userBehaviour == UserBehaviour.LOCKING) {
                            AudioRecordView.this.translateY(-(AudioRecordView.this.firstY - motionEvent.getRawY()));
                        }
                    }
                    AudioRecordView.this.lastX = motionEvent.getRawX();
                    AudioRecordView.this.lastY = motionEvent.getRawY();
                }
                view.onTouchEvent(motionEvent);
                return true;
            }
        });
        this.imageViewStop.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AudioRecordView.this.isLocked = false;
                AudioRecordView.this.stopRecording(RecordingBehaviour.LOCK_DONE);
            }
        });
    }

    private void translateY(float y) {
        if (y < -this.lockOffset) {
            this.locked();
            this.imageViewAudio.setTranslationY(0.0f);
            return;
        }
        if (this.layoutLock.getVisibility() != 0) {
            this.layoutLock.setVisibility(0);
        }
        this.imageViewAudio.setTranslationY(y);
        this.layoutLock.setTranslationY(y / 2.0f);
        this.imageViewAudio.setTranslationX(0.0f);
    }

    private void translateX(float x) {
        if (this.isLayoutDirectionRightToLeft ? x > this.cancelOffset : x < -this.cancelOffset) {
            this.canceled();
            this.imageViewAudio.setTranslationX(0.0f);
            this.layoutSlideCancel.setTranslationX(0.0f);
            return;
        }
        this.imageViewAudio.setTranslationX(x);
        this.layoutSlideCancel.setTranslationX(x);
        this.layoutLock.setTranslationY(0.0f);
        this.imageViewAudio.setTranslationY(0.0f);
        if (Math.abs(x) < (float)(this.imageViewMic.getWidth() / 2)) {
            if (this.layoutLock.getVisibility() != 0) {
                this.layoutLock.setVisibility(0);
            }
        } else if (this.layoutLock.getVisibility() != 8) {
            this.layoutLock.setVisibility(8);
        }
    }

    private void locked() {
        this.stopTrackingAction = true;
        this.stopRecording(RecordingBehaviour.LOCKED);
        this.isLocked = true;
    }

    private void canceled() {
        this.stopTrackingAction = true;
        this.stopRecording(RecordingBehaviour.CANCELED);
    }

    private void stopRecording(RecordingBehaviour recordingBehaviour) {
        this.stopTrackingAction = true;
        this.firstX = 0.0f;
        this.firstY = 0.0f;
        this.lastX = 0.0f;
        this.lastY = 0.0f;
        this.userBehaviour = UserBehaviour.NONE;
        this.imageViewAudio.animate().scaleX(1.0f).scaleY(1.0f).translationX(0.0f).translationY(0.0f).setDuration(100L).setInterpolator((TimeInterpolator)new LinearInterpolator()).start();
        this.layoutSlideCancel.setTranslationX(0.0f);
        this.layoutSlideCancel.setVisibility(8);
        this.layoutLock.setVisibility(8);
        this.layoutLock.setTranslationY(0.0f);
        this.imageViewLockArrow.clearAnimation();
        this.imageViewLock.clearAnimation();
        if (this.isLocked) {
            return;
        }
        if (recordingBehaviour == RecordingBehaviour.LOCKED) {
            this.imageViewStop.setVisibility(0);
            if (this.recordingListener != null) {
                this.recordingListener.onRecordingLocked();
            }
        } else if (recordingBehaviour == RecordingBehaviour.CANCELED) {
            this.timeText.clearAnimation();
            this.timeText.setVisibility(4);
            this.imageViewMic.setVisibility(4);
            this.imageViewStop.setVisibility(8);
            this.layoutEffect2.setVisibility(8);
            this.layoutEffect1.setVisibility(8);
            this.timerTask.cancel();
            this.delete();
            if (this.recordingListener != null) {
                this.recordingListener.onRecordingCanceled();
            }
        } else if (recordingBehaviour == RecordingBehaviour.RELEASED || recordingBehaviour == RecordingBehaviour.LOCK_DONE) {
            this.timeText.clearAnimation();
            this.timeText.setVisibility(4);
            this.imageViewMic.setVisibility(4);
            this.editTextMessage.setVisibility(0);
            if (this.showAttachmentIcon) {
                this.imageViewAttachment.setVisibility(0);
            }
            if (this.showCameraIcon) {
                this.imageViewCamera.setVisibility(0);
            }
            if (this.showEmojiIcon) {
                this.imageViewEmoji.setVisibility(0);
            }
            this.imageViewStop.setVisibility(8);
            this.editTextMessage.requestFocus();
            this.layoutEffect2.setVisibility(8);
            this.layoutEffect1.setVisibility(8);
            this.timerTask.cancel();
            if (this.recordingListener != null) {
                this.recordingListener.onRecordingCompleted();
            }
        }
    }

    private void startRecord() {
        if (this.recordingListener != null) {
            this.recordingListener.onRecordingStarted();
        }
        this.hideAttachmentOptionView();
        this.stopTrackingAction = false;
        this.editTextMessage.setVisibility(4);
        this.imageViewAttachment.setVisibility(4);
        this.imageViewCamera.setVisibility(4);
        this.imageViewEmoji.setVisibility(4);
        this.imageViewAudio.animate().scaleXBy(1.0f).scaleYBy(1.0f).setDuration(200L).setInterpolator((TimeInterpolator)new OvershootInterpolator()).start();
        this.timeText.setVisibility(0);
        this.layoutLock.setVisibility(0);
        this.layoutSlideCancel.setVisibility(0);
        this.imageViewMic.setVisibility(0);
        this.layoutEffect2.setVisibility(0);
        this.layoutEffect1.setVisibility(0);
        this.timeText.startAnimation(this.animBlink);
        this.imageViewLockArrow.clearAnimation();
        this.imageViewLock.clearAnimation();
        this.imageViewLockArrow.startAnimation(this.animJumpFast);
        this.imageViewLock.startAnimation(this.animJump);
        if (this.audioTimer == null) {
            this.audioTimer = new Timer();
            this.timeFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        }
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                AudioRecordView.this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        AudioRecordView.this.timeText.setText((CharSequence)AudioRecordView.this.timeFormatter.format(new Date(AudioRecordView.this.audioTotalTime * 1000)));
                        AudioRecordView.this.audioTotalTime++;
                    }
                });
            }
        };
        this.audioTotalTime = 0;
        this.audioTimer.schedule(this.timerTask, 0L, 1000L);
    }

    private void delete() {
        this.imageViewMic.setVisibility(0);
        this.imageViewMic.setRotation(0.0f);
        this.isDeleting = true;
        this.imageViewAudio.setEnabled(false);
        this.handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                AudioRecordView.this.isDeleting = false;
                AudioRecordView.this.imageViewAudio.setEnabled(true);
                if (AudioRecordView.this.showAttachmentIcon) {
                    AudioRecordView.this.imageViewAttachment.setVisibility(0);
                }
                if (AudioRecordView.this.showCameraIcon) {
                    AudioRecordView.this.imageViewCamera.setVisibility(0);
                }
                if (AudioRecordView.this.showEmojiIcon) {
                    AudioRecordView.this.imageViewEmoji.setVisibility(0);
                }
            }
        }, 1250L);
        this.imageViewMic.animate().translationY(-this.dp * 150.0f).rotation(180.0f).scaleXBy(0.6f).scaleYBy(0.6f).setDuration(500L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                float displacement = 0.0f;
                displacement = AudioRecordView.this.isLayoutDirectionRightToLeft ? AudioRecordView.this.dp * 40.0f : -AudioRecordView.this.dp * 40.0f;
                AudioRecordView.this.dustin.setTranslationX(displacement);
                AudioRecordView.this.dustin_cover.setTranslationX(displacement);
                AudioRecordView.this.dustin_cover.animate().translationX(0.0f).rotation(-120.0f).setDuration(350L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
                AudioRecordView.this.dustin.animate().translationX(0.0f).setDuration(350L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                        AudioRecordView.this.dustin.setVisibility(0);
                        AudioRecordView.this.dustin_cover.setVisibility(0);
                    }

                    public void onAnimationEnd(Animator animation) {
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                }).start();
            }

            public void onAnimationEnd(Animator animation) {
                AudioRecordView.this.imageViewMic.animate().translationY(0.0f).scaleX(1.0f).scaleY(1.0f).setDuration(350L).setInterpolator((TimeInterpolator)new LinearInterpolator()).setListener(new Animator.AnimatorListener(){

                    public void onAnimationStart(Animator animation) {
                    }

                    public void onAnimationEnd(Animator animation) {
                        AudioRecordView.this.imageViewMic.setVisibility(4);
                        AudioRecordView.this.imageViewMic.setRotation(0.0f);
                        float displacement = 0.0f;
                        displacement = AudioRecordView.this.isLayoutDirectionRightToLeft ? AudioRecordView.this.dp * 40.0f : -AudioRecordView.this.dp * 40.0f;
                        AudioRecordView.this.dustin_cover.animate().rotation(0.0f).setDuration(150L).setStartDelay(50L).start();
                        AudioRecordView.this.dustin.animate().translationX(displacement).setDuration(200L).setStartDelay(250L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
                        AudioRecordView.this.dustin_cover.animate().translationX(displacement).setDuration(200L).setStartDelay(250L).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener(new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                AudioRecordView.this.editTextMessage.setVisibility(0);
                                AudioRecordView.this.editTextMessage.requestFocus();
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        }).start();
                    }

                    public void onAnimationCancel(Animator animation) {
                    }

                    public void onAnimationRepeat(Animator animation) {
                    }
                }).start();
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).start();
    }

    private void showErrorLog(String s) {
        Log.e((String)this.TAG, (String)s);
    }

    public static enum UserBehaviour {
        CANCELING,
        LOCKING,
        NONE;

    }

    public static enum RecordingBehaviour {
        CANCELED,
        LOCKED,
        LOCK_DONE,
        RELEASED;

    }

    public static interface RecordingListener {
        public void onRecordingStarted();

        public void onRecordingLocked();

        public void onRecordingCompleted();

        public void onRecordingCanceled();
    }
}

