/*
 * Decompiled with CFR 0.152.
 */
package com.mxchip.easylink;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.mxchip.easylink.EasyServer;
import com.mxchip.easylink.FTCListener;
import com.mxchip.easylink_plus.EasyLink_plus;
import com.mxchip.helper.Helper;
import java.net.NetworkInterface;
import java.net.SocketException;

public class EasyLinkAPI {
    public static final String TAG = "---EasylinkAPI---";
    public static final int mPort = 8000;
    private static EasyServer mEasyServer = null;
    private final Context mContext;
    private WifiManager mWifiManager;
    private WifiInfo mWifiInfo;
    private EasyLink_plus mEasylinkPlus;
    private FTCListener mFTCListener;
    private Context ctx;
    private boolean eltag = false;

    public EasyLinkAPI(Context context) {
        this.mContext = context;
    }

    public String getSSID() {
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo.getSSID().replaceAll("\"", "");
    }

    public void startEasyLink_FTC(Context context, String ssid, String password, String extraData, FTCListener ftcl) {
        if (!this.eltag) {
            if (Helper.checkPara(ssid, password)) {
                try {
                    Log.d((String)TAG, (String)"We will start easylink");
                    this.mFTCListener = ftcl;
                    this.startEasylink(context, ssid, password, extraData);
                    mEasyServer = new EasyServer(8000);
                    mEasyServer.start(ftcl);
                    this.eltag = true;
                }
                catch (Exception e) {
                    Log.d((String)TAG, (String)e.getMessage());
                }
            } else {
                Log.d((String)TAG, (String)"Argument can not be empty");
            }
        } else {
            Log.d((String)TAG, (String)"Easylink is working");
        }
    }

    public void stopFTC() {
        this.mFTCListener = null;
        if (mEasyServer != null) {
            Log.d((String)TAG, (String)"We will stop FTC");
            mEasyServer.stop();
            mEasyServer = null;
        } else {
            Log.d((String)TAG, (String)"FTC is closed");
        }
    }

    public void stopEasyLink() {
        if (this.mEasylinkPlus != null && this.eltag) {
            Log.d((String)TAG, (String)"We will close easylink");
            this.mEasylinkPlus = EasyLink_plus.getInstence(this.ctx);
            this.mEasylinkPlus.stopTransmitting();
            this.eltag = false;
        } else {
            Log.d((String)TAG, (String)"Easylink is closed");
        }
    }

    protected void startEasylink(Context context, String ssid, String password, String extraData) {
        int ip;
        if (ssid == "") {
            ip = this.getNormalIP();
            ssid = this.getSSID();
            password = "react&flux";
        } else {
            ip = ssid == "!AP" ? EasyLinkAPI.getAPIP() : this.getNormalIP();
        }
        this.ctx = context;
        this.mEasylinkPlus = EasyLink_plus.getInstence(context);
        try {
            NetworkInterface intf = NetworkInterface.getByName("wlan0");
            if (intf.getMTU() < 1500) {
                this.mEasylinkPlus.setSmallMtu(true);
                this.mFTCListener.isSmallMTU(intf.getMTU());
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        try {
            if (extraData == null) {
                extraData = "";
            }
            this.mEasylinkPlus.transmitSettings(ssid, password, ip, extraData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNormalIP() {
        this.mWifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        this.mWifiInfo = this.mWifiManager.getConnectionInfo();
        return this.mWifiInfo.getIpAddress();
    }

    public static int getAPIP() {
        return EasyLinkAPI.ip2int("192.168.43.1");
    }

    public static int getTestIP() {
        return EasyLinkAPI.ip2int("192.168.199.163");
    }

    public static int ip2int(String ipAddress) {
        String[] ipAddressInArray = ipAddress.split("\\.");
        long result = 0L;
        int i = 0;
        while (i < ipAddressInArray.length) {
            int power = i;
            int ip = Integer.parseInt(ipAddressInArray[i]);
            result = (long)((double)result + (double)ip * Math.pow(256.0, power));
            ++i;
        }
        return (int)result;
    }
}

