/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl;

import java.io.IOException;
import java.net.DatagramPacket;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jmdns.impl.DNSIncoming;
import javax.jmdns.impl.DNSState;
import javax.jmdns.impl.JmDNSImpl;

class SocketListener
implements Runnable {
    public static final String TAG = SocketListener.class.toString();
    static Logger logger = Logger.getLogger(SocketListener.class.getName());
    private final JmDNSImpl jmDNSImpl;

    SocketListener(JmDNSImpl jmDNSImpl) {
        this.jmDNSImpl = jmDNSImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: {
            try {
                byte[] buf = new byte[8972];
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                while (this.jmDNSImpl.getState() != DNSState.CANCELED) {
                    packet.setLength(buf.length);
                    this.jmDNSImpl.getSocket().receive(packet);
                    if (this.jmDNSImpl.getState() != DNSState.CANCELED) {
                        try {
                            if (this.jmDNSImpl.getLocalHost().shouldIgnorePacket(packet)) continue;
                            DNSIncoming msg = new DNSIncoming(packet);
                            logger.finest("SocketListener.run() JmDNS in:" + msg.print(true));
                            Object object = this.jmDNSImpl.getIoLock();
                            synchronized (object) {
                                if (msg.isQuery()) {
                                    if (packet.getPort() != 5353) {
                                        this.jmDNSImpl.handleQuery(msg, packet.getAddress(), packet.getPort());
                                    }
                                    this.jmDNSImpl.handleQuery(msg, this.jmDNSImpl.getGroup(), 5353);
                                } else {
                                    this.jmDNSImpl.handleResponse(msg);
                                }
                            }
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "run() exception ", e);
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                if (this.jmDNSImpl.getState() == DNSState.CANCELED) break block12;
                logger.log(Level.WARNING, "run() exception ", e);
                this.jmDNSImpl.recover();
            }
        }
    }
}

