/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.appcompat.content.res.AppCompatResources;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiPagerAdapter;
import com.vanniktech.emoji.EmojiPopup;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.emoji.EmojiCategory;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiLongClickListener;
import com.vanniktech.emoji.listeners.RepeatListener;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"ViewConstructor"})
public final class EmojiView
extends LinearLayout
implements ViewPager.OnPageChangeListener {
    private static final long INITIAL_INTERVAL = TimeUnit.SECONDS.toMillis(1L) / 2L;
    private static final int NORMAL_INTERVAL = 50;
    @ColorInt
    private final int themeAccentColor;
    @ColorInt
    private final int themeIconColor;
    private final ImageButton[] emojiTabs;
    private final EmojiPagerAdapter emojiPagerAdapter;
    @Nullable
    OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    private int emojiTabLastSelectedIndex = -1;

    public EmojiView(Context context, OnEmojiClickListener onEmojiClickListener, OnEmojiLongClickListener onEmojiLongClickListener, @NonNull EmojiPopup.Builder builder) {
        super(context);
        View.inflate((Context)context, (int)R.layout.emoji_view, (ViewGroup)this);
        this.setOrientation(1);
        this.setBackgroundColor(builder.backgroundColor != 0 ? builder.backgroundColor : Utils.resolveColor(context, R.attr.emojiBackground, R.color.emoji_background));
        this.themeIconColor = builder.iconColor != 0 ? builder.iconColor : Utils.resolveColor(context, R.attr.emojiIcons, R.color.emoji_icons);
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorAccent, value, true);
        this.themeAccentColor = builder.selectedIconColor != 0 ? builder.selectedIconColor : value.data;
        ViewPager emojisPager = (ViewPager)this.findViewById(R.id.emojiViewPager);
        View emojiDivider = this.findViewById(R.id.emojiViewDivider);
        emojiDivider.setBackgroundColor(builder.dividerColor != 0 ? builder.dividerColor : Utils.resolveColor(context, R.attr.emojiDivider, R.color.emoji_divider));
        if (builder.pageTransformer != null) {
            emojisPager.setPageTransformer(true, builder.pageTransformer);
        }
        LinearLayout emojisTab = (LinearLayout)this.findViewById(R.id.emojiViewTab);
        emojisPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        EmojiCategory[] categories = EmojiManager.getInstance().getCategories();
        this.emojiPagerAdapter = new EmojiPagerAdapter(onEmojiClickListener, onEmojiLongClickListener, builder.recentEmoji, builder.variantEmoji);
        this.emojiTabs = new ImageButton[this.emojiPagerAdapter.recentAdapterItemCount() + categories.length + 1];
        if (this.emojiPagerAdapter.hasRecentEmoji()) {
            this.emojiTabs[0] = this.inflateButton(context, R.drawable.emoji_recent, R.string.emoji_category_recent, (ViewGroup)emojisTab);
        }
        for (int i = 0; i < categories.length; ++i) {
            this.emojiTabs[i + this.emojiPagerAdapter.recentAdapterItemCount()] = this.inflateButton(context, categories[i].getIcon(), categories[i].getCategoryName(), (ViewGroup)emojisTab);
        }
        this.emojiTabs[this.emojiTabs.length - 1] = this.inflateButton(context, R.drawable.emoji_backspace, R.string.emoji_backspace, (ViewGroup)emojisTab);
        this.handleOnClicks(emojisPager);
        emojisPager.setAdapter((PagerAdapter)this.emojiPagerAdapter);
        int startIndex = this.emojiPagerAdapter.hasRecentEmoji() ? (this.emojiPagerAdapter.numberOfRecentEmojis() > 0 ? 0 : 1) : 0;
        emojisPager.setCurrentItem(startIndex);
        this.onPageSelected(startIndex);
    }

    private void handleOnClicks(ViewPager emojisPager) {
        for (int i = 0; i < this.emojiTabs.length - 1; ++i) {
            this.emojiTabs[i].setOnClickListener((View.OnClickListener)new EmojiTabsClickListener(emojisPager, i));
        }
        this.emojiTabs[this.emojiTabs.length - 1].setOnTouchListener((View.OnTouchListener)new RepeatListener(INITIAL_INTERVAL, 50L, new View.OnClickListener(){

            public void onClick(View view) {
                if (EmojiView.this.onEmojiBackspaceClickListener != null) {
                    EmojiView.this.onEmojiBackspaceClickListener.onEmojiBackspaceClick(view);
                }
            }
        }));
    }

    public void setOnEmojiBackspaceClickListener(@Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener) {
        this.onEmojiBackspaceClickListener = onEmojiBackspaceClickListener;
    }

    private ImageButton inflateButton(Context context, @DrawableRes int icon, @StringRes int categoryName, ViewGroup parent) {
        ImageButton button = (ImageButton)LayoutInflater.from((Context)context).inflate(R.layout.emoji_view_category, parent, false);
        button.setImageDrawable(AppCompatResources.getDrawable((Context)context, (int)icon));
        button.setColorFilter(this.themeIconColor, PorterDuff.Mode.SRC_IN);
        button.setContentDescription((CharSequence)context.getString(categoryName));
        parent.addView((View)button);
        return button;
    }

    public void onPageSelected(int i) {
        if (this.emojiTabLastSelectedIndex != i) {
            if (i == 0) {
                this.emojiPagerAdapter.invalidateRecentEmojis();
            }
            if (this.emojiTabLastSelectedIndex >= 0 && this.emojiTabLastSelectedIndex < this.emojiTabs.length) {
                this.emojiTabs[this.emojiTabLastSelectedIndex].setSelected(false);
                this.emojiTabs[this.emojiTabLastSelectedIndex].setColorFilter(this.themeIconColor, PorterDuff.Mode.SRC_IN);
            }
            this.emojiTabs[i].setSelected(true);
            this.emojiTabs[i].setColorFilter(this.themeAccentColor, PorterDuff.Mode.SRC_IN);
            this.emojiTabLastSelectedIndex = i;
        }
    }

    public void onPageScrolled(int i, float v, int i2) {
    }

    public void onPageScrollStateChanged(int i) {
    }

    static class EmojiTabsClickListener
    implements View.OnClickListener {
        private final ViewPager emojisPager;
        private final int position;

        EmojiTabsClickListener(ViewPager emojisPager, int position) {
            this.emojisPager = emojisPager;
            this.position = position;
        }

        public void onClick(View v) {
            this.emojisPager.setCurrentItem(this.position);
        }
    }
}

