/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.Paint;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.CallSuper;
import androidx.annotation.DimenRes;
import androidx.annotation.Px;
import androidx.appcompat.widget.AppCompatTextView;
import com.vanniktech.emoji.EmojiDisplayable;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.Utils;

public class EmojiTextView
extends AppCompatTextView
implements EmojiDisplayable {
    private float emojiSize;

    public EmojiTextView(Context context) {
        this(context, null);
    }

    public EmojiTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.emojiSize = Utils.initTextView((TextView)this, attrs);
    }

    public EmojiTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.emojiSize = Utils.initTextView((TextView)this, attrs);
    }

    @CallSuper
    public void setText(CharSequence rawText, TextView.BufferType type) {
        if (this.isInEditMode()) {
            super.setText(rawText, type);
            return;
        }
        CharSequence text = rawText == null ? "" : rawText;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text);
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        EmojiManager.getInstance().replaceWithImages(this.getContext(), (Spannable)spannableStringBuilder, this.emojiSize != 0.0f ? this.emojiSize : defaultEmojiSize);
        super.setText((CharSequence)spannableStringBuilder, type);
    }

    @Override
    public float getEmojiSize() {
        return this.emojiSize;
    }

    @Override
    public final void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    @Override
    public final void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText(this.getText());
        }
    }

    @Override
    public final void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    @Override
    public final void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }
}

