/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.view.View;
import android.view.WindowInsets;
import android.view.autofill.AutofillManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.PopupWindow;
import androidx.annotation.CheckResult;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleRes;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import com.vanniktech.emoji.EmojiEditText;
import com.vanniktech.emoji.EmojiImageView;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiResultReceiver;
import com.vanniktech.emoji.EmojiVariantPopup;
import com.vanniktech.emoji.EmojiView;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.RecentEmojiManager;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.VariantEmoji;
import com.vanniktech.emoji.VariantEmojiManager;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiLongClickListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupDismissListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupShownListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardCloseListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardOpenListener;
import java.lang.ref.WeakReference;

public final class EmojiPopup
implements EmojiResultReceiver.Receiver {
    static final int MIN_KEYBOARD_HEIGHT = 50;
    static final int APPLY_WINDOW_INSETS_DURATION = 250;
    final View rootView;
    final Activity context;
    @NonNull
    final RecentEmoji recentEmoji;
    @NonNull
    final VariantEmoji variantEmoji;
    @NonNull
    final EmojiVariantPopup variantPopup;
    final PopupWindow popupWindow;
    final EditText editText;
    boolean isPendingOpen;
    boolean isKeyboardOpen;
    private int globalKeyboardHeight;
    private int delay;
    @Nullable
    OnEmojiPopupShownListener onEmojiPopupShownListener;
    @Nullable
    OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
    @Nullable
    OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
    @Nullable
    OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    @Nullable
    OnEmojiClickListener onEmojiClickListener;
    @Nullable
    OnEmojiPopupDismissListener onEmojiPopupDismissListener;
    int popupWindowHeight;
    int originalImeOptions = -1;
    final EmojiResultReceiver emojiResultReceiver = new EmojiResultReceiver(new Handler(Looper.getMainLooper()));
    final OnEmojiClickListener internalOnEmojiClickListener = new OnEmojiClickListener(){

        @Override
        public void onEmojiClick(@NonNull EmojiImageView imageView, @NonNull Emoji emoji) {
            Utils.input(EmojiPopup.this.editText, emoji);
            EmojiPopup.this.recentEmoji.addEmoji(emoji);
            EmojiPopup.this.variantEmoji.addVariant(emoji);
            imageView.updateEmoji(emoji);
            if (EmojiPopup.this.onEmojiClickListener != null) {
                EmojiPopup.this.onEmojiClickListener.onEmojiClick(imageView, emoji);
            }
            EmojiPopup.this.variantPopup.dismiss();
        }
    };
    final OnEmojiLongClickListener internalOnEmojiLongClickListener = new OnEmojiLongClickListener(){

        @Override
        public void onEmojiLongClick(@NonNull EmojiImageView view, @NonNull Emoji emoji) {
            EmojiPopup.this.variantPopup.show(view, emoji);
        }
    };
    final OnEmojiBackspaceClickListener internalOnEmojiBackspaceClickListener = new OnEmojiBackspaceClickListener(){

        @Override
        public void onEmojiBackspaceClick(View v) {
            Utils.backspace(EmojiPopup.this.editText);
            if (EmojiPopup.this.onEmojiBackspaceClickListener != null) {
                EmojiPopup.this.onEmojiBackspaceClickListener.onEmojiBackspaceClick(v);
            }
        }
    };
    final PopupWindow.OnDismissListener onDismissListener = new PopupWindow.OnDismissListener(){

        public void onDismiss() {
            if (EmojiPopup.this.editText instanceof EmojiEditText && ((EmojiEditText)EmojiPopup.this.editText).isKeyboardInputDisabled()) {
                EmojiPopup.this.editText.clearFocus();
            }
            if (EmojiPopup.this.onEmojiPopupDismissListener != null) {
                EmojiPopup.this.onEmojiPopupDismissListener.onEmojiPopupDismiss();
            }
        }
    };

    EmojiPopup(@NonNull Builder builder, @NonNull EditText editText) {
        this.context = Utils.asActivity(builder.rootView.getContext());
        this.rootView = builder.rootView.getRootView();
        this.editText = editText;
        this.recentEmoji = builder.recentEmoji;
        this.variantEmoji = builder.variantEmoji;
        this.popupWindow = new PopupWindow((Context)this.context);
        this.variantPopup = new EmojiVariantPopup(this.rootView, this.internalOnEmojiClickListener);
        EmojiView emojiView = new EmojiView((Context)this.context, this.internalOnEmojiClickListener, this.internalOnEmojiLongClickListener, builder);
        emojiView.setOnEmojiBackspaceClickListener(this.internalOnEmojiBackspaceClickListener);
        this.popupWindow.setContentView((View)emojiView);
        this.popupWindow.setInputMethodMode(2);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), (Bitmap)null));
        this.popupWindow.setOnDismissListener(this.onDismissListener);
        if (builder.keyboardAnimationStyle != 0) {
            this.popupWindow.setAnimationStyle(builder.keyboardAnimationStyle);
        }
        if (this.rootView.getParent() != null) {
            this.start();
        }
        this.rootView.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)new EmojiPopUpOnAttachStateChangeListener(this));
    }

    void start() {
        this.context.getWindow().getDecorView().setOnApplyWindowInsetsListener(new View.OnApplyWindowInsetsListener(){
            int previousOffset;

            public WindowInsets onApplyWindowInsets(View v, WindowInsets insets) {
                int offset = insets.getSystemWindowInsetBottom() < insets.getStableInsetBottom() ? insets.getSystemWindowInsetBottom() : insets.getSystemWindowInsetBottom() - insets.getStableInsetBottom();
                if (offset != this.previousOffset || offset == 0) {
                    this.previousOffset = offset;
                    if (offset > Utils.dpToPx((Context)EmojiPopup.this.context, 50.0f)) {
                        EmojiPopup.this.updateKeyboardStateOpened(offset);
                    } else {
                        EmojiPopup.this.updateKeyboardStateClosed();
                    }
                }
                return EmojiPopup.this.context.getWindow().getDecorView().onApplyWindowInsets(insets);
            }
        });
    }

    void stop() {
        this.dismiss();
        this.context.getWindow().getDecorView().setOnApplyWindowInsetsListener(null);
        this.popupWindow.setOnDismissListener(null);
    }

    void updateKeyboardStateOpened(int keyboardHeight) {
        if (this.popupWindowHeight > 0 && this.popupWindow.getHeight() != this.popupWindowHeight) {
            this.popupWindow.setHeight(this.popupWindowHeight);
        } else if (this.popupWindowHeight == 0 && this.popupWindow.getHeight() != keyboardHeight) {
            this.popupWindow.setHeight(keyboardHeight);
        }
        if (this.globalKeyboardHeight != keyboardHeight) {
            this.globalKeyboardHeight = keyboardHeight;
            this.delay = 250;
        } else {
            this.delay = 0;
        }
        int properWidth = Utils.getProperWidth(this.context);
        if (this.popupWindow.getWidth() != properWidth) {
            this.popupWindow.setWidth(properWidth);
        }
        if (!this.isKeyboardOpen) {
            this.isKeyboardOpen = true;
            if (this.onSoftKeyboardOpenListener != null) {
                this.onSoftKeyboardOpenListener.onKeyboardOpen(keyboardHeight);
            }
        }
        if (this.isPendingOpen) {
            this.showAtBottom();
        }
    }

    void updateKeyboardStateClosed() {
        this.isKeyboardOpen = false;
        if (this.onSoftKeyboardCloseListener != null) {
            this.onSoftKeyboardCloseListener.onKeyboardClose();
        }
        if (this.isShowing()) {
            this.dismiss();
        }
    }

    public void setPopupWindowHeight(int popupWindowHeight) {
        this.popupWindowHeight = popupWindowHeight >= 0 ? popupWindowHeight : 0;
    }

    public void toggle() {
        if (!this.popupWindow.isShowing()) {
            this.start();
            ViewCompat.requestApplyInsets((View)this.context.getWindow().getDecorView());
            this.show();
        } else {
            this.dismiss();
        }
    }

    public void show() {
        if (Utils.shouldOverrideRegularCondition((Context)this.context, this.editText) && this.originalImeOptions == -1) {
            this.originalImeOptions = this.editText.getImeOptions();
        }
        this.editText.setFocusableInTouchMode(true);
        this.editText.requestFocus();
        this.showAtBottomPending();
    }

    private void showAtBottomPending() {
        this.isPendingOpen = true;
        InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
        if (Utils.shouldOverrideRegularCondition((Context)this.context, this.editText)) {
            this.editText.setImeOptions(this.editText.getImeOptions() | 0x10000000);
            if (inputMethodManager != null) {
                inputMethodManager.restartInput((View)this.editText);
            }
        }
        if (inputMethodManager != null) {
            this.emojiResultReceiver.setReceiver(this);
            inputMethodManager.showSoftInput((View)this.editText, 0, (ResultReceiver)this.emojiResultReceiver);
        }
    }

    public boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    public void dismiss() {
        this.popupWindow.dismiss();
        this.variantPopup.dismiss();
        this.recentEmoji.persist();
        this.variantEmoji.persist();
        this.emojiResultReceiver.setReceiver(null);
        if (this.originalImeOptions != -1) {
            AutofillManager autofillManager;
            this.editText.setImeOptions(this.originalImeOptions);
            InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
            if (inputMethodManager != null) {
                inputMethodManager.restartInput((View)this.editText);
            }
            if (Build.VERSION.SDK_INT >= 26 && (autofillManager = (AutofillManager)this.context.getSystemService(AutofillManager.class)) != null) {
                autofillManager.cancel();
            }
        }
    }

    void showAtBottom() {
        this.isPendingOpen = false;
        this.editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                EmojiPopup.this.popupWindow.showAtLocation(EmojiPopup.this.rootView, 0, 0, Utils.getProperHeight(EmojiPopup.this.context) + EmojiPopup.this.popupWindowHeight);
            }
        }, (long)this.delay);
        if (this.onEmojiPopupShownListener != null) {
            this.onEmojiPopupShownListener.onEmojiPopupShown();
        }
    }

    @Override
    public void onReceiveResult(int resultCode, Bundle data) {
        if (resultCode == 0 || resultCode == 1) {
            this.showAtBottom();
        }
    }

    static final class EmojiPopUpOnAttachStateChangeListener
    implements View.OnAttachStateChangeListener {
        private final WeakReference<EmojiPopup> emojiPopup;

        EmojiPopUpOnAttachStateChangeListener(EmojiPopup emojiPopup) {
            this.emojiPopup = new WeakReference<EmojiPopup>(emojiPopup);
        }

        public void onViewAttachedToWindow(View v) {
            EmojiPopup popup = (EmojiPopup)this.emojiPopup.get();
            if (popup != null) {
                popup.start();
            }
        }

        public void onViewDetachedFromWindow(View v) {
            EmojiPopup popup = (EmojiPopup)this.emojiPopup.get();
            if (popup != null) {
                popup.stop();
            }
            this.emojiPopup.clear();
            v.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }

    public static final class Builder {
        @NonNull
        final View rootView;
        @StyleRes
        int keyboardAnimationStyle;
        @ColorInt
        int backgroundColor;
        @ColorInt
        int iconColor;
        @ColorInt
        int selectedIconColor;
        @ColorInt
        int dividerColor;
        @Nullable
        ViewPager.PageTransformer pageTransformer;
        @Nullable
        OnEmojiPopupShownListener onEmojiPopupShownListener;
        @Nullable
        OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
        @Nullable
        OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
        @Nullable
        OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
        @Nullable
        OnEmojiClickListener onEmojiClickListener;
        @Nullable
        OnEmojiPopupDismissListener onEmojiPopupDismissListener;
        @Nullable
        RecentEmoji recentEmoji;
        @NonNull
        VariantEmoji variantEmoji;
        int popupWindowHeight;

        private Builder(View rootView) {
            this.rootView = Utils.checkNotNull(rootView, "The root View can't be null");
            this.variantEmoji = new VariantEmojiManager(rootView.getContext());
        }

        @CheckResult
        public static Builder fromRootView(View rootView) {
            return new Builder(rootView);
        }

        @CheckResult
        public Builder setOnSoftKeyboardCloseListener(@Nullable OnSoftKeyboardCloseListener listener) {
            this.onSoftKeyboardCloseListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiClickListener(@Nullable OnEmojiClickListener listener) {
            this.onEmojiClickListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnSoftKeyboardOpenListener(@Nullable OnSoftKeyboardOpenListener listener) {
            this.onSoftKeyboardOpenListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiPopupShownListener(@Nullable OnEmojiPopupShownListener listener) {
            this.onEmojiPopupShownListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiPopupDismissListener(@Nullable OnEmojiPopupDismissListener listener) {
            this.onEmojiPopupDismissListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiBackspaceClickListener(@Nullable OnEmojiBackspaceClickListener listener) {
            this.onEmojiBackspaceClickListener = listener;
            return this;
        }

        @CheckResult
        public Builder setPopupWindowHeight(int windowHeight) {
            this.popupWindowHeight = Math.max(windowHeight, 0);
            return this;
        }

        @CheckResult
        public Builder setRecentEmoji(@NonNull RecentEmoji recent) {
            this.recentEmoji = Utils.checkNotNull(recent, "recent can't be null");
            return this;
        }

        @CheckResult
        public Builder setVariantEmoji(@NonNull VariantEmoji variant) {
            this.variantEmoji = Utils.checkNotNull(variant, "variant can't be null");
            return this;
        }

        @CheckResult
        public Builder setBackgroundColor(@ColorInt int color2) {
            this.backgroundColor = color2;
            return this;
        }

        @CheckResult
        public Builder setIconColor(@ColorInt int color2) {
            this.iconColor = color2;
            return this;
        }

        @CheckResult
        public Builder setSelectedIconColor(@ColorInt int color2) {
            this.selectedIconColor = color2;
            return this;
        }

        @CheckResult
        public Builder setDividerColor(@ColorInt int color2) {
            this.dividerColor = color2;
            return this;
        }

        @CheckResult
        public Builder setKeyboardAnimationStyle(@StyleRes int animation) {
            this.keyboardAnimationStyle = animation;
            return this;
        }

        @CheckResult
        public Builder setPageTransformer(@Nullable ViewPager.PageTransformer transformer) {
            this.pageTransformer = transformer;
            return this;
        }

        @CheckResult
        public EmojiPopup build(@NonNull EditText editText) {
            EmojiManager.getInstance().verifyInstalled();
            Utils.checkNotNull(editText, "EditText can't be null");
            if (this.recentEmoji == null) {
                this.recentEmoji = new RecentEmojiManager(this.rootView.getContext());
            }
            EmojiPopup emojiPopup = new EmojiPopup(this, editText);
            emojiPopup.onSoftKeyboardCloseListener = this.onSoftKeyboardCloseListener;
            emojiPopup.onEmojiClickListener = this.onEmojiClickListener;
            emojiPopup.onSoftKeyboardOpenListener = this.onSoftKeyboardOpenListener;
            emojiPopup.onEmojiPopupShownListener = this.onEmojiPopupShownListener;
            emojiPopup.onEmojiPopupDismissListener = this.onEmojiPopupDismissListener;
            emojiPopup.onEmojiBackspaceClickListener = this.onEmojiBackspaceClickListener;
            emojiPopup.popupWindowHeight = Math.max(this.popupWindowHeight, 0);
            return emojiPopup;
        }
    }
}

