/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.vanniktech.emoji.EmojiImageView;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.VariantEmoji;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiLongClickListener;
import java.util.Collection;

final class EmojiArrayAdapter
extends ArrayAdapter<Emoji> {
    @Nullable
    private final VariantEmoji variantManager;
    @Nullable
    private final OnEmojiClickListener listener;
    @Nullable
    private final OnEmojiLongClickListener longListener;

    EmojiArrayAdapter(@NonNull Context context, @NonNull Emoji[] emojis, @Nullable VariantEmoji variantManager, @Nullable OnEmojiClickListener listener, @Nullable OnEmojiLongClickListener longListener) {
        super(context, 0, Utils.asListWithoutDuplicates(emojis));
        this.variantManager = variantManager;
        this.listener = listener;
        this.longListener = longListener;
    }

    @NonNull
    public View getView(int position, View convertView, @NonNull ViewGroup parent) {
        EmojiImageView image = (EmojiImageView)convertView;
        Context context = this.getContext();
        if (image == null) {
            image = (EmojiImageView)LayoutInflater.from((Context)context).inflate(R.layout.emoji_adapter_item, parent, false);
            image.setOnEmojiClickListener(this.listener);
            image.setOnEmojiLongClickListener(this.longListener);
        }
        Emoji emoji = (Emoji)Utils.checkNotNull(this.getItem(position), "emoji == null");
        Emoji variantToUse = this.variantManager == null ? emoji : this.variantManager.getVariant(emoji);
        image.setContentDescription(emoji.getUnicode());
        image.setEmoji(variantToUse);
        return image;
    }

    void updateEmojis(Collection<Emoji> emojis) {
        this.clear();
        this.addAll(emojis);
        this.notifyDataSetChanged();
    }
}

