/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.emoji.Emoji;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

final class Utils {
    static final String TAG = "Utils";
    static final int DONT_UPDATE_FLAG = -1;

    @NonNull
    static <T> T checkNotNull(@Nullable T reference, String message) {
        if (reference == null) {
            throw new IllegalArgumentException(message);
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static float initTextView(TextView textView, AttributeSet attrs) {
        float emojiSize;
        if (!textView.isInEditMode()) {
            EmojiManager.getInstance().verifyInstalled();
        }
        Paint.FontMetrics fontMetrics = textView.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        if (attrs == null) {
            emojiSize = defaultEmojiSize;
        } else {
            TypedArray a = textView.getContext().obtainStyledAttributes(attrs, R.styleable.EmojiTextView);
            try {
                emojiSize = a.getDimension(R.styleable.EmojiTextView_emojiSize, defaultEmojiSize);
            }
            finally {
                a.recycle();
            }
        }
        textView.setText(textView.getText());
        return emojiSize;
    }

    static int dpToPx(@NonNull Context context, float dp) {
        return Math.round(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f);
    }

    static int getOrientation(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    static int getProperWidth(Activity activity) {
        Rect rect = Utils.windowVisibleDisplayFrame(activity);
        return Utils.getOrientation((Context)activity) == 1 ? rect.right : Utils.getScreenWidth(activity);
    }

    static boolean shouldOverrideRegularCondition(@NonNull Context context, EditText editText) {
        if ((editText.getImeOptions() & 0x10000000) == 0) {
            return Utils.getOrientation(context) == 2;
        }
        return false;
    }

    static int getInputMethodHeight(Context context, View rootView) {
        try {
            InputMethodManager imm = (InputMethodManager)context.getApplicationContext().getSystemService("input_method");
            Class<?> inputMethodManagerClass = imm.getClass();
            Method visibleHeightMethod = inputMethodManagerClass.getDeclaredMethod("getInputMethodWindowVisibleHeight", new Class[0]);
            visibleHeightMethod.setAccessible(true);
            return (Integer)visibleHeightMethod.invoke((Object)imm, new Object[0]);
        }
        catch (NoSuchMethodException exception) {
            Log.w((String)TAG, (String)exception.getLocalizedMessage());
        }
        catch (IllegalAccessException exception) {
            Log.w((String)TAG, (String)exception.getLocalizedMessage());
        }
        catch (InvocationTargetException exception) {
            Log.w((String)TAG, (String)exception.getLocalizedMessage());
        }
        return Utils.alternativeInputMethodHeight(rootView);
    }

    @TargetApi(value=21)
    static int getViewBottomInset(View rootView) {
        try {
            Field attachInfoField = View.class.getDeclaredField("mAttachInfo");
            attachInfoField.setAccessible(true);
            Object attachInfo = attachInfoField.get(rootView);
            if (attachInfo != null) {
                Field stableInsetsField = attachInfo.getClass().getDeclaredField("mStableInsets");
                stableInsetsField.setAccessible(true);
                return ((Rect)stableInsetsField.get((Object)attachInfo)).bottom;
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Log.w((String)TAG, (String)noSuchFieldException.getLocalizedMessage());
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.w((String)TAG, (String)illegalAccessException.getLocalizedMessage());
        }
        return 0;
    }

    static int alternativeInputMethodHeight(View rootView) {
        int viewInset = 0;
        if (Build.VERSION.SDK_INT >= 21) {
            viewInset = Utils.getViewBottomInset(rootView);
        }
        Rect rect = new Rect();
        rootView.getWindowVisibleDisplayFrame(rect);
        int availableHeight = rootView.getHeight() - viewInset - rect.top;
        return availableHeight - (rect.bottom - rect.top);
    }

    static int getProperHeight(Activity activity) {
        return Utils.windowVisibleDisplayFrame((Activity)activity).bottom;
    }

    static int getScreenWidth(@NonNull Activity context) {
        return Utils.dpToPx((Context)context, context.getResources().getConfiguration().screenWidthDp);
    }

    @NonNull
    static Point locationOnScreen(@NonNull View view) {
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return new Point(location[0], location[1]);
    }

    @NonNull
    static Rect windowVisibleDisplayFrame(@NonNull Activity context) {
        Rect result = new Rect();
        context.getWindow().getDecorView().getWindowVisibleDisplayFrame(result);
        return result;
    }

    static void backspace(@NonNull EditText editText) {
        KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
        editText.dispatchKeyEvent(event);
    }

    static List<Emoji> asListWithoutDuplicates(Emoji[] emojis) {
        ArrayList<Emoji> result = new ArrayList<Emoji>(emojis.length);
        for (Emoji emoji : emojis) {
            if (emoji.isDuplicate()) continue;
            result.add(emoji);
        }
        return result;
    }

    static void input(@NonNull EditText editText, @Nullable Emoji emoji) {
        if (emoji != null) {
            int start = editText.getSelectionStart();
            int end = editText.getSelectionEnd();
            if (start < 0) {
                editText.append((CharSequence)emoji.getUnicode());
            } else {
                editText.getText().replace(Math.min(start, end), Math.max(start, end), (CharSequence)emoji.getUnicode(), 0, emoji.getUnicode().length());
            }
        }
    }

    static Activity asActivity(@NonNull Context context) {
        Context result = context;
        while (result instanceof ContextWrapper) {
            if (result instanceof Activity) {
                return (Activity)result;
            }
            result = ((ContextWrapper)result).getBaseContext();
        }
        throw new IllegalArgumentException("The passed Context is not an Activity.");
    }

    static void fixPopupLocation(final @NonNull PopupWindow popupWindow, final @NonNull Point desiredLocation) {
        popupWindow.getContentView().post(new Runnable(){

            @Override
            public void run() {
                Point actualLocation = Utils.locationOnScreen(popupWindow.getContentView());
                if (actualLocation.x != desiredLocation.x || actualLocation.y != desiredLocation.y) {
                    int differenceX = actualLocation.x - desiredLocation.x;
                    int differenceY = actualLocation.y - desiredLocation.y;
                    int fixedOffsetX = actualLocation.x > desiredLocation.x ? desiredLocation.x - differenceX : desiredLocation.x + differenceX;
                    int fixedOffsetY = actualLocation.y > desiredLocation.y ? desiredLocation.y - differenceY : desiredLocation.y + differenceY;
                    popupWindow.update(fixedOffsetX, fixedOffsetY, -1, -1);
                }
            }
        });
    }

    @ColorInt
    static int resolveColor(Context context, @AttrRes int resource, @ColorRes int fallback) {
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(resource, value, true);
        int resolvedColor = value.resourceId != 0 ? ContextCompat.getColor((Context)context, (int)value.resourceId) : value.data;
        if (resolvedColor != 0) {
            return resolvedColor;
        }
        return ContextCompat.getColor((Context)context, (int)fallback);
    }

    private Utils() {
        throw new AssertionError((Object)"No instances.");
    }
}

