/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.vanniktech.emoji.EmojiInformation;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiRange;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EmojiUtils {
    private static final Pattern SPACE_REMOVAL = Pattern.compile("[\\s]");

    public static boolean isOnlyEmojis(@Nullable String text) {
        if (!TextUtils.isEmpty((CharSequence)text)) {
            String inputWithoutSpaces = SPACE_REMOVAL.matcher(text).replaceAll(Matcher.quoteReplacement(""));
            return EmojiManager.getInstance().getEmojiRepetitivePattern().matcher(inputWithoutSpaces).matches();
        }
        return false;
    }

    @NonNull
    public static List<EmojiRange> emojis(@Nullable String text) {
        return EmojiManager.getInstance().findAllEmojis(text);
    }

    public static int emojisCount(@Nullable String text) {
        return EmojiUtils.emojis(text).size();
    }

    @NonNull
    public static EmojiInformation emojiInformation(@Nullable String text) {
        List<EmojiRange> emojis = EmojiManager.getInstance().findAllEmojis(text);
        boolean isOnlyEmojis = EmojiUtils.isOnlyEmojis(text);
        return new EmojiInformation(isOnlyEmojis, emojis);
    }

    private EmojiUtils() {
        throw new AssertionError((Object)"No instances.");
    }
}

