/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.CheckResult;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import android.widget.PopupWindow;
import com.vanniktech.emoji.EmojiEditText;
import com.vanniktech.emoji.EmojiImageView;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiVariantPopup;
import com.vanniktech.emoji.EmojiView;
import com.vanniktech.emoji.RecentEmoji;
import com.vanniktech.emoji.RecentEmojiManager;
import com.vanniktech.emoji.Utils;
import com.vanniktech.emoji.VariantEmoji;
import com.vanniktech.emoji.VariantEmojiManager;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiLongClickListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupDismissListener;
import com.vanniktech.emoji.listeners.OnEmojiPopupShownListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardCloseListener;
import com.vanniktech.emoji.listeners.OnSoftKeyboardOpenListener;

public final class EmojiPopup {
    static final int MIN_KEYBOARD_HEIGHT = 100;
    final View rootView;
    final Activity context;
    @NonNull
    final RecentEmoji recentEmoji;
    @NonNull
    final VariantEmoji variantEmoji;
    @NonNull
    final EmojiVariantPopup variantPopup;
    final PopupWindow popupWindow;
    final EmojiEditText emojiEditText;
    boolean isPendingOpen;
    boolean isKeyboardOpen;
    @Nullable
    OnEmojiPopupShownListener onEmojiPopupShownListener;
    @Nullable
    OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
    @Nullable
    OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
    @Nullable
    OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    @Nullable
    OnEmojiClickListener onEmojiClickListener;
    @Nullable
    OnEmojiPopupDismissListener onEmojiPopupDismissListener;
    final ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            Rect rect = Utils.windowVisibleDisplayFrame(EmojiPopup.this.context);
            int heightDifference = Utils.screenHeight(EmojiPopup.this.context) - rect.bottom;
            if (heightDifference > Utils.dpToPx((Context)EmojiPopup.this.context, 100.0f)) {
                EmojiPopup.this.popupWindow.setHeight(heightDifference);
                EmojiPopup.this.popupWindow.setWidth(rect.right);
                if (!EmojiPopup.this.isKeyboardOpen && EmojiPopup.this.onSoftKeyboardOpenListener != null) {
                    EmojiPopup.this.onSoftKeyboardOpenListener.onKeyboardOpen(heightDifference);
                }
                EmojiPopup.this.isKeyboardOpen = true;
                if (EmojiPopup.this.isPendingOpen) {
                    EmojiPopup.this.showAtBottom();
                    EmojiPopup.this.isPendingOpen = false;
                }
            } else if (EmojiPopup.this.isKeyboardOpen) {
                EmojiPopup.this.isKeyboardOpen = false;
                if (EmojiPopup.this.onSoftKeyboardCloseListener != null) {
                    EmojiPopup.this.onSoftKeyboardCloseListener.onKeyboardClose();
                }
                EmojiPopup.this.dismiss();
                Utils.removeOnGlobalLayoutListener(EmojiPopup.this.context.getWindow().getDecorView(), EmojiPopup.this.onGlobalLayoutListener);
            }
        }
    };

    EmojiPopup(@NonNull View rootView, final @NonNull EmojiEditText emojiEditText, @Nullable RecentEmoji recent, @Nullable VariantEmoji variant) {
        this.context = Utils.asActivity(rootView.getContext());
        this.rootView = rootView.getRootView();
        this.emojiEditText = emojiEditText;
        this.recentEmoji = recent != null ? recent : new RecentEmojiManager((Context)this.context);
        this.variantEmoji = variant != null ? variant : new VariantEmojiManager((Context)this.context);
        this.popupWindow = new PopupWindow((Context)this.context);
        OnEmojiLongClickListener longClickListener = new OnEmojiLongClickListener(){

            @Override
            public void onEmojiLongClick(@NonNull EmojiImageView view, @NonNull Emoji emoji) {
                EmojiPopup.this.variantPopup.show(view, emoji);
            }
        };
        OnEmojiClickListener clickListener = new OnEmojiClickListener(){

            @Override
            public void onEmojiClick(@NonNull EmojiImageView imageView, @NonNull Emoji emoji) {
                emojiEditText.input(emoji);
                EmojiPopup.this.recentEmoji.addEmoji(emoji);
                EmojiPopup.this.variantEmoji.addVariant(emoji);
                imageView.updateEmoji(emoji);
                if (EmojiPopup.this.onEmojiClickListener != null) {
                    EmojiPopup.this.onEmojiClickListener.onEmojiClick(imageView, emoji);
                }
                EmojiPopup.this.variantPopup.dismiss();
            }
        };
        this.variantPopup = new EmojiVariantPopup(this.rootView, clickListener);
        EmojiView emojiView = new EmojiView((Context)this.context, clickListener, longClickListener, this.recentEmoji, this.variantEmoji);
        emojiView.setOnEmojiBackspaceClickListener(new OnEmojiBackspaceClickListener(){

            @Override
            public void onEmojiBackspaceClick(View v) {
                emojiEditText.backspace();
                if (EmojiPopup.this.onEmojiBackspaceClickListener != null) {
                    EmojiPopup.this.onEmojiBackspaceClickListener.onEmojiBackspaceClick(v);
                }
            }
        });
        this.popupWindow.setContentView((View)emojiView);
        this.popupWindow.setInputMethodMode(2);
        this.popupWindow.setBackgroundDrawable((Drawable)new BitmapDrawable(this.context.getResources(), (Bitmap)null));
        this.popupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                if (EmojiPopup.this.onEmojiPopupDismissListener != null) {
                    EmojiPopup.this.onEmojiPopupDismissListener.onEmojiPopupDismiss();
                }
            }
        });
    }

    public void toggle() {
        if (!this.popupWindow.isShowing()) {
            Utils.removeOnGlobalLayoutListener(this.context.getWindow().getDecorView(), this.onGlobalLayoutListener);
            this.context.getWindow().getDecorView().getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
            if (this.isKeyboardOpen) {
                this.showAtBottom();
            } else {
                this.emojiEditText.setFocusableInTouchMode(true);
                this.emojiEditText.requestFocus();
                this.showAtBottomPending();
                InputMethodManager inputMethodManager = (InputMethodManager)this.context.getSystemService("input_method");
                inputMethodManager.showSoftInput((View)this.emojiEditText, 1);
            }
        } else {
            this.dismiss();
        }
        this.context.getWindow().getDecorView().getViewTreeObserver().dispatchOnGlobalLayout();
    }

    public boolean isShowing() {
        return this.popupWindow.isShowing();
    }

    public void dismiss() {
        this.popupWindow.dismiss();
        this.variantPopup.dismiss();
        this.recentEmoji.persist();
        this.variantEmoji.persist();
    }

    void showAtBottom() {
        Point desiredLocation = new Point(0, Utils.screenHeight(this.context) - this.popupWindow.getHeight());
        this.popupWindow.showAtLocation(this.rootView, 0, desiredLocation.x, desiredLocation.y);
        Utils.fixPopupLocation(this.popupWindow, desiredLocation);
        if (this.onEmojiPopupShownListener != null) {
            this.onEmojiPopupShownListener.onEmojiPopupShown();
        }
    }

    private void showAtBottomPending() {
        if (this.isKeyboardOpen) {
            this.showAtBottom();
        } else {
            this.isPendingOpen = true;
        }
    }

    public static final class Builder {
        @NonNull
        private final View rootView;
        @Nullable
        private OnEmojiPopupShownListener onEmojiPopupShownListener;
        @Nullable
        private OnSoftKeyboardCloseListener onSoftKeyboardCloseListener;
        @Nullable
        private OnSoftKeyboardOpenListener onSoftKeyboardOpenListener;
        @Nullable
        private OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
        @Nullable
        private OnEmojiClickListener onEmojiClickListener;
        @Nullable
        private OnEmojiPopupDismissListener onEmojiPopupDismissListener;
        @Nullable
        private RecentEmoji recentEmoji;
        @Nullable
        private VariantEmoji variantEmoji;

        private Builder(View rootView) {
            this.rootView = Utils.checkNotNull(rootView, "The root View can't be null");
        }

        @CheckResult
        public static Builder fromRootView(View rootView) {
            return new Builder(rootView);
        }

        @CheckResult
        public Builder setOnSoftKeyboardCloseListener(@Nullable OnSoftKeyboardCloseListener listener) {
            this.onSoftKeyboardCloseListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiClickListener(@Nullable OnEmojiClickListener listener) {
            this.onEmojiClickListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnSoftKeyboardOpenListener(@Nullable OnSoftKeyboardOpenListener listener) {
            this.onSoftKeyboardOpenListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiPopupShownListener(@Nullable OnEmojiPopupShownListener listener) {
            this.onEmojiPopupShownListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiPopupDismissListener(@Nullable OnEmojiPopupDismissListener listener) {
            this.onEmojiPopupDismissListener = listener;
            return this;
        }

        @CheckResult
        public Builder setOnEmojiBackspaceClickListener(@Nullable OnEmojiBackspaceClickListener listener) {
            this.onEmojiBackspaceClickListener = listener;
            return this;
        }

        @CheckResult
        public Builder setRecentEmoji(@Nullable RecentEmoji recent) {
            this.recentEmoji = recent;
            return this;
        }

        @CheckResult
        public Builder setVariantEmoji(@Nullable VariantEmoji variant) {
            this.variantEmoji = variant;
            return this;
        }

        @CheckResult
        public EmojiPopup build(@NonNull EmojiEditText emojiEditText) {
            EmojiManager.getInstance().verifyInstalled();
            Utils.checkNotNull(emojiEditText, "EmojiEditText can't be null");
            EmojiPopup emojiPopup = new EmojiPopup(this.rootView, emojiEditText, this.recentEmoji, this.variantEmoji);
            emojiPopup.onSoftKeyboardCloseListener = this.onSoftKeyboardCloseListener;
            emojiPopup.onEmojiClickListener = this.onEmojiClickListener;
            emojiPopup.onSoftKeyboardOpenListener = this.onSoftKeyboardOpenListener;
            emojiPopup.onEmojiPopupShownListener = this.onEmojiPopupShownListener;
            emojiPopup.onEmojiPopupDismissListener = this.onEmojiPopupDismissListener;
            emojiPopup.onEmojiBackspaceClickListener = this.onEmojiBackspaceClickListener;
            return emojiPopup;
        }
    }
}

