/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RestrictTo;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import com.vanniktech.emoji.ImageLoadingTask;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.emoji.Emoji;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.listeners.OnEmojiLongClickListener;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class EmojiImageView
extends AppCompatImageView {
    private static final int VARIANT_INDICATOR_PART_AMOUNT = 6;
    private static final int VARIANT_INDICATOR_PART = 5;
    Emoji currentEmoji;
    OnEmojiClickListener clickListener;
    OnEmojiLongClickListener longClickListener;
    private final Paint variantIndicatorPaint = new Paint();
    private final Path variantIndicatorPath = new Path();
    private final Point variantIndicatorTop = new Point();
    private final Point variantIndicatorBottomRight = new Point();
    private final Point variantIndicatorBottomLeft = new Point();
    private ImageLoadingTask imageLoadingTask;
    private boolean hasVariants;

    public EmojiImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.variantIndicatorPaint.setColor(ContextCompat.getColor((Context)context, (int)R.color.emoji_divider));
        this.variantIndicatorPaint.setStyle(Paint.Style.FILL);
        this.variantIndicatorPaint.setAntiAlias(true);
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measuredWidth = this.getMeasuredWidth();
        this.setMeasuredDimension(measuredWidth, measuredWidth);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.variantIndicatorTop.x = w;
        this.variantIndicatorTop.y = h / 6 * 5;
        this.variantIndicatorBottomRight.x = w;
        this.variantIndicatorBottomRight.y = h;
        this.variantIndicatorBottomLeft.x = w / 6 * 5;
        this.variantIndicatorBottomLeft.y = h;
        this.variantIndicatorPath.rewind();
        this.variantIndicatorPath.moveTo((float)this.variantIndicatorTop.x, (float)this.variantIndicatorTop.y);
        this.variantIndicatorPath.lineTo((float)this.variantIndicatorBottomRight.x, (float)this.variantIndicatorBottomRight.y);
        this.variantIndicatorPath.lineTo((float)this.variantIndicatorBottomLeft.x, (float)this.variantIndicatorBottomLeft.y);
        this.variantIndicatorPath.close();
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.hasVariants) {
            canvas.drawPath(this.variantIndicatorPath, this.variantIndicatorPaint);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.imageLoadingTask != null) {
            this.imageLoadingTask.cancel(true);
            this.imageLoadingTask = null;
        }
    }

    void setEmoji(@NonNull Emoji emoji) {
        if (!emoji.equals(this.currentEmoji)) {
            this.setImageDrawable(null);
            this.currentEmoji = emoji;
            this.hasVariants = emoji.getBase().hasVariants();
            if (this.imageLoadingTask != null) {
                this.imageLoadingTask.cancel(true);
            }
            this.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (EmojiImageView.this.clickListener != null) {
                        EmojiImageView.this.clickListener.onEmojiClick(EmojiImageView.this, EmojiImageView.this.currentEmoji);
                    }
                }
            });
            this.setOnLongClickListener(this.hasVariants ? new View.OnLongClickListener(){

                public boolean onLongClick(View view) {
                    EmojiImageView.this.longClickListener.onEmojiLongClick(EmojiImageView.this, EmojiImageView.this.currentEmoji);
                    return true;
                }
            } : null);
            this.imageLoadingTask = new ImageLoadingTask((ImageView)this);
            this.imageLoadingTask.execute(new Integer[]{emoji.getResource()});
        }
    }

    void updateEmoji(@NonNull Emoji emoji) {
        if (!emoji.equals(this.currentEmoji)) {
            this.currentEmoji = emoji;
            this.setImageResource(emoji.getResource());
        }
    }

    void setOnEmojiClickListener(@Nullable OnEmojiClickListener listener) {
        this.clickListener = listener;
    }

    void setOnEmojiLongClickListener(@Nullable OnEmojiLongClickListener listener) {
        this.longClickListener = listener;
    }
}

