/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.support.annotation.CallSuper;
import android.support.annotation.DimenRes;
import android.support.annotation.Px;
import android.support.v7.widget.AppCompatButton;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.widget.TextView;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.R;

public class EmojiButton
extends AppCompatButton {
    private float emojiSize;

    public EmojiButton(Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EmojiButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            EmojiManager.getInstance().verifyInstalled();
        }
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        if (attrs == null) {
            this.emojiSize = defaultEmojiSize;
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.EmojiButton);
            try {
                this.emojiSize = a.getDimension(R.styleable.EmojiButton_emojiSize, defaultEmojiSize);
            }
            finally {
                a.recycle();
            }
        }
        this.setText(this.getText());
    }

    @CallSuper
    public void setText(CharSequence rawText, TextView.BufferType type) {
        CharSequence text = rawText == null ? "" : rawText;
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder(text);
        EmojiManager.replaceWithImages(this.getContext(), (Spannable)spannableStringBuilder, this.emojiSize);
        super.setText((CharSequence)spannableStringBuilder, type);
    }

    public final void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    public final void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText(this.getText());
        }
    }

    public final void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    public final void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }
}

