/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.emoji;

import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import java.io.Serializable;

public final class Emoji
implements Serializable {
    private static final long serialVersionUID = 2L;
    @NonNull
    private final String unicode;
    @DrawableRes
    private final int resource;
    private final boolean skinToned;

    public Emoji(@NonNull int[] codePoints, @DrawableRes int resource) {
        this(codePoints, resource, false);
    }

    public Emoji(int codePoint, @DrawableRes int resource) {
        this(codePoint, resource, false);
    }

    public Emoji(@NonNull int[] codePoints, @DrawableRes int resource, boolean skinToned) {
        this.unicode = new String(codePoints, 0, codePoints.length);
        this.resource = resource;
        this.skinToned = skinToned;
    }

    public Emoji(int codePoint, @DrawableRes int resource, boolean skinToned) {
        this.unicode = new String(new int[]{codePoint}, 0, 1);
        this.resource = resource;
        this.skinToned = skinToned;
    }

    @NonNull
    public String getUnicode() {
        return this.unicode;
    }

    @DrawableRes
    public int getResource() {
        return this.resource;
    }

    public int getLength() {
        return this.unicode.length();
    }

    public boolean isSkinToned() {
        return this.skinToned;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Emoji emoji = (Emoji)o;
        return this.resource == emoji.resource && this.skinToned == emoji.skinToned && this.unicode.equals(emoji.unicode);
    }

    public int hashCode() {
        int result = this.unicode.hashCode();
        result = 31 * result + this.resource;
        result = 31 * result + (this.skinToned ? 1 : 0);
        return result;
    }
}

