/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.support.v7.content.res.AppCompatResources;
import android.widget.ImageView;
import java.lang.ref.WeakReference;

final class ImageDownloaderTask
extends AsyncTask<Integer, Void, Drawable> {
    private final WeakReference<ImageView> imageViewReference;
    private final WeakReference<Context> contextReference;

    ImageDownloaderTask(ImageView imageView) {
        this.imageViewReference = new WeakReference<ImageView>(imageView);
        this.contextReference = new WeakReference<Context>(imageView.getContext());
    }

    protected Drawable doInBackground(Integer ... resource) {
        Context context = (Context)this.contextReference.get();
        if (context == null) {
            return null;
        }
        return AppCompatResources.getDrawable((Context)context, (int)resource[0]);
    }

    protected void onPostExecute(Drawable drawable) {
        ImageView imageView;
        if (!this.isCancelled() && drawable != null && (imageView = (ImageView)this.imageViewReference.get()) != null) {
            imageView.setImageDrawable(drawable);
        }
    }
}

