/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.style.DynamicDrawableSpan;
import com.vanniktech.emoji.Emoji;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJP\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\nH\u0016J2\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/vanniktech/emoji/internal/EmojiSpan;", "Landroid/text/style/DynamicDrawableSpan;", "context", "Landroid/content/Context;", "emoji", "Lcom/vanniktech/emoji/Emoji;", "size", "", "(Landroid/content/Context;Lcom/vanniktech/emoji/Emoji;F)V", "deferredDrawable", "Landroid/graphics/drawable/Drawable;", "getDeferredDrawable", "()Landroid/graphics/drawable/Drawable;", "deferredDrawable$delegate", "Lkotlin/Lazy;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "text", "", "start", "", "end", "x", "top", "y", "bottom", "paint", "Landroid/graphics/Paint;", "getDrawable", "getSize", "fontMetrics", "Landroid/graphics/Paint$FontMetricsInt;", "emoji_release"})
public final class EmojiSpan
extends DynamicDrawableSpan {
    @NotNull
    private final Context context;
    @NotNull
    private final Emoji emoji;
    private final float size;
    @NotNull
    private final Lazy deferredDrawable$delegate;

    public EmojiSpan(@NotNull Context context, @NotNull Emoji emoji, float size) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        this.context = context;
        this.emoji = emoji;
        this.size = size;
        this.deferredDrawable$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<Drawable>(this){
            final /* synthetic */ EmojiSpan this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Drawable invoke() {
                Drawable drawable2 = EmojiSpan.access$getEmoji$p(this.this$0).getDrawable(EmojiSpan.access$getContext$p(this.this$0));
                drawable2.setBounds(0, 0, (int)EmojiSpan.access$getSize$p(this.this$0), (int)EmojiSpan.access$getSize$p(this.this$0));
                return drawable2;
            }
        }));
    }

    private final Drawable getDeferredDrawable() {
        Lazy lazy = this.deferredDrawable$delegate;
        return (Drawable)lazy.getValue();
    }

    @NotNull
    public Drawable getDrawable() {
        return this.getDeferredDrawable();
    }

    public int getSize(@NotNull Paint paint, @NotNull CharSequence text, int start, int end, @Nullable Paint.FontMetricsInt fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (fontMetrics != null) {
            Paint.FontMetrics paintFontMetrics = paint.getFontMetrics();
            float ascent = paintFontMetrics.ascent;
            float descent = paintFontMetrics.descent;
            float targetSize = Math.abs(ascent) + Math.abs(descent);
            int roundEmojiSize = MathKt.roundToInt((float)this.size);
            if (roundEmojiSize == MathKt.roundToInt((float)targetSize)) {
                fontMetrics.ascent = (int)ascent;
                fontMetrics.descent = (int)descent;
                fontMetrics.top = (int)paintFontMetrics.top;
                fontMetrics.bottom = (int)paintFontMetrics.bottom;
            } else {
                float fontHeight = paintFontMetrics.descent - paintFontMetrics.ascent;
                float centerY = paintFontMetrics.ascent + fontHeight / (float)2;
                fontMetrics.top = fontMetrics.ascent = (int)(centerY - this.size / (float)2);
                fontMetrics.descent = fontMetrics.bottom = (int)(centerY + this.size / (float)2);
            }
        }
        return (int)this.size;
    }

    public void draw(@NotNull Canvas canvas, @NotNull CharSequence text, int start, int end, float x, int top, int y, int bottom, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        Drawable drawable2 = this.getDrawable();
        Paint.FontMetrics paintFontMetrics = paint.getFontMetrics();
        float fontHeight = paintFontMetrics.descent - paintFontMetrics.ascent;
        float centerY = (float)y + paintFontMetrics.descent - fontHeight / (float)2;
        float transitionY = centerY - this.size / (float)2;
        canvas.save();
        canvas.translate(x, transitionY);
        drawable2.draw(canvas);
        canvas.restore();
    }

    public static final /* synthetic */ Emoji access$getEmoji$p(EmojiSpan $this) {
        return $this.emoji;
    }

    public static final /* synthetic */ Context access$getContext$p(EmojiSpan $this) {
        return $this.context;
    }

    public static final /* synthetic */ float access$getSize$p(EmojiSpan $this) {
        return $this.size;
    }
}

