/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiTheming;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.internal.EmojiImageView;
import com.vanniktech.emoji.internal.OnEmojiLongClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.variant.VariantEmoji;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0014\u0010\u0017\u001a\u00020\u00182\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/vanniktech/emoji/internal/EmojiArrayAdapter;", "Landroid/widget/ArrayAdapter;", "Lcom/vanniktech/emoji/Emoji;", "context", "Landroid/content/Context;", "emojis", "", "variantEmoji", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "listener", "Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;", "longListener", "Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;", "theming", "Lcom/vanniktech/emoji/EmojiTheming;", "(Landroid/content/Context;Ljava/util/Collection;Lcom/vanniktech/emoji/variant/VariantEmoji;Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;Lcom/vanniktech/emoji/EmojiTheming;)V", "getView", "Landroid/view/View;", "position", "", "convertView", "parent", "Landroid/view/ViewGroup;", "updateEmojis", "", "emoji_release"})
public final class EmojiArrayAdapter
extends ArrayAdapter<Emoji> {
    @Nullable
    private final VariantEmoji variantEmoji;
    @Nullable
    private final OnEmojiClickListener listener;
    @Nullable
    private final OnEmojiLongClickListener longListener;
    @NotNull
    private final EmojiTheming theming;

    /*
     * WARNING - void declaration
     */
    public EmojiArrayAdapter(@NotNull Context context, @NotNull Collection<? extends Emoji> emojis, @Nullable VariantEmoji variantEmoji, @Nullable OnEmojiClickListener listener2, @Nullable OnEmojiLongClickListener longListener, @NotNull EmojiTheming theming) {
        void $this$filterNotTo$iv$iv;
        void $this$filterNot$iv;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(emojis, (String)"emojis");
        Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
        Iterable iterable = emojis;
        int n = 0;
        Context context2 = context;
        EmojiArrayAdapter emojiArrayAdapter = this;
        boolean $i$f$filterNot = false;
        void var9_12 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Emoji it = (Emoji)element$iv$iv;
            boolean bl = false;
            if (it.isDuplicate()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        super(context2, n, list);
        this.variantEmoji = variantEmoji;
        this.listener = listener2;
        this.longListener = longListener;
        this.theming = theming;
    }

    @NotNull
    public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        EmojiImageView image = convertView instanceof EmojiImageView ? (EmojiImageView)convertView : null;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        Context context2 = context;
        if (image == null) {
            View view = LayoutInflater.from((Context)context2).inflate(R.layout.emoji_adapter_item_emoji, parent, false);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.vanniktech.emoji.internal.EmojiImageView");
            }
            image = (EmojiImageView)view;
            image.setClickListener$emoji_release(this.listener);
            image.setLongClickListener$emoji_release(this.longListener);
        }
        Object object = this.getItem(position);
        Intrinsics.checkNotNull((Object)object);
        Emoji emoji = (Emoji)object;
        Object object2 = this.variantEmoji;
        if (object2 == null || (object2 = object2.getVariant(emoji)) == null) {
            object2 = emoji;
        }
        Object variantToUse = object2;
        image.setContentDescription(emoji.getUnicode());
        image.setEmoji(this.theming, (Emoji)variantToUse, this.variantEmoji);
        return (View)image;
    }

    public final void updateEmojis(@NotNull Collection<? extends Emoji> emojis) {
        Intrinsics.checkNotNullParameter(emojis, (String)"emojis");
        this.clear();
        this.addAll(emojis);
        this.notifyDataSetChanged();
    }
}

