/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.internal.EmojiImageView;
import com.vanniktech.emoji.internal.EmojiVariantDelegate;
import com.vanniktech.emoji.internal.Utils;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ(\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0016\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/vanniktech/emoji/internal/EmojiVariantPopup;", "", "rootView", "Landroid/view/View;", "delegate", "Lcom/vanniktech/emoji/internal/EmojiVariantDelegate;", "(Landroid/view/View;Lcom/vanniktech/emoji/internal/EmojiVariantDelegate;)V", "popupWindow", "Landroid/widget/PopupWindow;", "dismiss", "", "initView", "context", "Landroid/content/Context;", "emoji", "Lcom/vanniktech/emoji/Emoji;", "width", "", "clickedImage", "Lcom/vanniktech/emoji/internal/EmojiImageView;", "show", "Companion", "emoji_release"})
public final class EmojiVariantPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View rootView;
    @Nullable
    private final EmojiVariantDelegate delegate;
    @Nullable
    private PopupWindow popupWindow;
    private static final int MARGIN = 2;

    public EmojiVariantPopup(@NotNull View rootView, @Nullable EmojiVariantDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        this.rootView = rootView;
        this.delegate = delegate;
    }

    /*
     * WARNING - void declaration
     */
    public final void show(@NotNull EmojiImageView clickedImage, @NotNull Emoji emoji) {
        void $this$show_u24lambda_u2d0;
        PopupWindow popupWindow;
        Intrinsics.checkNotNullParameter((Object)((Object)clickedImage), (String)"clickedImage");
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        this.dismiss();
        Context context = clickedImage.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        View content = this.initView(context, emoji, clickedImage.getWidth(), clickedImage);
        content.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        Point location = Utils.INSTANCE.locationOnScreen$emoji_release((View)clickedImage);
        Point desiredLocation = new Point(location.x - content.getMeasuredWidth() / 2 + clickedImage.getWidth() / 2, location.y - content.getMeasuredHeight());
        PopupWindow popupWindow2 = popupWindow = new PopupWindow(content, -2, -2);
        EmojiVariantPopup emojiVariantPopup = this;
        boolean bl = false;
        $this$show_u24lambda_u2d0.setFocusable(true);
        $this$show_u24lambda_u2d0.setOutsideTouchable(true);
        $this$show_u24lambda_u2d0.setInputMethodMode(2);
        $this$show_u24lambda_u2d0.setBackgroundDrawable((Drawable)new BitmapDrawable(context.getResources(), (Bitmap)null));
        $this$show_u24lambda_u2d0.showAtLocation(this.rootView, 0, desiredLocation.x, desiredLocation.y);
        Utils.INSTANCE.fixPopupLocation$emoji_release((PopupWindow)$this$show_u24lambda_u2d0, desiredLocation);
        emojiVariantPopup.popupWindow = popupWindow;
        clickedImage.getParent().requestDisallowInterceptTouchEvent(true);
    }

    public final void dismiss() {
        PopupWindow popupWindow = this.popupWindow;
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
        this.popupWindow = null;
    }

    private final View initView(Context context, Emoji emoji, int width, EmojiImageView clickedImage) {
        View result = View.inflate((Context)context, (int)R.layout.emoji_popup_window_skin, null);
        LinearLayout imageContainer = (LinearLayout)result.findViewById(R.id.emojiPopupWindowSkinPopupContainer);
        List variants = CollectionsKt.toMutableList((Collection)emoji.getBase().getVariants());
        variants.add(0, emoji.getBase());
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        for (Emoji variant : variants) {
            View view = inflater.inflate(R.layout.emoji_adapter_item_emoji, (ViewGroup)imageContainer, false);
            if (view == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.widget.ImageView");
            }
            ImageView emojiImage = (ImageView)view;
            ViewGroup.LayoutParams layoutParams = emojiImage.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            }
            ViewGroup.MarginLayoutParams layoutParams2 = (ViewGroup.MarginLayoutParams)layoutParams;
            int margin = Utils.INSTANCE.dpToPx$emoji_release(context, 2.0f);
            layoutParams2.width = width;
            layoutParams2.setMargins(margin, margin, margin, margin);
            emojiImage.setImageDrawable(variant.getDrawable(context));
            emojiImage.setOnClickListener(arg_0 -> EmojiVariantPopup.initView$lambda-1(this, clickedImage, variant, arg_0));
            imageContainer.addView((View)emojiImage);
        }
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        return result;
    }

    private static final void initView$lambda-1(EmojiVariantPopup this$0, EmojiImageView $clickedImage, Emoji $variant, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)$clickedImage), (String)"$clickedImage");
            Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
            EmojiVariantDelegate emojiVariantDelegate = this$0.delegate;
            if (emojiVariantDelegate == null) break block0;
            emojiVariantDelegate.onEmojiClick($clickedImage, $variant);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vanniktech/emoji/internal/EmojiVariantPopup$Companion;", "", "()V", "MARGIN", "", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

