/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiTheming;
import com.vanniktech.emoji.internal.ImageLoadingTask;
import com.vanniktech.emoji.internal.OnEmojiLongClickListener;
import com.vanniktech.emoji.internal.ThemingsKt;
import com.vanniktech.emoji.listeners.OnEmojiClickListener;
import com.vanniktech.emoji.variant.NoVariantEmoji;
import com.vanniktech.emoji.variant.VariantEmoji;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 72\u00020\u0001:\u00017B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\"H\u0014J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0014J\u0018\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J(\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020)2\u0006\u0010/\u001a\u00020)H\u0014J \u00100\u001a\u00020\"2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\u000e2\b\u00104\u001a\u0004\u0018\u000105J\u000e\u00106\u001a\u00020\"2\u0006\u00103\u001a\u00020\u000eR\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/vanniktech/emoji/internal/EmojiImageView;", "Landroidx/appcompat/widget/AppCompatImageView;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "clickListener", "Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;", "getClickListener$emoji_release", "()Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;", "setClickListener$emoji_release", "(Lcom/vanniktech/emoji/listeners/OnEmojiClickListener;)V", "currentEmoji", "Lcom/vanniktech/emoji/Emoji;", "hasVariants", "", "imageLoadingTask", "Lcom/vanniktech/emoji/internal/ImageLoadingTask;", "longClickListener", "Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;", "getLongClickListener$emoji_release", "()Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;", "setLongClickListener$emoji_release", "(Lcom/vanniktech/emoji/internal/OnEmojiLongClickListener;)V", "variantIndicatorBottomLeft", "Landroid/graphics/Point;", "variantIndicatorBottomRight", "variantIndicatorPaint", "Landroid/graphics/Paint;", "variantIndicatorPath", "Landroid/graphics/Path;", "variantIndicatorTop", "cancelFuture", "", "onDetachedFromWindow", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "setEmoji", "theming", "Lcom/vanniktech/emoji/EmojiTheming;", "emoji", "variantEmoji", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "updateEmoji", "Companion", "emoji_release"})
public final class EmojiImageView
extends AppCompatImageView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Emoji currentEmoji;
    @Nullable
    private OnEmojiClickListener clickListener;
    @Nullable
    private OnEmojiLongClickListener longClickListener;
    @NotNull
    private final Paint variantIndicatorPaint;
    @NotNull
    private final Path variantIndicatorPath;
    @NotNull
    private final Point variantIndicatorTop;
    @NotNull
    private final Point variantIndicatorBottomRight;
    @NotNull
    private final Point variantIndicatorBottomLeft;
    private boolean hasVariants;
    @Nullable
    private ImageLoadingTask imageLoadingTask;
    private static final int VARIANT_INDICATOR_PART_AMOUNT = 6;
    private static final int VARIANT_INDICATOR_PART = 5;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public EmojiImageView(@NotNull Context context, @Nullable AttributeSet attrs) {
        void $this$variantIndicatorPaint_u24lambda_u2d0;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs);
        Paint paint2 = paint = new Paint();
        EmojiImageView emojiImageView = this;
        boolean bl = false;
        $this$variantIndicatorPaint_u24lambda_u2d0.setStyle(Paint.Style.FILL);
        $this$variantIndicatorPaint_u24lambda_u2d0.setAntiAlias(true);
        emojiImageView.variantIndicatorPaint = paint;
        this.variantIndicatorPath = new Path();
        this.variantIndicatorTop = new Point();
        this.variantIndicatorBottomRight = new Point();
        this.variantIndicatorBottomLeft = new Point();
    }

    public /* synthetic */ EmojiImageView(Context context, AttributeSet attributeSet, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        this(context, attributeSet);
    }

    @Nullable
    public final OnEmojiClickListener getClickListener$emoji_release() {
        return this.clickListener;
    }

    public final void setClickListener$emoji_release(@Nullable OnEmojiClickListener onEmojiClickListener) {
        this.clickListener = onEmojiClickListener;
    }

    @Nullable
    public final OnEmojiLongClickListener getLongClickListener$emoji_release() {
        return this.longClickListener;
    }

    public final void setLongClickListener$emoji_release(@Nullable OnEmojiLongClickListener onEmojiLongClickListener) {
        this.longClickListener = onEmojiLongClickListener;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measuredWidth = this.getMeasuredWidth();
        this.setMeasuredDimension(measuredWidth, measuredWidth);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.variantIndicatorTop.x = w;
        this.variantIndicatorTop.y = h / 6 * 5;
        this.variantIndicatorBottomRight.x = w;
        this.variantIndicatorBottomRight.y = h;
        this.variantIndicatorBottomLeft.x = w / 6 * 5;
        this.variantIndicatorBottomLeft.y = h;
        this.variantIndicatorPath.rewind();
        this.variantIndicatorPath.moveTo((float)this.variantIndicatorTop.x, (float)this.variantIndicatorTop.y);
        this.variantIndicatorPath.lineTo((float)this.variantIndicatorBottomRight.x, (float)this.variantIndicatorBottomRight.y);
        this.variantIndicatorPath.lineTo((float)this.variantIndicatorBottomLeft.x, (float)this.variantIndicatorBottomLeft.y);
        this.variantIndicatorPath.close();
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.onDraw(canvas);
        if (this.hasVariants && this.getDrawable() != null) {
            canvas.drawPath(this.variantIndicatorPath, this.variantIndicatorPaint);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.cancelFuture();
    }

    private final void cancelFuture() {
        ImageLoadingTask imageLoadingTask = this.imageLoadingTask;
        if (imageLoadingTask != null) {
            imageLoadingTask.cancel();
        }
        this.imageLoadingTask = null;
    }

    public final void setEmoji(@NotNull EmojiTheming theming, @NotNull Emoji emoji, @Nullable VariantEmoji variantEmoji) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)theming, (String)"theming");
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.variantIndicatorPaint.setColor(ThemingsKt.dividerColor(theming, context));
            this.postInvalidate();
            if (Intrinsics.areEqual((Object)emoji, (Object)this.currentEmoji)) break block1;
            this.setImageDrawable(null);
            this.currentEmoji = emoji;
            this.hasVariants = !((Collection)emoji.getBase().getVariants()).isEmpty() && !(variantEmoji instanceof NoVariantEmoji);
            this.cancelFuture();
            this.setOnClickListener(arg_0 -> EmojiImageView.setEmoji$lambda-1(this, arg_0));
            this.setOnLongClickListener(this.hasVariants ? arg_0 -> EmojiImageView.setEmoji$lambda-2(this, emoji, arg_0) : null);
            ImageLoadingTask imageLoadingTask = this.imageLoadingTask = new ImageLoadingTask((ImageView)this);
            if (imageLoadingTask != null) {
                imageLoadingTask.start(emoji);
            }
        }
    }

    public final void updateEmoji(@NotNull Emoji emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        if (!Intrinsics.areEqual((Object)emoji, (Object)this.currentEmoji)) {
            this.currentEmoji = emoji;
            Context context = this.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            this.setImageDrawable(emoji.getDrawable(context));
        }
    }

    @JvmOverloads
    public EmojiImageView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 2, null);
    }

    private static final void setEmoji$lambda-1(EmojiImageView this$0, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            OnEmojiClickListener onEmojiClickListener = this$0.clickListener;
            if (onEmojiClickListener == null) break block0;
            Emoji emoji = this$0.currentEmoji;
            Intrinsics.checkNotNull((Object)emoji);
            onEmojiClickListener.onEmojiClick(emoji);
        }
    }

    private static final boolean setEmoji$lambda-2(EmojiImageView this$0, Emoji $emoji, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$emoji, (String)"$emoji");
            OnEmojiLongClickListener onEmojiLongClickListener = this$0.longClickListener;
            if (onEmojiLongClickListener == null) break block0;
            onEmojiLongClickListener.onEmojiLongClick(this$0, $emoji);
        }
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vanniktech/emoji/internal/EmojiImageView$Companion;", "", "()V", "VARIANT_INDICATOR_PART", "", "VARIANT_INDICATOR_PART_AMOUNT", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

