/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.text.Spannable;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiCategory;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.EmojiRange;
import com.vanniktech.emoji.EmojiReplacer;
import com.vanniktech.emoji.internal.EmojiSpan;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0006\u0010\u001a\u001a\u00020\u001bJ\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0000\u00a2\u0006\u0002\b!J\u0017\u0010\"\u001a\u0004\u0018\u00010\u000f2\u0006\u0010#\u001a\u00020 H\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020\u001bJ\"\u0010)\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u001f\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.J\r\u0010/\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b0R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0011X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/vanniktech/emoji/EmojiManager;", "", "()V", "DEFAULT_EMOJI_REPLACER", "Lcom/vanniktech/emoji/EmojiReplacer;", "GUESSED_TOTAL_PATTERN_LENGTH", "", "GUESSED_UNICODE_AMOUNT", "categories", "", "Lcom/vanniktech/emoji/EmojiCategory;", "[Lcom/vanniktech/emoji/EmojiCategory;", "emojiMap", "", "", "Lcom/vanniktech/emoji/Emoji;", "emojiPattern", "Lkotlin/text/Regex;", "emojiRepetitivePattern", "getEmojiRepetitivePattern$emoji_release", "()Lkotlin/text/Regex;", "setEmojiRepetitivePattern$emoji_release", "(Lkotlin/text/Regex;)V", "emojiReplacer", "categories$emoji_release", "()[Lcom/vanniktech/emoji/EmojiCategory;", "destroy", "", "findAllEmojis", "", "Lcom/vanniktech/emoji/EmojiRange;", "text", "", "findAllEmojis$emoji_release", "findEmoji", "candidate", "findEmoji$emoji_release", "install", "provider", "Lcom/vanniktech/emoji/EmojiProvider;", "release", "replaceWithImages", "context", "Landroid/content/Context;", "Landroid/text/Spannable;", "emojiSize", "", "verifyInstalled", "verifyInstalled$emoji_release", "emoji_release"})
public final class EmojiManager {
    @NotNull
    public static final EmojiManager INSTANCE = new EmojiManager();
    private static final int GUESSED_UNICODE_AMOUNT = 3000;
    private static final int GUESSED_TOTAL_PATTERN_LENGTH = 12000;
    @NotNull
    private static final Map<String, Emoji> emojiMap = new LinkedHashMap(3000);
    @Nullable
    private static EmojiCategory[] categories;
    @Nullable
    private static Regex emojiPattern;
    @Nullable
    private static Regex emojiRepetitivePattern;
    @Nullable
    private static EmojiReplacer emojiReplacer;
    @NotNull
    private static final EmojiReplacer DEFAULT_EMOJI_REPLACER;

    private EmojiManager() {
    }

    @Nullable
    public final Regex getEmojiRepetitivePattern$emoji_release() {
        return emojiRepetitivePattern;
    }

    public final void setEmojiRepetitivePattern$emoji_release(@Nullable Regex regex) {
        emojiRepetitivePattern = regex;
    }

    public final void replaceWithImages(@Nullable Context context, @Nullable Spannable text, float emojiSize) {
        this.verifyInstalled$emoji_release();
        EmojiReplacer emojiReplacer = EmojiManager.emojiReplacer;
        Intrinsics.checkNotNull((Object)emojiReplacer);
        Context context2 = context;
        Intrinsics.checkNotNull((Object)context2);
        Spannable spannable = text;
        Intrinsics.checkNotNull((Object)spannable);
        emojiReplacer.replaceWithImages(context2, spannable, emojiSize, DEFAULT_EMOJI_REPLACER);
    }

    @NotNull
    public final EmojiCategory[] categories$emoji_release() {
        this.verifyInstalled$emoji_release();
        Intrinsics.checkNotNull((Object)categories);
        return categories;
    }

    @NotNull
    public final List<EmojiRange> findAllEmojis$emoji_release(@Nullable CharSequence text) {
        this.verifyInstalled$emoji_release();
        if (text != null && text.length() > 0) {
            Sequence sequence;
            Regex regex = emojiPattern;
            Sequence sequence2 = regex != null && (sequence = Regex.findAll$default((Regex)regex, (CharSequence)text, (int)0, (int)2, null)) != null ? SequencesKt.mapNotNull((Sequence)sequence, (Function1)findAllEmojis.1.INSTANCE) : null;
            if (sequence2 == null) {
                sequence2 = SequencesKt.emptySequence();
            }
            return SequencesKt.toList(sequence2);
        }
        return CollectionsKt.emptyList();
    }

    @Nullable
    public final Emoji findEmoji$emoji_release(@NotNull CharSequence candidate) {
        Intrinsics.checkNotNullParameter((Object)candidate, (String)"candidate");
        this.verifyInstalled$emoji_release();
        return emojiMap.get(((Object)candidate).toString());
    }

    public final void verifyInstalled$emoji_release() {
        EmojiCategory[] emojiCategoryArray = categories;
        if (categories == null) {
            boolean bl = false;
            String string = "Please install an EmojiProvider through the EmojiManager.install() method first.";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void install(@NotNull EmojiProvider provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Class<EmojiManager> clazz = EmojiManager.class;
        synchronized (clazz) {
            boolean bl = false;
            categories = provider.getCategories();
            emojiMap.clear();
            emojiReplacer = provider instanceof EmojiReplacer ? (EmojiReplacer)((Object)provider) : DEFAULT_EMOJI_REPLACER;
            List unicodesForPattern = new ArrayList(3000);
            int categoriesSize = provider.getCategories().length;
            for (int i = 0; i < categoriesSize; ++i) {
                List<Emoji> emojis = provider.getCategories()[i].getEmojis();
                int emojisSize = emojis.size();
                for (int j = 0; j < emojisSize; ++j) {
                    Emoji emoji = emojis.get(j);
                    String unicode = emoji.getUnicode();
                    List<Emoji> variants = emoji.getVariants();
                    emojiMap.put(unicode, emoji);
                    unicodesForPattern.add(unicode);
                    int n = variants.size();
                    for (int k = 0; k < n; ++k) {
                        Emoji variant = variants.get(k);
                        String variantUnicode = variant.getUnicode();
                        emojiMap.put(variantUnicode, variant);
                        unicodesForPattern.add(variantUnicode);
                    }
                }
            }
            if (!(!((Collection)unicodesForPattern).isEmpty())) {
                boolean $i$a$-require-EmojiManager$install$1$22 = false;
                String $i$a$-require-EmojiManager$install$1$22 = "Your EmojiProvider must at least have one category with at least one emoji.";
                throw new IllegalArgumentException($i$a$-require-EmojiManager$install$1$22.toString());
            }
            CollectionsKt.sortWith((List)unicodesForPattern, EmojiManager::install$lambda-4$lambda-3);
            StringBuilder patternBuilder = new StringBuilder(12000);
            int unicodesForPatternSize = unicodesForPattern.size();
            for (int i = 0; i < unicodesForPatternSize; ++i) {
                patternBuilder.append(Regex.Companion.escape((String)unicodesForPattern.get(i))).append('|');
            }
            String string = patternBuilder.deleteCharAt(patternBuilder.length() - 1).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"patternBuilder.deleteCha\u2026er.length - 1).toString()");
            String regex = string;
            emojiPattern = new Regex(regex, RegexOption.IGNORE_CASE);
            emojiRepetitivePattern = new Regex('(' + regex + ")+", RegexOption.IGNORE_CASE);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void destroy() {
        Class<EmojiManager> clazz = EmojiManager.class;
        synchronized (clazz) {
            boolean bl = false;
            INSTANCE.release();
            emojiMap.clear();
            categories = null;
            emojiPattern = null;
            emojiRepetitivePattern = null;
            emojiReplacer = null;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void release() {
        Class<EmojiManager> clazz = EmojiManager.class;
        synchronized (clazz) {
            boolean bl = false;
            for (Emoji emoji : emojiMap.values()) {
                emoji.destroy();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void DEFAULT_EMOJI_REPLACER$lambda-1(Context context, Spannable text, float emojiSize, EmojiReplacer emojiReplacer) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        EmojiSpan[] existingSpans = (EmojiSpan[])text.getSpans(0, text.length(), EmojiSpan.class);
        List existingSpanPositions = new ArrayList(existingSpans.length);
        int size = existingSpans.length;
        for (int i = 0; i < size; ++i) {
            existingSpanPositions.add(text.getSpanStart((Object)existingSpans[i]));
        }
        List<EmojiRange> findAllEmojis2 = INSTANCE.findAllEmojis$emoji_release((CharSequence)text);
        int n = findAllEmojis2.size();
        for (int i = 0; i < n; ++i) {
            EmojiRange emojiRange = findAllEmojis2.get(i);
            Emoji emoji = emojiRange.component1();
            IntRange range = emojiRange.component2();
            if (existingSpanPositions.contains(range.getFirst())) continue;
            text.setSpan((Object)new EmojiSpan(context, emoji, emojiSize), range.getFirst(), range.getLast(), 33);
        }
    }

    private static final int install$lambda-4$lambda-3(String first, String second) {
        return Intrinsics.compare((int)second.length(), (int)first.length());
    }

    static {
        DEFAULT_EMOJI_REPLACER = EmojiManager::DEFAULT_EMOJI_REPLACER$lambda-1;
    }
}

