/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.variant;

import android.content.Context;
import android.content.SharedPreferences;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.variant.VariantEmoji;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0002J\b\u0010\u0011\u001a\u00020\fH\u0016R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/vanniktech/emoji/variant/VariantEmojiManager;", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "variantsList", "", "Lcom/vanniktech/emoji/Emoji;", "addVariant", "", "newVariant", "getVariant", "desiredEmoji", "initFromSharedPreferences", "persist", "Companion", "emoji_release"})
public final class VariantEmojiManager
implements VariantEmoji {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences preferences;
    @NotNull
    private List<Emoji> variantsList;
    @NotNull
    private static final String PREFERENCE_NAME = "variant-emoji-manager";
    @NotNull
    private static final String EMOJI_DELIMITER = "~";
    @NotNull
    private static final String VARIANT_EMOJIS = "variant-emojis";
    private static final int EMOJI_GUESS_SIZE = 5;

    public VariantEmojiManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.preferences = context.getApplicationContext().getSharedPreferences(PREFERENCE_NAME, 0);
        this.variantsList = new ArrayList();
    }

    @Override
    @NotNull
    public Emoji getVariant(@NotNull Emoji desiredEmoji) {
        Emoji emoji;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)desiredEmoji, (String)"desiredEmoji");
            if (this.variantsList.isEmpty()) {
                this.initFromSharedPreferences();
            }
            Emoji baseEmoji = desiredEmoji.getBase();
            Iterable $this$firstOrNull$iv = this.variantsList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Emoji it = (Emoji)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBase(), (Object)baseEmoji)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((emoji = (Emoji)v0) == null) {
            emoji = desiredEmoji;
        }
        return emoji;
    }

    @Override
    public void addVariant(@NotNull Emoji newVariant) {
        Intrinsics.checkNotNullParameter((Object)newVariant, (String)"newVariant");
        Emoji newVariantBase = newVariant.getBase();
        int n = this.variantsList.size();
        for (int i = 0; i < n; ++i) {
            Emoji variant = this.variantsList.get(i);
            if (!Intrinsics.areEqual((Object)variant.getBase(), (Object)newVariantBase)) continue;
            if (Intrinsics.areEqual((Object)variant, (Object)newVariant)) {
                return;
            }
            this.variantsList.remove(i);
            this.variantsList.add(newVariant);
            return;
        }
        this.variantsList.add(newVariant);
    }

    @Override
    public void persist() {
        if (this.variantsList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.variantsList.size() * 5);
            int n = this.variantsList.size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.variantsList.get(i).getUnicode()).append(EMOJI_DELIMITER);
            }
            stringBuilder.setLength(stringBuilder.length() - EMOJI_DELIMITER.length());
            this.preferences.edit().putString(VARIANT_EMOJIS, stringBuilder.toString()).apply();
        } else {
            this.preferences.edit().remove(VARIANT_EMOJIS).apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initFromSharedPreferences() {
        String savedRecentVariants;
        String string2 = this.preferences.getString(VARIANT_EMOJIS, "");
        if (string2 == null) {
            string2 = "";
        }
        if (((CharSequence)(savedRecentVariants = string2)).length() > 0) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = new String[]{EMOJI_DELIMITER};
            object = StringsKt.split$default((CharSequence)savedRecentVariants, (String[])object, (boolean)false, (int)0, (int)6, null);
            VariantEmojiManager variantEmojiManager = this;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Emoji it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (EmojiManager.INSTANCE.findEmoji$emoji_release(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            variantEmojiManager.variantsList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/vanniktech/emoji/variant/VariantEmojiManager$Companion;", "", "()V", "EMOJI_DELIMITER", "", "EMOJI_GUESS_SIZE", "", "PREFERENCE_NAME", "VARIANT_EMOJIS", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

