/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.recent;

import android.content.Context;
import android.content.SharedPreferences;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.recent.RecentEmoji;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\u0018\u0000 \u00112\u00020\u0001:\u0003\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager;", "Lcom/vanniktech/emoji/recent/RecentEmoji;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "emojiList", "Lcom/vanniktech/emoji/recent/RecentEmojiManager$EmojiList;", "sharedPreferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "addEmoji", "", "emoji", "Lcom/vanniktech/emoji/Emoji;", "getRecentEmojis", "", "persist", "Companion", "Data", "EmojiList", "emoji_release"})
public final class RecentEmojiManager
implements RecentEmoji {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private EmojiList emojiList;
    private final SharedPreferences sharedPreferences;
    @NotNull
    private static final String PREFERENCE_NAME = "emoji-recent-manager";
    @NotNull
    private static final String TIME_DELIMITER = ";";
    @NotNull
    private static final String EMOJI_DELIMITER = "~";
    @NotNull
    private static final String RECENT_EMOJIS = "recent-emojis";
    public static final int EMOJI_GUESS_SIZE = 5;
    public static final int MAX_RECENTS = 40;

    public RecentEmojiManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.emojiList = new EmojiList(0);
        this.sharedPreferences = context.getApplicationContext().getSharedPreferences(PREFERENCE_NAME, 0);
    }

    @Override
    @NotNull
    public Collection<Emoji> getRecentEmojis() {
        if (this.emojiList.size() == 0) {
            String savedRecentEmojis;
            String string2 = this.sharedPreferences.getString(RECENT_EMOJIS, "");
            if (string2 == null) {
                string2 = "";
            }
            if (((CharSequence)(savedRecentEmojis = string2)).length() > 0) {
                String[] stringArray = new String[]{EMOJI_DELIMITER};
                List split = StringsKt.split$default((CharSequence)savedRecentEmojis, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                this.emojiList = new EmojiList(split.size());
                Iterable $this$forEach$iv = split;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String candidate;
                    Emoji emoji;
                    String[] parts;
                    String it = (String)element$iv;
                    boolean bl = false;
                    String[] stringArray2 = new String[]{TIME_DELIMITER};
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)it, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new String[0]) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    if (parts.length != 2 || (emoji = EmojiManager.INSTANCE.findEmoji$emoji_release(candidate = parts[0])) == null) continue;
                    long timestamp = Long.parseLong(parts[1]);
                    this.emojiList.add(emoji, timestamp);
                }
            } else {
                this.emojiList = new EmojiList(0);
            }
        }
        return this.emojiList.getEmojis();
    }

    @Override
    public void addEmoji(@NotNull Emoji emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        EmojiList.add$default(this.emojiList, emoji, 0L, 2, null);
    }

    @Override
    public void persist() {
        if (this.emojiList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.emojiList.size() * 5);
            int n = this.emojiList.size();
            for (int i = 0; i < n; ++i) {
                Data data = this.emojiList.get(i);
                stringBuilder.append(data.getEmoji().getUnicode()).append(TIME_DELIMITER).append(data.getTimestamp()).append(EMOJI_DELIMITER);
            }
            stringBuilder.setLength(stringBuilder.length() - EMOJI_DELIMITER.length());
            this.sharedPreferences.edit().putString(RECENT_EMOJIS, stringBuilder.toString()).apply();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rJ\u0011\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0003H\u0086\u0002J\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0011J\u0006\u0010\u0002\u001a\u00020\u0003R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager$EmojiList;", "", "size", "", "(I)V", "emojis", "", "Lcom/vanniktech/emoji/recent/RecentEmojiManager$Data;", "add", "", "emoji", "Lcom/vanniktech/emoji/Emoji;", "timestamp", "", "get", "index", "getEmojis", "", "emoji_release"})
    public static final class EmojiList {
        @NotNull
        private final List<Data> emojis;

        public EmojiList(int size) {
            this.emojis = new ArrayList(size);
        }

        public final void add(@NotNull Emoji emoji, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            Iterator<Data> iterator = this.emojis.iterator();
            Emoji emojiBase = emoji.getBase();
            while (iterator.hasNext()) {
                Data data = iterator.next();
                if (!Intrinsics.areEqual((Object)data.getEmoji().getBase(), (Object)emojiBase)) continue;
                iterator.remove();
            }
            this.emojis.add(0, new Data(emoji, timestamp));
            if (this.emojis.size() > 40) {
                this.emojis.remove(40);
            }
        }

        public static /* synthetic */ void add$default(EmojiList emojiList, Emoji emoji, long l, int n, Object object) {
            if ((n & 2) != 0) {
                l = System.currentTimeMillis();
            }
            emojiList.add(emoji, l);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Emoji> getEmojis() {
            void $this$mapTo$iv$iv;
            Iterable $this$sortedByDescending$iv = this.emojis;
            boolean $i$f$sortedByDescending = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Data it = (Data)b;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (Data)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            });
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Data data = (Data)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getEmoji());
            }
            return (List)destination$iv$iv;
        }

        public final int size() {
            return this.emojis.size();
        }

        @NotNull
        public final Data get(int index) {
            return this.emojis.get(index);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager$Data;", "", "emoji", "Lcom/vanniktech/emoji/Emoji;", "timestamp", "", "(Lcom/vanniktech/emoji/Emoji;J)V", "getEmoji", "()Lcom/vanniktech/emoji/Emoji;", "getTimestamp", "()J", "emoji_release"})
    public static final class Data {
        @NotNull
        private final Emoji emoji;
        private final long timestamp;

        public Data(@NotNull Emoji emoji, long timestamp) {
            Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
            this.emoji = emoji;
            this.timestamp = timestamp;
        }

        @NotNull
        public final Emoji getEmoji() {
            return this.emoji;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/vanniktech/emoji/recent/RecentEmojiManager$Companion;", "", "()V", "EMOJI_DELIMITER", "", "EMOJI_GUESS_SIZE", "", "MAX_RECENTS", "PREFERENCE_NAME", "RECENT_EMOJIS", "TIME_DELIMITER", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

