/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Point;
import android.graphics.Rect;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.EditText;
import android.widget.PopupWindow;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.core.content.ContextCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0017J\u0015\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0019J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u0015\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eJ)\u0010\u001f\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010 \u001a\u00020\t2\b\b\u0001\u0010!\u001a\u00020\tH\u0001\u00a2\u0006\u0002\b\"J\u001d\u0010#\u001a\u00020$2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a8\u0006*"}, d2={"Lcom/vanniktech/emoji/internal/Utils;", "", "()V", "asActivity", "Landroid/app/Activity;", "context", "Landroid/content/Context;", "asActivity$emoji_release", "dpToPx", "", "dp", "", "dpToPx$emoji_release", "fixPopupLocation", "", "popupWindow", "Landroid/widget/PopupWindow;", "desiredLocation", "Landroid/graphics/Point;", "fixPopupLocation$emoji_release", "getOrientation", "getProperHeight", "activity", "getProperHeight$emoji_release", "getProperWidth", "getProperWidth$emoji_release", "getScreenWidth", "locationOnScreen", "view", "Landroid/view/View;", "locationOnScreen$emoji_release", "resolveColor", "resource", "fallback", "resolveColor$emoji_release", "shouldOverrideRegularCondition", "", "editText", "Landroid/widget/EditText;", "shouldOverrideRegularCondition$emoji_release", "windowVisibleDisplayFrame", "Landroid/graphics/Rect;", "emoji_release"})
public final class Utils {
    @NotNull
    public static final Utils INSTANCE = new Utils();

    private Utils() {
    }

    public final int dpToPx$emoji_release(@NotNull Context context, float dp) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return MathKt.roundToInt((float)(TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)context.getResources().getDisplayMetrics()) + 0.5f));
    }

    private final int getOrientation(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public final int getProperWidth$emoji_release(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect rect = this.windowVisibleDisplayFrame(activity);
        return this.getOrientation((Context)activity) == 1 ? rect.right : this.getScreenWidth(activity);
    }

    public final boolean shouldOverrideRegularCondition$emoji_release(@NotNull Context context, @NotNull EditText editText) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        return (editText.getImeOptions() & 0x10000000) == 0 ? this.getOrientation(context) == 2 : false;
    }

    public final int getProperHeight$emoji_release(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        return this.windowVisibleDisplayFrame((Activity)activity).bottom;
    }

    private final int getScreenWidth(Activity context) {
        return this.dpToPx$emoji_release((Context)context, context.getResources().getConfiguration().screenWidthDp);
    }

    @NotNull
    public final Point locationOnScreen$emoji_release(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        int[] location = new int[2];
        view.getLocationOnScreen(location);
        return new Point(location[0], location[1]);
    }

    private final Rect windowVisibleDisplayFrame(Activity context) {
        Rect result = new Rect();
        context.getWindow().getDecorView().getWindowVisibleDisplayFrame(result);
        return result;
    }

    @NotNull
    public final Activity asActivity$emoji_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Context result = context;
        while (result instanceof ContextWrapper) {
            if (result instanceof Activity) {
                return (Activity)result;
            }
            result = ((ContextWrapper)result).getBaseContext();
        }
        throw new IllegalStateException("The passed Context is not an Activity.".toString());
    }

    public final void fixPopupLocation$emoji_release(@NotNull PopupWindow popupWindow, @NotNull Point desiredLocation) {
        Intrinsics.checkNotNullParameter((Object)popupWindow, (String)"popupWindow");
        Intrinsics.checkNotNullParameter((Object)desiredLocation, (String)"desiredLocation");
        popupWindow.getContentView().post(() -> Utils.fixPopupLocation$lambda-0(popupWindow, desiredLocation));
    }

    @ColorInt
    public final int resolveColor$emoji_release(@NotNull Context context, @AttrRes int resource, @ColorRes int fallback) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(resource, value, true);
        int resolvedColor = value.resourceId != 0 ? ContextCompat.getColor((Context)context, (int)value.resourceId) : value.data;
        return resolvedColor != 0 ? resolvedColor : ContextCompat.getColor((Context)context, (int)fallback);
    }

    private static final void fixPopupLocation$lambda-0(PopupWindow $popupWindow, Point $desiredLocation) {
        Intrinsics.checkNotNullParameter((Object)$popupWindow, (String)"$popupWindow");
        Intrinsics.checkNotNullParameter((Object)$desiredLocation, (String)"$desiredLocation");
        View view = $popupWindow.getContentView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"popupWindow.contentView");
        Point actualLocation = INSTANCE.locationOnScreen$emoji_release(view);
        if (actualLocation.x != $desiredLocation.x || actualLocation.y != $desiredLocation.y) {
            int differenceX = actualLocation.x - $desiredLocation.x;
            int differenceY = actualLocation.y - $desiredLocation.y;
            int fixedOffsetX = actualLocation.x > $desiredLocation.x ? $desiredLocation.x - differenceX : $desiredLocation.x + differenceX;
            int fixedOffsetY = actualLocation.y > $desiredLocation.y ? $desiredLocation.y - differenceY : $desiredLocation.y + differenceY;
            $popupWindow.update(fixedOffsetX, fixedOffsetY, -1, -1);
        }
    }
}

