/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PorterDuff;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.vanniktech.emoji.EmojiGridView;
import com.vanniktech.emoji.EmojiPagerAdapter;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.emoji.Nature;
import com.vanniktech.emoji.emoji.Objects;
import com.vanniktech.emoji.emoji.People;
import com.vanniktech.emoji.emoji.Places;
import com.vanniktech.emoji.emoji.Symbols;
import com.vanniktech.emoji.listeners.OnEmojiBackspaceClickListener;
import com.vanniktech.emoji.listeners.OnEmojiClickedListener;
import com.vanniktech.emoji.listeners.RepeatListener;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

@SuppressLint(value={"ViewConstructor"})
final class EmojiView
extends FrameLayout
implements ViewPager.OnPageChangeListener {
    private static final int PEOPLE_INDEX = 0;
    private static final int NATURE_INDEX = 1;
    private static final int OBJECTS_INDEX = 2;
    private static final int CARS_INDEX = 3;
    private static final int PUNCTUATION_INDEX = 4;
    private static final long INITIAL_INTERVAL = TimeUnit.SECONDS.toMillis(1L) / 2L;
    private static final int NORMAL_INTERVAL = 50;
    @ColorInt
    private final int themeAccentColor;
    @Nullable
    private OnEmojiBackspaceClickListener onEmojiBackspaceClickListener;
    private int emojiTabLastSelectedIndex = -1;
    private final ImageView[] emojiTabs;

    EmojiView(Context context, OnEmojiClickedListener onEmojiClickedListener) {
        super(context);
        View.inflate((Context)context, (int)R.layout.emoji_view, (ViewGroup)this);
        ViewPager emojisPager = (ViewPager)this.findViewById(R.id.emojis_pager);
        emojisPager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        List<EmojiGridView> views = this.getViews(context, onEmojiClickedListener);
        EmojiPagerAdapter emojisAdapter = new EmojiPagerAdapter(views);
        emojisPager.setAdapter((PagerAdapter)emojisAdapter);
        this.emojiTabs = new ImageView[5];
        this.emojiTabs[0] = (ImageView)this.findViewById(R.id.emojis_tab_0_people);
        this.emojiTabs[1] = (ImageView)this.findViewById(R.id.emojis_tab_1_nature);
        this.emojiTabs[2] = (ImageView)this.findViewById(R.id.emojis_tab_2_objects);
        this.emojiTabs[3] = (ImageView)this.findViewById(R.id.emojis_tab_3_cars);
        this.emojiTabs[4] = (ImageView)this.findViewById(R.id.emojis_tab_4_punctuation);
        this.handleOnClicks(emojisPager);
        this.findViewById(R.id.emojis_backspace).setOnTouchListener((View.OnTouchListener)new RepeatListener(INITIAL_INTERVAL, 50L, new View.OnClickListener(){

            public void onClick(View view) {
                if (EmojiView.this.onEmojiBackspaceClickListener != null) {
                    EmojiView.this.onEmojiBackspaceClickListener.onEmojiBackspaceClicked(view);
                }
            }
        }));
        TypedValue value = new TypedValue();
        context.getTheme().resolveAttribute(R.attr.colorAccent, value, true);
        this.themeAccentColor = value.data;
        emojisPager.setCurrentItem(0);
        this.onPageSelected(0);
    }

    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"}, justification="Do not care in this one")
    private void handleOnClicks(final ViewPager emojisPager) {
        for (int i = 0; i < this.emojiTabs.length; ++i) {
            final int position = i;
            this.emojiTabs[i].setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    emojisPager.setCurrentItem(position);
                }
            });
        }
    }

    public void setOnEmojiBackspaceClickListener(@Nullable OnEmojiBackspaceClickListener onEmojiBackspaceClickListener) {
        this.onEmojiBackspaceClickListener = onEmojiBackspaceClickListener;
    }

    @NonNull
    private List<EmojiGridView> getViews(Context context, @Nullable OnEmojiClickedListener onEmojiClickedListener) {
        EmojiGridView peopleGridView = new EmojiGridView(context).init(People.DATA, onEmojiClickedListener);
        EmojiGridView natureGridView = new EmojiGridView(context).init(Nature.DATA, onEmojiClickedListener);
        EmojiGridView objectsGridView = new EmojiGridView(context).init(Objects.DATA, onEmojiClickedListener);
        EmojiGridView lacesGridView = new EmojiGridView(context).init(Places.DATA, onEmojiClickedListener);
        EmojiGridView symbolsGridView = new EmojiGridView(context).init(Symbols.DATA, onEmojiClickedListener);
        return Arrays.asList(peopleGridView, natureGridView, objectsGridView, lacesGridView, symbolsGridView);
    }

    public void onPageSelected(int i) {
        if (this.emojiTabLastSelectedIndex != i) {
            switch (i) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    if (this.emojiTabLastSelectedIndex >= 0 && this.emojiTabLastSelectedIndex < this.emojiTabs.length) {
                        this.emojiTabs[this.emojiTabLastSelectedIndex].setSelected(false);
                        this.emojiTabs[this.emojiTabLastSelectedIndex].clearColorFilter();
                    }
                    this.emojiTabs[i].setSelected(true);
                    this.emojiTabs[i].setColorFilter(this.themeAccentColor, PorterDuff.Mode.SRC_IN);
                    this.emojiTabLastSelectedIndex = i;
                    break;
                }
            }
        }
    }

    public void onPageScrolled(int i, float v, int i2) {
    }

    public void onPageScrollStateChanged(int i) {
    }
}

