/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.text.Spannable;
import android.util.SparseIntArray;
import com.vanniktech.emoji.EmojiSpan;
import com.vanniktech.emoji.R;

final class EmojiHandler {
    private static final SparseIntArray EMOJIS_MAP = new SparseIntArray(846);
    private static final SparseIntArray SOFTBANKS_MAP = new SparseIntArray(471);

    private static boolean isSoftBankEmoji(char c) {
        return c >> 12 == 14;
    }

    private static int getEmojiResource(int codePoint) {
        return EMOJIS_MAP.get(codePoint);
    }

    private static int getSoftbankEmojiResource(char c) {
        return SOFTBANKS_MAP.get((int)c);
    }

    public static void addEmojis(Context context, Spannable text, int emojiSize) {
        int skip;
        int length = text.length();
        EmojiSpan[] oldSpans = (EmojiSpan[])text.getSpans(0, length, EmojiSpan.class);
        for (int i = 0; i < oldSpans.length; ++i) {
            text.removeSpan((Object)oldSpans[i]);
        }
        for (int i = 0; i < length; i += skip) {
            skip = 0;
            int icon = 0;
            char c = text.charAt(i);
            if (EmojiHandler.isSoftBankEmoji(c)) {
                icon = EmojiHandler.getSoftbankEmojiResource(c);
                int n = skip = icon == 0 ? 0 : 1;
            }
            if (icon == 0) {
                int unicode = Character.codePointAt((CharSequence)text, i);
                skip = Character.charCount(unicode);
                if (unicode > 255) {
                    icon = EmojiHandler.getEmojiResource(unicode);
                }
                if (icon == 0 && i + skip < length) {
                    int followSkip;
                    int followUnicode = Character.codePointAt((CharSequence)text, i + skip);
                    if (followUnicode == 8419) {
                        followSkip = Character.charCount(followUnicode);
                        switch (unicode) {
                            case 49: {
                                icon = R.drawable.emoji_0031;
                                break;
                            }
                            case 50: {
                                icon = R.drawable.emoji_0032;
                                break;
                            }
                            case 51: {
                                icon = R.drawable.emoji_0033;
                                break;
                            }
                            case 52: {
                                icon = R.drawable.emoji_0034;
                                break;
                            }
                            case 53: {
                                icon = R.drawable.emoji_0035;
                                break;
                            }
                            case 54: {
                                icon = R.drawable.emoji_0036;
                                break;
                            }
                            case 55: {
                                icon = R.drawable.emoji_0037;
                                break;
                            }
                            case 56: {
                                icon = R.drawable.emoji_0038;
                                break;
                            }
                            case 57: {
                                icon = R.drawable.emoji_0039;
                                break;
                            }
                            case 48: {
                                icon = R.drawable.emoji_0030;
                                break;
                            }
                            case 35: {
                                icon = R.drawable.emoji_0023;
                                break;
                            }
                            default: {
                                followSkip = 0;
                            }
                        }
                        skip += followSkip;
                    } else {
                        followSkip = Character.charCount(followUnicode);
                        switch (unicode) {
                            case 127471: {
                                icon = followUnicode == 127477 ? R.drawable.emoji_1f1ef_1f1f5 : 0;
                                break;
                            }
                            case 127482: {
                                icon = followUnicode == 127480 ? R.drawable.emoji_1f1fa_1f1f8 : 0;
                                break;
                            }
                            case 127467: {
                                icon = followUnicode == 127479 ? R.drawable.emoji_1f1eb_1f1f7 : 0;
                                break;
                            }
                            case 127465: {
                                icon = followUnicode == 127466 ? R.drawable.emoji_1f1e9_1f1ea : 0;
                                break;
                            }
                            case 127470: {
                                icon = followUnicode == 127481 ? R.drawable.emoji_1f1ee_1f1f9 : 0;
                                break;
                            }
                            case 127468: {
                                icon = followUnicode == 127463 ? R.drawable.emoji_1f1ec_1f1e7 : 0;
                                break;
                            }
                            case 127466: {
                                icon = followUnicode == 127480 ? R.drawable.emoji_1f1ea_1f1f8 : 0;
                                break;
                            }
                            case 127479: {
                                icon = followUnicode == 127482 ? R.drawable.emoji_1f1f7_1f1fa : 0;
                                break;
                            }
                            case 127464: {
                                icon = followUnicode == 127475 ? R.drawable.emoji_1f1e8_1f1f3 : 0;
                                break;
                            }
                            case 127472: {
                                icon = followUnicode == 127479 ? R.drawable.emoji_1f1f0_1f1f7 : 0;
                                break;
                            }
                            default: {
                                followSkip = 0;
                            }
                        }
                        skip += followSkip;
                    }
                }
            }
            if (icon <= 0) continue;
            text.setSpan((Object)new EmojiSpan(context, icon, emojiSize), i, i + skip, 33);
        }
    }

    private EmojiHandler() {
        throw new AssertionError((Object)"No instances.");
    }

    static {
        EMOJIS_MAP.put(128516, R.drawable.emoji_1f604);
        EMOJIS_MAP.put(128515, R.drawable.emoji_1f603);
        EMOJIS_MAP.put(128512, R.drawable.emoji_1f600);
        EMOJIS_MAP.put(128522, R.drawable.emoji_1f60a);
        EMOJIS_MAP.put(9786, R.drawable.emoji_263a);
        EMOJIS_MAP.put(128521, R.drawable.emoji_1f609);
        EMOJIS_MAP.put(128525, R.drawable.emoji_1f60d);
        EMOJIS_MAP.put(128536, R.drawable.emoji_1f618);
        EMOJIS_MAP.put(128538, R.drawable.emoji_1f61a);
        EMOJIS_MAP.put(128535, R.drawable.emoji_1f617);
        EMOJIS_MAP.put(128537, R.drawable.emoji_1f619);
        EMOJIS_MAP.put(128540, R.drawable.emoji_1f61c);
        EMOJIS_MAP.put(128541, R.drawable.emoji_1f61d);
        EMOJIS_MAP.put(128539, R.drawable.emoji_1f61b);
        EMOJIS_MAP.put(128563, R.drawable.emoji_1f633);
        EMOJIS_MAP.put(128513, R.drawable.emoji_1f601);
        EMOJIS_MAP.put(128532, R.drawable.emoji_1f614);
        EMOJIS_MAP.put(128524, R.drawable.emoji_1f60c);
        EMOJIS_MAP.put(128530, R.drawable.emoji_1f612);
        EMOJIS_MAP.put(128542, R.drawable.emoji_1f61e);
        EMOJIS_MAP.put(128547, R.drawable.emoji_1f623);
        EMOJIS_MAP.put(128546, R.drawable.emoji_1f622);
        EMOJIS_MAP.put(128514, R.drawable.emoji_1f602);
        EMOJIS_MAP.put(128557, R.drawable.emoji_1f62d);
        EMOJIS_MAP.put(128554, R.drawable.emoji_1f62a);
        EMOJIS_MAP.put(128549, R.drawable.emoji_1f625);
        EMOJIS_MAP.put(128560, R.drawable.emoji_1f630);
        EMOJIS_MAP.put(128517, R.drawable.emoji_1f605);
        EMOJIS_MAP.put(128531, R.drawable.emoji_1f613);
        EMOJIS_MAP.put(128553, R.drawable.emoji_1f629);
        EMOJIS_MAP.put(128555, R.drawable.emoji_1f62b);
        EMOJIS_MAP.put(128552, R.drawable.emoji_1f628);
        EMOJIS_MAP.put(128561, R.drawable.emoji_1f631);
        EMOJIS_MAP.put(128544, R.drawable.emoji_1f620);
        EMOJIS_MAP.put(128545, R.drawable.emoji_1f621);
        EMOJIS_MAP.put(128548, R.drawable.emoji_1f624);
        EMOJIS_MAP.put(128534, R.drawable.emoji_1f616);
        EMOJIS_MAP.put(128518, R.drawable.emoji_1f606);
        EMOJIS_MAP.put(128523, R.drawable.emoji_1f60b);
        EMOJIS_MAP.put(128567, R.drawable.emoji_1f637);
        EMOJIS_MAP.put(128526, R.drawable.emoji_1f60e);
        EMOJIS_MAP.put(128564, R.drawable.emoji_1f634);
        EMOJIS_MAP.put(128565, R.drawable.emoji_1f635);
        EMOJIS_MAP.put(128562, R.drawable.emoji_1f632);
        EMOJIS_MAP.put(128543, R.drawable.emoji_1f61f);
        EMOJIS_MAP.put(128550, R.drawable.emoji_1f626);
        EMOJIS_MAP.put(128551, R.drawable.emoji_1f627);
        EMOJIS_MAP.put(128520, R.drawable.emoji_1f608);
        EMOJIS_MAP.put(128127, R.drawable.emoji_1f47f);
        EMOJIS_MAP.put(128558, R.drawable.emoji_1f62e);
        EMOJIS_MAP.put(128556, R.drawable.emoji_1f62c);
        EMOJIS_MAP.put(128528, R.drawable.emoji_1f610);
        EMOJIS_MAP.put(128533, R.drawable.emoji_1f615);
        EMOJIS_MAP.put(128559, R.drawable.emoji_1f62f);
        EMOJIS_MAP.put(128566, R.drawable.emoji_1f636);
        EMOJIS_MAP.put(128519, R.drawable.emoji_1f607);
        EMOJIS_MAP.put(128527, R.drawable.emoji_1f60f);
        EMOJIS_MAP.put(128529, R.drawable.emoji_1f611);
        EMOJIS_MAP.put(128114, R.drawable.emoji_1f472);
        EMOJIS_MAP.put(128115, R.drawable.emoji_1f473);
        EMOJIS_MAP.put(128110, R.drawable.emoji_1f46e);
        EMOJIS_MAP.put(128119, R.drawable.emoji_1f477);
        EMOJIS_MAP.put(128130, R.drawable.emoji_1f482);
        EMOJIS_MAP.put(128118, R.drawable.emoji_1f476);
        EMOJIS_MAP.put(128102, R.drawable.emoji_1f466);
        EMOJIS_MAP.put(128103, R.drawable.emoji_1f467);
        EMOJIS_MAP.put(128104, R.drawable.emoji_1f468);
        EMOJIS_MAP.put(128105, R.drawable.emoji_1f469);
        EMOJIS_MAP.put(128116, R.drawable.emoji_1f474);
        EMOJIS_MAP.put(128117, R.drawable.emoji_1f475);
        EMOJIS_MAP.put(128113, R.drawable.emoji_1f471);
        EMOJIS_MAP.put(128124, R.drawable.emoji_1f47c);
        EMOJIS_MAP.put(128120, R.drawable.emoji_1f478);
        EMOJIS_MAP.put(128570, R.drawable.emoji_1f63a);
        EMOJIS_MAP.put(128568, R.drawable.emoji_1f638);
        EMOJIS_MAP.put(128571, R.drawable.emoji_1f63b);
        EMOJIS_MAP.put(128573, R.drawable.emoji_1f63d);
        EMOJIS_MAP.put(128572, R.drawable.emoji_1f63c);
        EMOJIS_MAP.put(128576, R.drawable.emoji_1f640);
        EMOJIS_MAP.put(128575, R.drawable.emoji_1f63f);
        EMOJIS_MAP.put(128569, R.drawable.emoji_1f639);
        EMOJIS_MAP.put(128574, R.drawable.emoji_1f63e);
        EMOJIS_MAP.put(128121, R.drawable.emoji_1f479);
        EMOJIS_MAP.put(128122, R.drawable.emoji_1f47a);
        EMOJIS_MAP.put(128584, R.drawable.emoji_1f648);
        EMOJIS_MAP.put(128585, R.drawable.emoji_1f649);
        EMOJIS_MAP.put(128586, R.drawable.emoji_1f64a);
        EMOJIS_MAP.put(128128, R.drawable.emoji_1f480);
        EMOJIS_MAP.put(128125, R.drawable.emoji_1f47d);
        EMOJIS_MAP.put(128169, R.drawable.emoji_1f4a9);
        EMOJIS_MAP.put(128293, R.drawable.emoji_1f525);
        EMOJIS_MAP.put(10024, R.drawable.emoji_2728);
        EMOJIS_MAP.put(127775, R.drawable.emoji_1f31f);
        EMOJIS_MAP.put(128171, R.drawable.emoji_1f4ab);
        EMOJIS_MAP.put(128165, R.drawable.emoji_1f4a5);
        EMOJIS_MAP.put(128162, R.drawable.emoji_1f4a2);
        EMOJIS_MAP.put(128166, R.drawable.emoji_1f4a6);
        EMOJIS_MAP.put(128167, R.drawable.emoji_1f4a7);
        EMOJIS_MAP.put(128164, R.drawable.emoji_1f4a4);
        EMOJIS_MAP.put(128168, R.drawable.emoji_1f4a8);
        EMOJIS_MAP.put(128066, R.drawable.emoji_1f442);
        EMOJIS_MAP.put(128064, R.drawable.emoji_1f440);
        EMOJIS_MAP.put(128067, R.drawable.emoji_1f443);
        EMOJIS_MAP.put(128069, R.drawable.emoji_1f445);
        EMOJIS_MAP.put(128068, R.drawable.emoji_1f444);
        EMOJIS_MAP.put(128077, R.drawable.emoji_1f44d);
        EMOJIS_MAP.put(128078, R.drawable.emoji_1f44e);
        EMOJIS_MAP.put(128076, R.drawable.emoji_1f44c);
        EMOJIS_MAP.put(128074, R.drawable.emoji_1f44a);
        EMOJIS_MAP.put(9994, R.drawable.emoji_270a);
        EMOJIS_MAP.put(9996, R.drawable.emoji_270c);
        EMOJIS_MAP.put(128075, R.drawable.emoji_1f44b);
        EMOJIS_MAP.put(9995, R.drawable.emoji_270b);
        EMOJIS_MAP.put(128080, R.drawable.emoji_1f450);
        EMOJIS_MAP.put(128070, R.drawable.emoji_1f446);
        EMOJIS_MAP.put(128071, R.drawable.emoji_1f447);
        EMOJIS_MAP.put(128073, R.drawable.emoji_1f449);
        EMOJIS_MAP.put(128072, R.drawable.emoji_1f448);
        EMOJIS_MAP.put(128588, R.drawable.emoji_1f64c);
        EMOJIS_MAP.put(128591, R.drawable.emoji_1f64f);
        EMOJIS_MAP.put(9757, R.drawable.emoji_261d);
        EMOJIS_MAP.put(128079, R.drawable.emoji_1f44f);
        EMOJIS_MAP.put(128170, R.drawable.emoji_1f4aa);
        EMOJIS_MAP.put(128694, R.drawable.emoji_1f6b6);
        EMOJIS_MAP.put(127939, R.drawable.emoji_1f3c3);
        EMOJIS_MAP.put(128131, R.drawable.emoji_1f483);
        EMOJIS_MAP.put(128107, R.drawable.emoji_1f46b);
        EMOJIS_MAP.put(128106, R.drawable.emoji_1f46a);
        EMOJIS_MAP.put(128108, R.drawable.emoji_1f46c);
        EMOJIS_MAP.put(128109, R.drawable.emoji_1f46d);
        EMOJIS_MAP.put(128143, R.drawable.emoji_1f48f);
        EMOJIS_MAP.put(128145, R.drawable.emoji_1f491);
        EMOJIS_MAP.put(128111, R.drawable.emoji_1f46f);
        EMOJIS_MAP.put(128582, R.drawable.emoji_1f646);
        EMOJIS_MAP.put(128581, R.drawable.emoji_1f645);
        EMOJIS_MAP.put(128129, R.drawable.emoji_1f481);
        EMOJIS_MAP.put(128587, R.drawable.emoji_1f64b);
        EMOJIS_MAP.put(128134, R.drawable.emoji_1f486);
        EMOJIS_MAP.put(128135, R.drawable.emoji_1f487);
        EMOJIS_MAP.put(128133, R.drawable.emoji_1f485);
        EMOJIS_MAP.put(128112, R.drawable.emoji_1f470);
        EMOJIS_MAP.put(128590, R.drawable.emoji_1f64e);
        EMOJIS_MAP.put(128589, R.drawable.emoji_1f64d);
        EMOJIS_MAP.put(128583, R.drawable.emoji_1f647);
        EMOJIS_MAP.put(127913, R.drawable.emoji_1f3a9);
        EMOJIS_MAP.put(128081, R.drawable.emoji_1f451);
        EMOJIS_MAP.put(128082, R.drawable.emoji_1f452);
        EMOJIS_MAP.put(128095, R.drawable.emoji_1f45f);
        EMOJIS_MAP.put(128094, R.drawable.emoji_1f45e);
        EMOJIS_MAP.put(128097, R.drawable.emoji_1f461);
        EMOJIS_MAP.put(128096, R.drawable.emoji_1f460);
        EMOJIS_MAP.put(128098, R.drawable.emoji_1f462);
        EMOJIS_MAP.put(128085, R.drawable.emoji_1f455);
        EMOJIS_MAP.put(128084, R.drawable.emoji_1f454);
        EMOJIS_MAP.put(128090, R.drawable.emoji_1f45a);
        EMOJIS_MAP.put(128087, R.drawable.emoji_1f457);
        EMOJIS_MAP.put(127933, R.drawable.emoji_1f3bd);
        EMOJIS_MAP.put(128086, R.drawable.emoji_1f456);
        EMOJIS_MAP.put(128088, R.drawable.emoji_1f458);
        EMOJIS_MAP.put(128089, R.drawable.emoji_1f459);
        EMOJIS_MAP.put(128188, R.drawable.emoji_1f4bc);
        EMOJIS_MAP.put(128092, R.drawable.emoji_1f45c);
        EMOJIS_MAP.put(128093, R.drawable.emoji_1f45d);
        EMOJIS_MAP.put(128091, R.drawable.emoji_1f45b);
        EMOJIS_MAP.put(128083, R.drawable.emoji_1f453);
        EMOJIS_MAP.put(127872, R.drawable.emoji_1f380);
        EMOJIS_MAP.put(127746, R.drawable.emoji_1f302);
        EMOJIS_MAP.put(128132, R.drawable.emoji_1f484);
        EMOJIS_MAP.put(128155, R.drawable.emoji_1f49b);
        EMOJIS_MAP.put(128153, R.drawable.emoji_1f499);
        EMOJIS_MAP.put(128156, R.drawable.emoji_1f49c);
        EMOJIS_MAP.put(128154, R.drawable.emoji_1f49a);
        EMOJIS_MAP.put(10084, R.drawable.emoji_2764);
        EMOJIS_MAP.put(128148, R.drawable.emoji_1f494);
        EMOJIS_MAP.put(128151, R.drawable.emoji_1f497);
        EMOJIS_MAP.put(128147, R.drawable.emoji_1f493);
        EMOJIS_MAP.put(128149, R.drawable.emoji_1f495);
        EMOJIS_MAP.put(128150, R.drawable.emoji_1f496);
        EMOJIS_MAP.put(128158, R.drawable.emoji_1f49e);
        EMOJIS_MAP.put(128152, R.drawable.emoji_1f498);
        EMOJIS_MAP.put(128140, R.drawable.emoji_1f48c);
        EMOJIS_MAP.put(128139, R.drawable.emoji_1f48b);
        EMOJIS_MAP.put(128141, R.drawable.emoji_1f48d);
        EMOJIS_MAP.put(128142, R.drawable.emoji_1f48e);
        EMOJIS_MAP.put(128100, R.drawable.emoji_1f464);
        EMOJIS_MAP.put(128101, R.drawable.emoji_1f465);
        EMOJIS_MAP.put(128172, R.drawable.emoji_1f4ac);
        EMOJIS_MAP.put(128099, R.drawable.emoji_1f463);
        EMOJIS_MAP.put(128173, R.drawable.emoji_1f4ad);
        EMOJIS_MAP.put(128054, R.drawable.emoji_1f436);
        EMOJIS_MAP.put(128058, R.drawable.emoji_1f43a);
        EMOJIS_MAP.put(128049, R.drawable.emoji_1f431);
        EMOJIS_MAP.put(128045, R.drawable.emoji_1f42d);
        EMOJIS_MAP.put(128057, R.drawable.emoji_1f439);
        EMOJIS_MAP.put(128048, R.drawable.emoji_1f430);
        EMOJIS_MAP.put(128056, R.drawable.emoji_1f438);
        EMOJIS_MAP.put(128047, R.drawable.emoji_1f42f);
        EMOJIS_MAP.put(128040, R.drawable.emoji_1f428);
        EMOJIS_MAP.put(128059, R.drawable.emoji_1f43b);
        EMOJIS_MAP.put(128055, R.drawable.emoji_1f437);
        EMOJIS_MAP.put(128061, R.drawable.emoji_1f43d);
        EMOJIS_MAP.put(128046, R.drawable.emoji_1f42e);
        EMOJIS_MAP.put(128023, R.drawable.emoji_1f417);
        EMOJIS_MAP.put(128053, R.drawable.emoji_1f435);
        EMOJIS_MAP.put(128018, R.drawable.emoji_1f412);
        EMOJIS_MAP.put(128052, R.drawable.emoji_1f434);
        EMOJIS_MAP.put(128017, R.drawable.emoji_1f411);
        EMOJIS_MAP.put(128024, R.drawable.emoji_1f418);
        EMOJIS_MAP.put(128060, R.drawable.emoji_1f43c);
        EMOJIS_MAP.put(128039, R.drawable.emoji_1f427);
        EMOJIS_MAP.put(128038, R.drawable.emoji_1f426);
        EMOJIS_MAP.put(128036, R.drawable.emoji_1f424);
        EMOJIS_MAP.put(128037, R.drawable.emoji_1f425);
        EMOJIS_MAP.put(128035, R.drawable.emoji_1f423);
        EMOJIS_MAP.put(128020, R.drawable.emoji_1f414);
        EMOJIS_MAP.put(128013, R.drawable.emoji_1f40d);
        EMOJIS_MAP.put(128034, R.drawable.emoji_1f422);
        EMOJIS_MAP.put(128027, R.drawable.emoji_1f41b);
        EMOJIS_MAP.put(128029, R.drawable.emoji_1f41d);
        EMOJIS_MAP.put(128028, R.drawable.emoji_1f41c);
        EMOJIS_MAP.put(128030, R.drawable.emoji_1f41e);
        EMOJIS_MAP.put(128012, R.drawable.emoji_1f40c);
        EMOJIS_MAP.put(128025, R.drawable.emoji_1f419);
        EMOJIS_MAP.put(128026, R.drawable.emoji_1f41a);
        EMOJIS_MAP.put(128032, R.drawable.emoji_1f420);
        EMOJIS_MAP.put(128031, R.drawable.emoji_1f41f);
        EMOJIS_MAP.put(128044, R.drawable.emoji_1f42c);
        EMOJIS_MAP.put(128051, R.drawable.emoji_1f433);
        EMOJIS_MAP.put(128011, R.drawable.emoji_1f40b);
        EMOJIS_MAP.put(128004, R.drawable.emoji_1f404);
        EMOJIS_MAP.put(128015, R.drawable.emoji_1f40f);
        EMOJIS_MAP.put(128000, R.drawable.emoji_1f400);
        EMOJIS_MAP.put(128003, R.drawable.emoji_1f403);
        EMOJIS_MAP.put(128005, R.drawable.emoji_1f405);
        EMOJIS_MAP.put(128007, R.drawable.emoji_1f407);
        EMOJIS_MAP.put(128009, R.drawable.emoji_1f409);
        EMOJIS_MAP.put(128014, R.drawable.emoji_1f40e);
        EMOJIS_MAP.put(128016, R.drawable.emoji_1f410);
        EMOJIS_MAP.put(128019, R.drawable.emoji_1f413);
        EMOJIS_MAP.put(128021, R.drawable.emoji_1f415);
        EMOJIS_MAP.put(128022, R.drawable.emoji_1f416);
        EMOJIS_MAP.put(128001, R.drawable.emoji_1f401);
        EMOJIS_MAP.put(128002, R.drawable.emoji_1f402);
        EMOJIS_MAP.put(128050, R.drawable.emoji_1f432);
        EMOJIS_MAP.put(128033, R.drawable.emoji_1f421);
        EMOJIS_MAP.put(128010, R.drawable.emoji_1f40a);
        EMOJIS_MAP.put(128043, R.drawable.emoji_1f42b);
        EMOJIS_MAP.put(128042, R.drawable.emoji_1f42a);
        EMOJIS_MAP.put(128006, R.drawable.emoji_1f406);
        EMOJIS_MAP.put(128008, R.drawable.emoji_1f408);
        EMOJIS_MAP.put(128041, R.drawable.emoji_1f429);
        EMOJIS_MAP.put(128062, R.drawable.emoji_1f43e);
        EMOJIS_MAP.put(128144, R.drawable.emoji_1f490);
        EMOJIS_MAP.put(127800, R.drawable.emoji_1f338);
        EMOJIS_MAP.put(127799, R.drawable.emoji_1f337);
        EMOJIS_MAP.put(127808, R.drawable.emoji_1f340);
        EMOJIS_MAP.put(127801, R.drawable.emoji_1f339);
        EMOJIS_MAP.put(127803, R.drawable.emoji_1f33b);
        EMOJIS_MAP.put(127802, R.drawable.emoji_1f33a);
        EMOJIS_MAP.put(127809, R.drawable.emoji_1f341);
        EMOJIS_MAP.put(127811, R.drawable.emoji_1f343);
        EMOJIS_MAP.put(127810, R.drawable.emoji_1f342);
        EMOJIS_MAP.put(127807, R.drawable.emoji_1f33f);
        EMOJIS_MAP.put(127806, R.drawable.emoji_1f33e);
        EMOJIS_MAP.put(127812, R.drawable.emoji_1f344);
        EMOJIS_MAP.put(127797, R.drawable.emoji_1f335);
        EMOJIS_MAP.put(127796, R.drawable.emoji_1f334);
        EMOJIS_MAP.put(127794, R.drawable.emoji_1f332);
        EMOJIS_MAP.put(127795, R.drawable.emoji_1f333);
        EMOJIS_MAP.put(127792, R.drawable.emoji_1f330);
        EMOJIS_MAP.put(127793, R.drawable.emoji_1f331);
        EMOJIS_MAP.put(127804, R.drawable.emoji_1f33c);
        EMOJIS_MAP.put(127760, R.drawable.emoji_1f310);
        EMOJIS_MAP.put(127774, R.drawable.emoji_1f31e);
        EMOJIS_MAP.put(127773, R.drawable.emoji_1f31d);
        EMOJIS_MAP.put(127770, R.drawable.emoji_1f31a);
        EMOJIS_MAP.put(127761, R.drawable.emoji_1f311);
        EMOJIS_MAP.put(127762, R.drawable.emoji_1f312);
        EMOJIS_MAP.put(127763, R.drawable.emoji_1f313);
        EMOJIS_MAP.put(127764, R.drawable.emoji_1f314);
        EMOJIS_MAP.put(127765, R.drawable.emoji_1f315);
        EMOJIS_MAP.put(127766, R.drawable.emoji_1f316);
        EMOJIS_MAP.put(127767, R.drawable.emoji_1f317);
        EMOJIS_MAP.put(127768, R.drawable.emoji_1f318);
        EMOJIS_MAP.put(127772, R.drawable.emoji_1f31c);
        EMOJIS_MAP.put(127771, R.drawable.emoji_1f31b);
        EMOJIS_MAP.put(127769, R.drawable.emoji_1f319);
        EMOJIS_MAP.put(127757, R.drawable.emoji_1f30d);
        EMOJIS_MAP.put(127758, R.drawable.emoji_1f30e);
        EMOJIS_MAP.put(127759, R.drawable.emoji_1f30f);
        EMOJIS_MAP.put(127755, R.drawable.emoji_1f30b);
        EMOJIS_MAP.put(127756, R.drawable.emoji_1f30c);
        EMOJIS_MAP.put(127776, R.drawable.emoji_1f303);
        EMOJIS_MAP.put(11088, R.drawable.emoji_2b50);
        EMOJIS_MAP.put(9728, R.drawable.emoji_2600);
        EMOJIS_MAP.put(9925, R.drawable.emoji_26c5);
        EMOJIS_MAP.put(9729, R.drawable.emoji_2601);
        EMOJIS_MAP.put(9889, R.drawable.emoji_26a1);
        EMOJIS_MAP.put(9748, R.drawable.emoji_2614);
        EMOJIS_MAP.put(10052, R.drawable.emoji_2744);
        EMOJIS_MAP.put(9924, R.drawable.emoji_26c4);
        EMOJIS_MAP.put(127744, R.drawable.emoji_1f300);
        EMOJIS_MAP.put(127745, R.drawable.emoji_1f301);
        EMOJIS_MAP.put(127752, R.drawable.emoji_1f308);
        EMOJIS_MAP.put(127754, R.drawable.emoji_1f30a);
        EMOJIS_MAP.put(127885, R.drawable.emoji_1f38d);
        EMOJIS_MAP.put(128157, R.drawable.emoji_1f49d);
        EMOJIS_MAP.put(127886, R.drawable.emoji_1f38e);
        EMOJIS_MAP.put(127890, R.drawable.emoji_1f392);
        EMOJIS_MAP.put(127891, R.drawable.emoji_1f393);
        EMOJIS_MAP.put(127887, R.drawable.emoji_1f38f);
        EMOJIS_MAP.put(127878, R.drawable.emoji_1f386);
        EMOJIS_MAP.put(127879, R.drawable.emoji_1f387);
        EMOJIS_MAP.put(127888, R.drawable.emoji_1f390);
        EMOJIS_MAP.put(127889, R.drawable.emoji_1f391);
        EMOJIS_MAP.put(127875, R.drawable.emoji_1f383);
        EMOJIS_MAP.put(128123, R.drawable.emoji_1f47b);
        EMOJIS_MAP.put(127877, R.drawable.emoji_1f385);
        EMOJIS_MAP.put(127876, R.drawable.emoji_1f384);
        EMOJIS_MAP.put(127873, R.drawable.emoji_1f381);
        EMOJIS_MAP.put(127883, R.drawable.emoji_1f38b);
        EMOJIS_MAP.put(127881, R.drawable.emoji_1f389);
        EMOJIS_MAP.put(127882, R.drawable.emoji_1f38a);
        EMOJIS_MAP.put(127880, R.drawable.emoji_1f388);
        EMOJIS_MAP.put(127884, R.drawable.emoji_1f38c);
        EMOJIS_MAP.put(128302, R.drawable.emoji_1f52e);
        EMOJIS_MAP.put(127909, R.drawable.emoji_1f3a5);
        EMOJIS_MAP.put(128247, R.drawable.emoji_1f4f7);
        EMOJIS_MAP.put(128249, R.drawable.emoji_1f4f9);
        EMOJIS_MAP.put(128252, R.drawable.emoji_1f4fc);
        EMOJIS_MAP.put(128191, R.drawable.emoji_1f4bf);
        EMOJIS_MAP.put(128192, R.drawable.emoji_1f4c0);
        EMOJIS_MAP.put(128189, R.drawable.emoji_1f4bd);
        EMOJIS_MAP.put(128190, R.drawable.emoji_1f4be);
        EMOJIS_MAP.put(128187, R.drawable.emoji_1f4bb);
        EMOJIS_MAP.put(128241, R.drawable.emoji_1f4f1);
        EMOJIS_MAP.put(9742, R.drawable.emoji_260e);
        EMOJIS_MAP.put(128222, R.drawable.emoji_1f4de);
        EMOJIS_MAP.put(128223, R.drawable.emoji_1f4df);
        EMOJIS_MAP.put(128224, R.drawable.emoji_1f4e0);
        EMOJIS_MAP.put(128225, R.drawable.emoji_1f4e1);
        EMOJIS_MAP.put(128250, R.drawable.emoji_1f4fa);
        EMOJIS_MAP.put(128251, R.drawable.emoji_1f4fb);
        EMOJIS_MAP.put(128266, R.drawable.emoji_1f50a);
        EMOJIS_MAP.put(128265, R.drawable.emoji_1f509);
        EMOJIS_MAP.put(128264, R.drawable.emoji_1f508);
        EMOJIS_MAP.put(128263, R.drawable.emoji_1f507);
        EMOJIS_MAP.put(128276, R.drawable.emoji_1f514);
        EMOJIS_MAP.put(128277, R.drawable.emoji_1f515);
        EMOJIS_MAP.put(128226, R.drawable.emoji_1f4e2);
        EMOJIS_MAP.put(128227, R.drawable.emoji_1f4e3);
        EMOJIS_MAP.put(9203, R.drawable.emoji_23f3);
        EMOJIS_MAP.put(8987, R.drawable.emoji_231b);
        EMOJIS_MAP.put(9200, R.drawable.emoji_23f0);
        EMOJIS_MAP.put(8986, R.drawable.emoji_231a);
        EMOJIS_MAP.put(128275, R.drawable.emoji_1f513);
        EMOJIS_MAP.put(128274, R.drawable.emoji_1f512);
        EMOJIS_MAP.put(128271, R.drawable.emoji_1f50f);
        EMOJIS_MAP.put(128272, R.drawable.emoji_1f510);
        EMOJIS_MAP.put(128273, R.drawable.emoji_1f511);
        EMOJIS_MAP.put(128270, R.drawable.emoji_1f50e);
        EMOJIS_MAP.put(128161, R.drawable.emoji_1f4a1);
        EMOJIS_MAP.put(128294, R.drawable.emoji_1f526);
        EMOJIS_MAP.put(128262, R.drawable.emoji_1f506);
        EMOJIS_MAP.put(128261, R.drawable.emoji_1f505);
        EMOJIS_MAP.put(128268, R.drawable.emoji_1f50c);
        EMOJIS_MAP.put(128267, R.drawable.emoji_1f50b);
        EMOJIS_MAP.put(128269, R.drawable.emoji_1f50d);
        EMOJIS_MAP.put(128705, R.drawable.emoji_1f6c1);
        EMOJIS_MAP.put(128704, R.drawable.emoji_1f6c0);
        EMOJIS_MAP.put(128703, R.drawable.emoji_1f6bf);
        EMOJIS_MAP.put(128701, R.drawable.emoji_1f6bd);
        EMOJIS_MAP.put(128295, R.drawable.emoji_1f527);
        EMOJIS_MAP.put(128297, R.drawable.emoji_1f529);
        EMOJIS_MAP.put(128296, R.drawable.emoji_1f528);
        EMOJIS_MAP.put(128682, R.drawable.emoji_1f6aa);
        EMOJIS_MAP.put(128684, R.drawable.emoji_1f6ac);
        EMOJIS_MAP.put(128163, R.drawable.emoji_1f4a3);
        EMOJIS_MAP.put(128299, R.drawable.emoji_1f52b);
        EMOJIS_MAP.put(128298, R.drawable.emoji_1f52a);
        EMOJIS_MAP.put(128138, R.drawable.emoji_1f48a);
        EMOJIS_MAP.put(128137, R.drawable.emoji_1f489);
        EMOJIS_MAP.put(128176, R.drawable.emoji_1f4b0);
        EMOJIS_MAP.put(128180, R.drawable.emoji_1f4b4);
        EMOJIS_MAP.put(128181, R.drawable.emoji_1f4b5);
        EMOJIS_MAP.put(128183, R.drawable.emoji_1f4b7);
        EMOJIS_MAP.put(128182, R.drawable.emoji_1f4b6);
        EMOJIS_MAP.put(128179, R.drawable.emoji_1f4b3);
        EMOJIS_MAP.put(128184, R.drawable.emoji_1f4b8);
        EMOJIS_MAP.put(128242, R.drawable.emoji_1f4f2);
        EMOJIS_MAP.put(128231, R.drawable.emoji_1f4e7);
        EMOJIS_MAP.put(128229, R.drawable.emoji_1f4e5);
        EMOJIS_MAP.put(128228, R.drawable.emoji_1f4e4);
        EMOJIS_MAP.put(9993, R.drawable.emoji_2709);
        EMOJIS_MAP.put(128233, R.drawable.emoji_1f4e9);
        EMOJIS_MAP.put(128232, R.drawable.emoji_1f4e8);
        EMOJIS_MAP.put(128239, R.drawable.emoji_1f4ef);
        EMOJIS_MAP.put(128235, R.drawable.emoji_1f4eb);
        EMOJIS_MAP.put(128234, R.drawable.emoji_1f4ea);
        EMOJIS_MAP.put(128236, R.drawable.emoji_1f4ec);
        EMOJIS_MAP.put(128237, R.drawable.emoji_1f4ed);
        EMOJIS_MAP.put(128238, R.drawable.emoji_1f4ee);
        EMOJIS_MAP.put(128230, R.drawable.emoji_1f4e6);
        EMOJIS_MAP.put(128221, R.drawable.emoji_1f4dd);
        EMOJIS_MAP.put(128196, R.drawable.emoji_1f4c4);
        EMOJIS_MAP.put(128195, R.drawable.emoji_1f4c3);
        EMOJIS_MAP.put(128209, R.drawable.emoji_1f4d1);
        EMOJIS_MAP.put(128202, R.drawable.emoji_1f4ca);
        EMOJIS_MAP.put(128200, R.drawable.emoji_1f4c8);
        EMOJIS_MAP.put(128201, R.drawable.emoji_1f4c9);
        EMOJIS_MAP.put(128220, R.drawable.emoji_1f4dc);
        EMOJIS_MAP.put(128203, R.drawable.emoji_1f4cb);
        EMOJIS_MAP.put(128197, R.drawable.emoji_1f4c5);
        EMOJIS_MAP.put(128198, R.drawable.emoji_1f4c6);
        EMOJIS_MAP.put(128199, R.drawable.emoji_1f4c7);
        EMOJIS_MAP.put(128193, R.drawable.emoji_1f4c1);
        EMOJIS_MAP.put(128194, R.drawable.emoji_1f4c2);
        EMOJIS_MAP.put(9986, R.drawable.emoji_2702);
        EMOJIS_MAP.put(128204, R.drawable.emoji_1f4cc);
        EMOJIS_MAP.put(128206, R.drawable.emoji_1f4ce);
        EMOJIS_MAP.put(10002, R.drawable.emoji_2712);
        EMOJIS_MAP.put(9999, R.drawable.emoji_270f);
        EMOJIS_MAP.put(128207, R.drawable.emoji_1f4cf);
        EMOJIS_MAP.put(128208, R.drawable.emoji_1f4d0);
        EMOJIS_MAP.put(128213, R.drawable.emoji_1f4d5);
        EMOJIS_MAP.put(128215, R.drawable.emoji_1f4d7);
        EMOJIS_MAP.put(128216, R.drawable.emoji_1f4d8);
        EMOJIS_MAP.put(128217, R.drawable.emoji_1f4d9);
        EMOJIS_MAP.put(128211, R.drawable.emoji_1f4d3);
        EMOJIS_MAP.put(128212, R.drawable.emoji_1f4d4);
        EMOJIS_MAP.put(128210, R.drawable.emoji_1f4d2);
        EMOJIS_MAP.put(128218, R.drawable.emoji_1f4da);
        EMOJIS_MAP.put(128214, R.drawable.emoji_1f4d6);
        EMOJIS_MAP.put(128278, R.drawable.emoji_1f516);
        EMOJIS_MAP.put(128219, R.drawable.emoji_1f4db);
        EMOJIS_MAP.put(128300, R.drawable.emoji_1f52c);
        EMOJIS_MAP.put(128301, R.drawable.emoji_1f52d);
        EMOJIS_MAP.put(128240, R.drawable.emoji_1f4f0);
        EMOJIS_MAP.put(127912, R.drawable.emoji_1f3a8);
        EMOJIS_MAP.put(127916, R.drawable.emoji_1f3ac);
        EMOJIS_MAP.put(127908, R.drawable.emoji_1f3a4);
        EMOJIS_MAP.put(127911, R.drawable.emoji_1f3a7);
        EMOJIS_MAP.put(127932, R.drawable.emoji_1f3bc);
        EMOJIS_MAP.put(127925, R.drawable.emoji_1f3b5);
        EMOJIS_MAP.put(127926, R.drawable.emoji_1f3b6);
        EMOJIS_MAP.put(127929, R.drawable.emoji_1f3b9);
        EMOJIS_MAP.put(127931, R.drawable.emoji_1f3bb);
        EMOJIS_MAP.put(127930, R.drawable.emoji_1f3ba);
        EMOJIS_MAP.put(127927, R.drawable.emoji_1f3b7);
        EMOJIS_MAP.put(127928, R.drawable.emoji_1f3b8);
        EMOJIS_MAP.put(128126, R.drawable.emoji_1f47e);
        EMOJIS_MAP.put(127918, R.drawable.emoji_1f3ae);
        EMOJIS_MAP.put(127183, R.drawable.emoji_1f0cf);
        EMOJIS_MAP.put(127924, R.drawable.emoji_1f3b4);
        EMOJIS_MAP.put(126980, R.drawable.emoji_1f004);
        EMOJIS_MAP.put(127922, R.drawable.emoji_1f3b2);
        EMOJIS_MAP.put(127919, R.drawable.emoji_1f3af);
        EMOJIS_MAP.put(127944, R.drawable.emoji_1f3c8);
        EMOJIS_MAP.put(127936, R.drawable.emoji_1f3c0);
        EMOJIS_MAP.put(9917, R.drawable.emoji_26bd);
        EMOJIS_MAP.put(9918, R.drawable.emoji_26be);
        EMOJIS_MAP.put(127934, R.drawable.emoji_1f3be);
        EMOJIS_MAP.put(127921, R.drawable.emoji_1f3b1);
        EMOJIS_MAP.put(127945, R.drawable.emoji_1f3c9);
        EMOJIS_MAP.put(127923, R.drawable.emoji_1f3b3);
        EMOJIS_MAP.put(9971, R.drawable.emoji_26f3);
        EMOJIS_MAP.put(128693, R.drawable.emoji_1f6b5);
        EMOJIS_MAP.put(128692, R.drawable.emoji_1f6b4);
        EMOJIS_MAP.put(127937, R.drawable.emoji_1f3c1);
        EMOJIS_MAP.put(127943, R.drawable.emoji_1f3c7);
        EMOJIS_MAP.put(127942, R.drawable.emoji_1f3c6);
        EMOJIS_MAP.put(127935, R.drawable.emoji_1f3bf);
        EMOJIS_MAP.put(127938, R.drawable.emoji_1f3c2);
        EMOJIS_MAP.put(127946, R.drawable.emoji_1f3ca);
        EMOJIS_MAP.put(127940, R.drawable.emoji_1f3c4);
        EMOJIS_MAP.put(127907, R.drawable.emoji_1f3a3);
        EMOJIS_MAP.put(9749, R.drawable.emoji_2615);
        EMOJIS_MAP.put(127861, R.drawable.emoji_1f375);
        EMOJIS_MAP.put(127862, R.drawable.emoji_1f376);
        EMOJIS_MAP.put(127868, R.drawable.emoji_1f37c);
        EMOJIS_MAP.put(127866, R.drawable.emoji_1f37a);
        EMOJIS_MAP.put(127867, R.drawable.emoji_1f37b);
        EMOJIS_MAP.put(127864, R.drawable.emoji_1f378);
        EMOJIS_MAP.put(127865, R.drawable.emoji_1f379);
        EMOJIS_MAP.put(127863, R.drawable.emoji_1f377);
        EMOJIS_MAP.put(127860, R.drawable.emoji_1f374);
        EMOJIS_MAP.put(127829, R.drawable.emoji_1f355);
        EMOJIS_MAP.put(127828, R.drawable.emoji_1f354);
        EMOJIS_MAP.put(127839, R.drawable.emoji_1f35f);
        EMOJIS_MAP.put(127831, R.drawable.emoji_1f357);
        EMOJIS_MAP.put(127830, R.drawable.emoji_1f356);
        EMOJIS_MAP.put(127837, R.drawable.emoji_1f35d);
        EMOJIS_MAP.put(127835, R.drawable.emoji_1f35b);
        EMOJIS_MAP.put(127844, R.drawable.emoji_1f364);
        EMOJIS_MAP.put(127857, R.drawable.emoji_1f371);
        EMOJIS_MAP.put(127843, R.drawable.emoji_1f363);
        EMOJIS_MAP.put(127845, R.drawable.emoji_1f365);
        EMOJIS_MAP.put(127833, R.drawable.emoji_1f359);
        EMOJIS_MAP.put(127832, R.drawable.emoji_1f358);
        EMOJIS_MAP.put(127834, R.drawable.emoji_1f35a);
        EMOJIS_MAP.put(127836, R.drawable.emoji_1f35c);
        EMOJIS_MAP.put(127858, R.drawable.emoji_1f372);
        EMOJIS_MAP.put(127842, R.drawable.emoji_1f362);
        EMOJIS_MAP.put(127841, R.drawable.emoji_1f361);
        EMOJIS_MAP.put(127859, R.drawable.emoji_1f373);
        EMOJIS_MAP.put(127838, R.drawable.emoji_1f35e);
        EMOJIS_MAP.put(127849, R.drawable.emoji_1f369);
        EMOJIS_MAP.put(127854, R.drawable.emoji_1f36e);
        EMOJIS_MAP.put(127846, R.drawable.emoji_1f366);
        EMOJIS_MAP.put(127848, R.drawable.emoji_1f368);
        EMOJIS_MAP.put(127847, R.drawable.emoji_1f367);
        EMOJIS_MAP.put(127874, R.drawable.emoji_1f382);
        EMOJIS_MAP.put(127856, R.drawable.emoji_1f370);
        EMOJIS_MAP.put(127850, R.drawable.emoji_1f36a);
        EMOJIS_MAP.put(127851, R.drawable.emoji_1f36b);
        EMOJIS_MAP.put(127852, R.drawable.emoji_1f36c);
        EMOJIS_MAP.put(127853, R.drawable.emoji_1f36d);
        EMOJIS_MAP.put(127855, R.drawable.emoji_1f36f);
        EMOJIS_MAP.put(127822, R.drawable.emoji_1f34e);
        EMOJIS_MAP.put(127823, R.drawable.emoji_1f34f);
        EMOJIS_MAP.put(127818, R.drawable.emoji_1f34a);
        EMOJIS_MAP.put(127819, R.drawable.emoji_1f34b);
        EMOJIS_MAP.put(127826, R.drawable.emoji_1f352);
        EMOJIS_MAP.put(127815, R.drawable.emoji_1f347);
        EMOJIS_MAP.put(127817, R.drawable.emoji_1f349);
        EMOJIS_MAP.put(127827, R.drawable.emoji_1f353);
        EMOJIS_MAP.put(127825, R.drawable.emoji_1f351);
        EMOJIS_MAP.put(127816, R.drawable.emoji_1f348);
        EMOJIS_MAP.put(127820, R.drawable.emoji_1f34c);
        EMOJIS_MAP.put(127824, R.drawable.emoji_1f350);
        EMOJIS_MAP.put(127821, R.drawable.emoji_1f34d);
        EMOJIS_MAP.put(127840, R.drawable.emoji_1f360);
        EMOJIS_MAP.put(127814, R.drawable.emoji_1f346);
        EMOJIS_MAP.put(127813, R.drawable.emoji_1f345);
        EMOJIS_MAP.put(127805, R.drawable.emoji_1f33d);
        EMOJIS_MAP.put(127968, R.drawable.emoji_1f3e0);
        EMOJIS_MAP.put(127969, R.drawable.emoji_1f3e1);
        EMOJIS_MAP.put(127979, R.drawable.emoji_1f3eb);
        EMOJIS_MAP.put(127970, R.drawable.emoji_1f3e2);
        EMOJIS_MAP.put(127971, R.drawable.emoji_1f3e3);
        EMOJIS_MAP.put(127973, R.drawable.emoji_1f3e5);
        EMOJIS_MAP.put(127974, R.drawable.emoji_1f3e6);
        EMOJIS_MAP.put(127978, R.drawable.emoji_1f3ea);
        EMOJIS_MAP.put(127977, R.drawable.emoji_1f3e9);
        EMOJIS_MAP.put(127976, R.drawable.emoji_1f3e8);
        EMOJIS_MAP.put(128146, R.drawable.emoji_1f492);
        EMOJIS_MAP.put(9962, R.drawable.emoji_26ea);
        EMOJIS_MAP.put(127980, R.drawable.emoji_1f3ec);
        EMOJIS_MAP.put(127972, R.drawable.emoji_1f3e4);
        EMOJIS_MAP.put(127751, R.drawable.emoji_1f307);
        EMOJIS_MAP.put(127750, R.drawable.emoji_1f306);
        EMOJIS_MAP.put(127983, R.drawable.emoji_1f3ef);
        EMOJIS_MAP.put(127984, R.drawable.emoji_1f3f0);
        EMOJIS_MAP.put(9978, R.drawable.emoji_26fa);
        EMOJIS_MAP.put(127981, R.drawable.emoji_1f3ed);
        EMOJIS_MAP.put(128508, R.drawable.emoji_1f5fc);
        EMOJIS_MAP.put(128510, R.drawable.emoji_1f5fe);
        EMOJIS_MAP.put(128507, R.drawable.emoji_1f5fb);
        EMOJIS_MAP.put(127748, R.drawable.emoji_1f304);
        EMOJIS_MAP.put(127749, R.drawable.emoji_1f305);
        EMOJIS_MAP.put(127747, R.drawable.emoji_1f303);
        EMOJIS_MAP.put(128509, R.drawable.emoji_1f5fd);
        EMOJIS_MAP.put(127753, R.drawable.emoji_1f309);
        EMOJIS_MAP.put(127904, R.drawable.emoji_1f3a0);
        EMOJIS_MAP.put(127905, R.drawable.emoji_1f3a1);
        EMOJIS_MAP.put(9970, R.drawable.emoji_26f2);
        EMOJIS_MAP.put(127906, R.drawable.emoji_1f3a2);
        EMOJIS_MAP.put(128674, R.drawable.emoji_1f6a2);
        EMOJIS_MAP.put(9973, R.drawable.emoji_26f5);
        EMOJIS_MAP.put(128676, R.drawable.emoji_1f6a4);
        EMOJIS_MAP.put(128675, R.drawable.emoji_1f6a3);
        EMOJIS_MAP.put(9875, R.drawable.emoji_2693);
        EMOJIS_MAP.put(128640, R.drawable.emoji_1f680);
        EMOJIS_MAP.put(9992, R.drawable.emoji_2708);
        EMOJIS_MAP.put(128186, R.drawable.emoji_1f4ba);
        EMOJIS_MAP.put(128641, R.drawable.emoji_1f681);
        EMOJIS_MAP.put(128642, R.drawable.emoji_1f682);
        EMOJIS_MAP.put(128650, R.drawable.emoji_1f68a);
        EMOJIS_MAP.put(128649, R.drawable.emoji_1f689);
        EMOJIS_MAP.put(128670, R.drawable.emoji_1f69e);
        EMOJIS_MAP.put(128646, R.drawable.emoji_1f686);
        EMOJIS_MAP.put(128644, R.drawable.emoji_1f684);
        EMOJIS_MAP.put(128645, R.drawable.emoji_1f685);
        EMOJIS_MAP.put(128648, R.drawable.emoji_1f688);
        EMOJIS_MAP.put(128647, R.drawable.emoji_1f687);
        EMOJIS_MAP.put(128669, R.drawable.emoji_1f69d);
        EMOJIS_MAP.put(128651, R.drawable.emoji_1f68b);
        EMOJIS_MAP.put(128643, R.drawable.emoji_1f683);
        EMOJIS_MAP.put(128654, R.drawable.emoji_1f68e);
        EMOJIS_MAP.put(128652, R.drawable.emoji_1f68c);
        EMOJIS_MAP.put(128653, R.drawable.emoji_1f68d);
        EMOJIS_MAP.put(128665, R.drawable.emoji_1f699);
        EMOJIS_MAP.put(128664, R.drawable.emoji_1f698);
        EMOJIS_MAP.put(128663, R.drawable.emoji_1f697);
        EMOJIS_MAP.put(128661, R.drawable.emoji_1f695);
        EMOJIS_MAP.put(128662, R.drawable.emoji_1f696);
        EMOJIS_MAP.put(128667, R.drawable.emoji_1f69b);
        EMOJIS_MAP.put(128666, R.drawable.emoji_1f69a);
        EMOJIS_MAP.put(128680, R.drawable.emoji_1f6a8);
        EMOJIS_MAP.put(128659, R.drawable.emoji_1f693);
        EMOJIS_MAP.put(128660, R.drawable.emoji_1f694);
        EMOJIS_MAP.put(128658, R.drawable.emoji_1f692);
        EMOJIS_MAP.put(128657, R.drawable.emoji_1f691);
        EMOJIS_MAP.put(128656, R.drawable.emoji_1f690);
        EMOJIS_MAP.put(128690, R.drawable.emoji_1f6b2);
        EMOJIS_MAP.put(128673, R.drawable.emoji_1f6a1);
        EMOJIS_MAP.put(128671, R.drawable.emoji_1f69f);
        EMOJIS_MAP.put(128672, R.drawable.emoji_1f6a0);
        EMOJIS_MAP.put(128668, R.drawable.emoji_1f69c);
        EMOJIS_MAP.put(128136, R.drawable.emoji_1f488);
        EMOJIS_MAP.put(128655, R.drawable.emoji_1f68f);
        EMOJIS_MAP.put(127915, R.drawable.emoji_1f3ab);
        EMOJIS_MAP.put(128678, R.drawable.emoji_1f6a6);
        EMOJIS_MAP.put(128677, R.drawable.emoji_1f6a5);
        EMOJIS_MAP.put(9888, R.drawable.emoji_26a0);
        EMOJIS_MAP.put(128679, R.drawable.emoji_1f6a7);
        EMOJIS_MAP.put(128304, R.drawable.emoji_1f530);
        EMOJIS_MAP.put(9981, R.drawable.emoji_26fd);
        EMOJIS_MAP.put(127982, R.drawable.emoji_1f3ee);
        EMOJIS_MAP.put(127920, R.drawable.emoji_1f3b0);
        EMOJIS_MAP.put(9832, R.drawable.emoji_2668);
        EMOJIS_MAP.put(128511, R.drawable.emoji_1f5ff);
        EMOJIS_MAP.put(127914, R.drawable.emoji_1f3aa);
        EMOJIS_MAP.put(127917, R.drawable.emoji_1f3ad);
        EMOJIS_MAP.put(128205, R.drawable.emoji_1f4cd);
        EMOJIS_MAP.put(128681, R.drawable.emoji_1f6a9);
        EMOJIS_MAP.put(128287, R.drawable.emoji_1f51f);
        EMOJIS_MAP.put(128290, R.drawable.emoji_1f522);
        EMOJIS_MAP.put(128291, R.drawable.emoji_1f523);
        EMOJIS_MAP.put(11014, R.drawable.emoji_2b06);
        EMOJIS_MAP.put(11015, R.drawable.emoji_2b07);
        EMOJIS_MAP.put(11013, R.drawable.emoji_2b05);
        EMOJIS_MAP.put(10145, R.drawable.emoji_27a1);
        EMOJIS_MAP.put(128288, R.drawable.emoji_1f520);
        EMOJIS_MAP.put(128289, R.drawable.emoji_1f521);
        EMOJIS_MAP.put(128292, R.drawable.emoji_1f524);
        EMOJIS_MAP.put(8599, R.drawable.emoji_2197);
        EMOJIS_MAP.put(8598, R.drawable.emoji_2196);
        EMOJIS_MAP.put(8600, R.drawable.emoji_2198);
        EMOJIS_MAP.put(8601, R.drawable.emoji_2199);
        EMOJIS_MAP.put(8596, R.drawable.emoji_2194);
        EMOJIS_MAP.put(8597, R.drawable.emoji_2195);
        EMOJIS_MAP.put(128260, R.drawable.emoji_1f504);
        EMOJIS_MAP.put(9664, R.drawable.emoji_25c0);
        EMOJIS_MAP.put(9654, R.drawable.emoji_25b6);
        EMOJIS_MAP.put(128316, R.drawable.emoji_1f53c);
        EMOJIS_MAP.put(128317, R.drawable.emoji_1f53d);
        EMOJIS_MAP.put(8617, R.drawable.emoji_21a9);
        EMOJIS_MAP.put(8618, R.drawable.emoji_21aa);
        EMOJIS_MAP.put(8505, R.drawable.emoji_2139);
        EMOJIS_MAP.put(9194, R.drawable.emoji_23ea);
        EMOJIS_MAP.put(9193, R.drawable.emoji_23e9);
        EMOJIS_MAP.put(9195, R.drawable.emoji_23eb);
        EMOJIS_MAP.put(9196, R.drawable.emoji_23ec);
        EMOJIS_MAP.put(10549, R.drawable.emoji_2935);
        EMOJIS_MAP.put(10548, R.drawable.emoji_2934);
        EMOJIS_MAP.put(127383, R.drawable.emoji_1f197);
        EMOJIS_MAP.put(128256, R.drawable.emoji_1f500);
        EMOJIS_MAP.put(128257, R.drawable.emoji_1f501);
        EMOJIS_MAP.put(128258, R.drawable.emoji_1f502);
        EMOJIS_MAP.put(127381, R.drawable.emoji_1f195);
        EMOJIS_MAP.put(127385, R.drawable.emoji_1f199);
        EMOJIS_MAP.put(127378, R.drawable.emoji_1f192);
        EMOJIS_MAP.put(127379, R.drawable.emoji_1f193);
        EMOJIS_MAP.put(127382, R.drawable.emoji_1f196);
        EMOJIS_MAP.put(128246, R.drawable.emoji_1f4f6);
        EMOJIS_MAP.put(127910, R.drawable.emoji_1f3a6);
        EMOJIS_MAP.put(127489, R.drawable.emoji_1f201);
        EMOJIS_MAP.put(127535, R.drawable.emoji_1f22f);
        EMOJIS_MAP.put(127539, R.drawable.emoji_1f233);
        EMOJIS_MAP.put(127541, R.drawable.emoji_1f235);
        EMOJIS_MAP.put(127540, R.drawable.emoji_1f234);
        EMOJIS_MAP.put(127538, R.drawable.emoji_1f232);
        EMOJIS_MAP.put(127568, R.drawable.emoji_1f250);
        EMOJIS_MAP.put(127545, R.drawable.emoji_1f239);
        EMOJIS_MAP.put(127546, R.drawable.emoji_1f23a);
        EMOJIS_MAP.put(127542, R.drawable.emoji_1f236);
        EMOJIS_MAP.put(127514, R.drawable.emoji_1f21a);
        EMOJIS_MAP.put(128699, R.drawable.emoji_1f6bb);
        EMOJIS_MAP.put(128697, R.drawable.emoji_1f6b9);
        EMOJIS_MAP.put(128698, R.drawable.emoji_1f6ba);
        EMOJIS_MAP.put(128700, R.drawable.emoji_1f6bc);
        EMOJIS_MAP.put(128702, R.drawable.emoji_1f6be);
        EMOJIS_MAP.put(128688, R.drawable.emoji_1f6b0);
        EMOJIS_MAP.put(128686, R.drawable.emoji_1f6ae);
        EMOJIS_MAP.put(127359, R.drawable.emoji_1f17f);
        EMOJIS_MAP.put(9855, R.drawable.emoji_267f);
        EMOJIS_MAP.put(128685, R.drawable.emoji_1f6ad);
        EMOJIS_MAP.put(127543, R.drawable.emoji_1f237);
        EMOJIS_MAP.put(127544, R.drawable.emoji_1f238);
        EMOJIS_MAP.put(127490, R.drawable.emoji_1f202);
        EMOJIS_MAP.put(9410, R.drawable.emoji_24c2);
        EMOJIS_MAP.put(128706, R.drawable.emoji_1f6c2);
        EMOJIS_MAP.put(128708, R.drawable.emoji_1f6c4);
        EMOJIS_MAP.put(128709, R.drawable.emoji_1f6c5);
        EMOJIS_MAP.put(128707, R.drawable.emoji_1f6c3);
        EMOJIS_MAP.put(127569, R.drawable.emoji_1f251);
        EMOJIS_MAP.put(12953, R.drawable.emoji_3299);
        EMOJIS_MAP.put(12951, R.drawable.emoji_3297);
        EMOJIS_MAP.put(127377, R.drawable.emoji_1f191);
        EMOJIS_MAP.put(127384, R.drawable.emoji_1f198);
        EMOJIS_MAP.put(127380, R.drawable.emoji_1f194);
        EMOJIS_MAP.put(128683, R.drawable.emoji_1f6ab);
        EMOJIS_MAP.put(128286, R.drawable.emoji_1f51e);
        EMOJIS_MAP.put(128245, R.drawable.emoji_1f4f5);
        EMOJIS_MAP.put(128687, R.drawable.emoji_1f6af);
        EMOJIS_MAP.put(128689, R.drawable.emoji_1f6b1);
        EMOJIS_MAP.put(128691, R.drawable.emoji_1f6b3);
        EMOJIS_MAP.put(128695, R.drawable.emoji_1f6b7);
        EMOJIS_MAP.put(128696, R.drawable.emoji_1f6b8);
        EMOJIS_MAP.put(9940, R.drawable.emoji_26d4);
        EMOJIS_MAP.put(10035, R.drawable.emoji_2733);
        EMOJIS_MAP.put(10055, R.drawable.emoji_2747);
        EMOJIS_MAP.put(10062, R.drawable.emoji_274e);
        EMOJIS_MAP.put(9989, R.drawable.emoji_2705);
        EMOJIS_MAP.put(10036, R.drawable.emoji_2734);
        EMOJIS_MAP.put(128159, R.drawable.emoji_1f49f);
        EMOJIS_MAP.put(127386, R.drawable.emoji_1f19a);
        EMOJIS_MAP.put(128243, R.drawable.emoji_1f4f3);
        EMOJIS_MAP.put(128244, R.drawable.emoji_1f4f4);
        EMOJIS_MAP.put(127344, R.drawable.emoji_1f170);
        EMOJIS_MAP.put(127345, R.drawable.emoji_1f171);
        EMOJIS_MAP.put(127374, R.drawable.emoji_1f18e);
        EMOJIS_MAP.put(127358, R.drawable.emoji_1f17e);
        EMOJIS_MAP.put(128160, R.drawable.emoji_1f4a0);
        EMOJIS_MAP.put(10175, R.drawable.emoji_27bf);
        EMOJIS_MAP.put(9851, R.drawable.emoji_267b);
        EMOJIS_MAP.put(9800, R.drawable.emoji_2648);
        EMOJIS_MAP.put(9801, R.drawable.emoji_2649);
        EMOJIS_MAP.put(9802, R.drawable.emoji_264a);
        EMOJIS_MAP.put(9803, R.drawable.emoji_264b);
        EMOJIS_MAP.put(9804, R.drawable.emoji_264c);
        EMOJIS_MAP.put(9805, R.drawable.emoji_264d);
        EMOJIS_MAP.put(9806, R.drawable.emoji_264e);
        EMOJIS_MAP.put(9807, R.drawable.emoji_264f);
        EMOJIS_MAP.put(9808, R.drawable.emoji_2650);
        EMOJIS_MAP.put(9809, R.drawable.emoji_2651);
        EMOJIS_MAP.put(9810, R.drawable.emoji_2652);
        EMOJIS_MAP.put(9811, R.drawable.emoji_2653);
        EMOJIS_MAP.put(9934, R.drawable.emoji_26ce);
        EMOJIS_MAP.put(128303, R.drawable.emoji_1f52f);
        EMOJIS_MAP.put(127975, R.drawable.emoji_1f3e7);
        EMOJIS_MAP.put(128185, R.drawable.emoji_1f4b9);
        EMOJIS_MAP.put(128178, R.drawable.emoji_1f4b2);
        EMOJIS_MAP.put(128177, R.drawable.emoji_1f4b1);
        EMOJIS_MAP.put(169, R.drawable.emoji_00a9);
        EMOJIS_MAP.put(174, R.drawable.emoji_00ae);
        EMOJIS_MAP.put(8482, R.drawable.emoji_2122);
        EMOJIS_MAP.put(10060, R.drawable.emoji_274c);
        EMOJIS_MAP.put(8252, R.drawable.emoji_203c);
        EMOJIS_MAP.put(8265, R.drawable.emoji_2049);
        EMOJIS_MAP.put(10071, R.drawable.emoji_2757);
        EMOJIS_MAP.put(10067, R.drawable.emoji_2753);
        EMOJIS_MAP.put(10069, R.drawable.emoji_2755);
        EMOJIS_MAP.put(10068, R.drawable.emoji_2754);
        EMOJIS_MAP.put(11093, R.drawable.emoji_2b55);
        EMOJIS_MAP.put(128285, R.drawable.emoji_1f51d);
        EMOJIS_MAP.put(128282, R.drawable.emoji_1f51a);
        EMOJIS_MAP.put(128281, R.drawable.emoji_1f519);
        EMOJIS_MAP.put(128283, R.drawable.emoji_1f51b);
        EMOJIS_MAP.put(128284, R.drawable.emoji_1f51c);
        EMOJIS_MAP.put(128259, R.drawable.emoji_1f503);
        EMOJIS_MAP.put(128347, R.drawable.emoji_1f55b);
        EMOJIS_MAP.put(128359, R.drawable.emoji_1f567);
        EMOJIS_MAP.put(128336, R.drawable.emoji_1f550);
        EMOJIS_MAP.put(128348, R.drawable.emoji_1f55c);
        EMOJIS_MAP.put(128337, R.drawable.emoji_1f551);
        EMOJIS_MAP.put(128349, R.drawable.emoji_1f55d);
        EMOJIS_MAP.put(128338, R.drawable.emoji_1f552);
        EMOJIS_MAP.put(128350, R.drawable.emoji_1f55e);
        EMOJIS_MAP.put(128339, R.drawable.emoji_1f553);
        EMOJIS_MAP.put(128351, R.drawable.emoji_1f55f);
        EMOJIS_MAP.put(128340, R.drawable.emoji_1f554);
        EMOJIS_MAP.put(128352, R.drawable.emoji_1f560);
        EMOJIS_MAP.put(128341, R.drawable.emoji_1f555);
        EMOJIS_MAP.put(128342, R.drawable.emoji_1f556);
        EMOJIS_MAP.put(128343, R.drawable.emoji_1f557);
        EMOJIS_MAP.put(128344, R.drawable.emoji_1f558);
        EMOJIS_MAP.put(128345, R.drawable.emoji_1f559);
        EMOJIS_MAP.put(128346, R.drawable.emoji_1f55a);
        EMOJIS_MAP.put(128353, R.drawable.emoji_1f561);
        EMOJIS_MAP.put(128354, R.drawable.emoji_1f562);
        EMOJIS_MAP.put(128355, R.drawable.emoji_1f563);
        EMOJIS_MAP.put(128356, R.drawable.emoji_1f564);
        EMOJIS_MAP.put(128357, R.drawable.emoji_1f565);
        EMOJIS_MAP.put(128358, R.drawable.emoji_1f566);
        EMOJIS_MAP.put(10006, R.drawable.emoji_2716);
        EMOJIS_MAP.put(10133, R.drawable.emoji_2795);
        EMOJIS_MAP.put(10134, R.drawable.emoji_2796);
        EMOJIS_MAP.put(10135, R.drawable.emoji_2797);
        EMOJIS_MAP.put(9824, R.drawable.emoji_2660);
        EMOJIS_MAP.put(9829, R.drawable.emoji_2665);
        EMOJIS_MAP.put(9827, R.drawable.emoji_2663);
        EMOJIS_MAP.put(9830, R.drawable.emoji_2666);
        EMOJIS_MAP.put(128174, R.drawable.emoji_1f4ae);
        EMOJIS_MAP.put(128175, R.drawable.emoji_1f4af);
        EMOJIS_MAP.put(10004, R.drawable.emoji_2714);
        EMOJIS_MAP.put(9745, R.drawable.emoji_2611);
        EMOJIS_MAP.put(128280, R.drawable.emoji_1f518);
        EMOJIS_MAP.put(128279, R.drawable.emoji_1f517);
        EMOJIS_MAP.put(10160, R.drawable.emoji_27b0);
        EMOJIS_MAP.put(12336, R.drawable.emoji_3030);
        EMOJIS_MAP.put(12349, R.drawable.emoji_303d);
        EMOJIS_MAP.put(128305, R.drawable.emoji_1f531);
        EMOJIS_MAP.put(9724, R.drawable.emoji_25fc);
        EMOJIS_MAP.put(9723, R.drawable.emoji_25fb);
        EMOJIS_MAP.put(9726, R.drawable.emoji_25fe);
        EMOJIS_MAP.put(9725, R.drawable.emoji_25fd);
        EMOJIS_MAP.put(9642, R.drawable.emoji_25aa);
        EMOJIS_MAP.put(9643, R.drawable.emoji_25ab);
        EMOJIS_MAP.put(128314, R.drawable.emoji_1f53a);
        EMOJIS_MAP.put(128306, R.drawable.emoji_1f532);
        EMOJIS_MAP.put(128307, R.drawable.emoji_1f533);
        EMOJIS_MAP.put(9899, R.drawable.emoji_26ab);
        EMOJIS_MAP.put(9898, R.drawable.emoji_26aa);
        EMOJIS_MAP.put(128308, R.drawable.emoji_1f534);
        EMOJIS_MAP.put(128309, R.drawable.emoji_1f535);
        EMOJIS_MAP.put(128315, R.drawable.emoji_1f53b);
        EMOJIS_MAP.put(11036, R.drawable.emoji_2b1c);
        EMOJIS_MAP.put(11035, R.drawable.emoji_2b1b);
        EMOJIS_MAP.put(128310, R.drawable.emoji_1f536);
        EMOJIS_MAP.put(128311, R.drawable.emoji_1f537);
        EMOJIS_MAP.put(128312, R.drawable.emoji_1f538);
        EMOJIS_MAP.put(128313, R.drawable.emoji_1f539);
        SOFTBANKS_MAP.put(57345, R.drawable.emoji_1f466);
        SOFTBANKS_MAP.put(57346, R.drawable.emoji_1f467);
        SOFTBANKS_MAP.put(57347, R.drawable.emoji_1f48b);
        SOFTBANKS_MAP.put(57348, R.drawable.emoji_1f468);
        SOFTBANKS_MAP.put(57349, R.drawable.emoji_1f469);
        SOFTBANKS_MAP.put(57350, R.drawable.emoji_1f455);
        SOFTBANKS_MAP.put(57351, R.drawable.emoji_1f45e);
        SOFTBANKS_MAP.put(57352, R.drawable.emoji_1f4f7);
        SOFTBANKS_MAP.put(57353, R.drawable.emoji_1f4de);
        SOFTBANKS_MAP.put(57354, R.drawable.emoji_1f4f1);
        SOFTBANKS_MAP.put(57355, R.drawable.emoji_1f4e0);
        SOFTBANKS_MAP.put(57356, R.drawable.emoji_1f4bb);
        SOFTBANKS_MAP.put(57357, R.drawable.emoji_1f44a);
        SOFTBANKS_MAP.put(57358, R.drawable.emoji_1f44d);
        SOFTBANKS_MAP.put(57359, R.drawable.emoji_261d);
        SOFTBANKS_MAP.put(57360, R.drawable.emoji_270a);
        SOFTBANKS_MAP.put(57361, R.drawable.emoji_270c);
        SOFTBANKS_MAP.put(57362, R.drawable.emoji_1f64b);
        SOFTBANKS_MAP.put(57363, R.drawable.emoji_1f3bf);
        SOFTBANKS_MAP.put(57364, R.drawable.emoji_26f3);
        SOFTBANKS_MAP.put(57365, R.drawable.emoji_1f3be);
        SOFTBANKS_MAP.put(57366, R.drawable.emoji_26be);
        SOFTBANKS_MAP.put(57367, R.drawable.emoji_1f3c4);
        SOFTBANKS_MAP.put(57368, R.drawable.emoji_26bd);
        SOFTBANKS_MAP.put(57369, R.drawable.emoji_1f3a3);
        SOFTBANKS_MAP.put(57370, R.drawable.emoji_1f434);
        SOFTBANKS_MAP.put(57371, R.drawable.emoji_1f697);
        SOFTBANKS_MAP.put(57372, R.drawable.emoji_26f5);
        SOFTBANKS_MAP.put(57373, R.drawable.emoji_2708);
        SOFTBANKS_MAP.put(57374, R.drawable.emoji_1f683);
        SOFTBANKS_MAP.put(57375, R.drawable.emoji_1f685);
        SOFTBANKS_MAP.put(57376, R.drawable.emoji_2753);
        SOFTBANKS_MAP.put(57377, R.drawable.emoji_2757);
        SOFTBANKS_MAP.put(57378, R.drawable.emoji_2764);
        SOFTBANKS_MAP.put(57379, R.drawable.emoji_1f494);
        SOFTBANKS_MAP.put(57380, R.drawable.emoji_1f550);
        SOFTBANKS_MAP.put(57381, R.drawable.emoji_1f551);
        SOFTBANKS_MAP.put(57382, R.drawable.emoji_1f552);
        SOFTBANKS_MAP.put(57383, R.drawable.emoji_1f553);
        SOFTBANKS_MAP.put(57384, R.drawable.emoji_1f554);
        SOFTBANKS_MAP.put(57385, R.drawable.emoji_1f555);
        SOFTBANKS_MAP.put(57386, R.drawable.emoji_1f556);
        SOFTBANKS_MAP.put(57387, R.drawable.emoji_1f557);
        SOFTBANKS_MAP.put(57388, R.drawable.emoji_1f558);
        SOFTBANKS_MAP.put(57389, R.drawable.emoji_1f559);
        SOFTBANKS_MAP.put(57390, R.drawable.emoji_1f55a);
        SOFTBANKS_MAP.put(57391, R.drawable.emoji_1f55b);
        SOFTBANKS_MAP.put(57392, R.drawable.emoji_1f338);
        SOFTBANKS_MAP.put(57393, R.drawable.emoji_1f531);
        SOFTBANKS_MAP.put(57394, R.drawable.emoji_1f339);
        SOFTBANKS_MAP.put(57395, R.drawable.emoji_1f384);
        SOFTBANKS_MAP.put(57396, R.drawable.emoji_1f48d);
        SOFTBANKS_MAP.put(57397, R.drawable.emoji_1f48e);
        SOFTBANKS_MAP.put(57398, R.drawable.emoji_1f3e0);
        SOFTBANKS_MAP.put(57399, R.drawable.emoji_26ea);
        SOFTBANKS_MAP.put(57400, R.drawable.emoji_1f3e2);
        SOFTBANKS_MAP.put(57401, R.drawable.emoji_1f689);
        SOFTBANKS_MAP.put(57402, R.drawable.emoji_26fd);
        SOFTBANKS_MAP.put(57403, R.drawable.emoji_1f5fb);
        SOFTBANKS_MAP.put(57404, R.drawable.emoji_1f3a4);
        SOFTBANKS_MAP.put(57405, R.drawable.emoji_1f3a5);
        SOFTBANKS_MAP.put(57406, R.drawable.emoji_1f3b5);
        SOFTBANKS_MAP.put(57407, R.drawable.emoji_1f511);
        SOFTBANKS_MAP.put(57408, R.drawable.emoji_1f3b7);
        SOFTBANKS_MAP.put(57409, R.drawable.emoji_1f3b8);
        SOFTBANKS_MAP.put(57410, R.drawable.emoji_1f3ba);
        SOFTBANKS_MAP.put(57411, R.drawable.emoji_1f374);
        SOFTBANKS_MAP.put(57412, R.drawable.emoji_1f377);
        SOFTBANKS_MAP.put(57413, R.drawable.emoji_2615);
        SOFTBANKS_MAP.put(57414, R.drawable.emoji_1f370);
        SOFTBANKS_MAP.put(57415, R.drawable.emoji_1f37a);
        SOFTBANKS_MAP.put(57416, R.drawable.emoji_26c4);
        SOFTBANKS_MAP.put(57417, R.drawable.emoji_2601);
        SOFTBANKS_MAP.put(57418, R.drawable.emoji_2600);
        SOFTBANKS_MAP.put(57419, R.drawable.emoji_2614);
        SOFTBANKS_MAP.put(57420, R.drawable.emoji_1f313);
        SOFTBANKS_MAP.put(57421, R.drawable.emoji_1f304);
        SOFTBANKS_MAP.put(57422, R.drawable.emoji_1f47c);
        SOFTBANKS_MAP.put(57423, R.drawable.emoji_1f431);
        SOFTBANKS_MAP.put(57424, R.drawable.emoji_1f42f);
        SOFTBANKS_MAP.put(57425, R.drawable.emoji_1f43b);
        SOFTBANKS_MAP.put(57426, R.drawable.emoji_1f429);
        SOFTBANKS_MAP.put(57427, R.drawable.emoji_1f42d);
        SOFTBANKS_MAP.put(57428, R.drawable.emoji_1f433);
        SOFTBANKS_MAP.put(57429, R.drawable.emoji_1f427);
        SOFTBANKS_MAP.put(57430, R.drawable.emoji_1f60a);
        SOFTBANKS_MAP.put(57431, R.drawable.emoji_1f603);
        SOFTBANKS_MAP.put(57432, R.drawable.emoji_1f61e);
        SOFTBANKS_MAP.put(57433, R.drawable.emoji_1f620);
        SOFTBANKS_MAP.put(57434, R.drawable.emoji_1f4a9);
        SOFTBANKS_MAP.put(57601, R.drawable.emoji_1f4ea);
        SOFTBANKS_MAP.put(57602, R.drawable.emoji_1f4ee);
        SOFTBANKS_MAP.put(57603, R.drawable.emoji_1f4e7);
        SOFTBANKS_MAP.put(57604, R.drawable.emoji_1f4f2);
        SOFTBANKS_MAP.put(57605, R.drawable.emoji_1f61c);
        SOFTBANKS_MAP.put(57606, R.drawable.emoji_1f60d);
        SOFTBANKS_MAP.put(57607, R.drawable.emoji_1f631);
        SOFTBANKS_MAP.put(57608, R.drawable.emoji_1f613);
        SOFTBANKS_MAP.put(57609, R.drawable.emoji_1f435);
        SOFTBANKS_MAP.put(57610, R.drawable.emoji_1f419);
        SOFTBANKS_MAP.put(57611, R.drawable.emoji_1f437);
        SOFTBANKS_MAP.put(57612, R.drawable.emoji_1f47d);
        SOFTBANKS_MAP.put(57613, R.drawable.emoji_1f680);
        SOFTBANKS_MAP.put(57614, R.drawable.emoji_1f451);
        SOFTBANKS_MAP.put(57615, R.drawable.emoji_1f4a1);
        SOFTBANKS_MAP.put(57616, R.drawable.emoji_1f331);
        SOFTBANKS_MAP.put(57617, R.drawable.emoji_1f48f);
        SOFTBANKS_MAP.put(57618, R.drawable.emoji_1f381);
        SOFTBANKS_MAP.put(57619, R.drawable.emoji_1f52b);
        SOFTBANKS_MAP.put(57620, R.drawable.emoji_1f50d);
        SOFTBANKS_MAP.put(57621, R.drawable.emoji_1f3c3);
        SOFTBANKS_MAP.put(57622, R.drawable.emoji_1f528);
        SOFTBANKS_MAP.put(57623, R.drawable.emoji_1f386);
        SOFTBANKS_MAP.put(57624, R.drawable.emoji_1f341);
        SOFTBANKS_MAP.put(57625, R.drawable.emoji_1f342);
        SOFTBANKS_MAP.put(57626, R.drawable.emoji_1f47f);
        SOFTBANKS_MAP.put(57627, R.drawable.emoji_1f47b);
        SOFTBANKS_MAP.put(57628, R.drawable.emoji_1f480);
        SOFTBANKS_MAP.put(57629, R.drawable.emoji_1f525);
        SOFTBANKS_MAP.put(57630, R.drawable.emoji_1f4bc);
        SOFTBANKS_MAP.put(57631, R.drawable.emoji_1f4ba);
        SOFTBANKS_MAP.put(57632, R.drawable.emoji_1f354);
        SOFTBANKS_MAP.put(57633, R.drawable.emoji_26f2);
        SOFTBANKS_MAP.put(57634, R.drawable.emoji_26fa);
        SOFTBANKS_MAP.put(57635, R.drawable.emoji_2668);
        SOFTBANKS_MAP.put(57636, R.drawable.emoji_1f3a1);
        SOFTBANKS_MAP.put(57637, R.drawable.emoji_1f3ab);
        SOFTBANKS_MAP.put(57638, R.drawable.emoji_1f4bf);
        SOFTBANKS_MAP.put(57639, R.drawable.emoji_1f4c0);
        SOFTBANKS_MAP.put(57640, R.drawable.emoji_1f4fb);
        SOFTBANKS_MAP.put(57641, R.drawable.emoji_1f4fc);
        SOFTBANKS_MAP.put(57642, R.drawable.emoji_1f4fa);
        SOFTBANKS_MAP.put(57643, R.drawable.emoji_1f47e);
        SOFTBANKS_MAP.put(57644, R.drawable.emoji_303d);
        SOFTBANKS_MAP.put(57645, R.drawable.emoji_1f004);
        SOFTBANKS_MAP.put(57646, R.drawable.emoji_1f19a);
        SOFTBANKS_MAP.put(57647, R.drawable.emoji_1f4b0);
        SOFTBANKS_MAP.put(57648, R.drawable.emoji_1f3af);
        SOFTBANKS_MAP.put(57649, R.drawable.emoji_1f3c6);
        SOFTBANKS_MAP.put(57650, R.drawable.emoji_1f3c1);
        SOFTBANKS_MAP.put(57651, R.drawable.emoji_1f3b0);
        SOFTBANKS_MAP.put(57652, R.drawable.emoji_1f40e);
        SOFTBANKS_MAP.put(57653, R.drawable.emoji_1f6a4);
        SOFTBANKS_MAP.put(57654, R.drawable.emoji_1f6b2);
        SOFTBANKS_MAP.put(57655, R.drawable.emoji_1f6a7);
        SOFTBANKS_MAP.put(57656, R.drawable.emoji_1f6b9);
        SOFTBANKS_MAP.put(57657, R.drawable.emoji_1f6ba);
        SOFTBANKS_MAP.put(57658, R.drawable.emoji_1f6bc);
        SOFTBANKS_MAP.put(57659, R.drawable.emoji_1f489);
        SOFTBANKS_MAP.put(57660, R.drawable.emoji_1f4a4);
        SOFTBANKS_MAP.put(57661, R.drawable.emoji_26a1);
        SOFTBANKS_MAP.put(57662, R.drawable.emoji_1f460);
        SOFTBANKS_MAP.put(57663, R.drawable.emoji_1f6c0);
        SOFTBANKS_MAP.put(57664, R.drawable.emoji_1f6bd);
        SOFTBANKS_MAP.put(57665, R.drawable.emoji_1f50a);
        SOFTBANKS_MAP.put(57666, R.drawable.emoji_1f4e2);
        SOFTBANKS_MAP.put(57667, R.drawable.emoji_1f38c);
        SOFTBANKS_MAP.put(57668, R.drawable.emoji_1f50f);
        SOFTBANKS_MAP.put(57669, R.drawable.emoji_1f513);
        SOFTBANKS_MAP.put(57670, R.drawable.emoji_1f306);
        SOFTBANKS_MAP.put(57671, R.drawable.emoji_1f373);
        SOFTBANKS_MAP.put(57672, R.drawable.emoji_1f4c7);
        SOFTBANKS_MAP.put(57673, R.drawable.emoji_1f4b1);
        SOFTBANKS_MAP.put(57674, R.drawable.emoji_1f4b9);
        SOFTBANKS_MAP.put(57675, R.drawable.emoji_1f4e1);
        SOFTBANKS_MAP.put(57676, R.drawable.emoji_1f4aa);
        SOFTBANKS_MAP.put(57677, R.drawable.emoji_1f3e6);
        SOFTBANKS_MAP.put(57678, R.drawable.emoji_1f6a5);
        SOFTBANKS_MAP.put(57679, R.drawable.emoji_1f17f);
        SOFTBANKS_MAP.put(57680, R.drawable.emoji_1f68f);
        SOFTBANKS_MAP.put(57681, R.drawable.emoji_1f6bb);
        SOFTBANKS_MAP.put(57682, R.drawable.emoji_1f46e);
        SOFTBANKS_MAP.put(57683, R.drawable.emoji_1f3e3);
        SOFTBANKS_MAP.put(57684, R.drawable.emoji_1f3e7);
        SOFTBANKS_MAP.put(57685, R.drawable.emoji_1f3e5);
        SOFTBANKS_MAP.put(57686, R.drawable.emoji_1f3ea);
        SOFTBANKS_MAP.put(57687, R.drawable.emoji_1f3eb);
        SOFTBANKS_MAP.put(57688, R.drawable.emoji_1f3e8);
        SOFTBANKS_MAP.put(57689, R.drawable.emoji_1f68c);
        SOFTBANKS_MAP.put(57690, R.drawable.emoji_1f695);
        SOFTBANKS_MAP.put(57857, R.drawable.emoji_1f6b6);
        SOFTBANKS_MAP.put(57858, R.drawable.emoji_1f6a2);
        SOFTBANKS_MAP.put(57859, R.drawable.emoji_1f201);
        SOFTBANKS_MAP.put(57860, R.drawable.emoji_1f49f);
        SOFTBANKS_MAP.put(57861, R.drawable.emoji_2734);
        SOFTBANKS_MAP.put(57862, R.drawable.emoji_2733);
        SOFTBANKS_MAP.put(57863, R.drawable.emoji_1f51e);
        SOFTBANKS_MAP.put(57864, R.drawable.emoji_1f6ad);
        SOFTBANKS_MAP.put(57865, R.drawable.emoji_1f530);
        SOFTBANKS_MAP.put(57866, R.drawable.emoji_267f);
        SOFTBANKS_MAP.put(57867, R.drawable.emoji_1f4f6);
        SOFTBANKS_MAP.put(57868, R.drawable.emoji_2665);
        SOFTBANKS_MAP.put(57869, R.drawable.emoji_2666);
        SOFTBANKS_MAP.put(57870, R.drawable.emoji_2660);
        SOFTBANKS_MAP.put(57871, R.drawable.emoji_2663);
        SOFTBANKS_MAP.put(57872, R.drawable.emoji_0023);
        SOFTBANKS_MAP.put(57873, R.drawable.emoji_27bf);
        SOFTBANKS_MAP.put(57874, R.drawable.emoji_1f195);
        SOFTBANKS_MAP.put(57875, R.drawable.emoji_1f199);
        SOFTBANKS_MAP.put(57876, R.drawable.emoji_1f192);
        SOFTBANKS_MAP.put(57877, R.drawable.emoji_1f236);
        SOFTBANKS_MAP.put(57878, R.drawable.emoji_1f21a);
        SOFTBANKS_MAP.put(57879, R.drawable.emoji_1f237);
        SOFTBANKS_MAP.put(57880, R.drawable.emoji_1f238);
        SOFTBANKS_MAP.put(57881, R.drawable.emoji_1f534);
        SOFTBANKS_MAP.put(57882, R.drawable.emoji_1f532);
        SOFTBANKS_MAP.put(57883, R.drawable.emoji_1f533);
        SOFTBANKS_MAP.put(57884, R.drawable.emoji_0031);
        SOFTBANKS_MAP.put(57885, R.drawable.emoji_0032);
        SOFTBANKS_MAP.put(57886, R.drawable.emoji_0033);
        SOFTBANKS_MAP.put(57887, R.drawable.emoji_0034);
        SOFTBANKS_MAP.put(57888, R.drawable.emoji_0035);
        SOFTBANKS_MAP.put(57889, R.drawable.emoji_0036);
        SOFTBANKS_MAP.put(57890, R.drawable.emoji_0037);
        SOFTBANKS_MAP.put(57891, R.drawable.emoji_0038);
        SOFTBANKS_MAP.put(57892, R.drawable.emoji_0039);
        SOFTBANKS_MAP.put(57893, R.drawable.emoji_0030);
        SOFTBANKS_MAP.put(57894, R.drawable.emoji_1f250);
        SOFTBANKS_MAP.put(57895, R.drawable.emoji_1f239);
        SOFTBANKS_MAP.put(57896, R.drawable.emoji_1f202);
        SOFTBANKS_MAP.put(57897, R.drawable.emoji_1f194);
        SOFTBANKS_MAP.put(57898, R.drawable.emoji_1f235);
        SOFTBANKS_MAP.put(57899, R.drawable.emoji_1f233);
        SOFTBANKS_MAP.put(57900, R.drawable.emoji_1f22f);
        SOFTBANKS_MAP.put(57901, R.drawable.emoji_1f23a);
        SOFTBANKS_MAP.put(57902, R.drawable.emoji_1f446);
        SOFTBANKS_MAP.put(57903, R.drawable.emoji_1f447);
        SOFTBANKS_MAP.put(57904, R.drawable.emoji_1f448);
        SOFTBANKS_MAP.put(57905, R.drawable.emoji_1f449);
        SOFTBANKS_MAP.put(57906, R.drawable.emoji_2b06);
        SOFTBANKS_MAP.put(57907, R.drawable.emoji_2b07);
        SOFTBANKS_MAP.put(57908, R.drawable.emoji_27a1);
        SOFTBANKS_MAP.put(57909, R.drawable.emoji_1f519);
        SOFTBANKS_MAP.put(57910, R.drawable.emoji_2197);
        SOFTBANKS_MAP.put(57911, R.drawable.emoji_2196);
        SOFTBANKS_MAP.put(57912, R.drawable.emoji_2198);
        SOFTBANKS_MAP.put(57913, R.drawable.emoji_2199);
        SOFTBANKS_MAP.put(57914, R.drawable.emoji_25b6);
        SOFTBANKS_MAP.put(57915, R.drawable.emoji_25c0);
        SOFTBANKS_MAP.put(57916, R.drawable.emoji_23e9);
        SOFTBANKS_MAP.put(57917, R.drawable.emoji_23ea);
        SOFTBANKS_MAP.put(57918, R.drawable.emoji_1f52e);
        SOFTBANKS_MAP.put(57919, R.drawable.emoji_2648);
        SOFTBANKS_MAP.put(57920, R.drawable.emoji_2649);
        SOFTBANKS_MAP.put(57921, R.drawable.emoji_264a);
        SOFTBANKS_MAP.put(57922, R.drawable.emoji_264b);
        SOFTBANKS_MAP.put(57923, R.drawable.emoji_264c);
        SOFTBANKS_MAP.put(57924, R.drawable.emoji_264d);
        SOFTBANKS_MAP.put(57925, R.drawable.emoji_264e);
        SOFTBANKS_MAP.put(57926, R.drawable.emoji_264f);
        SOFTBANKS_MAP.put(57927, R.drawable.emoji_2650);
        SOFTBANKS_MAP.put(57928, R.drawable.emoji_2651);
        SOFTBANKS_MAP.put(57929, R.drawable.emoji_2652);
        SOFTBANKS_MAP.put(57930, R.drawable.emoji_2653);
        SOFTBANKS_MAP.put(57931, R.drawable.emoji_26ce);
        SOFTBANKS_MAP.put(57932, R.drawable.emoji_1f51d);
        SOFTBANKS_MAP.put(57933, R.drawable.emoji_1f197);
        SOFTBANKS_MAP.put(57934, R.drawable.emoji_00a9);
        SOFTBANKS_MAP.put(57935, R.drawable.emoji_00ae);
        SOFTBANKS_MAP.put(57936, R.drawable.emoji_1f4f3);
        SOFTBANKS_MAP.put(57937, R.drawable.emoji_1f4f4);
        SOFTBANKS_MAP.put(57938, R.drawable.emoji_26a0);
        SOFTBANKS_MAP.put(57939, R.drawable.emoji_1f481);
        SOFTBANKS_MAP.put(58113, R.drawable.emoji_1f4c3);
        SOFTBANKS_MAP.put(58114, R.drawable.emoji_1f454);
        SOFTBANKS_MAP.put(58115, R.drawable.emoji_1f33a);
        SOFTBANKS_MAP.put(58116, R.drawable.emoji_1f337);
        SOFTBANKS_MAP.put(58117, R.drawable.emoji_1f33b);
        SOFTBANKS_MAP.put(58118, R.drawable.emoji_1f490);
        SOFTBANKS_MAP.put(58119, R.drawable.emoji_1f334);
        SOFTBANKS_MAP.put(58120, R.drawable.emoji_1f335);
        SOFTBANKS_MAP.put(58121, R.drawable.emoji_1f6be);
        SOFTBANKS_MAP.put(58122, R.drawable.emoji_1f3a7);
        SOFTBANKS_MAP.put(58123, R.drawable.emoji_1f376);
        SOFTBANKS_MAP.put(58124, R.drawable.emoji_1f37b);
        SOFTBANKS_MAP.put(58125, R.drawable.emoji_3297);
        SOFTBANKS_MAP.put(58126, R.drawable.emoji_1f6ac);
        SOFTBANKS_MAP.put(58127, R.drawable.emoji_1f48a);
        SOFTBANKS_MAP.put(58128, R.drawable.emoji_1f388);
        SOFTBANKS_MAP.put(58129, R.drawable.emoji_1f4a3);
        SOFTBANKS_MAP.put(58130, R.drawable.emoji_1f389);
        SOFTBANKS_MAP.put(58131, R.drawable.emoji_2702);
        SOFTBANKS_MAP.put(58132, R.drawable.emoji_1f380);
        SOFTBANKS_MAP.put(58133, R.drawable.emoji_3299);
        SOFTBANKS_MAP.put(58134, R.drawable.emoji_1f4bd);
        SOFTBANKS_MAP.put(58135, R.drawable.emoji_1f4e3);
        SOFTBANKS_MAP.put(58136, R.drawable.emoji_1f452);
        SOFTBANKS_MAP.put(58137, R.drawable.emoji_1f457);
        SOFTBANKS_MAP.put(58138, R.drawable.emoji_1f461);
        SOFTBANKS_MAP.put(58139, R.drawable.emoji_1f462);
        SOFTBANKS_MAP.put(58140, R.drawable.emoji_1f484);
        SOFTBANKS_MAP.put(58141, R.drawable.emoji_1f485);
        SOFTBANKS_MAP.put(58142, R.drawable.emoji_1f486);
        SOFTBANKS_MAP.put(58143, R.drawable.emoji_1f487);
        SOFTBANKS_MAP.put(58144, R.drawable.emoji_1f488);
        SOFTBANKS_MAP.put(58145, R.drawable.emoji_1f458);
        SOFTBANKS_MAP.put(58146, R.drawable.emoji_1f459);
        SOFTBANKS_MAP.put(58147, R.drawable.emoji_1f45c);
        SOFTBANKS_MAP.put(58148, R.drawable.emoji_1f3ac);
        SOFTBANKS_MAP.put(58149, R.drawable.emoji_1f514);
        SOFTBANKS_MAP.put(58150, R.drawable.emoji_1f3b6);
        SOFTBANKS_MAP.put(58151, R.drawable.emoji_1f493);
        SOFTBANKS_MAP.put(58152, R.drawable.emoji_1f48c);
        SOFTBANKS_MAP.put(58153, R.drawable.emoji_1f498);
        SOFTBANKS_MAP.put(58154, R.drawable.emoji_1f499);
        SOFTBANKS_MAP.put(58155, R.drawable.emoji_1f49a);
        SOFTBANKS_MAP.put(58156, R.drawable.emoji_1f49b);
        SOFTBANKS_MAP.put(58157, R.drawable.emoji_1f49c);
        SOFTBANKS_MAP.put(58158, R.drawable.emoji_2728);
        SOFTBANKS_MAP.put(58159, R.drawable.emoji_2b50);
        SOFTBANKS_MAP.put(58160, R.drawable.emoji_1f4a8);
        SOFTBANKS_MAP.put(58161, R.drawable.emoji_1f4a6);
        SOFTBANKS_MAP.put(58162, R.drawable.emoji_2b55);
        SOFTBANKS_MAP.put(58163, R.drawable.emoji_2716);
        SOFTBANKS_MAP.put(58164, R.drawable.emoji_1f4a2);
        SOFTBANKS_MAP.put(58165, R.drawable.emoji_1f31f);
        SOFTBANKS_MAP.put(58166, R.drawable.emoji_2754);
        SOFTBANKS_MAP.put(58167, R.drawable.emoji_2755);
        SOFTBANKS_MAP.put(58168, R.drawable.emoji_1f375);
        SOFTBANKS_MAP.put(58169, R.drawable.emoji_1f35e);
        SOFTBANKS_MAP.put(58170, R.drawable.emoji_1f366);
        SOFTBANKS_MAP.put(58171, R.drawable.emoji_1f35f);
        SOFTBANKS_MAP.put(58172, R.drawable.emoji_1f361);
        SOFTBANKS_MAP.put(58173, R.drawable.emoji_1f358);
        SOFTBANKS_MAP.put(58174, R.drawable.emoji_1f35a);
        SOFTBANKS_MAP.put(58175, R.drawable.emoji_1f35d);
        SOFTBANKS_MAP.put(58176, R.drawable.emoji_1f35c);
        SOFTBANKS_MAP.put(58177, R.drawable.emoji_1f35b);
        SOFTBANKS_MAP.put(58178, R.drawable.emoji_1f359);
        SOFTBANKS_MAP.put(58179, R.drawable.emoji_1f362);
        SOFTBANKS_MAP.put(58180, R.drawable.emoji_1f363);
        SOFTBANKS_MAP.put(58181, R.drawable.emoji_1f34e);
        SOFTBANKS_MAP.put(58182, R.drawable.emoji_1f34a);
        SOFTBANKS_MAP.put(58183, R.drawable.emoji_1f353);
        SOFTBANKS_MAP.put(58184, R.drawable.emoji_1f349);
        SOFTBANKS_MAP.put(58185, R.drawable.emoji_1f345);
        SOFTBANKS_MAP.put(58186, R.drawable.emoji_1f346);
        SOFTBANKS_MAP.put(58187, R.drawable.emoji_1f382);
        SOFTBANKS_MAP.put(58188, R.drawable.emoji_1f371);
        SOFTBANKS_MAP.put(58189, R.drawable.emoji_1f372);
        SOFTBANKS_MAP.put(58369, R.drawable.emoji_1f625);
        SOFTBANKS_MAP.put(58370, R.drawable.emoji_1f60f);
        SOFTBANKS_MAP.put(58371, R.drawable.emoji_1f614);
        SOFTBANKS_MAP.put(58372, R.drawable.emoji_1f601);
        SOFTBANKS_MAP.put(58373, R.drawable.emoji_1f609);
        SOFTBANKS_MAP.put(58374, R.drawable.emoji_1f623);
        SOFTBANKS_MAP.put(58375, R.drawable.emoji_1f616);
        SOFTBANKS_MAP.put(58376, R.drawable.emoji_1f62a);
        SOFTBANKS_MAP.put(58377, R.drawable.emoji_1f445);
        SOFTBANKS_MAP.put(58378, R.drawable.emoji_1f606);
        SOFTBANKS_MAP.put(58379, R.drawable.emoji_1f628);
        SOFTBANKS_MAP.put(58380, R.drawable.emoji_1f637);
        SOFTBANKS_MAP.put(58381, R.drawable.emoji_1f633);
        SOFTBANKS_MAP.put(58382, R.drawable.emoji_1f612);
        SOFTBANKS_MAP.put(58383, R.drawable.emoji_1f630);
        SOFTBANKS_MAP.put(58384, R.drawable.emoji_1f632);
        SOFTBANKS_MAP.put(58385, R.drawable.emoji_1f62d);
        SOFTBANKS_MAP.put(58386, R.drawable.emoji_1f602);
        SOFTBANKS_MAP.put(58387, R.drawable.emoji_1f622);
        SOFTBANKS_MAP.put(58388, R.drawable.emoji_263a);
        SOFTBANKS_MAP.put(58389, R.drawable.emoji_1f605);
        SOFTBANKS_MAP.put(58390, R.drawable.emoji_1f621);
        SOFTBANKS_MAP.put(58391, R.drawable.emoji_1f61a);
        SOFTBANKS_MAP.put(58392, R.drawable.emoji_1f618);
        SOFTBANKS_MAP.put(58393, R.drawable.emoji_1f440);
        SOFTBANKS_MAP.put(58394, R.drawable.emoji_1f443);
        SOFTBANKS_MAP.put(58395, R.drawable.emoji_1f442);
        SOFTBANKS_MAP.put(58396, R.drawable.emoji_1f444);
        SOFTBANKS_MAP.put(58397, R.drawable.emoji_1f64f);
        SOFTBANKS_MAP.put(58398, R.drawable.emoji_1f44b);
        SOFTBANKS_MAP.put(58399, R.drawable.emoji_1f44f);
        SOFTBANKS_MAP.put(58400, R.drawable.emoji_1f44c);
        SOFTBANKS_MAP.put(58401, R.drawable.emoji_1f44e);
        SOFTBANKS_MAP.put(58402, R.drawable.emoji_1f450);
        SOFTBANKS_MAP.put(58403, R.drawable.emoji_1f645);
        SOFTBANKS_MAP.put(58404, R.drawable.emoji_1f646);
        SOFTBANKS_MAP.put(58405, R.drawable.emoji_1f491);
        SOFTBANKS_MAP.put(58406, R.drawable.emoji_1f647);
        SOFTBANKS_MAP.put(58407, R.drawable.emoji_1f64c);
        SOFTBANKS_MAP.put(58408, R.drawable.emoji_1f46b);
        SOFTBANKS_MAP.put(58409, R.drawable.emoji_1f46f);
        SOFTBANKS_MAP.put(58410, R.drawable.emoji_1f3c0);
        SOFTBANKS_MAP.put(58411, R.drawable.emoji_1f3c8);
        SOFTBANKS_MAP.put(58412, R.drawable.emoji_1f3b1);
        SOFTBANKS_MAP.put(58413, R.drawable.emoji_1f3ca);
        SOFTBANKS_MAP.put(58414, R.drawable.emoji_1f699);
        SOFTBANKS_MAP.put(58415, R.drawable.emoji_1f69a);
        SOFTBANKS_MAP.put(58416, R.drawable.emoji_1f692);
        SOFTBANKS_MAP.put(58417, R.drawable.emoji_1f691);
        SOFTBANKS_MAP.put(58418, R.drawable.emoji_1f693);
        SOFTBANKS_MAP.put(58419, R.drawable.emoji_1f3a2);
        SOFTBANKS_MAP.put(58420, R.drawable.emoji_1f687);
        SOFTBANKS_MAP.put(58421, R.drawable.emoji_1f684);
        SOFTBANKS_MAP.put(58422, R.drawable.emoji_1f38d);
        SOFTBANKS_MAP.put(58423, R.drawable.emoji_1f49d);
        SOFTBANKS_MAP.put(58424, R.drawable.emoji_1f38e);
        SOFTBANKS_MAP.put(58425, R.drawable.emoji_1f393);
        SOFTBANKS_MAP.put(58426, R.drawable.emoji_1f392);
        SOFTBANKS_MAP.put(58427, R.drawable.emoji_1f38f);
        SOFTBANKS_MAP.put(58428, R.drawable.emoji_1f302);
        SOFTBANKS_MAP.put(58429, R.drawable.emoji_1f492);
        SOFTBANKS_MAP.put(58430, R.drawable.emoji_1f30a);
        SOFTBANKS_MAP.put(58431, R.drawable.emoji_1f367);
        SOFTBANKS_MAP.put(58432, R.drawable.emoji_1f387);
        SOFTBANKS_MAP.put(58433, R.drawable.emoji_1f41a);
        SOFTBANKS_MAP.put(58434, R.drawable.emoji_1f390);
        SOFTBANKS_MAP.put(58435, R.drawable.emoji_1f300);
        SOFTBANKS_MAP.put(58436, R.drawable.emoji_1f33e);
        SOFTBANKS_MAP.put(58437, R.drawable.emoji_1f383);
        SOFTBANKS_MAP.put(58438, R.drawable.emoji_1f391);
        SOFTBANKS_MAP.put(58439, R.drawable.emoji_1f343);
        SOFTBANKS_MAP.put(58440, R.drawable.emoji_1f385);
        SOFTBANKS_MAP.put(58441, R.drawable.emoji_1f305);
        SOFTBANKS_MAP.put(58442, R.drawable.emoji_1f307);
        SOFTBANKS_MAP.put(58443, R.drawable.emoji_1f303);
        SOFTBANKS_MAP.put(58443, R.drawable.emoji_1f30c);
        SOFTBANKS_MAP.put(58444, R.drawable.emoji_1f308);
        SOFTBANKS_MAP.put(58625, R.drawable.emoji_1f3e9);
        SOFTBANKS_MAP.put(58626, R.drawable.emoji_1f3a8);
        SOFTBANKS_MAP.put(58627, R.drawable.emoji_1f3a9);
        SOFTBANKS_MAP.put(58628, R.drawable.emoji_1f3ec);
        SOFTBANKS_MAP.put(58629, R.drawable.emoji_1f3ef);
        SOFTBANKS_MAP.put(58630, R.drawable.emoji_1f3f0);
        SOFTBANKS_MAP.put(58631, R.drawable.emoji_1f3a6);
        SOFTBANKS_MAP.put(58632, R.drawable.emoji_1f3ed);
        SOFTBANKS_MAP.put(58633, R.drawable.emoji_1f5fc);
        SOFTBANKS_MAP.put(58635, R.drawable.emoji_1f1ef_1f1f5);
        SOFTBANKS_MAP.put(58636, R.drawable.emoji_1f1fa_1f1f8);
        SOFTBANKS_MAP.put(58637, R.drawable.emoji_1f1eb_1f1f7);
        SOFTBANKS_MAP.put(58638, R.drawable.emoji_1f1e9_1f1ea);
        SOFTBANKS_MAP.put(58639, R.drawable.emoji_1f1ee_1f1f9);
        SOFTBANKS_MAP.put(58640, R.drawable.emoji_1f1ec_1f1e7);
        SOFTBANKS_MAP.put(58641, R.drawable.emoji_1f1ea_1f1f8);
        SOFTBANKS_MAP.put(58642, R.drawable.emoji_1f1f7_1f1fa);
        SOFTBANKS_MAP.put(58643, R.drawable.emoji_1f1e8_1f1f3);
        SOFTBANKS_MAP.put(58644, R.drawable.emoji_1f1f0_1f1f7);
        SOFTBANKS_MAP.put(58645, R.drawable.emoji_1f471);
        SOFTBANKS_MAP.put(58646, R.drawable.emoji_1f472);
        SOFTBANKS_MAP.put(58647, R.drawable.emoji_1f473);
        SOFTBANKS_MAP.put(58648, R.drawable.emoji_1f474);
        SOFTBANKS_MAP.put(58649, R.drawable.emoji_1f475);
        SOFTBANKS_MAP.put(58650, R.drawable.emoji_1f476);
        SOFTBANKS_MAP.put(58651, R.drawable.emoji_1f477);
        SOFTBANKS_MAP.put(58652, R.drawable.emoji_1f478);
        SOFTBANKS_MAP.put(58653, R.drawable.emoji_1f5fd);
        SOFTBANKS_MAP.put(58654, R.drawable.emoji_1f482);
        SOFTBANKS_MAP.put(58655, R.drawable.emoji_1f483);
        SOFTBANKS_MAP.put(58656, R.drawable.emoji_1f42c);
        SOFTBANKS_MAP.put(58657, R.drawable.emoji_1f426);
        SOFTBANKS_MAP.put(58658, R.drawable.emoji_1f420);
        SOFTBANKS_MAP.put(58659, R.drawable.emoji_1f423);
        SOFTBANKS_MAP.put(58660, R.drawable.emoji_1f439);
        SOFTBANKS_MAP.put(58661, R.drawable.emoji_1f41b);
        SOFTBANKS_MAP.put(58662, R.drawable.emoji_1f418);
        SOFTBANKS_MAP.put(58663, R.drawable.emoji_1f428);
        SOFTBANKS_MAP.put(58664, R.drawable.emoji_1f412);
        SOFTBANKS_MAP.put(58665, R.drawable.emoji_1f411);
        SOFTBANKS_MAP.put(58666, R.drawable.emoji_1f43a);
        SOFTBANKS_MAP.put(58667, R.drawable.emoji_1f42e);
        SOFTBANKS_MAP.put(58668, R.drawable.emoji_1f430);
        SOFTBANKS_MAP.put(58669, R.drawable.emoji_1f40d);
        SOFTBANKS_MAP.put(58670, R.drawable.emoji_1f414);
        SOFTBANKS_MAP.put(58671, R.drawable.emoji_1f417);
        SOFTBANKS_MAP.put(58672, R.drawable.emoji_1f42b);
        SOFTBANKS_MAP.put(58673, R.drawable.emoji_1f438);
        SOFTBANKS_MAP.put(58674, R.drawable.emoji_1f170);
        SOFTBANKS_MAP.put(58675, R.drawable.emoji_1f171);
        SOFTBANKS_MAP.put(58676, R.drawable.emoji_1f18e);
        SOFTBANKS_MAP.put(58677, R.drawable.emoji_1f17e);
        SOFTBANKS_MAP.put(58678, R.drawable.emoji_1f43e);
        SOFTBANKS_MAP.put(58679, R.drawable.emoji_2122);
        EMOJIS_MAP.put(128516, R.drawable.emoji_1f604);
        EMOJIS_MAP.put(128515, R.drawable.emoji_1f603);
        EMOJIS_MAP.put(128512, R.drawable.emoji_1f600);
        EMOJIS_MAP.put(128522, R.drawable.emoji_1f60a);
        EMOJIS_MAP.put(9786, R.drawable.emoji_263a);
        EMOJIS_MAP.put(128521, R.drawable.emoji_1f609);
        EMOJIS_MAP.put(128525, R.drawable.emoji_1f60d);
        EMOJIS_MAP.put(128536, R.drawable.emoji_1f618);
        EMOJIS_MAP.put(128538, R.drawable.emoji_1f61a);
        EMOJIS_MAP.put(128535, R.drawable.emoji_1f617);
        EMOJIS_MAP.put(128537, R.drawable.emoji_1f619);
        EMOJIS_MAP.put(128540, R.drawable.emoji_1f61c);
        EMOJIS_MAP.put(128541, R.drawable.emoji_1f61d);
        EMOJIS_MAP.put(128539, R.drawable.emoji_1f61b);
        EMOJIS_MAP.put(128563, R.drawable.emoji_1f633);
        EMOJIS_MAP.put(128513, R.drawable.emoji_1f601);
        EMOJIS_MAP.put(128532, R.drawable.emoji_1f614);
        EMOJIS_MAP.put(128524, R.drawable.emoji_1f60c);
        EMOJIS_MAP.put(128530, R.drawable.emoji_1f612);
        EMOJIS_MAP.put(128542, R.drawable.emoji_1f61e);
        EMOJIS_MAP.put(128547, R.drawable.emoji_1f623);
        EMOJIS_MAP.put(128546, R.drawable.emoji_1f622);
        EMOJIS_MAP.put(128514, R.drawable.emoji_1f602);
        EMOJIS_MAP.put(128557, R.drawable.emoji_1f62d);
        EMOJIS_MAP.put(128554, R.drawable.emoji_1f62a);
        EMOJIS_MAP.put(128549, R.drawable.emoji_1f625);
        EMOJIS_MAP.put(128560, R.drawable.emoji_1f630);
        EMOJIS_MAP.put(128517, R.drawable.emoji_1f605);
        EMOJIS_MAP.put(128531, R.drawable.emoji_1f613);
        EMOJIS_MAP.put(128553, R.drawable.emoji_1f629);
        EMOJIS_MAP.put(128555, R.drawable.emoji_1f62b);
        EMOJIS_MAP.put(128552, R.drawable.emoji_1f628);
        EMOJIS_MAP.put(128561, R.drawable.emoji_1f631);
        EMOJIS_MAP.put(128544, R.drawable.emoji_1f620);
        EMOJIS_MAP.put(128545, R.drawable.emoji_1f621);
        EMOJIS_MAP.put(128548, R.drawable.emoji_1f624);
        EMOJIS_MAP.put(128534, R.drawable.emoji_1f616);
        EMOJIS_MAP.put(128518, R.drawable.emoji_1f606);
        EMOJIS_MAP.put(128523, R.drawable.emoji_1f60b);
        EMOJIS_MAP.put(128567, R.drawable.emoji_1f637);
        EMOJIS_MAP.put(128526, R.drawable.emoji_1f60e);
        EMOJIS_MAP.put(128564, R.drawable.emoji_1f634);
        EMOJIS_MAP.put(128565, R.drawable.emoji_1f635);
        EMOJIS_MAP.put(128562, R.drawable.emoji_1f632);
        EMOJIS_MAP.put(128543, R.drawable.emoji_1f61f);
        EMOJIS_MAP.put(128550, R.drawable.emoji_1f626);
        EMOJIS_MAP.put(128551, R.drawable.emoji_1f627);
        EMOJIS_MAP.put(128520, R.drawable.emoji_1f608);
        EMOJIS_MAP.put(128127, R.drawable.emoji_1f47f);
        EMOJIS_MAP.put(128558, R.drawable.emoji_1f62e);
        EMOJIS_MAP.put(128556, R.drawable.emoji_1f62c);
        EMOJIS_MAP.put(128528, R.drawable.emoji_1f610);
        EMOJIS_MAP.put(128533, R.drawable.emoji_1f615);
        EMOJIS_MAP.put(128559, R.drawable.emoji_1f62f);
        EMOJIS_MAP.put(128566, R.drawable.emoji_1f636);
        EMOJIS_MAP.put(128519, R.drawable.emoji_1f607);
        EMOJIS_MAP.put(128527, R.drawable.emoji_1f60f);
        EMOJIS_MAP.put(128529, R.drawable.emoji_1f611);
        EMOJIS_MAP.put(128114, R.drawable.emoji_1f472);
        EMOJIS_MAP.put(128115, R.drawable.emoji_1f473);
        EMOJIS_MAP.put(128110, R.drawable.emoji_1f46e);
        EMOJIS_MAP.put(128119, R.drawable.emoji_1f477);
        EMOJIS_MAP.put(128130, R.drawable.emoji_1f482);
        EMOJIS_MAP.put(128118, R.drawable.emoji_1f476);
        EMOJIS_MAP.put(128102, R.drawable.emoji_1f466);
        EMOJIS_MAP.put(128103, R.drawable.emoji_1f467);
        EMOJIS_MAP.put(128104, R.drawable.emoji_1f468);
        EMOJIS_MAP.put(128105, R.drawable.emoji_1f469);
        EMOJIS_MAP.put(128116, R.drawable.emoji_1f474);
        EMOJIS_MAP.put(128117, R.drawable.emoji_1f475);
        EMOJIS_MAP.put(128113, R.drawable.emoji_1f471);
        EMOJIS_MAP.put(128124, R.drawable.emoji_1f47c);
        EMOJIS_MAP.put(128120, R.drawable.emoji_1f478);
        EMOJIS_MAP.put(128570, R.drawable.emoji_1f63a);
        EMOJIS_MAP.put(128568, R.drawable.emoji_1f638);
        EMOJIS_MAP.put(128571, R.drawable.emoji_1f63b);
        EMOJIS_MAP.put(128573, R.drawable.emoji_1f63d);
        EMOJIS_MAP.put(128572, R.drawable.emoji_1f63c);
        EMOJIS_MAP.put(128576, R.drawable.emoji_1f640);
        EMOJIS_MAP.put(128575, R.drawable.emoji_1f63f);
        EMOJIS_MAP.put(128569, R.drawable.emoji_1f639);
        EMOJIS_MAP.put(128574, R.drawable.emoji_1f63e);
        EMOJIS_MAP.put(128121, R.drawable.emoji_1f479);
        EMOJIS_MAP.put(128122, R.drawable.emoji_1f47a);
        EMOJIS_MAP.put(128584, R.drawable.emoji_1f648);
        EMOJIS_MAP.put(128585, R.drawable.emoji_1f649);
        EMOJIS_MAP.put(128586, R.drawable.emoji_1f64a);
        EMOJIS_MAP.put(128128, R.drawable.emoji_1f480);
        EMOJIS_MAP.put(128125, R.drawable.emoji_1f47d);
        EMOJIS_MAP.put(128169, R.drawable.emoji_1f4a9);
        EMOJIS_MAP.put(128293, R.drawable.emoji_1f525);
        EMOJIS_MAP.put(10024, R.drawable.emoji_2728);
        EMOJIS_MAP.put(127775, R.drawable.emoji_1f31f);
        EMOJIS_MAP.put(128171, R.drawable.emoji_1f4ab);
        EMOJIS_MAP.put(128165, R.drawable.emoji_1f4a5);
        EMOJIS_MAP.put(128162, R.drawable.emoji_1f4a2);
        EMOJIS_MAP.put(128166, R.drawable.emoji_1f4a6);
        EMOJIS_MAP.put(128167, R.drawable.emoji_1f4a7);
        EMOJIS_MAP.put(128164, R.drawable.emoji_1f4a4);
        EMOJIS_MAP.put(128168, R.drawable.emoji_1f4a8);
        EMOJIS_MAP.put(128066, R.drawable.emoji_1f442);
        EMOJIS_MAP.put(128064, R.drawable.emoji_1f440);
        EMOJIS_MAP.put(128067, R.drawable.emoji_1f443);
        EMOJIS_MAP.put(128069, R.drawable.emoji_1f445);
        EMOJIS_MAP.put(128068, R.drawable.emoji_1f444);
        EMOJIS_MAP.put(128077, R.drawable.emoji_1f44d);
        EMOJIS_MAP.put(128078, R.drawable.emoji_1f44e);
        EMOJIS_MAP.put(128076, R.drawable.emoji_1f44c);
        EMOJIS_MAP.put(128074, R.drawable.emoji_1f44a);
        EMOJIS_MAP.put(9994, R.drawable.emoji_270a);
        EMOJIS_MAP.put(9996, R.drawable.emoji_270c);
        EMOJIS_MAP.put(128075, R.drawable.emoji_1f44b);
        EMOJIS_MAP.put(9995, R.drawable.emoji_270b);
        EMOJIS_MAP.put(128080, R.drawable.emoji_1f450);
        EMOJIS_MAP.put(128070, R.drawable.emoji_1f446);
        EMOJIS_MAP.put(128071, R.drawable.emoji_1f447);
        EMOJIS_MAP.put(128073, R.drawable.emoji_1f449);
        EMOJIS_MAP.put(128072, R.drawable.emoji_1f448);
        EMOJIS_MAP.put(128588, R.drawable.emoji_1f64c);
        EMOJIS_MAP.put(128591, R.drawable.emoji_1f64f);
        EMOJIS_MAP.put(9757, R.drawable.emoji_261d);
        EMOJIS_MAP.put(128079, R.drawable.emoji_1f44f);
        EMOJIS_MAP.put(128170, R.drawable.emoji_1f4aa);
        EMOJIS_MAP.put(128694, R.drawable.emoji_1f6b6);
        EMOJIS_MAP.put(127939, R.drawable.emoji_1f3c3);
        EMOJIS_MAP.put(128131, R.drawable.emoji_1f483);
        EMOJIS_MAP.put(128107, R.drawable.emoji_1f46b);
        EMOJIS_MAP.put(128106, R.drawable.emoji_1f46a);
        EMOJIS_MAP.put(128108, R.drawable.emoji_1f46c);
        EMOJIS_MAP.put(128109, R.drawable.emoji_1f46d);
        EMOJIS_MAP.put(128143, R.drawable.emoji_1f48f);
        EMOJIS_MAP.put(128145, R.drawable.emoji_1f491);
        EMOJIS_MAP.put(128111, R.drawable.emoji_1f46f);
        EMOJIS_MAP.put(128582, R.drawable.emoji_1f646);
        EMOJIS_MAP.put(128581, R.drawable.emoji_1f645);
        EMOJIS_MAP.put(128129, R.drawable.emoji_1f481);
        EMOJIS_MAP.put(128587, R.drawable.emoji_1f64b);
        EMOJIS_MAP.put(128134, R.drawable.emoji_1f486);
        EMOJIS_MAP.put(128135, R.drawable.emoji_1f487);
        EMOJIS_MAP.put(128133, R.drawable.emoji_1f485);
        EMOJIS_MAP.put(128112, R.drawable.emoji_1f470);
        EMOJIS_MAP.put(128590, R.drawable.emoji_1f64e);
        EMOJIS_MAP.put(128589, R.drawable.emoji_1f64d);
        EMOJIS_MAP.put(128583, R.drawable.emoji_1f647);
        EMOJIS_MAP.put(127913, R.drawable.emoji_1f3a9);
        EMOJIS_MAP.put(128081, R.drawable.emoji_1f451);
        EMOJIS_MAP.put(128082, R.drawable.emoji_1f452);
        EMOJIS_MAP.put(128095, R.drawable.emoji_1f45f);
        EMOJIS_MAP.put(128094, R.drawable.emoji_1f45e);
        EMOJIS_MAP.put(128097, R.drawable.emoji_1f461);
        EMOJIS_MAP.put(128096, R.drawable.emoji_1f460);
        EMOJIS_MAP.put(128098, R.drawable.emoji_1f462);
        EMOJIS_MAP.put(128085, R.drawable.emoji_1f455);
        EMOJIS_MAP.put(128084, R.drawable.emoji_1f454);
        EMOJIS_MAP.put(128090, R.drawable.emoji_1f45a);
        EMOJIS_MAP.put(128087, R.drawable.emoji_1f457);
        EMOJIS_MAP.put(127933, R.drawable.emoji_1f3bd);
        EMOJIS_MAP.put(128086, R.drawable.emoji_1f456);
        EMOJIS_MAP.put(128088, R.drawable.emoji_1f458);
        EMOJIS_MAP.put(128089, R.drawable.emoji_1f459);
        EMOJIS_MAP.put(128188, R.drawable.emoji_1f4bc);
        EMOJIS_MAP.put(128092, R.drawable.emoji_1f45c);
        EMOJIS_MAP.put(128093, R.drawable.emoji_1f45d);
        EMOJIS_MAP.put(128091, R.drawable.emoji_1f45b);
        EMOJIS_MAP.put(128083, R.drawable.emoji_1f453);
        EMOJIS_MAP.put(127872, R.drawable.emoji_1f380);
        EMOJIS_MAP.put(127746, R.drawable.emoji_1f302);
        EMOJIS_MAP.put(128132, R.drawable.emoji_1f484);
        EMOJIS_MAP.put(128155, R.drawable.emoji_1f49b);
        EMOJIS_MAP.put(128153, R.drawable.emoji_1f499);
        EMOJIS_MAP.put(128156, R.drawable.emoji_1f49c);
        EMOJIS_MAP.put(128154, R.drawable.emoji_1f49a);
        EMOJIS_MAP.put(10084, R.drawable.emoji_2764);
        EMOJIS_MAP.put(128148, R.drawable.emoji_1f494);
        EMOJIS_MAP.put(128151, R.drawable.emoji_1f497);
        EMOJIS_MAP.put(128147, R.drawable.emoji_1f493);
        EMOJIS_MAP.put(128149, R.drawable.emoji_1f495);
        EMOJIS_MAP.put(128150, R.drawable.emoji_1f496);
        EMOJIS_MAP.put(128158, R.drawable.emoji_1f49e);
        EMOJIS_MAP.put(128152, R.drawable.emoji_1f498);
        EMOJIS_MAP.put(128140, R.drawable.emoji_1f48c);
        EMOJIS_MAP.put(128139, R.drawable.emoji_1f48b);
        EMOJIS_MAP.put(128141, R.drawable.emoji_1f48d);
        EMOJIS_MAP.put(128142, R.drawable.emoji_1f48e);
        EMOJIS_MAP.put(128100, R.drawable.emoji_1f464);
        EMOJIS_MAP.put(128101, R.drawable.emoji_1f465);
        EMOJIS_MAP.put(128172, R.drawable.emoji_1f4ac);
        EMOJIS_MAP.put(128099, R.drawable.emoji_1f463);
        EMOJIS_MAP.put(128173, R.drawable.emoji_1f4ad);
        EMOJIS_MAP.put(128054, R.drawable.emoji_1f436);
        EMOJIS_MAP.put(128058, R.drawable.emoji_1f43a);
        EMOJIS_MAP.put(128049, R.drawable.emoji_1f431);
        EMOJIS_MAP.put(128045, R.drawable.emoji_1f42d);
        EMOJIS_MAP.put(128057, R.drawable.emoji_1f439);
        EMOJIS_MAP.put(128048, R.drawable.emoji_1f430);
        EMOJIS_MAP.put(128056, R.drawable.emoji_1f438);
        EMOJIS_MAP.put(128047, R.drawable.emoji_1f42f);
        EMOJIS_MAP.put(128040, R.drawable.emoji_1f428);
        EMOJIS_MAP.put(128059, R.drawable.emoji_1f43b);
        EMOJIS_MAP.put(128055, R.drawable.emoji_1f437);
        EMOJIS_MAP.put(128061, R.drawable.emoji_1f43d);
        EMOJIS_MAP.put(128046, R.drawable.emoji_1f42e);
        EMOJIS_MAP.put(128023, R.drawable.emoji_1f417);
        EMOJIS_MAP.put(128053, R.drawable.emoji_1f435);
        EMOJIS_MAP.put(128018, R.drawable.emoji_1f412);
        EMOJIS_MAP.put(128052, R.drawable.emoji_1f434);
        EMOJIS_MAP.put(128017, R.drawable.emoji_1f411);
        EMOJIS_MAP.put(128024, R.drawable.emoji_1f418);
        EMOJIS_MAP.put(128060, R.drawable.emoji_1f43c);
        EMOJIS_MAP.put(128039, R.drawable.emoji_1f427);
        EMOJIS_MAP.put(128038, R.drawable.emoji_1f426);
        EMOJIS_MAP.put(128036, R.drawable.emoji_1f424);
        EMOJIS_MAP.put(128037, R.drawable.emoji_1f425);
        EMOJIS_MAP.put(128035, R.drawable.emoji_1f423);
        EMOJIS_MAP.put(128020, R.drawable.emoji_1f414);
        EMOJIS_MAP.put(128013, R.drawable.emoji_1f40d);
        EMOJIS_MAP.put(128034, R.drawable.emoji_1f422);
        EMOJIS_MAP.put(128027, R.drawable.emoji_1f41b);
        EMOJIS_MAP.put(128029, R.drawable.emoji_1f41d);
        EMOJIS_MAP.put(128028, R.drawable.emoji_1f41c);
        EMOJIS_MAP.put(128030, R.drawable.emoji_1f41e);
        EMOJIS_MAP.put(128012, R.drawable.emoji_1f40c);
        EMOJIS_MAP.put(128025, R.drawable.emoji_1f419);
        EMOJIS_MAP.put(128026, R.drawable.emoji_1f41a);
        EMOJIS_MAP.put(128032, R.drawable.emoji_1f420);
        EMOJIS_MAP.put(128031, R.drawable.emoji_1f41f);
        EMOJIS_MAP.put(128044, R.drawable.emoji_1f42c);
        EMOJIS_MAP.put(128051, R.drawable.emoji_1f433);
        EMOJIS_MAP.put(128011, R.drawable.emoji_1f40b);
        EMOJIS_MAP.put(128004, R.drawable.emoji_1f404);
        EMOJIS_MAP.put(128015, R.drawable.emoji_1f40f);
        EMOJIS_MAP.put(128000, R.drawable.emoji_1f400);
        EMOJIS_MAP.put(128003, R.drawable.emoji_1f403);
        EMOJIS_MAP.put(128005, R.drawable.emoji_1f405);
        EMOJIS_MAP.put(128007, R.drawable.emoji_1f407);
        EMOJIS_MAP.put(128009, R.drawable.emoji_1f409);
        EMOJIS_MAP.put(128014, R.drawable.emoji_1f40e);
        EMOJIS_MAP.put(128016, R.drawable.emoji_1f410);
        EMOJIS_MAP.put(128019, R.drawable.emoji_1f413);
        EMOJIS_MAP.put(128021, R.drawable.emoji_1f415);
        EMOJIS_MAP.put(128022, R.drawable.emoji_1f416);
        EMOJIS_MAP.put(128001, R.drawable.emoji_1f401);
        EMOJIS_MAP.put(128002, R.drawable.emoji_1f402);
        EMOJIS_MAP.put(128050, R.drawable.emoji_1f432);
        EMOJIS_MAP.put(128033, R.drawable.emoji_1f421);
        EMOJIS_MAP.put(128010, R.drawable.emoji_1f40a);
        EMOJIS_MAP.put(128043, R.drawable.emoji_1f42b);
        EMOJIS_MAP.put(128042, R.drawable.emoji_1f42a);
        EMOJIS_MAP.put(128006, R.drawable.emoji_1f406);
        EMOJIS_MAP.put(128008, R.drawable.emoji_1f408);
        EMOJIS_MAP.put(128041, R.drawable.emoji_1f429);
        EMOJIS_MAP.put(128062, R.drawable.emoji_1f43e);
        EMOJIS_MAP.put(128144, R.drawable.emoji_1f490);
        EMOJIS_MAP.put(127800, R.drawable.emoji_1f338);
        EMOJIS_MAP.put(127799, R.drawable.emoji_1f337);
        EMOJIS_MAP.put(127808, R.drawable.emoji_1f340);
        EMOJIS_MAP.put(127801, R.drawable.emoji_1f339);
        EMOJIS_MAP.put(127803, R.drawable.emoji_1f33b);
        EMOJIS_MAP.put(127802, R.drawable.emoji_1f33a);
        EMOJIS_MAP.put(127809, R.drawable.emoji_1f341);
        EMOJIS_MAP.put(127811, R.drawable.emoji_1f343);
        EMOJIS_MAP.put(127810, R.drawable.emoji_1f342);
        EMOJIS_MAP.put(127807, R.drawable.emoji_1f33f);
        EMOJIS_MAP.put(127806, R.drawable.emoji_1f33e);
        EMOJIS_MAP.put(127812, R.drawable.emoji_1f344);
        EMOJIS_MAP.put(127797, R.drawable.emoji_1f335);
        EMOJIS_MAP.put(127796, R.drawable.emoji_1f334);
        EMOJIS_MAP.put(127794, R.drawable.emoji_1f332);
        EMOJIS_MAP.put(127795, R.drawable.emoji_1f333);
        EMOJIS_MAP.put(127792, R.drawable.emoji_1f330);
        EMOJIS_MAP.put(127793, R.drawable.emoji_1f331);
        EMOJIS_MAP.put(127804, R.drawable.emoji_1f33c);
        EMOJIS_MAP.put(127760, R.drawable.emoji_1f310);
        EMOJIS_MAP.put(127774, R.drawable.emoji_1f31e);
        EMOJIS_MAP.put(127773, R.drawable.emoji_1f31d);
        EMOJIS_MAP.put(127770, R.drawable.emoji_1f31a);
        EMOJIS_MAP.put(127761, R.drawable.emoji_1f311);
        EMOJIS_MAP.put(127762, R.drawable.emoji_1f312);
        EMOJIS_MAP.put(127763, R.drawable.emoji_1f313);
        EMOJIS_MAP.put(127764, R.drawable.emoji_1f314);
        EMOJIS_MAP.put(127765, R.drawable.emoji_1f315);
        EMOJIS_MAP.put(127766, R.drawable.emoji_1f316);
        EMOJIS_MAP.put(127767, R.drawable.emoji_1f317);
        EMOJIS_MAP.put(127768, R.drawable.emoji_1f318);
        EMOJIS_MAP.put(127772, R.drawable.emoji_1f31c);
        EMOJIS_MAP.put(127771, R.drawable.emoji_1f31b);
        EMOJIS_MAP.put(127769, R.drawable.emoji_1f319);
        EMOJIS_MAP.put(127757, R.drawable.emoji_1f30d);
        EMOJIS_MAP.put(127758, R.drawable.emoji_1f30e);
        EMOJIS_MAP.put(127759, R.drawable.emoji_1f30f);
        EMOJIS_MAP.put(127755, R.drawable.emoji_1f30b);
        EMOJIS_MAP.put(127756, R.drawable.emoji_1f30c);
        EMOJIS_MAP.put(127776, R.drawable.emoji_1f303);
        EMOJIS_MAP.put(11088, R.drawable.emoji_2b50);
        EMOJIS_MAP.put(9728, R.drawable.emoji_2600);
        EMOJIS_MAP.put(9925, R.drawable.emoji_26c5);
        EMOJIS_MAP.put(9729, R.drawable.emoji_2601);
        EMOJIS_MAP.put(9889, R.drawable.emoji_26a1);
        EMOJIS_MAP.put(9748, R.drawable.emoji_2614);
        EMOJIS_MAP.put(10052, R.drawable.emoji_2744);
        EMOJIS_MAP.put(9924, R.drawable.emoji_26c4);
        EMOJIS_MAP.put(127744, R.drawable.emoji_1f300);
        EMOJIS_MAP.put(127745, R.drawable.emoji_1f301);
        EMOJIS_MAP.put(127752, R.drawable.emoji_1f308);
        EMOJIS_MAP.put(127754, R.drawable.emoji_1f30a);
        EMOJIS_MAP.put(127885, R.drawable.emoji_1f38d);
        EMOJIS_MAP.put(128157, R.drawable.emoji_1f49d);
        EMOJIS_MAP.put(127886, R.drawable.emoji_1f38e);
        EMOJIS_MAP.put(127890, R.drawable.emoji_1f392);
        EMOJIS_MAP.put(127891, R.drawable.emoji_1f393);
        EMOJIS_MAP.put(127887, R.drawable.emoji_1f38f);
        EMOJIS_MAP.put(127878, R.drawable.emoji_1f386);
        EMOJIS_MAP.put(127879, R.drawable.emoji_1f387);
        EMOJIS_MAP.put(127888, R.drawable.emoji_1f390);
        EMOJIS_MAP.put(127889, R.drawable.emoji_1f391);
        EMOJIS_MAP.put(127875, R.drawable.emoji_1f383);
        EMOJIS_MAP.put(128123, R.drawable.emoji_1f47b);
        EMOJIS_MAP.put(127877, R.drawable.emoji_1f385);
        EMOJIS_MAP.put(127876, R.drawable.emoji_1f384);
        EMOJIS_MAP.put(127873, R.drawable.emoji_1f381);
        EMOJIS_MAP.put(127883, R.drawable.emoji_1f38b);
        EMOJIS_MAP.put(127881, R.drawable.emoji_1f389);
        EMOJIS_MAP.put(127882, R.drawable.emoji_1f38a);
        EMOJIS_MAP.put(127880, R.drawable.emoji_1f388);
        EMOJIS_MAP.put(127884, R.drawable.emoji_1f38c);
        EMOJIS_MAP.put(128302, R.drawable.emoji_1f52e);
        EMOJIS_MAP.put(127909, R.drawable.emoji_1f3a5);
        EMOJIS_MAP.put(128247, R.drawable.emoji_1f4f7);
        EMOJIS_MAP.put(128249, R.drawable.emoji_1f4f9);
        EMOJIS_MAP.put(128252, R.drawable.emoji_1f4fc);
        EMOJIS_MAP.put(128191, R.drawable.emoji_1f4bf);
        EMOJIS_MAP.put(128192, R.drawable.emoji_1f4c0);
        EMOJIS_MAP.put(128189, R.drawable.emoji_1f4bd);
        EMOJIS_MAP.put(128190, R.drawable.emoji_1f4be);
        EMOJIS_MAP.put(128187, R.drawable.emoji_1f4bb);
        EMOJIS_MAP.put(128241, R.drawable.emoji_1f4f1);
        EMOJIS_MAP.put(9742, R.drawable.emoji_260e);
        EMOJIS_MAP.put(128222, R.drawable.emoji_1f4de);
        EMOJIS_MAP.put(128223, R.drawable.emoji_1f4df);
        EMOJIS_MAP.put(128224, R.drawable.emoji_1f4e0);
        EMOJIS_MAP.put(128225, R.drawable.emoji_1f4e1);
        EMOJIS_MAP.put(128250, R.drawable.emoji_1f4fa);
        EMOJIS_MAP.put(128251, R.drawable.emoji_1f4fb);
        EMOJIS_MAP.put(128266, R.drawable.emoji_1f50a);
        EMOJIS_MAP.put(128265, R.drawable.emoji_1f509);
        EMOJIS_MAP.put(128264, R.drawable.emoji_1f508);
        EMOJIS_MAP.put(128263, R.drawable.emoji_1f507);
        EMOJIS_MAP.put(128276, R.drawable.emoji_1f514);
        EMOJIS_MAP.put(128277, R.drawable.emoji_1f515);
        EMOJIS_MAP.put(128226, R.drawable.emoji_1f4e2);
        EMOJIS_MAP.put(128227, R.drawable.emoji_1f4e3);
        EMOJIS_MAP.put(9203, R.drawable.emoji_23f3);
        EMOJIS_MAP.put(8987, R.drawable.emoji_231b);
        EMOJIS_MAP.put(9200, R.drawable.emoji_23f0);
        EMOJIS_MAP.put(8986, R.drawable.emoji_231a);
        EMOJIS_MAP.put(128275, R.drawable.emoji_1f513);
        EMOJIS_MAP.put(128274, R.drawable.emoji_1f512);
        EMOJIS_MAP.put(128271, R.drawable.emoji_1f50f);
        EMOJIS_MAP.put(128272, R.drawable.emoji_1f510);
        EMOJIS_MAP.put(128273, R.drawable.emoji_1f511);
        EMOJIS_MAP.put(128270, R.drawable.emoji_1f50e);
        EMOJIS_MAP.put(128161, R.drawable.emoji_1f4a1);
        EMOJIS_MAP.put(128294, R.drawable.emoji_1f526);
        EMOJIS_MAP.put(128262, R.drawable.emoji_1f506);
        EMOJIS_MAP.put(128261, R.drawable.emoji_1f505);
        EMOJIS_MAP.put(128268, R.drawable.emoji_1f50c);
        EMOJIS_MAP.put(128267, R.drawable.emoji_1f50b);
        EMOJIS_MAP.put(128269, R.drawable.emoji_1f50d);
        EMOJIS_MAP.put(128705, R.drawable.emoji_1f6c1);
        EMOJIS_MAP.put(128704, R.drawable.emoji_1f6c0);
        EMOJIS_MAP.put(128703, R.drawable.emoji_1f6bf);
        EMOJIS_MAP.put(128701, R.drawable.emoji_1f6bd);
        EMOJIS_MAP.put(128295, R.drawable.emoji_1f527);
        EMOJIS_MAP.put(128297, R.drawable.emoji_1f529);
        EMOJIS_MAP.put(128296, R.drawable.emoji_1f528);
        EMOJIS_MAP.put(128682, R.drawable.emoji_1f6aa);
        EMOJIS_MAP.put(128684, R.drawable.emoji_1f6ac);
        EMOJIS_MAP.put(128163, R.drawable.emoji_1f4a3);
        EMOJIS_MAP.put(128299, R.drawable.emoji_1f52b);
        EMOJIS_MAP.put(128298, R.drawable.emoji_1f52a);
        EMOJIS_MAP.put(128138, R.drawable.emoji_1f48a);
        EMOJIS_MAP.put(128137, R.drawable.emoji_1f489);
        EMOJIS_MAP.put(128176, R.drawable.emoji_1f4b0);
        EMOJIS_MAP.put(128180, R.drawable.emoji_1f4b4);
        EMOJIS_MAP.put(128181, R.drawable.emoji_1f4b5);
        EMOJIS_MAP.put(128183, R.drawable.emoji_1f4b7);
        EMOJIS_MAP.put(128182, R.drawable.emoji_1f4b6);
        EMOJIS_MAP.put(128179, R.drawable.emoji_1f4b3);
        EMOJIS_MAP.put(128184, R.drawable.emoji_1f4b8);
        EMOJIS_MAP.put(128242, R.drawable.emoji_1f4f2);
        EMOJIS_MAP.put(128231, R.drawable.emoji_1f4e7);
        EMOJIS_MAP.put(128229, R.drawable.emoji_1f4e5);
        EMOJIS_MAP.put(128228, R.drawable.emoji_1f4e4);
        EMOJIS_MAP.put(9993, R.drawable.emoji_2709);
        EMOJIS_MAP.put(128233, R.drawable.emoji_1f4e9);
        EMOJIS_MAP.put(128232, R.drawable.emoji_1f4e8);
        EMOJIS_MAP.put(128239, R.drawable.emoji_1f4ef);
        EMOJIS_MAP.put(128235, R.drawable.emoji_1f4eb);
        EMOJIS_MAP.put(128234, R.drawable.emoji_1f4ea);
        EMOJIS_MAP.put(128236, R.drawable.emoji_1f4ec);
        EMOJIS_MAP.put(128237, R.drawable.emoji_1f4ed);
        EMOJIS_MAP.put(128238, R.drawable.emoji_1f4ee);
        EMOJIS_MAP.put(128230, R.drawable.emoji_1f4e6);
        EMOJIS_MAP.put(128221, R.drawable.emoji_1f4dd);
        EMOJIS_MAP.put(128196, R.drawable.emoji_1f4c4);
        EMOJIS_MAP.put(128195, R.drawable.emoji_1f4c3);
        EMOJIS_MAP.put(128209, R.drawable.emoji_1f4d1);
        EMOJIS_MAP.put(128202, R.drawable.emoji_1f4ca);
        EMOJIS_MAP.put(128200, R.drawable.emoji_1f4c8);
        EMOJIS_MAP.put(128201, R.drawable.emoji_1f4c9);
        EMOJIS_MAP.put(128220, R.drawable.emoji_1f4dc);
        EMOJIS_MAP.put(128203, R.drawable.emoji_1f4cb);
        EMOJIS_MAP.put(128197, R.drawable.emoji_1f4c5);
        EMOJIS_MAP.put(128198, R.drawable.emoji_1f4c6);
        EMOJIS_MAP.put(128199, R.drawable.emoji_1f4c7);
        EMOJIS_MAP.put(128193, R.drawable.emoji_1f4c1);
        EMOJIS_MAP.put(128194, R.drawable.emoji_1f4c2);
        EMOJIS_MAP.put(9986, R.drawable.emoji_2702);
        EMOJIS_MAP.put(128204, R.drawable.emoji_1f4cc);
        EMOJIS_MAP.put(128206, R.drawable.emoji_1f4ce);
        EMOJIS_MAP.put(10002, R.drawable.emoji_2712);
        EMOJIS_MAP.put(9999, R.drawable.emoji_270f);
        EMOJIS_MAP.put(128207, R.drawable.emoji_1f4cf);
        EMOJIS_MAP.put(128208, R.drawable.emoji_1f4d0);
        EMOJIS_MAP.put(128213, R.drawable.emoji_1f4d5);
        EMOJIS_MAP.put(128215, R.drawable.emoji_1f4d7);
        EMOJIS_MAP.put(128216, R.drawable.emoji_1f4d8);
        EMOJIS_MAP.put(128217, R.drawable.emoji_1f4d9);
        EMOJIS_MAP.put(128211, R.drawable.emoji_1f4d3);
        EMOJIS_MAP.put(128212, R.drawable.emoji_1f4d4);
        EMOJIS_MAP.put(128210, R.drawable.emoji_1f4d2);
        EMOJIS_MAP.put(128218, R.drawable.emoji_1f4da);
        EMOJIS_MAP.put(128214, R.drawable.emoji_1f4d6);
        EMOJIS_MAP.put(128278, R.drawable.emoji_1f516);
        EMOJIS_MAP.put(128219, R.drawable.emoji_1f4db);
        EMOJIS_MAP.put(128300, R.drawable.emoji_1f52c);
        EMOJIS_MAP.put(128301, R.drawable.emoji_1f52d);
        EMOJIS_MAP.put(128240, R.drawable.emoji_1f4f0);
        EMOJIS_MAP.put(127912, R.drawable.emoji_1f3a8);
        EMOJIS_MAP.put(127916, R.drawable.emoji_1f3ac);
        EMOJIS_MAP.put(127908, R.drawable.emoji_1f3a4);
        EMOJIS_MAP.put(127911, R.drawable.emoji_1f3a7);
        EMOJIS_MAP.put(127932, R.drawable.emoji_1f3bc);
        EMOJIS_MAP.put(127925, R.drawable.emoji_1f3b5);
        EMOJIS_MAP.put(127926, R.drawable.emoji_1f3b6);
        EMOJIS_MAP.put(127929, R.drawable.emoji_1f3b9);
        EMOJIS_MAP.put(127931, R.drawable.emoji_1f3bb);
        EMOJIS_MAP.put(127930, R.drawable.emoji_1f3ba);
        EMOJIS_MAP.put(127927, R.drawable.emoji_1f3b7);
        EMOJIS_MAP.put(127928, R.drawable.emoji_1f3b8);
        EMOJIS_MAP.put(128126, R.drawable.emoji_1f47e);
        EMOJIS_MAP.put(127918, R.drawable.emoji_1f3ae);
        EMOJIS_MAP.put(127183, R.drawable.emoji_1f0cf);
        EMOJIS_MAP.put(127924, R.drawable.emoji_1f3b4);
        EMOJIS_MAP.put(126980, R.drawable.emoji_1f004);
        EMOJIS_MAP.put(127922, R.drawable.emoji_1f3b2);
        EMOJIS_MAP.put(127919, R.drawable.emoji_1f3af);
        EMOJIS_MAP.put(127944, R.drawable.emoji_1f3c8);
        EMOJIS_MAP.put(127936, R.drawable.emoji_1f3c0);
        EMOJIS_MAP.put(9917, R.drawable.emoji_26bd);
        EMOJIS_MAP.put(9918, R.drawable.emoji_26be);
        EMOJIS_MAP.put(127934, R.drawable.emoji_1f3be);
        EMOJIS_MAP.put(127921, R.drawable.emoji_1f3b1);
        EMOJIS_MAP.put(127945, R.drawable.emoji_1f3c9);
        EMOJIS_MAP.put(127923, R.drawable.emoji_1f3b3);
        EMOJIS_MAP.put(9971, R.drawable.emoji_26f3);
        EMOJIS_MAP.put(128693, R.drawable.emoji_1f6b5);
        EMOJIS_MAP.put(128692, R.drawable.emoji_1f6b4);
        EMOJIS_MAP.put(127937, R.drawable.emoji_1f3c1);
        EMOJIS_MAP.put(127943, R.drawable.emoji_1f3c7);
        EMOJIS_MAP.put(127942, R.drawable.emoji_1f3c6);
        EMOJIS_MAP.put(127935, R.drawable.emoji_1f3bf);
        EMOJIS_MAP.put(127938, R.drawable.emoji_1f3c2);
        EMOJIS_MAP.put(127946, R.drawable.emoji_1f3ca);
        EMOJIS_MAP.put(127940, R.drawable.emoji_1f3c4);
        EMOJIS_MAP.put(127907, R.drawable.emoji_1f3a3);
        EMOJIS_MAP.put(9749, R.drawable.emoji_2615);
        EMOJIS_MAP.put(127861, R.drawable.emoji_1f375);
        EMOJIS_MAP.put(127862, R.drawable.emoji_1f376);
        EMOJIS_MAP.put(127868, R.drawable.emoji_1f37c);
        EMOJIS_MAP.put(127866, R.drawable.emoji_1f37a);
        EMOJIS_MAP.put(127867, R.drawable.emoji_1f37b);
        EMOJIS_MAP.put(127864, R.drawable.emoji_1f378);
        EMOJIS_MAP.put(127865, R.drawable.emoji_1f379);
        EMOJIS_MAP.put(127863, R.drawable.emoji_1f377);
        EMOJIS_MAP.put(127860, R.drawable.emoji_1f374);
        EMOJIS_MAP.put(127829, R.drawable.emoji_1f355);
        EMOJIS_MAP.put(127828, R.drawable.emoji_1f354);
        EMOJIS_MAP.put(127839, R.drawable.emoji_1f35f);
        EMOJIS_MAP.put(127831, R.drawable.emoji_1f357);
        EMOJIS_MAP.put(127830, R.drawable.emoji_1f356);
        EMOJIS_MAP.put(127837, R.drawable.emoji_1f35d);
        EMOJIS_MAP.put(127835, R.drawable.emoji_1f35b);
        EMOJIS_MAP.put(127844, R.drawable.emoji_1f364);
        EMOJIS_MAP.put(127857, R.drawable.emoji_1f371);
        EMOJIS_MAP.put(127843, R.drawable.emoji_1f363);
        EMOJIS_MAP.put(127845, R.drawable.emoji_1f365);
        EMOJIS_MAP.put(127833, R.drawable.emoji_1f359);
        EMOJIS_MAP.put(127832, R.drawable.emoji_1f358);
        EMOJIS_MAP.put(127834, R.drawable.emoji_1f35a);
        EMOJIS_MAP.put(127836, R.drawable.emoji_1f35c);
        EMOJIS_MAP.put(127858, R.drawable.emoji_1f372);
        EMOJIS_MAP.put(127842, R.drawable.emoji_1f362);
        EMOJIS_MAP.put(127841, R.drawable.emoji_1f361);
        EMOJIS_MAP.put(127859, R.drawable.emoji_1f373);
        EMOJIS_MAP.put(127838, R.drawable.emoji_1f35e);
        EMOJIS_MAP.put(127849, R.drawable.emoji_1f369);
        EMOJIS_MAP.put(127854, R.drawable.emoji_1f36e);
        EMOJIS_MAP.put(127846, R.drawable.emoji_1f366);
        EMOJIS_MAP.put(127848, R.drawable.emoji_1f368);
        EMOJIS_MAP.put(127847, R.drawable.emoji_1f367);
        EMOJIS_MAP.put(127874, R.drawable.emoji_1f382);
        EMOJIS_MAP.put(127856, R.drawable.emoji_1f370);
        EMOJIS_MAP.put(127850, R.drawable.emoji_1f36a);
        EMOJIS_MAP.put(127851, R.drawable.emoji_1f36b);
        EMOJIS_MAP.put(127852, R.drawable.emoji_1f36c);
        EMOJIS_MAP.put(127853, R.drawable.emoji_1f36d);
        EMOJIS_MAP.put(127855, R.drawable.emoji_1f36f);
        EMOJIS_MAP.put(127822, R.drawable.emoji_1f34e);
        EMOJIS_MAP.put(127823, R.drawable.emoji_1f34f);
        EMOJIS_MAP.put(127818, R.drawable.emoji_1f34a);
        EMOJIS_MAP.put(127819, R.drawable.emoji_1f34b);
        EMOJIS_MAP.put(127826, R.drawable.emoji_1f352);
        EMOJIS_MAP.put(127815, R.drawable.emoji_1f347);
        EMOJIS_MAP.put(127817, R.drawable.emoji_1f349);
        EMOJIS_MAP.put(127827, R.drawable.emoji_1f353);
        EMOJIS_MAP.put(127825, R.drawable.emoji_1f351);
        EMOJIS_MAP.put(127816, R.drawable.emoji_1f348);
        EMOJIS_MAP.put(127820, R.drawable.emoji_1f34c);
        EMOJIS_MAP.put(127824, R.drawable.emoji_1f350);
        EMOJIS_MAP.put(127821, R.drawable.emoji_1f34d);
        EMOJIS_MAP.put(127840, R.drawable.emoji_1f360);
        EMOJIS_MAP.put(127814, R.drawable.emoji_1f346);
        EMOJIS_MAP.put(127813, R.drawable.emoji_1f345);
        EMOJIS_MAP.put(127805, R.drawable.emoji_1f33d);
        EMOJIS_MAP.put(127968, R.drawable.emoji_1f3e0);
        EMOJIS_MAP.put(127969, R.drawable.emoji_1f3e1);
        EMOJIS_MAP.put(127979, R.drawable.emoji_1f3eb);
        EMOJIS_MAP.put(127970, R.drawable.emoji_1f3e2);
        EMOJIS_MAP.put(127971, R.drawable.emoji_1f3e3);
        EMOJIS_MAP.put(127973, R.drawable.emoji_1f3e5);
        EMOJIS_MAP.put(127974, R.drawable.emoji_1f3e6);
        EMOJIS_MAP.put(127978, R.drawable.emoji_1f3ea);
        EMOJIS_MAP.put(127977, R.drawable.emoji_1f3e9);
        EMOJIS_MAP.put(127976, R.drawable.emoji_1f3e8);
        EMOJIS_MAP.put(128146, R.drawable.emoji_1f492);
        EMOJIS_MAP.put(9962, R.drawable.emoji_26ea);
        EMOJIS_MAP.put(127980, R.drawable.emoji_1f3ec);
        EMOJIS_MAP.put(127972, R.drawable.emoji_1f3e4);
        EMOJIS_MAP.put(127751, R.drawable.emoji_1f307);
        EMOJIS_MAP.put(127750, R.drawable.emoji_1f306);
        EMOJIS_MAP.put(127983, R.drawable.emoji_1f3ef);
        EMOJIS_MAP.put(127984, R.drawable.emoji_1f3f0);
        EMOJIS_MAP.put(9978, R.drawable.emoji_26fa);
        EMOJIS_MAP.put(127981, R.drawable.emoji_1f3ed);
        EMOJIS_MAP.put(128508, R.drawable.emoji_1f5fc);
        EMOJIS_MAP.put(128510, R.drawable.emoji_1f5fe);
        EMOJIS_MAP.put(128507, R.drawable.emoji_1f5fb);
        EMOJIS_MAP.put(127748, R.drawable.emoji_1f304);
        EMOJIS_MAP.put(127749, R.drawable.emoji_1f305);
        EMOJIS_MAP.put(127747, R.drawable.emoji_1f303);
        EMOJIS_MAP.put(128509, R.drawable.emoji_1f5fd);
        EMOJIS_MAP.put(127753, R.drawable.emoji_1f309);
        EMOJIS_MAP.put(127904, R.drawable.emoji_1f3a0);
        EMOJIS_MAP.put(127905, R.drawable.emoji_1f3a1);
        EMOJIS_MAP.put(9970, R.drawable.emoji_26f2);
        EMOJIS_MAP.put(127906, R.drawable.emoji_1f3a2);
        EMOJIS_MAP.put(128674, R.drawable.emoji_1f6a2);
        EMOJIS_MAP.put(9973, R.drawable.emoji_26f5);
        EMOJIS_MAP.put(128676, R.drawable.emoji_1f6a4);
        EMOJIS_MAP.put(128675, R.drawable.emoji_1f6a3);
        EMOJIS_MAP.put(9875, R.drawable.emoji_2693);
        EMOJIS_MAP.put(128640, R.drawable.emoji_1f680);
        EMOJIS_MAP.put(9992, R.drawable.emoji_2708);
        EMOJIS_MAP.put(128186, R.drawable.emoji_1f4ba);
        EMOJIS_MAP.put(128641, R.drawable.emoji_1f681);
        EMOJIS_MAP.put(128642, R.drawable.emoji_1f682);
        EMOJIS_MAP.put(128650, R.drawable.emoji_1f68a);
        EMOJIS_MAP.put(128649, R.drawable.emoji_1f689);
        EMOJIS_MAP.put(128670, R.drawable.emoji_1f69e);
        EMOJIS_MAP.put(128646, R.drawable.emoji_1f686);
        EMOJIS_MAP.put(128644, R.drawable.emoji_1f684);
        EMOJIS_MAP.put(128645, R.drawable.emoji_1f685);
        EMOJIS_MAP.put(128648, R.drawable.emoji_1f688);
        EMOJIS_MAP.put(128647, R.drawable.emoji_1f687);
        EMOJIS_MAP.put(128669, R.drawable.emoji_1f69d);
        EMOJIS_MAP.put(128651, R.drawable.emoji_1f68b);
        EMOJIS_MAP.put(128643, R.drawable.emoji_1f683);
        EMOJIS_MAP.put(128654, R.drawable.emoji_1f68e);
        EMOJIS_MAP.put(128652, R.drawable.emoji_1f68c);
        EMOJIS_MAP.put(128653, R.drawable.emoji_1f68d);
        EMOJIS_MAP.put(128665, R.drawable.emoji_1f699);
        EMOJIS_MAP.put(128664, R.drawable.emoji_1f698);
        EMOJIS_MAP.put(128663, R.drawable.emoji_1f697);
        EMOJIS_MAP.put(128661, R.drawable.emoji_1f695);
        EMOJIS_MAP.put(128662, R.drawable.emoji_1f696);
        EMOJIS_MAP.put(128667, R.drawable.emoji_1f69b);
        EMOJIS_MAP.put(128666, R.drawable.emoji_1f69a);
        EMOJIS_MAP.put(128680, R.drawable.emoji_1f6a8);
        EMOJIS_MAP.put(128659, R.drawable.emoji_1f693);
        EMOJIS_MAP.put(128660, R.drawable.emoji_1f694);
        EMOJIS_MAP.put(128658, R.drawable.emoji_1f692);
        EMOJIS_MAP.put(128657, R.drawable.emoji_1f691);
        EMOJIS_MAP.put(128656, R.drawable.emoji_1f690);
        EMOJIS_MAP.put(128690, R.drawable.emoji_1f6b2);
        EMOJIS_MAP.put(128673, R.drawable.emoji_1f6a1);
        EMOJIS_MAP.put(128671, R.drawable.emoji_1f69f);
        EMOJIS_MAP.put(128672, R.drawable.emoji_1f6a0);
        EMOJIS_MAP.put(128668, R.drawable.emoji_1f69c);
        EMOJIS_MAP.put(128136, R.drawable.emoji_1f488);
        EMOJIS_MAP.put(128655, R.drawable.emoji_1f68f);
        EMOJIS_MAP.put(127915, R.drawable.emoji_1f3ab);
        EMOJIS_MAP.put(128678, R.drawable.emoji_1f6a6);
        EMOJIS_MAP.put(128677, R.drawable.emoji_1f6a5);
        EMOJIS_MAP.put(9888, R.drawable.emoji_26a0);
        EMOJIS_MAP.put(128679, R.drawable.emoji_1f6a7);
        EMOJIS_MAP.put(128304, R.drawable.emoji_1f530);
        EMOJIS_MAP.put(9981, R.drawable.emoji_26fd);
        EMOJIS_MAP.put(127982, R.drawable.emoji_1f3ee);
        EMOJIS_MAP.put(127920, R.drawable.emoji_1f3b0);
        EMOJIS_MAP.put(9832, R.drawable.emoji_2668);
        EMOJIS_MAP.put(128511, R.drawable.emoji_1f5ff);
        EMOJIS_MAP.put(127914, R.drawable.emoji_1f3aa);
        EMOJIS_MAP.put(127917, R.drawable.emoji_1f3ad);
        EMOJIS_MAP.put(128205, R.drawable.emoji_1f4cd);
        EMOJIS_MAP.put(128681, R.drawable.emoji_1f6a9);
        EMOJIS_MAP.put(128287, R.drawable.emoji_1f51f);
        EMOJIS_MAP.put(128290, R.drawable.emoji_1f522);
        EMOJIS_MAP.put(128291, R.drawable.emoji_1f523);
        EMOJIS_MAP.put(11014, R.drawable.emoji_2b06);
        EMOJIS_MAP.put(11015, R.drawable.emoji_2b07);
        EMOJIS_MAP.put(11013, R.drawable.emoji_2b05);
        EMOJIS_MAP.put(10145, R.drawable.emoji_27a1);
        EMOJIS_MAP.put(128288, R.drawable.emoji_1f520);
        EMOJIS_MAP.put(128289, R.drawable.emoji_1f521);
        EMOJIS_MAP.put(128292, R.drawable.emoji_1f524);
        EMOJIS_MAP.put(8599, R.drawable.emoji_2197);
        EMOJIS_MAP.put(8598, R.drawable.emoji_2196);
        EMOJIS_MAP.put(8600, R.drawable.emoji_2198);
        EMOJIS_MAP.put(8601, R.drawable.emoji_2199);
        EMOJIS_MAP.put(8596, R.drawable.emoji_2194);
        EMOJIS_MAP.put(8597, R.drawable.emoji_2195);
        EMOJIS_MAP.put(128260, R.drawable.emoji_1f504);
        EMOJIS_MAP.put(9664, R.drawable.emoji_25c0);
        EMOJIS_MAP.put(9654, R.drawable.emoji_25b6);
        EMOJIS_MAP.put(128316, R.drawable.emoji_1f53c);
        EMOJIS_MAP.put(128317, R.drawable.emoji_1f53d);
        EMOJIS_MAP.put(8617, R.drawable.emoji_21a9);
        EMOJIS_MAP.put(8618, R.drawable.emoji_21aa);
        EMOJIS_MAP.put(8505, R.drawable.emoji_2139);
        EMOJIS_MAP.put(9194, R.drawable.emoji_23ea);
        EMOJIS_MAP.put(9193, R.drawable.emoji_23e9);
        EMOJIS_MAP.put(9195, R.drawable.emoji_23eb);
        EMOJIS_MAP.put(9196, R.drawable.emoji_23ec);
        EMOJIS_MAP.put(10549, R.drawable.emoji_2935);
        EMOJIS_MAP.put(10548, R.drawable.emoji_2934);
        EMOJIS_MAP.put(127383, R.drawable.emoji_1f197);
        EMOJIS_MAP.put(128256, R.drawable.emoji_1f500);
        EMOJIS_MAP.put(128257, R.drawable.emoji_1f501);
        EMOJIS_MAP.put(128258, R.drawable.emoji_1f502);
        EMOJIS_MAP.put(127381, R.drawable.emoji_1f195);
        EMOJIS_MAP.put(127385, R.drawable.emoji_1f199);
        EMOJIS_MAP.put(127378, R.drawable.emoji_1f192);
        EMOJIS_MAP.put(127379, R.drawable.emoji_1f193);
        EMOJIS_MAP.put(127382, R.drawable.emoji_1f196);
        EMOJIS_MAP.put(128246, R.drawable.emoji_1f4f6);
        EMOJIS_MAP.put(127910, R.drawable.emoji_1f3a6);
        EMOJIS_MAP.put(127489, R.drawable.emoji_1f201);
        EMOJIS_MAP.put(127535, R.drawable.emoji_1f22f);
        EMOJIS_MAP.put(127539, R.drawable.emoji_1f233);
        EMOJIS_MAP.put(127541, R.drawable.emoji_1f235);
        EMOJIS_MAP.put(127540, R.drawable.emoji_1f234);
        EMOJIS_MAP.put(127538, R.drawable.emoji_1f232);
        EMOJIS_MAP.put(127568, R.drawable.emoji_1f250);
        EMOJIS_MAP.put(127545, R.drawable.emoji_1f239);
        EMOJIS_MAP.put(127546, R.drawable.emoji_1f23a);
        EMOJIS_MAP.put(127542, R.drawable.emoji_1f236);
        EMOJIS_MAP.put(127514, R.drawable.emoji_1f21a);
        EMOJIS_MAP.put(128699, R.drawable.emoji_1f6bb);
        EMOJIS_MAP.put(128697, R.drawable.emoji_1f6b9);
        EMOJIS_MAP.put(128698, R.drawable.emoji_1f6ba);
        EMOJIS_MAP.put(128700, R.drawable.emoji_1f6bc);
        EMOJIS_MAP.put(128702, R.drawable.emoji_1f6be);
        EMOJIS_MAP.put(128688, R.drawable.emoji_1f6b0);
        EMOJIS_MAP.put(128686, R.drawable.emoji_1f6ae);
        EMOJIS_MAP.put(127359, R.drawable.emoji_1f17f);
        EMOJIS_MAP.put(9855, R.drawable.emoji_267f);
        EMOJIS_MAP.put(128685, R.drawable.emoji_1f6ad);
        EMOJIS_MAP.put(127543, R.drawable.emoji_1f237);
        EMOJIS_MAP.put(127544, R.drawable.emoji_1f238);
        EMOJIS_MAP.put(127490, R.drawable.emoji_1f202);
        EMOJIS_MAP.put(9410, R.drawable.emoji_24c2);
        EMOJIS_MAP.put(128706, R.drawable.emoji_1f6c2);
        EMOJIS_MAP.put(128708, R.drawable.emoji_1f6c4);
        EMOJIS_MAP.put(128709, R.drawable.emoji_1f6c5);
        EMOJIS_MAP.put(128707, R.drawable.emoji_1f6c3);
        EMOJIS_MAP.put(127569, R.drawable.emoji_1f251);
        EMOJIS_MAP.put(12953, R.drawable.emoji_3299);
        EMOJIS_MAP.put(12951, R.drawable.emoji_3297);
        EMOJIS_MAP.put(127377, R.drawable.emoji_1f191);
        EMOJIS_MAP.put(127384, R.drawable.emoji_1f198);
        EMOJIS_MAP.put(127380, R.drawable.emoji_1f194);
        EMOJIS_MAP.put(128683, R.drawable.emoji_1f6ab);
        EMOJIS_MAP.put(128286, R.drawable.emoji_1f51e);
        EMOJIS_MAP.put(128245, R.drawable.emoji_1f4f5);
        EMOJIS_MAP.put(128687, R.drawable.emoji_1f6af);
        EMOJIS_MAP.put(128689, R.drawable.emoji_1f6b1);
        EMOJIS_MAP.put(128691, R.drawable.emoji_1f6b3);
        EMOJIS_MAP.put(128695, R.drawable.emoji_1f6b7);
        EMOJIS_MAP.put(128696, R.drawable.emoji_1f6b8);
        EMOJIS_MAP.put(9940, R.drawable.emoji_26d4);
        EMOJIS_MAP.put(10035, R.drawable.emoji_2733);
        EMOJIS_MAP.put(10055, R.drawable.emoji_2747);
        EMOJIS_MAP.put(10062, R.drawable.emoji_274e);
        EMOJIS_MAP.put(9989, R.drawable.emoji_2705);
        EMOJIS_MAP.put(10036, R.drawable.emoji_2734);
        EMOJIS_MAP.put(128159, R.drawable.emoji_1f49f);
        EMOJIS_MAP.put(127386, R.drawable.emoji_1f19a);
        EMOJIS_MAP.put(128243, R.drawable.emoji_1f4f3);
        EMOJIS_MAP.put(128244, R.drawable.emoji_1f4f4);
        EMOJIS_MAP.put(127344, R.drawable.emoji_1f170);
        EMOJIS_MAP.put(127345, R.drawable.emoji_1f171);
        EMOJIS_MAP.put(127374, R.drawable.emoji_1f18e);
        EMOJIS_MAP.put(127358, R.drawable.emoji_1f17e);
        EMOJIS_MAP.put(128160, R.drawable.emoji_1f4a0);
        EMOJIS_MAP.put(10175, R.drawable.emoji_27bf);
        EMOJIS_MAP.put(9851, R.drawable.emoji_267b);
        EMOJIS_MAP.put(9800, R.drawable.emoji_2648);
        EMOJIS_MAP.put(9801, R.drawable.emoji_2649);
        EMOJIS_MAP.put(9802, R.drawable.emoji_264a);
        EMOJIS_MAP.put(9803, R.drawable.emoji_264b);
        EMOJIS_MAP.put(9804, R.drawable.emoji_264c);
        EMOJIS_MAP.put(9805, R.drawable.emoji_264d);
        EMOJIS_MAP.put(9806, R.drawable.emoji_264e);
        EMOJIS_MAP.put(9807, R.drawable.emoji_264f);
        EMOJIS_MAP.put(9808, R.drawable.emoji_2650);
        EMOJIS_MAP.put(9809, R.drawable.emoji_2651);
        EMOJIS_MAP.put(9810, R.drawable.emoji_2652);
        EMOJIS_MAP.put(9811, R.drawable.emoji_2653);
        EMOJIS_MAP.put(9934, R.drawable.emoji_26ce);
        EMOJIS_MAP.put(128303, R.drawable.emoji_1f52f);
        EMOJIS_MAP.put(127975, R.drawable.emoji_1f3e7);
        EMOJIS_MAP.put(128185, R.drawable.emoji_1f4b9);
        EMOJIS_MAP.put(128178, R.drawable.emoji_1f4b2);
        EMOJIS_MAP.put(128177, R.drawable.emoji_1f4b1);
        EMOJIS_MAP.put(169, R.drawable.emoji_00a9);
        EMOJIS_MAP.put(174, R.drawable.emoji_00ae);
        EMOJIS_MAP.put(8482, R.drawable.emoji_2122);
        EMOJIS_MAP.put(10060, R.drawable.emoji_274c);
        EMOJIS_MAP.put(8252, R.drawable.emoji_203c);
        EMOJIS_MAP.put(8265, R.drawable.emoji_2049);
        EMOJIS_MAP.put(10071, R.drawable.emoji_2757);
        EMOJIS_MAP.put(10067, R.drawable.emoji_2753);
        EMOJIS_MAP.put(10069, R.drawable.emoji_2755);
        EMOJIS_MAP.put(10068, R.drawable.emoji_2754);
        EMOJIS_MAP.put(11093, R.drawable.emoji_2b55);
        EMOJIS_MAP.put(128285, R.drawable.emoji_1f51d);
        EMOJIS_MAP.put(128282, R.drawable.emoji_1f51a);
        EMOJIS_MAP.put(128281, R.drawable.emoji_1f519);
        EMOJIS_MAP.put(128283, R.drawable.emoji_1f51b);
        EMOJIS_MAP.put(128284, R.drawable.emoji_1f51c);
        EMOJIS_MAP.put(128259, R.drawable.emoji_1f503);
        EMOJIS_MAP.put(128347, R.drawable.emoji_1f55b);
        EMOJIS_MAP.put(128359, R.drawable.emoji_1f567);
        EMOJIS_MAP.put(128336, R.drawable.emoji_1f550);
        EMOJIS_MAP.put(128348, R.drawable.emoji_1f55c);
        EMOJIS_MAP.put(128337, R.drawable.emoji_1f551);
        EMOJIS_MAP.put(128349, R.drawable.emoji_1f55d);
        EMOJIS_MAP.put(128338, R.drawable.emoji_1f552);
        EMOJIS_MAP.put(128350, R.drawable.emoji_1f55e);
        EMOJIS_MAP.put(128339, R.drawable.emoji_1f553);
        EMOJIS_MAP.put(128351, R.drawable.emoji_1f55f);
        EMOJIS_MAP.put(128340, R.drawable.emoji_1f554);
        EMOJIS_MAP.put(128352, R.drawable.emoji_1f560);
        EMOJIS_MAP.put(128341, R.drawable.emoji_1f555);
        EMOJIS_MAP.put(128342, R.drawable.emoji_1f556);
        EMOJIS_MAP.put(128343, R.drawable.emoji_1f557);
        EMOJIS_MAP.put(128344, R.drawable.emoji_1f558);
        EMOJIS_MAP.put(128345, R.drawable.emoji_1f559);
        EMOJIS_MAP.put(128346, R.drawable.emoji_1f55a);
        EMOJIS_MAP.put(128353, R.drawable.emoji_1f561);
        EMOJIS_MAP.put(128354, R.drawable.emoji_1f562);
        EMOJIS_MAP.put(128355, R.drawable.emoji_1f563);
        EMOJIS_MAP.put(128356, R.drawable.emoji_1f564);
        EMOJIS_MAP.put(128357, R.drawable.emoji_1f565);
        EMOJIS_MAP.put(128358, R.drawable.emoji_1f566);
        EMOJIS_MAP.put(10006, R.drawable.emoji_2716);
        EMOJIS_MAP.put(10133, R.drawable.emoji_2795);
        EMOJIS_MAP.put(10134, R.drawable.emoji_2796);
        EMOJIS_MAP.put(10135, R.drawable.emoji_2797);
        EMOJIS_MAP.put(9824, R.drawable.emoji_2660);
        EMOJIS_MAP.put(9829, R.drawable.emoji_2665);
        EMOJIS_MAP.put(9827, R.drawable.emoji_2663);
        EMOJIS_MAP.put(9830, R.drawable.emoji_2666);
        EMOJIS_MAP.put(128174, R.drawable.emoji_1f4ae);
        EMOJIS_MAP.put(128175, R.drawable.emoji_1f4af);
        EMOJIS_MAP.put(10004, R.drawable.emoji_2714);
        EMOJIS_MAP.put(9745, R.drawable.emoji_2611);
        EMOJIS_MAP.put(128280, R.drawable.emoji_1f518);
        EMOJIS_MAP.put(128279, R.drawable.emoji_1f517);
        EMOJIS_MAP.put(10160, R.drawable.emoji_27b0);
        EMOJIS_MAP.put(12336, R.drawable.emoji_3030);
        EMOJIS_MAP.put(12349, R.drawable.emoji_303d);
        EMOJIS_MAP.put(128305, R.drawable.emoji_1f531);
        EMOJIS_MAP.put(9724, R.drawable.emoji_25fc);
        EMOJIS_MAP.put(9723, R.drawable.emoji_25fb);
        EMOJIS_MAP.put(9726, R.drawable.emoji_25fe);
        EMOJIS_MAP.put(9725, R.drawable.emoji_25fd);
        EMOJIS_MAP.put(9642, R.drawable.emoji_25aa);
        EMOJIS_MAP.put(9643, R.drawable.emoji_25ab);
        EMOJIS_MAP.put(128314, R.drawable.emoji_1f53a);
        EMOJIS_MAP.put(128306, R.drawable.emoji_1f532);
        EMOJIS_MAP.put(128307, R.drawable.emoji_1f533);
        EMOJIS_MAP.put(9899, R.drawable.emoji_26ab);
        EMOJIS_MAP.put(9898, R.drawable.emoji_26aa);
        EMOJIS_MAP.put(128308, R.drawable.emoji_1f534);
        EMOJIS_MAP.put(128309, R.drawable.emoji_1f535);
        EMOJIS_MAP.put(128315, R.drawable.emoji_1f53b);
        EMOJIS_MAP.put(11036, R.drawable.emoji_2b1c);
        EMOJIS_MAP.put(11035, R.drawable.emoji_2b1b);
        EMOJIS_MAP.put(128310, R.drawable.emoji_1f536);
        EMOJIS_MAP.put(128311, R.drawable.emoji_1f537);
        EMOJIS_MAP.put(128312, R.drawable.emoji_1f538);
        EMOJIS_MAP.put(128313, R.drawable.emoji_1f539);
        SOFTBANKS_MAP.put(57345, R.drawable.emoji_1f466);
        SOFTBANKS_MAP.put(57346, R.drawable.emoji_1f467);
        SOFTBANKS_MAP.put(57347, R.drawable.emoji_1f48b);
        SOFTBANKS_MAP.put(57348, R.drawable.emoji_1f468);
        SOFTBANKS_MAP.put(57349, R.drawable.emoji_1f469);
        SOFTBANKS_MAP.put(57350, R.drawable.emoji_1f455);
        SOFTBANKS_MAP.put(57351, R.drawable.emoji_1f45e);
        SOFTBANKS_MAP.put(57352, R.drawable.emoji_1f4f7);
        SOFTBANKS_MAP.put(57353, R.drawable.emoji_1f4de);
        SOFTBANKS_MAP.put(57354, R.drawable.emoji_1f4f1);
        SOFTBANKS_MAP.put(57355, R.drawable.emoji_1f4e0);
        SOFTBANKS_MAP.put(57356, R.drawable.emoji_1f4bb);
        SOFTBANKS_MAP.put(57357, R.drawable.emoji_1f44a);
        SOFTBANKS_MAP.put(57358, R.drawable.emoji_1f44d);
        SOFTBANKS_MAP.put(57359, R.drawable.emoji_261d);
        SOFTBANKS_MAP.put(57360, R.drawable.emoji_270a);
        SOFTBANKS_MAP.put(57361, R.drawable.emoji_270c);
        SOFTBANKS_MAP.put(57362, R.drawable.emoji_1f64b);
        SOFTBANKS_MAP.put(57363, R.drawable.emoji_1f3bf);
        SOFTBANKS_MAP.put(57364, R.drawable.emoji_26f3);
        SOFTBANKS_MAP.put(57365, R.drawable.emoji_1f3be);
        SOFTBANKS_MAP.put(57366, R.drawable.emoji_26be);
        SOFTBANKS_MAP.put(57367, R.drawable.emoji_1f3c4);
        SOFTBANKS_MAP.put(57368, R.drawable.emoji_26bd);
        SOFTBANKS_MAP.put(57369, R.drawable.emoji_1f3a3);
        SOFTBANKS_MAP.put(57370, R.drawable.emoji_1f434);
        SOFTBANKS_MAP.put(57371, R.drawable.emoji_1f697);
        SOFTBANKS_MAP.put(57372, R.drawable.emoji_26f5);
        SOFTBANKS_MAP.put(57373, R.drawable.emoji_2708);
        SOFTBANKS_MAP.put(57374, R.drawable.emoji_1f683);
        SOFTBANKS_MAP.put(57375, R.drawable.emoji_1f685);
        SOFTBANKS_MAP.put(57376, R.drawable.emoji_2753);
        SOFTBANKS_MAP.put(57377, R.drawable.emoji_2757);
        SOFTBANKS_MAP.put(57378, R.drawable.emoji_2764);
        SOFTBANKS_MAP.put(57379, R.drawable.emoji_1f494);
        SOFTBANKS_MAP.put(57380, R.drawable.emoji_1f550);
        SOFTBANKS_MAP.put(57381, R.drawable.emoji_1f551);
        SOFTBANKS_MAP.put(57382, R.drawable.emoji_1f552);
        SOFTBANKS_MAP.put(57383, R.drawable.emoji_1f553);
        SOFTBANKS_MAP.put(57384, R.drawable.emoji_1f554);
        SOFTBANKS_MAP.put(57385, R.drawable.emoji_1f555);
        SOFTBANKS_MAP.put(57386, R.drawable.emoji_1f556);
        SOFTBANKS_MAP.put(57387, R.drawable.emoji_1f557);
        SOFTBANKS_MAP.put(57388, R.drawable.emoji_1f558);
        SOFTBANKS_MAP.put(57389, R.drawable.emoji_1f559);
        SOFTBANKS_MAP.put(57390, R.drawable.emoji_1f55a);
        SOFTBANKS_MAP.put(57391, R.drawable.emoji_1f55b);
        SOFTBANKS_MAP.put(57392, R.drawable.emoji_1f338);
        SOFTBANKS_MAP.put(57393, R.drawable.emoji_1f531);
        SOFTBANKS_MAP.put(57394, R.drawable.emoji_1f339);
        SOFTBANKS_MAP.put(57395, R.drawable.emoji_1f384);
        SOFTBANKS_MAP.put(57396, R.drawable.emoji_1f48d);
        SOFTBANKS_MAP.put(57397, R.drawable.emoji_1f48e);
        SOFTBANKS_MAP.put(57398, R.drawable.emoji_1f3e0);
        SOFTBANKS_MAP.put(57399, R.drawable.emoji_26ea);
        SOFTBANKS_MAP.put(57400, R.drawable.emoji_1f3e2);
        SOFTBANKS_MAP.put(57401, R.drawable.emoji_1f689);
        SOFTBANKS_MAP.put(57402, R.drawable.emoji_26fd);
        SOFTBANKS_MAP.put(57403, R.drawable.emoji_1f5fb);
        SOFTBANKS_MAP.put(57404, R.drawable.emoji_1f3a4);
        SOFTBANKS_MAP.put(57405, R.drawable.emoji_1f3a5);
        SOFTBANKS_MAP.put(57406, R.drawable.emoji_1f3b5);
        SOFTBANKS_MAP.put(57407, R.drawable.emoji_1f511);
        SOFTBANKS_MAP.put(57408, R.drawable.emoji_1f3b7);
        SOFTBANKS_MAP.put(57409, R.drawable.emoji_1f3b8);
        SOFTBANKS_MAP.put(57410, R.drawable.emoji_1f3ba);
        SOFTBANKS_MAP.put(57411, R.drawable.emoji_1f374);
        SOFTBANKS_MAP.put(57412, R.drawable.emoji_1f377);
        SOFTBANKS_MAP.put(57413, R.drawable.emoji_2615);
        SOFTBANKS_MAP.put(57414, R.drawable.emoji_1f370);
        SOFTBANKS_MAP.put(57415, R.drawable.emoji_1f37a);
        SOFTBANKS_MAP.put(57416, R.drawable.emoji_26c4);
        SOFTBANKS_MAP.put(57417, R.drawable.emoji_2601);
        SOFTBANKS_MAP.put(57418, R.drawable.emoji_2600);
        SOFTBANKS_MAP.put(57419, R.drawable.emoji_2614);
        SOFTBANKS_MAP.put(57420, R.drawable.emoji_1f313);
        SOFTBANKS_MAP.put(57421, R.drawable.emoji_1f304);
        SOFTBANKS_MAP.put(57422, R.drawable.emoji_1f47c);
        SOFTBANKS_MAP.put(57423, R.drawable.emoji_1f431);
        SOFTBANKS_MAP.put(57424, R.drawable.emoji_1f42f);
        SOFTBANKS_MAP.put(57425, R.drawable.emoji_1f43b);
        SOFTBANKS_MAP.put(57426, R.drawable.emoji_1f429);
        SOFTBANKS_MAP.put(57427, R.drawable.emoji_1f42d);
        SOFTBANKS_MAP.put(57428, R.drawable.emoji_1f433);
        SOFTBANKS_MAP.put(57429, R.drawable.emoji_1f427);
        SOFTBANKS_MAP.put(57430, R.drawable.emoji_1f60a);
        SOFTBANKS_MAP.put(57431, R.drawable.emoji_1f603);
        SOFTBANKS_MAP.put(57432, R.drawable.emoji_1f61e);
        SOFTBANKS_MAP.put(57433, R.drawable.emoji_1f620);
        SOFTBANKS_MAP.put(57434, R.drawable.emoji_1f4a9);
        SOFTBANKS_MAP.put(57601, R.drawable.emoji_1f4ea);
        SOFTBANKS_MAP.put(57602, R.drawable.emoji_1f4ee);
        SOFTBANKS_MAP.put(57603, R.drawable.emoji_1f4e7);
        SOFTBANKS_MAP.put(57604, R.drawable.emoji_1f4f2);
        SOFTBANKS_MAP.put(57605, R.drawable.emoji_1f61c);
        SOFTBANKS_MAP.put(57606, R.drawable.emoji_1f60d);
        SOFTBANKS_MAP.put(57607, R.drawable.emoji_1f631);
        SOFTBANKS_MAP.put(57608, R.drawable.emoji_1f613);
        SOFTBANKS_MAP.put(57609, R.drawable.emoji_1f435);
        SOFTBANKS_MAP.put(57610, R.drawable.emoji_1f419);
        SOFTBANKS_MAP.put(57611, R.drawable.emoji_1f437);
        SOFTBANKS_MAP.put(57612, R.drawable.emoji_1f47d);
        SOFTBANKS_MAP.put(57613, R.drawable.emoji_1f680);
        SOFTBANKS_MAP.put(57614, R.drawable.emoji_1f451);
        SOFTBANKS_MAP.put(57615, R.drawable.emoji_1f4a1);
        SOFTBANKS_MAP.put(57616, R.drawable.emoji_1f331);
        SOFTBANKS_MAP.put(57617, R.drawable.emoji_1f48f);
        SOFTBANKS_MAP.put(57618, R.drawable.emoji_1f381);
        SOFTBANKS_MAP.put(57619, R.drawable.emoji_1f52b);
        SOFTBANKS_MAP.put(57620, R.drawable.emoji_1f50d);
        SOFTBANKS_MAP.put(57621, R.drawable.emoji_1f3c3);
        SOFTBANKS_MAP.put(57622, R.drawable.emoji_1f528);
        SOFTBANKS_MAP.put(57623, R.drawable.emoji_1f386);
        SOFTBANKS_MAP.put(57624, R.drawable.emoji_1f341);
        SOFTBANKS_MAP.put(57625, R.drawable.emoji_1f342);
        SOFTBANKS_MAP.put(57626, R.drawable.emoji_1f47f);
        SOFTBANKS_MAP.put(57627, R.drawable.emoji_1f47b);
        SOFTBANKS_MAP.put(57628, R.drawable.emoji_1f480);
        SOFTBANKS_MAP.put(57629, R.drawable.emoji_1f525);
        SOFTBANKS_MAP.put(57630, R.drawable.emoji_1f4bc);
        SOFTBANKS_MAP.put(57631, R.drawable.emoji_1f4ba);
        SOFTBANKS_MAP.put(57632, R.drawable.emoji_1f354);
        SOFTBANKS_MAP.put(57633, R.drawable.emoji_26f2);
        SOFTBANKS_MAP.put(57634, R.drawable.emoji_26fa);
        SOFTBANKS_MAP.put(57635, R.drawable.emoji_2668);
        SOFTBANKS_MAP.put(57636, R.drawable.emoji_1f3a1);
        SOFTBANKS_MAP.put(57637, R.drawable.emoji_1f3ab);
        SOFTBANKS_MAP.put(57638, R.drawable.emoji_1f4bf);
        SOFTBANKS_MAP.put(57639, R.drawable.emoji_1f4c0);
        SOFTBANKS_MAP.put(57640, R.drawable.emoji_1f4fb);
        SOFTBANKS_MAP.put(57641, R.drawable.emoji_1f4fc);
        SOFTBANKS_MAP.put(57642, R.drawable.emoji_1f4fa);
        SOFTBANKS_MAP.put(57643, R.drawable.emoji_1f47e);
        SOFTBANKS_MAP.put(57644, R.drawable.emoji_303d);
        SOFTBANKS_MAP.put(57645, R.drawable.emoji_1f004);
        SOFTBANKS_MAP.put(57646, R.drawable.emoji_1f19a);
        SOFTBANKS_MAP.put(57647, R.drawable.emoji_1f4b0);
        SOFTBANKS_MAP.put(57648, R.drawable.emoji_1f3af);
        SOFTBANKS_MAP.put(57649, R.drawable.emoji_1f3c6);
        SOFTBANKS_MAP.put(57650, R.drawable.emoji_1f3c1);
        SOFTBANKS_MAP.put(57651, R.drawable.emoji_1f3b0);
        SOFTBANKS_MAP.put(57652, R.drawable.emoji_1f40e);
        SOFTBANKS_MAP.put(57653, R.drawable.emoji_1f6a4);
        SOFTBANKS_MAP.put(57654, R.drawable.emoji_1f6b2);
        SOFTBANKS_MAP.put(57655, R.drawable.emoji_1f6a7);
        SOFTBANKS_MAP.put(57656, R.drawable.emoji_1f6b9);
        SOFTBANKS_MAP.put(57657, R.drawable.emoji_1f6ba);
        SOFTBANKS_MAP.put(57658, R.drawable.emoji_1f6bc);
        SOFTBANKS_MAP.put(57659, R.drawable.emoji_1f489);
        SOFTBANKS_MAP.put(57660, R.drawable.emoji_1f4a4);
        SOFTBANKS_MAP.put(57661, R.drawable.emoji_26a1);
        SOFTBANKS_MAP.put(57662, R.drawable.emoji_1f460);
        SOFTBANKS_MAP.put(57663, R.drawable.emoji_1f6c0);
        SOFTBANKS_MAP.put(57664, R.drawable.emoji_1f6bd);
        SOFTBANKS_MAP.put(57665, R.drawable.emoji_1f50a);
        SOFTBANKS_MAP.put(57666, R.drawable.emoji_1f4e2);
        SOFTBANKS_MAP.put(57667, R.drawable.emoji_1f38c);
        SOFTBANKS_MAP.put(57668, R.drawable.emoji_1f50f);
        SOFTBANKS_MAP.put(57669, R.drawable.emoji_1f513);
        SOFTBANKS_MAP.put(57670, R.drawable.emoji_1f306);
        SOFTBANKS_MAP.put(57671, R.drawable.emoji_1f373);
        SOFTBANKS_MAP.put(57672, R.drawable.emoji_1f4c7);
        SOFTBANKS_MAP.put(57673, R.drawable.emoji_1f4b1);
        SOFTBANKS_MAP.put(57674, R.drawable.emoji_1f4b9);
        SOFTBANKS_MAP.put(57675, R.drawable.emoji_1f4e1);
        SOFTBANKS_MAP.put(57676, R.drawable.emoji_1f4aa);
        SOFTBANKS_MAP.put(57677, R.drawable.emoji_1f3e6);
        SOFTBANKS_MAP.put(57678, R.drawable.emoji_1f6a5);
        SOFTBANKS_MAP.put(57679, R.drawable.emoji_1f17f);
        SOFTBANKS_MAP.put(57680, R.drawable.emoji_1f68f);
        SOFTBANKS_MAP.put(57681, R.drawable.emoji_1f6bb);
        SOFTBANKS_MAP.put(57682, R.drawable.emoji_1f46e);
        SOFTBANKS_MAP.put(57683, R.drawable.emoji_1f3e3);
        SOFTBANKS_MAP.put(57684, R.drawable.emoji_1f3e7);
        SOFTBANKS_MAP.put(57685, R.drawable.emoji_1f3e5);
        SOFTBANKS_MAP.put(57686, R.drawable.emoji_1f3ea);
        SOFTBANKS_MAP.put(57687, R.drawable.emoji_1f3eb);
        SOFTBANKS_MAP.put(57688, R.drawable.emoji_1f3e8);
        SOFTBANKS_MAP.put(57689, R.drawable.emoji_1f68c);
        SOFTBANKS_MAP.put(57690, R.drawable.emoji_1f695);
        SOFTBANKS_MAP.put(57857, R.drawable.emoji_1f6b6);
        SOFTBANKS_MAP.put(57858, R.drawable.emoji_1f6a2);
        SOFTBANKS_MAP.put(57859, R.drawable.emoji_1f201);
        SOFTBANKS_MAP.put(57860, R.drawable.emoji_1f49f);
        SOFTBANKS_MAP.put(57861, R.drawable.emoji_2734);
        SOFTBANKS_MAP.put(57862, R.drawable.emoji_2733);
        SOFTBANKS_MAP.put(57863, R.drawable.emoji_1f51e);
        SOFTBANKS_MAP.put(57864, R.drawable.emoji_1f6ad);
        SOFTBANKS_MAP.put(57865, R.drawable.emoji_1f530);
        SOFTBANKS_MAP.put(57866, R.drawable.emoji_267f);
        SOFTBANKS_MAP.put(57867, R.drawable.emoji_1f4f6);
        SOFTBANKS_MAP.put(57868, R.drawable.emoji_2665);
        SOFTBANKS_MAP.put(57869, R.drawable.emoji_2666);
        SOFTBANKS_MAP.put(57870, R.drawable.emoji_2660);
        SOFTBANKS_MAP.put(57871, R.drawable.emoji_2663);
        SOFTBANKS_MAP.put(57872, R.drawable.emoji_0023);
        SOFTBANKS_MAP.put(57873, R.drawable.emoji_27bf);
        SOFTBANKS_MAP.put(57874, R.drawable.emoji_1f195);
        SOFTBANKS_MAP.put(57875, R.drawable.emoji_1f199);
        SOFTBANKS_MAP.put(57876, R.drawable.emoji_1f192);
        SOFTBANKS_MAP.put(57877, R.drawable.emoji_1f236);
        SOFTBANKS_MAP.put(57878, R.drawable.emoji_1f21a);
        SOFTBANKS_MAP.put(57879, R.drawable.emoji_1f237);
        SOFTBANKS_MAP.put(57880, R.drawable.emoji_1f238);
        SOFTBANKS_MAP.put(57881, R.drawable.emoji_1f534);
        SOFTBANKS_MAP.put(57882, R.drawable.emoji_1f532);
        SOFTBANKS_MAP.put(57883, R.drawable.emoji_1f533);
        SOFTBANKS_MAP.put(57884, R.drawable.emoji_0031);
        SOFTBANKS_MAP.put(57885, R.drawable.emoji_0032);
        SOFTBANKS_MAP.put(57886, R.drawable.emoji_0033);
        SOFTBANKS_MAP.put(57887, R.drawable.emoji_0034);
        SOFTBANKS_MAP.put(57888, R.drawable.emoji_0035);
        SOFTBANKS_MAP.put(57889, R.drawable.emoji_0036);
        SOFTBANKS_MAP.put(57890, R.drawable.emoji_0037);
        SOFTBANKS_MAP.put(57891, R.drawable.emoji_0038);
        SOFTBANKS_MAP.put(57892, R.drawable.emoji_0039);
        SOFTBANKS_MAP.put(57893, R.drawable.emoji_0030);
        SOFTBANKS_MAP.put(57894, R.drawable.emoji_1f250);
        SOFTBANKS_MAP.put(57895, R.drawable.emoji_1f239);
        SOFTBANKS_MAP.put(57896, R.drawable.emoji_1f202);
        SOFTBANKS_MAP.put(57897, R.drawable.emoji_1f194);
        SOFTBANKS_MAP.put(57898, R.drawable.emoji_1f235);
        SOFTBANKS_MAP.put(57899, R.drawable.emoji_1f233);
        SOFTBANKS_MAP.put(57900, R.drawable.emoji_1f22f);
        SOFTBANKS_MAP.put(57901, R.drawable.emoji_1f23a);
        SOFTBANKS_MAP.put(57902, R.drawable.emoji_1f446);
        SOFTBANKS_MAP.put(57903, R.drawable.emoji_1f447);
        SOFTBANKS_MAP.put(57904, R.drawable.emoji_1f448);
        SOFTBANKS_MAP.put(57905, R.drawable.emoji_1f449);
        SOFTBANKS_MAP.put(57906, R.drawable.emoji_2b06);
        SOFTBANKS_MAP.put(57907, R.drawable.emoji_2b07);
        SOFTBANKS_MAP.put(57908, R.drawable.emoji_27a1);
        SOFTBANKS_MAP.put(57909, R.drawable.emoji_1f519);
        SOFTBANKS_MAP.put(57910, R.drawable.emoji_2197);
        SOFTBANKS_MAP.put(57911, R.drawable.emoji_2196);
        SOFTBANKS_MAP.put(57912, R.drawable.emoji_2198);
        SOFTBANKS_MAP.put(57913, R.drawable.emoji_2199);
        SOFTBANKS_MAP.put(57914, R.drawable.emoji_25b6);
        SOFTBANKS_MAP.put(57915, R.drawable.emoji_25c0);
        SOFTBANKS_MAP.put(57916, R.drawable.emoji_23e9);
        SOFTBANKS_MAP.put(57917, R.drawable.emoji_23ea);
        SOFTBANKS_MAP.put(57918, R.drawable.emoji_1f52e);
        SOFTBANKS_MAP.put(57919, R.drawable.emoji_2648);
        SOFTBANKS_MAP.put(57920, R.drawable.emoji_2649);
        SOFTBANKS_MAP.put(57921, R.drawable.emoji_264a);
        SOFTBANKS_MAP.put(57922, R.drawable.emoji_264b);
        SOFTBANKS_MAP.put(57923, R.drawable.emoji_264c);
        SOFTBANKS_MAP.put(57924, R.drawable.emoji_264d);
        SOFTBANKS_MAP.put(57925, R.drawable.emoji_264e);
        SOFTBANKS_MAP.put(57926, R.drawable.emoji_264f);
        SOFTBANKS_MAP.put(57927, R.drawable.emoji_2650);
        SOFTBANKS_MAP.put(57928, R.drawable.emoji_2651);
        SOFTBANKS_MAP.put(57929, R.drawable.emoji_2652);
        SOFTBANKS_MAP.put(57930, R.drawable.emoji_2653);
        SOFTBANKS_MAP.put(57931, R.drawable.emoji_26ce);
        SOFTBANKS_MAP.put(57932, R.drawable.emoji_1f51d);
        SOFTBANKS_MAP.put(57933, R.drawable.emoji_1f197);
        SOFTBANKS_MAP.put(57934, R.drawable.emoji_00a9);
        SOFTBANKS_MAP.put(57935, R.drawable.emoji_00ae);
        SOFTBANKS_MAP.put(57936, R.drawable.emoji_1f4f3);
        SOFTBANKS_MAP.put(57937, R.drawable.emoji_1f4f4);
        SOFTBANKS_MAP.put(57938, R.drawable.emoji_26a0);
        SOFTBANKS_MAP.put(57939, R.drawable.emoji_1f481);
        SOFTBANKS_MAP.put(58113, R.drawable.emoji_1f4c3);
        SOFTBANKS_MAP.put(58114, R.drawable.emoji_1f454);
        SOFTBANKS_MAP.put(58115, R.drawable.emoji_1f33a);
        SOFTBANKS_MAP.put(58116, R.drawable.emoji_1f337);
        SOFTBANKS_MAP.put(58117, R.drawable.emoji_1f33b);
        SOFTBANKS_MAP.put(58118, R.drawable.emoji_1f490);
        SOFTBANKS_MAP.put(58119, R.drawable.emoji_1f334);
        SOFTBANKS_MAP.put(58120, R.drawable.emoji_1f335);
        SOFTBANKS_MAP.put(58121, R.drawable.emoji_1f6be);
        SOFTBANKS_MAP.put(58122, R.drawable.emoji_1f3a7);
        SOFTBANKS_MAP.put(58123, R.drawable.emoji_1f376);
        SOFTBANKS_MAP.put(58124, R.drawable.emoji_1f37b);
        SOFTBANKS_MAP.put(58125, R.drawable.emoji_3297);
        SOFTBANKS_MAP.put(58126, R.drawable.emoji_1f6ac);
        SOFTBANKS_MAP.put(58127, R.drawable.emoji_1f48a);
        SOFTBANKS_MAP.put(58128, R.drawable.emoji_1f388);
        SOFTBANKS_MAP.put(58129, R.drawable.emoji_1f4a3);
        SOFTBANKS_MAP.put(58130, R.drawable.emoji_1f389);
        SOFTBANKS_MAP.put(58131, R.drawable.emoji_2702);
        SOFTBANKS_MAP.put(58132, R.drawable.emoji_1f380);
        SOFTBANKS_MAP.put(58133, R.drawable.emoji_3299);
        SOFTBANKS_MAP.put(58134, R.drawable.emoji_1f4bd);
        SOFTBANKS_MAP.put(58135, R.drawable.emoji_1f4e3);
        SOFTBANKS_MAP.put(58136, R.drawable.emoji_1f452);
        SOFTBANKS_MAP.put(58137, R.drawable.emoji_1f457);
        SOFTBANKS_MAP.put(58138, R.drawable.emoji_1f461);
        SOFTBANKS_MAP.put(58139, R.drawable.emoji_1f462);
        SOFTBANKS_MAP.put(58140, R.drawable.emoji_1f484);
        SOFTBANKS_MAP.put(58141, R.drawable.emoji_1f485);
        SOFTBANKS_MAP.put(58142, R.drawable.emoji_1f486);
        SOFTBANKS_MAP.put(58143, R.drawable.emoji_1f487);
        SOFTBANKS_MAP.put(58144, R.drawable.emoji_1f488);
        SOFTBANKS_MAP.put(58145, R.drawable.emoji_1f458);
        SOFTBANKS_MAP.put(58146, R.drawable.emoji_1f459);
        SOFTBANKS_MAP.put(58147, R.drawable.emoji_1f45c);
        SOFTBANKS_MAP.put(58148, R.drawable.emoji_1f3ac);
        SOFTBANKS_MAP.put(58149, R.drawable.emoji_1f514);
        SOFTBANKS_MAP.put(58150, R.drawable.emoji_1f3b6);
        SOFTBANKS_MAP.put(58151, R.drawable.emoji_1f493);
        SOFTBANKS_MAP.put(58152, R.drawable.emoji_1f48c);
        SOFTBANKS_MAP.put(58153, R.drawable.emoji_1f498);
        SOFTBANKS_MAP.put(58154, R.drawable.emoji_1f499);
        SOFTBANKS_MAP.put(58155, R.drawable.emoji_1f49a);
        SOFTBANKS_MAP.put(58156, R.drawable.emoji_1f49b);
        SOFTBANKS_MAP.put(58157, R.drawable.emoji_1f49c);
        SOFTBANKS_MAP.put(58158, R.drawable.emoji_2728);
        SOFTBANKS_MAP.put(58159, R.drawable.emoji_2b50);
        SOFTBANKS_MAP.put(58160, R.drawable.emoji_1f4a8);
        SOFTBANKS_MAP.put(58161, R.drawable.emoji_1f4a6);
        SOFTBANKS_MAP.put(58162, R.drawable.emoji_2b55);
        SOFTBANKS_MAP.put(58163, R.drawable.emoji_2716);
        SOFTBANKS_MAP.put(58164, R.drawable.emoji_1f4a2);
        SOFTBANKS_MAP.put(58165, R.drawable.emoji_1f31f);
        SOFTBANKS_MAP.put(58166, R.drawable.emoji_2754);
        SOFTBANKS_MAP.put(58167, R.drawable.emoji_2755);
        SOFTBANKS_MAP.put(58168, R.drawable.emoji_1f375);
        SOFTBANKS_MAP.put(58169, R.drawable.emoji_1f35e);
        SOFTBANKS_MAP.put(58170, R.drawable.emoji_1f366);
        SOFTBANKS_MAP.put(58171, R.drawable.emoji_1f35f);
        SOFTBANKS_MAP.put(58172, R.drawable.emoji_1f361);
        SOFTBANKS_MAP.put(58173, R.drawable.emoji_1f358);
        SOFTBANKS_MAP.put(58174, R.drawable.emoji_1f35a);
        SOFTBANKS_MAP.put(58175, R.drawable.emoji_1f35d);
        SOFTBANKS_MAP.put(58176, R.drawable.emoji_1f35c);
        SOFTBANKS_MAP.put(58177, R.drawable.emoji_1f35b);
        SOFTBANKS_MAP.put(58178, R.drawable.emoji_1f359);
        SOFTBANKS_MAP.put(58179, R.drawable.emoji_1f362);
        SOFTBANKS_MAP.put(58180, R.drawable.emoji_1f363);
        SOFTBANKS_MAP.put(58181, R.drawable.emoji_1f34e);
        SOFTBANKS_MAP.put(58182, R.drawable.emoji_1f34a);
        SOFTBANKS_MAP.put(58183, R.drawable.emoji_1f353);
        SOFTBANKS_MAP.put(58184, R.drawable.emoji_1f349);
        SOFTBANKS_MAP.put(58185, R.drawable.emoji_1f345);
        SOFTBANKS_MAP.put(58186, R.drawable.emoji_1f346);
        SOFTBANKS_MAP.put(58187, R.drawable.emoji_1f382);
        SOFTBANKS_MAP.put(58188, R.drawable.emoji_1f371);
        SOFTBANKS_MAP.put(58189, R.drawable.emoji_1f372);
        SOFTBANKS_MAP.put(58369, R.drawable.emoji_1f625);
        SOFTBANKS_MAP.put(58370, R.drawable.emoji_1f60f);
        SOFTBANKS_MAP.put(58371, R.drawable.emoji_1f614);
        SOFTBANKS_MAP.put(58372, R.drawable.emoji_1f601);
        SOFTBANKS_MAP.put(58373, R.drawable.emoji_1f609);
        SOFTBANKS_MAP.put(58374, R.drawable.emoji_1f623);
        SOFTBANKS_MAP.put(58375, R.drawable.emoji_1f616);
        SOFTBANKS_MAP.put(58376, R.drawable.emoji_1f62a);
        SOFTBANKS_MAP.put(58377, R.drawable.emoji_1f445);
        SOFTBANKS_MAP.put(58378, R.drawable.emoji_1f606);
        SOFTBANKS_MAP.put(58379, R.drawable.emoji_1f628);
        SOFTBANKS_MAP.put(58380, R.drawable.emoji_1f637);
        SOFTBANKS_MAP.put(58381, R.drawable.emoji_1f633);
        SOFTBANKS_MAP.put(58382, R.drawable.emoji_1f612);
        SOFTBANKS_MAP.put(58383, R.drawable.emoji_1f630);
        SOFTBANKS_MAP.put(58384, R.drawable.emoji_1f632);
        SOFTBANKS_MAP.put(58385, R.drawable.emoji_1f62d);
        SOFTBANKS_MAP.put(58386, R.drawable.emoji_1f602);
        SOFTBANKS_MAP.put(58387, R.drawable.emoji_1f622);
        SOFTBANKS_MAP.put(58388, R.drawable.emoji_263a);
        SOFTBANKS_MAP.put(58389, R.drawable.emoji_1f605);
        SOFTBANKS_MAP.put(58390, R.drawable.emoji_1f621);
        SOFTBANKS_MAP.put(58391, R.drawable.emoji_1f61a);
        SOFTBANKS_MAP.put(58392, R.drawable.emoji_1f618);
        SOFTBANKS_MAP.put(58393, R.drawable.emoji_1f440);
        SOFTBANKS_MAP.put(58394, R.drawable.emoji_1f443);
        SOFTBANKS_MAP.put(58395, R.drawable.emoji_1f442);
        SOFTBANKS_MAP.put(58396, R.drawable.emoji_1f444);
        SOFTBANKS_MAP.put(58397, R.drawable.emoji_1f64f);
        SOFTBANKS_MAP.put(58398, R.drawable.emoji_1f44b);
        SOFTBANKS_MAP.put(58399, R.drawable.emoji_1f44f);
        SOFTBANKS_MAP.put(58400, R.drawable.emoji_1f44c);
        SOFTBANKS_MAP.put(58401, R.drawable.emoji_1f44e);
        SOFTBANKS_MAP.put(58402, R.drawable.emoji_1f450);
        SOFTBANKS_MAP.put(58403, R.drawable.emoji_1f645);
        SOFTBANKS_MAP.put(58404, R.drawable.emoji_1f646);
        SOFTBANKS_MAP.put(58405, R.drawable.emoji_1f491);
        SOFTBANKS_MAP.put(58406, R.drawable.emoji_1f647);
        SOFTBANKS_MAP.put(58407, R.drawable.emoji_1f64c);
        SOFTBANKS_MAP.put(58408, R.drawable.emoji_1f46b);
        SOFTBANKS_MAP.put(58409, R.drawable.emoji_1f46f);
        SOFTBANKS_MAP.put(58410, R.drawable.emoji_1f3c0);
        SOFTBANKS_MAP.put(58411, R.drawable.emoji_1f3c8);
        SOFTBANKS_MAP.put(58412, R.drawable.emoji_1f3b1);
        SOFTBANKS_MAP.put(58413, R.drawable.emoji_1f3ca);
        SOFTBANKS_MAP.put(58414, R.drawable.emoji_1f699);
        SOFTBANKS_MAP.put(58415, R.drawable.emoji_1f69a);
        SOFTBANKS_MAP.put(58416, R.drawable.emoji_1f692);
        SOFTBANKS_MAP.put(58417, R.drawable.emoji_1f691);
        SOFTBANKS_MAP.put(58418, R.drawable.emoji_1f693);
        SOFTBANKS_MAP.put(58419, R.drawable.emoji_1f3a2);
        SOFTBANKS_MAP.put(58420, R.drawable.emoji_1f687);
        SOFTBANKS_MAP.put(58421, R.drawable.emoji_1f684);
        SOFTBANKS_MAP.put(58422, R.drawable.emoji_1f38d);
        SOFTBANKS_MAP.put(58423, R.drawable.emoji_1f49d);
        SOFTBANKS_MAP.put(58424, R.drawable.emoji_1f38e);
        SOFTBANKS_MAP.put(58425, R.drawable.emoji_1f393);
        SOFTBANKS_MAP.put(58426, R.drawable.emoji_1f392);
        SOFTBANKS_MAP.put(58427, R.drawable.emoji_1f38f);
        SOFTBANKS_MAP.put(58428, R.drawable.emoji_1f302);
        SOFTBANKS_MAP.put(58429, R.drawable.emoji_1f492);
        SOFTBANKS_MAP.put(58430, R.drawable.emoji_1f30a);
        SOFTBANKS_MAP.put(58431, R.drawable.emoji_1f367);
        SOFTBANKS_MAP.put(58432, R.drawable.emoji_1f387);
        SOFTBANKS_MAP.put(58433, R.drawable.emoji_1f41a);
        SOFTBANKS_MAP.put(58434, R.drawable.emoji_1f390);
        SOFTBANKS_MAP.put(58435, R.drawable.emoji_1f300);
        SOFTBANKS_MAP.put(58436, R.drawable.emoji_1f33e);
        SOFTBANKS_MAP.put(58437, R.drawable.emoji_1f383);
        SOFTBANKS_MAP.put(58438, R.drawable.emoji_1f391);
        SOFTBANKS_MAP.put(58439, R.drawable.emoji_1f343);
        SOFTBANKS_MAP.put(58440, R.drawable.emoji_1f385);
        SOFTBANKS_MAP.put(58441, R.drawable.emoji_1f305);
        SOFTBANKS_MAP.put(58442, R.drawable.emoji_1f307);
        SOFTBANKS_MAP.put(58443, R.drawable.emoji_1f303);
        SOFTBANKS_MAP.put(58443, R.drawable.emoji_1f30c);
        SOFTBANKS_MAP.put(58444, R.drawable.emoji_1f308);
        SOFTBANKS_MAP.put(58625, R.drawable.emoji_1f3e9);
        SOFTBANKS_MAP.put(58626, R.drawable.emoji_1f3a8);
        SOFTBANKS_MAP.put(58627, R.drawable.emoji_1f3a9);
        SOFTBANKS_MAP.put(58628, R.drawable.emoji_1f3ec);
        SOFTBANKS_MAP.put(58629, R.drawable.emoji_1f3ef);
        SOFTBANKS_MAP.put(58630, R.drawable.emoji_1f3f0);
        SOFTBANKS_MAP.put(58631, R.drawable.emoji_1f3a6);
        SOFTBANKS_MAP.put(58632, R.drawable.emoji_1f3ed);
        SOFTBANKS_MAP.put(58633, R.drawable.emoji_1f5fc);
        SOFTBANKS_MAP.put(58635, R.drawable.emoji_1f1ef_1f1f5);
        SOFTBANKS_MAP.put(58636, R.drawable.emoji_1f1fa_1f1f8);
        SOFTBANKS_MAP.put(58637, R.drawable.emoji_1f1eb_1f1f7);
        SOFTBANKS_MAP.put(58638, R.drawable.emoji_1f1e9_1f1ea);
        SOFTBANKS_MAP.put(58639, R.drawable.emoji_1f1ee_1f1f9);
        SOFTBANKS_MAP.put(58640, R.drawable.emoji_1f1ec_1f1e7);
        SOFTBANKS_MAP.put(58641, R.drawable.emoji_1f1ea_1f1f8);
        SOFTBANKS_MAP.put(58642, R.drawable.emoji_1f1f7_1f1fa);
        SOFTBANKS_MAP.put(58643, R.drawable.emoji_1f1e8_1f1f3);
        SOFTBANKS_MAP.put(58644, R.drawable.emoji_1f1f0_1f1f7);
        SOFTBANKS_MAP.put(58645, R.drawable.emoji_1f471);
        SOFTBANKS_MAP.put(58646, R.drawable.emoji_1f472);
        SOFTBANKS_MAP.put(58647, R.drawable.emoji_1f473);
        SOFTBANKS_MAP.put(58648, R.drawable.emoji_1f474);
        SOFTBANKS_MAP.put(58649, R.drawable.emoji_1f475);
        SOFTBANKS_MAP.put(58650, R.drawable.emoji_1f476);
        SOFTBANKS_MAP.put(58651, R.drawable.emoji_1f477);
        SOFTBANKS_MAP.put(58652, R.drawable.emoji_1f478);
        SOFTBANKS_MAP.put(58653, R.drawable.emoji_1f5fd);
        SOFTBANKS_MAP.put(58654, R.drawable.emoji_1f482);
        SOFTBANKS_MAP.put(58655, R.drawable.emoji_1f483);
        SOFTBANKS_MAP.put(58656, R.drawable.emoji_1f42c);
        SOFTBANKS_MAP.put(58657, R.drawable.emoji_1f426);
        SOFTBANKS_MAP.put(58658, R.drawable.emoji_1f420);
        SOFTBANKS_MAP.put(58659, R.drawable.emoji_1f423);
        SOFTBANKS_MAP.put(58660, R.drawable.emoji_1f439);
        SOFTBANKS_MAP.put(58661, R.drawable.emoji_1f41b);
        SOFTBANKS_MAP.put(58662, R.drawable.emoji_1f418);
        SOFTBANKS_MAP.put(58663, R.drawable.emoji_1f428);
        SOFTBANKS_MAP.put(58664, R.drawable.emoji_1f412);
        SOFTBANKS_MAP.put(58665, R.drawable.emoji_1f411);
        SOFTBANKS_MAP.put(58666, R.drawable.emoji_1f43a);
        SOFTBANKS_MAP.put(58667, R.drawable.emoji_1f42e);
        SOFTBANKS_MAP.put(58668, R.drawable.emoji_1f430);
        SOFTBANKS_MAP.put(58669, R.drawable.emoji_1f40d);
        SOFTBANKS_MAP.put(58670, R.drawable.emoji_1f414);
        SOFTBANKS_MAP.put(58671, R.drawable.emoji_1f417);
        SOFTBANKS_MAP.put(58672, R.drawable.emoji_1f42b);
        SOFTBANKS_MAP.put(58673, R.drawable.emoji_1f438);
        SOFTBANKS_MAP.put(58674, R.drawable.emoji_1f170);
        SOFTBANKS_MAP.put(58675, R.drawable.emoji_1f171);
        SOFTBANKS_MAP.put(58676, R.drawable.emoji_1f18e);
        SOFTBANKS_MAP.put(58677, R.drawable.emoji_1f17e);
        SOFTBANKS_MAP.put(58678, R.drawable.emoji_1f43e);
        SOFTBANKS_MAP.put(58679, R.drawable.emoji_2122);
    }
}

