/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.text.Spannable;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.widget.EditText;
import com.vanniktech.emoji.EmojiHandler;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.emoji.Emoji;

public class EmojiEditText
extends EditText {
    private int emojiSize;

    public EmojiEditText(Context context) {
        super(context);
        this.init(null);
    }

    public EmojiEditText(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public EmojiEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    private void init(@Nullable AttributeSet attrs) {
        if (attrs == null) {
            this.emojiSize = (int)this.getTextSize();
        } else {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.emoji);
            try {
                this.emojiSize = (int)a.getDimension(R.styleable.emoji_emojiSize, this.getTextSize());
            }
            finally {
                a.recycle();
            }
        }
        this.setText((CharSequence)this.getText());
    }

    protected void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        EmojiHandler.addEmojis(this.getContext(), (Spannable)this.getText(), this.emojiSize);
    }

    public void setEmojiSize(int pixels) {
        this.emojiSize = pixels;
    }

    public void backspace() {
        KeyEvent event = new KeyEvent(0L, 0L, 0, 67, 0, 0, 0, 0, 6);
        this.dispatchKeyEvent(event);
    }

    public void input(Emoji emoji) {
        if (emoji != null) {
            int start = this.getSelectionStart();
            int end = this.getSelectionEnd();
            if (start < 0) {
                this.append(emoji.getEmoji());
            } else {
                this.getText().replace(Math.min(start, end), Math.max(start, end), (CharSequence)emoji.getEmoji(), 0, emoji.getEmoji().length());
            }
        }
    }
}

