/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.material;

import android.content.Context;
import android.graphics.Paint;
import android.text.Spannable;
import android.util.AttributeSet;
import android.widget.TextView;
import androidx.annotation.AttrRes;
import androidx.annotation.CallSuper;
import androidx.annotation.DimenRes;
import androidx.annotation.Px;
import com.google.android.material.R;
import com.google.android.material.textfield.TextInputEditText;
import com.vanniktech.emoji.EmojiDisplayable;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.EmojiManagers;
import com.vanniktech.emoji.EmojiTextViews;
import com.vanniktech.emoji.material.R;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B%\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0003\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\u000bH\u0016J*\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\bH\u0015J\u0012\u0010\u0014\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\bH\u0016J\u001a\u0010\u0014\u001a\u00020\u000e2\b\b\u0001\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\bH\u0016J\u001a\u0010\u0018\u001a\u00020\u000e2\b\b\u0001\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\n\u001a\u00020\u000b8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/vanniktech/emoji/material/EmojiTextInputEditText;", "Lcom/google/android/material/textfield/TextInputEditText;", "Lcom/vanniktech/emoji/EmojiDisplayable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "emojiSize", "", "getEmojiSize", "onTextChanged", "", "text", "", "start", "lengthBefore", "lengthAfter", "setEmojiSize", "pixels", "shouldInvalidate", "", "setEmojiSizeRes", "res", "emoji-material_release"})
public class EmojiTextInputEditText
extends TextInputEditText
implements EmojiDisplayable {
    @Px
    private float emojiSize;

    @JvmOverloads
    public EmojiTextInputEditText(@NotNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        TextView textView = (TextView)this;
        Intrinsics.checkNotNullExpressionValue((Object)R.styleable.EmojiTextInputEditText, (String)"EmojiTextInputEditText");
        this.emojiSize = EmojiTextViews.init((TextView)textView, (AttributeSet)attrs, (int[])R.styleable.EmojiTextInputEditText, (int)R.styleable.EmojiTextInputEditText_emojiSize);
    }

    public /* synthetic */ EmojiTextInputEditText(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = R.attr.editTextStyle;
        }
        this(context, attributeSet, n);
    }

    @CallSuper
    protected void onTextChanged(@Nullable CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this.isInEditMode()) {
            return;
        }
        Paint.FontMetrics fontMetrics = this.getPaint().getFontMetrics();
        float defaultEmojiSize = fontMetrics.descent - fontMetrics.ascent;
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        EmojiManagers.replaceWithImages((EmojiManager)EmojiManager.INSTANCE, (Context)context, (Spannable)((Spannable)this.getText()), (float)(!(this.emojiSize == 0.0f) ? this.emojiSize : defaultEmojiSize));
    }

    public float getEmojiSize() {
        return this.emojiSize;
    }

    public void setEmojiSize(@Px int pixels) {
        this.setEmojiSize(pixels, true);
    }

    public void setEmojiSize(@Px int pixels, boolean shouldInvalidate) {
        this.emojiSize = pixels;
        if (shouldInvalidate) {
            this.setText((CharSequence)this.getText());
        }
    }

    public void setEmojiSizeRes(@DimenRes int res) {
        this.setEmojiSizeRes(res, true);
    }

    public void setEmojiSizeRes(@DimenRes int res, boolean shouldInvalidate) {
        this.setEmojiSize(this.getResources().getDimensionPixelSize(res), shouldInvalidate);
    }

    @JvmOverloads
    public EmojiTextInputEditText(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public EmojiTextInputEditText(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, 6, null);
    }
}

