/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.google;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.LruCache;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiAndroidProvider;
import com.vanniktech.emoji.EmojiCategory;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.google.GoogleEmoji;
import com.vanniktech.emoji.google.R;
import com.vanniktech.emoji.google.category.ActivitiesCategory;
import com.vanniktech.emoji.google.category.AnimalsAndNatureCategory;
import com.vanniktech.emoji.google.category.FlagsCategory;
import com.vanniktech.emoji.google.category.FoodAndDrinkCategory;
import com.vanniktech.emoji.google.category.ObjectsCategory;
import com.vanniktech.emoji.google.category.SmileysAndPeopleCategory;
import com.vanniktech.emoji.google.category.SymbolsCategory;
import com.vanniktech.emoji.google.category.TravelAndPlacesCategory;
import java.lang.ref.SoftReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u00012\u00020\u0002:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/vanniktech/emoji/google/GoogleEmojiProvider;", "Lcom/vanniktech/emoji/EmojiProvider;", "Lcom/vanniktech/emoji/EmojiAndroidProvider;", "()V", "categories", "", "Lcom/vanniktech/emoji/EmojiCategory;", "getCategories", "()[Lcom/vanniktech/emoji/EmojiCategory;", "getDrawable", "Landroid/graphics/drawable/Drawable;", "emoji", "Lcom/vanniktech/emoji/Emoji;", "context", "Landroid/content/Context;", "getIcon", "", "emojiCategory", "loadStrip", "Landroid/graphics/Bitmap;", "x", "release", "", "Companion", "emoji-google_release"})
@SourceDebugExtension(value={"SMAP\nGoogleEmojiProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoogleEmojiProvider.kt\ncom/vanniktech/emoji/google/GoogleEmojiProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,186:1\n1#2:187\n*E\n"})
public final class GoogleEmojiProvider
implements EmojiProvider,
EmojiAndroidProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private static final int CACHE_SIZE = 100;
    private static final int SPRITE_SIZE = 64;
    private static final int SPRITE_SIZE_INC_BORDER = 66;
    private static final int NUM_STRIPS = 60;
    @NotNull
    private static final List<Integer> SHEETS;
    @NotNull
    private static final Object LOCK;
    @NotNull
    private static final SoftReference<?>[] STRIP_REFS;
    @NotNull
    private static final LruCache<Point, Bitmap> BITMAP_CACHE;

    @NotNull
    public EmojiCategory[] getCategories() {
        EmojiCategory[] emojiCategoryArray = new EmojiCategory[]{new SmileysAndPeopleCategory(), new AnimalsAndNatureCategory(), new FoodAndDrinkCategory(), new ActivitiesCategory(), new TravelAndPlacesCategory(), new ObjectsCategory(), new SymbolsCategory(), new FlagsCategory()};
        return emojiCategoryArray;
    }

    public int getIcon(@NotNull EmojiCategory emojiCategory) {
        int n;
        Intrinsics.checkNotNullParameter((Object)emojiCategory, (String)"emojiCategory");
        EmojiCategory emojiCategory2 = emojiCategory;
        if (emojiCategory2 instanceof SmileysAndPeopleCategory) {
            n = R.drawable.emoji_google_category_smileysandpeople;
        } else if (emojiCategory2 instanceof AnimalsAndNatureCategory) {
            n = R.drawable.emoji_google_category_animalsandnature;
        } else if (emojiCategory2 instanceof FoodAndDrinkCategory) {
            n = R.drawable.emoji_google_category_foodanddrink;
        } else if (emojiCategory2 instanceof ActivitiesCategory) {
            n = R.drawable.emoji_google_category_activities;
        } else if (emojiCategory2 instanceof TravelAndPlacesCategory) {
            n = R.drawable.emoji_google_category_travelandplaces;
        } else if (emojiCategory2 instanceof ObjectsCategory) {
            n = R.drawable.emoji_google_category_objects;
        } else if (emojiCategory2 instanceof SymbolsCategory) {
            n = R.drawable.emoji_google_category_symbols;
        } else if (emojiCategory2 instanceof FlagsCategory) {
            n = R.drawable.emoji_google_category_flags;
        } else {
            throw new IllegalStateException(("Unknown " + emojiCategory).toString());
        }
        return n;
    }

    @NotNull
    public Drawable getDrawable(@NotNull Emoji emoji, @NotNull Context context) {
        Bitmap strip;
        int y;
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(emoji instanceof GoogleEmoji)) {
            boolean $i$a$-require-GoogleEmojiProvider$getDrawable$22 = false;
            String $i$a$-require-GoogleEmojiProvider$getDrawable$22 = "emoji needs to be of type GoogleEmoji";
            throw new IllegalArgumentException($i$a$-require-GoogleEmojiProvider$getDrawable$22.toString());
        }
        int x = ((GoogleEmoji)emoji).getX$emoji_google_release();
        Point key = new Point(x, y = ((GoogleEmoji)emoji).getY$emoji_google_release());
        Bitmap bitmap = (Bitmap)BITMAP_CACHE.get((Object)key);
        if (bitmap != null) {
            return (Drawable)new BitmapDrawable(context.getResources(), bitmap);
        }
        Bitmap bitmap2 = strip = this.loadStrip(x, context);
        Intrinsics.checkNotNull((Object)bitmap2);
        Bitmap cut = Bitmap.createBitmap((Bitmap)bitmap2, (int)1, (int)(y * 66 + 1), (int)64, (int)64);
        BITMAP_CACHE.put((Object)key, (Object)cut);
        return (Drawable)new BitmapDrawable(context.getResources(), cut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap loadStrip(int x, Context context) {
        Bitmap strip = null;
        SoftReference<?> softReference = STRIP_REFS[x];
        strip = (Bitmap)(softReference != null ? softReference.get() : null);
        if (strip == null) {
            Object object = LOCK;
            synchronized (object) {
                boolean bl = false;
                SoftReference<?> softReference2 = STRIP_REFS[x];
                strip = (Bitmap)(softReference2 != null ? softReference2.get() : null);
                if (strip == null) {
                    Context context2 = context;
                    Intrinsics.checkNotNull((Object)context2);
                    Resources resources = context2.getResources();
                    strip = BitmapFactory.decodeResource((Resources)resources, (int)((Number)SHEETS.get(x)).intValue());
                    GoogleEmojiProvider.STRIP_REFS[x] = new SoftReference<Bitmap>(strip);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return strip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = LOCK;
        synchronized (object) {
            boolean bl = false;
            BITMAP_CACHE.evictAll();
            for (int i = 0; i < 60; ++i) {
                SoftReference<?> softReference;
                SoftReference<?> softReference2 = softReference = STRIP_REFS[i];
                Bitmap bitmap = (Bitmap)(softReference2 != null ? softReference2.get() : null);
                if (bitmap != null) {
                    bitmap.recycle();
                }
                SoftReference<?> softReference3 = softReference;
                if (softReference3 == null) continue;
                softReference3.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    static {
        Object[] objectArray = new Integer[]{R.drawable.emoji_google_sheet_0, R.drawable.emoji_google_sheet_1, R.drawable.emoji_google_sheet_2, R.drawable.emoji_google_sheet_3, R.drawable.emoji_google_sheet_4, R.drawable.emoji_google_sheet_5, R.drawable.emoji_google_sheet_6, R.drawable.emoji_google_sheet_7, R.drawable.emoji_google_sheet_8, R.drawable.emoji_google_sheet_9, R.drawable.emoji_google_sheet_10, R.drawable.emoji_google_sheet_11, R.drawable.emoji_google_sheet_12, R.drawable.emoji_google_sheet_13, R.drawable.emoji_google_sheet_14, R.drawable.emoji_google_sheet_15, R.drawable.emoji_google_sheet_16, R.drawable.emoji_google_sheet_17, R.drawable.emoji_google_sheet_18, R.drawable.emoji_google_sheet_19, R.drawable.emoji_google_sheet_20, R.drawable.emoji_google_sheet_21, R.drawable.emoji_google_sheet_22, R.drawable.emoji_google_sheet_23, R.drawable.emoji_google_sheet_24, R.drawable.emoji_google_sheet_25, R.drawable.emoji_google_sheet_26, R.drawable.emoji_google_sheet_27, R.drawable.emoji_google_sheet_28, R.drawable.emoji_google_sheet_29, R.drawable.emoji_google_sheet_30, R.drawable.emoji_google_sheet_31, R.drawable.emoji_google_sheet_32, R.drawable.emoji_google_sheet_33, R.drawable.emoji_google_sheet_34, R.drawable.emoji_google_sheet_35, R.drawable.emoji_google_sheet_36, R.drawable.emoji_google_sheet_37, R.drawable.emoji_google_sheet_38, R.drawable.emoji_google_sheet_39, R.drawable.emoji_google_sheet_40, R.drawable.emoji_google_sheet_41, R.drawable.emoji_google_sheet_42, R.drawable.emoji_google_sheet_43, R.drawable.emoji_google_sheet_44, R.drawable.emoji_google_sheet_45, R.drawable.emoji_google_sheet_46, R.drawable.emoji_google_sheet_47, R.drawable.emoji_google_sheet_48, R.drawable.emoji_google_sheet_49, R.drawable.emoji_google_sheet_50, R.drawable.emoji_google_sheet_51, R.drawable.emoji_google_sheet_52, R.drawable.emoji_google_sheet_53, R.drawable.emoji_google_sheet_54, R.drawable.emoji_google_sheet_55, R.drawable.emoji_google_sheet_56, R.drawable.emoji_google_sheet_57, R.drawable.emoji_google_sheet_58, R.drawable.emoji_google_sheet_59};
        SHEETS = CollectionsKt.listOf((Object[])objectArray);
        LOCK = new Object();
        STRIP_REFS = new SoftReference[60];
        BITMAP_CACHE = new LruCache(100);
        for (int i = 0; i < 60; ++i) {
            GoogleEmojiProvider.STRIP_REFS[i] = new SoftReference<Object>(null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/vanniktech/emoji/google/GoogleEmojiProvider$Companion;", "", "()V", "BITMAP_CACHE", "Landroid/util/LruCache;", "Landroid/graphics/Point;", "Landroid/graphics/Bitmap;", "CACHE_SIZE", "", "LOCK", "NUM_STRIPS", "SHEETS", "", "SPRITE_SIZE", "SPRITE_SIZE_INC_BORDER", "STRIP_REFS", "", "Ljava/lang/ref/SoftReference;", "[Ljava/lang/ref/SoftReference;", "emoji-google_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

