/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.androidxemoji2;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Spannable;
import androidx.emoji2.text.EmojiCompat;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiAndroidProvider;
import com.vanniktech.emoji.EmojiCategory;
import com.vanniktech.emoji.EmojiProvider;
import com.vanniktech.emoji.EmojiReplacer;
import com.vanniktech.emoji.androidxemoji2.AndroidxEmoji2Drawable;
import com.vanniktech.emoji.androidxemoji2.R;
import com.vanniktech.emoji.androidxemoji2.category.ActivitiesCategory;
import com.vanniktech.emoji.androidxemoji2.category.AnimalsAndNatureCategory;
import com.vanniktech.emoji.androidxemoji2.category.FlagsCategory;
import com.vanniktech.emoji.androidxemoji2.category.FoodAndDrinkCategory;
import com.vanniktech.emoji.androidxemoji2.category.ObjectsCategory;
import com.vanniktech.emoji.androidxemoji2.category.SmileysAndPeopleCategory;
import com.vanniktech.emoji.androidxemoji2.category.SymbolsCategory;
import com.vanniktech.emoji.androidxemoji2.category.TravelAndPlacesCategory;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0016J*\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/vanniktech/emoji/androidxemoji2/AndroidxEmoji2Provider;", "Lcom/vanniktech/emoji/EmojiProvider;", "Lcom/vanniktech/emoji/EmojiAndroidProvider;", "Lcom/vanniktech/emoji/EmojiReplacer;", "emojiCompat", "Landroidx/emoji2/text/EmojiCompat;", "<init>", "(Landroidx/emoji2/text/EmojiCompat;)V", "categories", "", "Lcom/vanniktech/emoji/EmojiCategory;", "getCategories", "()[Lcom/vanniktech/emoji/EmojiCategory;", "getIcon", "", "emojiCategory", "replaceWithImages", "", "context", "Landroid/content/Context;", "text", "Landroid/text/Spannable;", "emojiSize", "", "fallback", "getDrawable", "Landroid/graphics/drawable/Drawable;", "emoji", "Lcom/vanniktech/emoji/Emoji;", "release", "emoji-androidx-emoji2_release"})
public final class AndroidxEmoji2Provider
implements EmojiProvider,
EmojiAndroidProvider,
EmojiReplacer {
    @NotNull
    private final EmojiCompat emojiCompat;

    public AndroidxEmoji2Provider(@NotNull EmojiCompat emojiCompat) {
        Intrinsics.checkNotNullParameter((Object)emojiCompat, (String)"emojiCompat");
        this.emojiCompat = emojiCompat;
    }

    @NotNull
    public EmojiCategory[] getCategories() {
        EmojiCategory[] emojiCategoryArray = new EmojiCategory[]{new SmileysAndPeopleCategory(), new AnimalsAndNatureCategory(), new FoodAndDrinkCategory(), new ActivitiesCategory(), new TravelAndPlacesCategory(), new ObjectsCategory(), new SymbolsCategory(), new FlagsCategory()};
        return emojiCategoryArray;
    }

    public int getIcon(@NotNull EmojiCategory emojiCategory) {
        int n;
        Intrinsics.checkNotNullParameter((Object)emojiCategory, (String)"emojiCategory");
        EmojiCategory emojiCategory2 = emojiCategory;
        if (emojiCategory2 instanceof SmileysAndPeopleCategory) {
            n = R.drawable.emoji_androidxemoji2_category_smileysandpeople;
        } else if (emojiCategory2 instanceof AnimalsAndNatureCategory) {
            n = R.drawable.emoji_androidxemoji2_category_animalsandnature;
        } else if (emojiCategory2 instanceof FoodAndDrinkCategory) {
            n = R.drawable.emoji_androidxemoji2_category_foodanddrink;
        } else if (emojiCategory2 instanceof ActivitiesCategory) {
            n = R.drawable.emoji_androidxemoji2_category_activities;
        } else if (emojiCategory2 instanceof TravelAndPlacesCategory) {
            n = R.drawable.emoji_androidxemoji2_category_travelandplaces;
        } else if (emojiCategory2 instanceof ObjectsCategory) {
            n = R.drawable.emoji_androidxemoji2_category_objects;
        } else if (emojiCategory2 instanceof SymbolsCategory) {
            n = R.drawable.emoji_androidxemoji2_category_symbols;
        } else if (emojiCategory2 instanceof FlagsCategory) {
            n = R.drawable.emoji_androidxemoji2_category_flags;
        } else {
            throw new IllegalStateException(("Unknown " + emojiCategory).toString());
        }
        return n;
    }

    public void replaceWithImages(@NotNull Context context, @NotNull Spannable text, float emojiSize, @Nullable EmojiReplacer fallback) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            EmojiCompat emojiCompat = EmojiCompat.get();
            Intrinsics.checkNotNullExpressionValue((Object)emojiCompat, (String)"get(...)");
            EmojiCompat emojiCompat2 = emojiCompat;
            if (emojiCompat2.getLoadState() == 1 && emojiCompat2.process((CharSequence)text, 0, text.length()) == text) break block1;
            EmojiReplacer emojiReplacer = fallback;
            if (emojiReplacer != null) {
                emojiReplacer.replaceWithImages(context, text, emojiSize, null);
            }
        }
    }

    @NotNull
    public Drawable getDrawable(@NotNull Emoji emoji, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new AndroidxEmoji2Drawable(emoji.getUnicode());
    }

    public void release() {
    }
}

