/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.androidxemoji2;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Spanned;
import android.text.TextPaint;
import androidx.emoji2.text.EmojiCompat;
import androidx.emoji2.text.EmojiSpan;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/vanniktech/emoji/androidxemoji2/AndroidxEmoji2Drawable;", "Landroid/graphics/drawable/Drawable;", "unicode", "", "<init>", "(Ljava/lang/String;)V", "emojiSpan", "Landroidx/emoji2/text/EmojiSpan;", "processed", "", "emojiCharSequence", "", "textPaint", "Landroid/text/TextPaint;", "process", "", "draw", "canvas", "Landroid/graphics/Canvas;", "setAlpha", "alpha", "", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "Companion", "emoji-androidx-emoji2_release"})
public final class AndroidxEmoji2Drawable
extends Drawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private EmojiSpan emojiSpan;
    private boolean processed;
    @Nullable
    private CharSequence emojiCharSequence;
    @NotNull
    private final TextPaint textPaint;
    private static final float TEXT_SIZE_FACTOR = 0.8f;
    private static final float BASELINE_OFFSET_FACTOR = 0.225f;

    /*
     * WARNING - void declaration
     */
    public AndroidxEmoji2Drawable(@NotNull String unicode) {
        void $this$textPaint_u24lambda_u240;
        TextPaint textPaint;
        Intrinsics.checkNotNullParameter((Object)unicode, (String)"unicode");
        this.emojiCharSequence = unicode;
        TextPaint textPaint2 = textPaint = new TextPaint();
        AndroidxEmoji2Drawable androidxEmoji2Drawable = this;
        boolean bl = false;
        $this$textPaint_u24lambda_u240.setStyle(Paint.Style.FILL);
        $this$textPaint_u24lambda_u240.setColor(-1);
        $this$textPaint_u24lambda_u240.setAntiAlias(true);
        androidxEmoji2Drawable.textPaint = textPaint;
    }

    private final void process() {
        CharSequence sequence;
        this.emojiCharSequence = sequence = EmojiCompat.get().process(this.emojiCharSequence);
        if (sequence instanceof Spanned) {
            EmojiSpan[] spans = (EmojiSpan[])((Spanned)sequence).getSpans(0, ((Spanned)sequence).length(), EmojiSpan.class);
            Intrinsics.checkNotNull((Object)spans);
            if (!(spans.length == 0)) {
                EmojiSpan emojiSpan = spans[0];
                Intrinsics.checkNotNull((Object)emojiSpan, (String)"null cannot be cast to non-null type androidx.emoji2.text.EmojiSpan");
                this.emojiSpan = emojiSpan;
            }
        }
    }

    public void draw(@NotNull Canvas canvas) {
        CharSequence sequence;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"getBounds(...)");
        Rect bounds = rect;
        this.textPaint.setTextSize((float)bounds.height() * 0.8f);
        int y = MathKt.roundToInt((float)((float)bounds.bottom - (float)bounds.height() * 0.225f));
        if (!this.processed && EmojiCompat.get().getLoadState() != 0) {
            this.processed = true;
            if (EmojiCompat.get().getLoadState() != 2) {
                this.process();
            }
        }
        if ((sequence = this.emojiCharSequence) != null) {
            if (this.emojiSpan == null) {
                canvas.drawText(sequence, 0, sequence.length(), (float)bounds.left, (float)y, (Paint)this.textPaint);
            } else {
                EmojiSpan emojiSpan = this.emojiSpan;
                Intrinsics.checkNotNull((Object)emojiSpan);
                emojiSpan.draw(canvas, sequence, 0, sequence.length(), (float)bounds.left, bounds.top, y, bounds.bottom, (Paint)this.textPaint);
            }
        }
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.textPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return 0;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/vanniktech/emoji/androidxemoji2/AndroidxEmoji2Drawable$Companion;", "", "<init>", "()V", "TEXT_SIZE_FACTOR", "", "BASELINE_OFFSET_FACTOR", "emoji-androidx-emoji2_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

