/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.variant;

import android.content.Context;
import android.content.SharedPreferences;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.Emojis;
import com.vanniktech.emoji.variant.VariantEmoji;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0016J\b\u0010\u0015\u001a\u00020\u0013H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002R\u0018\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/vanniktech/emoji/variant/VariantEmojiManager;", "Lcom/vanniktech/emoji/variant/VariantEmoji;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "preferences", "Landroid/content/SharedPreferences;", "kotlin.jvm.PlatformType", "Landroid/content/SharedPreferences;", "variantsList", "", "Lcom/vanniktech/emoji/Emoji;", "getVariant", "desiredEmoji", "getVariants", "", "emoji", "addVariant", "", "newVariant", "persist", "initFromSharedPreferences", "Companion", "emoji_release"})
@SourceDebugExtension(value={"SMAP\nVariantEmojiManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VariantEmojiManager.kt\ncom/vanniktech/emoji/variant/VariantEmojiManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,95:1\n295#2,2:96\n1611#2,9:98\n1863#2:107\n1864#2:109\n1620#2:110\n1#3:108\n*S KotlinDebug\n*F\n+ 1 VariantEmojiManager.kt\ncom/vanniktech/emoji/variant/VariantEmojiManager\n*L\n36#1:96,2\n83#1:98,9\n83#1:107\n83#1:109\n83#1:110\n83#1:108\n*E\n"})
public final class VariantEmojiManager
implements VariantEmoji {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final SharedPreferences preferences;
    @NotNull
    private List<Emoji> variantsList;
    @NotNull
    private static final String PREFERENCE_NAME = "variant-emoji-manager";
    @NotNull
    private static final String EMOJI_DELIMITER = "~";
    @NotNull
    private static final String VARIANT_EMOJIS = "variant-emojis";
    private static final int EMOJI_GUESS_SIZE = 5;

    public VariantEmojiManager(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.preferences = context.getApplicationContext().getSharedPreferences(PREFERENCE_NAME, 0);
        this.variantsList = new ArrayList();
    }

    @Override
    @NotNull
    public Emoji getVariant(@NotNull Emoji desiredEmoji) {
        Emoji emoji;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)desiredEmoji, (String)"desiredEmoji");
            if (this.variantsList.isEmpty()) {
                this.initFromSharedPreferences();
            }
            Emoji baseEmoji = desiredEmoji.getBase();
            Iterable $this$firstOrNull$iv = this.variantsList;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Emoji it = (Emoji)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getBase(), (Object)baseEmoji)) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((emoji = (Emoji)v0) == null) {
            emoji = desiredEmoji;
        }
        return emoji;
    }

    @Override
    @NotNull
    public List<Emoji> getVariants(@NotNull Emoji emoji) {
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        if (Emojis.isVariantSelector16(emoji)) {
            return CollectionsKt.emptyList();
        }
        return emoji.getVariants();
    }

    @Override
    public void addVariant(@NotNull Emoji newVariant) {
        Intrinsics.checkNotNullParameter((Object)newVariant, (String)"newVariant");
        Emoji newVariantBase = newVariant.getBase();
        int n = ((Collection)this.variantsList).size();
        for (int i = 0; i < n; ++i) {
            Emoji variant = this.variantsList.get(i);
            if (!Intrinsics.areEqual((Object)variant.getBase(), (Object)newVariantBase)) continue;
            if (Intrinsics.areEqual((Object)variant, (Object)newVariant)) {
                return;
            }
            this.variantsList.remove(i);
            this.variantsList.add(newVariant);
            return;
        }
        this.variantsList.add(newVariant);
    }

    @Override
    public void persist() {
        if (this.variantsList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.variantsList.size() * 5);
            int n = ((Collection)this.variantsList).size();
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.variantsList.get(i).getUnicode()).append(EMOJI_DELIMITER);
            }
            stringBuilder.setLength(stringBuilder.length() - 1);
            this.preferences.edit().putString(VARIANT_EMOJIS, stringBuilder.toString()).apply();
        } else {
            this.preferences.edit().remove(VARIANT_EMOJIS).apply();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initFromSharedPreferences() {
        String savedRecentVariants;
        String string2 = this.preferences.getString(VARIANT_EMOJIS, "");
        if (string2 == null) {
            string2 = "";
        }
        if (((CharSequence)(savedRecentVariants = string2)).length() > 0) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Object object = new String[]{EMOJI_DELIMITER};
            object = StringsKt.split$default((CharSequence)savedRecentVariants, (String[])object, (boolean)false, (int)0, (int)6, null);
            VariantEmojiManager variantEmojiManager = this;
            boolean $i$f$mapNotNull = false;
            void var4_5 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Emoji it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                if (EmojiManager.INSTANCE.findEmoji$emoji_release(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            variantEmojiManager.variantsList = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vanniktech/emoji/variant/VariantEmojiManager$Companion;", "", "<init>", "()V", "PREFERENCE_NAME", "", "EMOJI_DELIMITER", "VARIANT_EMOJIS", "EMOJI_GUESS_SIZE", "", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

