/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.traits;

import android.view.View;
import android.widget.EditText;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.vanniktech.emoji.EmojiPopup;
import com.vanniktech.emoji.traits.EmojiTrait;
import com.vanniktech.emoji.traits.EmojiTraitable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\nB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/vanniktech/emoji/traits/DisableKeyboardInputTrait;", "Lcom/vanniktech/emoji/traits/EmojiTraitable;", "emojiPopup", "Lcom/vanniktech/emoji/EmojiPopup;", "<init>", "(Lcom/vanniktech/emoji/EmojiPopup;)V", "install", "Lcom/vanniktech/emoji/traits/EmojiTrait;", "editText", "Landroid/widget/EditText;", "ForceEmojisOnlyFocusChangeListener", "emoji_release"})
public final class DisableKeyboardInputTrait
implements EmojiTraitable {
    @NotNull
    private final EmojiPopup emojiPopup;

    public DisableKeyboardInputTrait(@NotNull EmojiPopup emojiPopup) {
        Intrinsics.checkNotNullParameter((Object)emojiPopup, (String)"emojiPopup");
        this.emojiPopup = emojiPopup;
    }

    @Override
    @NotNull
    public EmojiTrait install(@NotNull EditText editText) {
        boolean isKeyboardOpen;
        Intrinsics.checkNotNullParameter((Object)editText, (String)"editText");
        ForceEmojisOnlyFocusChangeListener forceEmojisOnlyFocusChangeListener = new ForceEmojisOnlyFocusChangeListener(editText.getOnFocusChangeListener(), this.emojiPopup);
        editText.setOnFocusChangeListener((View.OnFocusChangeListener)forceEmojisOnlyFocusChangeListener);
        WindowInsetsCompat windowInsetsCompat = ViewCompat.getRootWindowInsets((View)editText.getRootView());
        boolean bl = windowInsetsCompat != null ? windowInsetsCompat.isVisible(WindowInsetsCompat.Type.ime()) : (isKeyboardOpen = false);
        if (editText.hasFocus() || isKeyboardOpen) {
            forceEmojisOnlyFocusChangeListener.focus$emoji_release();
        }
        return new EmojiTrait(editText, forceEmojisOnlyFocusChangeListener){
            final /* synthetic */ EditText $editText;
            final /* synthetic */ ForceEmojisOnlyFocusChangeListener $forceEmojisOnlyFocusChangeListener;
            {
                this.$editText = $editText;
                this.$forceEmojisOnlyFocusChangeListener = $forceEmojisOnlyFocusChangeListener;
            }

            public void uninstall() {
                this.$editText.setOnFocusChangeListener(this.$forceEmojisOnlyFocusChangeListener.getDelegate$emoji_release());
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\r\u0010\u000f\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\u0010R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/vanniktech/emoji/traits/DisableKeyboardInputTrait$ForceEmojisOnlyFocusChangeListener;", "Landroid/view/View$OnFocusChangeListener;", "delegate", "emojiPopup", "Lcom/vanniktech/emoji/EmojiPopup;", "<init>", "(Landroid/view/View$OnFocusChangeListener;Lcom/vanniktech/emoji/EmojiPopup;)V", "getDelegate$emoji_release", "()Landroid/view/View$OnFocusChangeListener;", "onFocusChange", "", "view", "Landroid/view/View;", "hasFocus", "", "focus", "focus$emoji_release", "emoji_release"})
    public static final class ForceEmojisOnlyFocusChangeListener
    implements View.OnFocusChangeListener {
        @Nullable
        private final View.OnFocusChangeListener delegate;
        @NotNull
        private final EmojiPopup emojiPopup;

        public ForceEmojisOnlyFocusChangeListener(@Nullable View.OnFocusChangeListener delegate, @NotNull EmojiPopup emojiPopup) {
            Intrinsics.checkNotNullParameter((Object)emojiPopup, (String)"emojiPopup");
            this.delegate = delegate;
            this.emojiPopup = emojiPopup;
        }

        @Nullable
        public final View.OnFocusChangeListener getDelegate$emoji_release() {
            return this.delegate;
        }

        public void onFocusChange(@NotNull View view, boolean hasFocus) {
            block2: {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                if (hasFocus) {
                    this.emojiPopup.start$emoji_release();
                    this.emojiPopup.show();
                } else {
                    this.emojiPopup.dismiss();
                }
                View.OnFocusChangeListener onFocusChangeListener = this.delegate;
                if (onFocusChangeListener == null) break block2;
                onFocusChangeListener.onFocusChange(view, hasFocus);
            }
        }

        public final void focus$emoji_release() {
            if (!this.emojiPopup.isShowing()) {
                this.emojiPopup.start$emoji_release();
                this.emojiPopup.show();
            }
        }
    }
}

