/*
 * Decompiled with CFR 0.152.
 */
package com.vanniktech.emoji.internal;

import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.vanniktech.emoji.Emoji;
import com.vanniktech.emoji.EmojiManager;
import com.vanniktech.emoji.R;
import com.vanniktech.emoji.internal.EmojiImageView;
import com.vanniktech.emoji.internal.EmojiVariantDelegate;
import com.vanniktech.emoji.internal.Utils;
import com.vanniktech.emoji.internal.UtilsKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011J\u0006\u0010\u0012\u001a\u00020\u000bJ6\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/vanniktech/emoji/internal/EmojiVariantPopup;", "", "rootView", "Landroid/view/View;", "delegate", "Lcom/vanniktech/emoji/internal/EmojiVariantDelegate;", "<init>", "(Landroid/view/View;Lcom/vanniktech/emoji/internal/EmojiVariantDelegate;)V", "popupWindow", "Landroid/widget/PopupWindow;", "show", "", "clickedImage", "Lcom/vanniktech/emoji/internal/EmojiImageView;", "emoji", "Lcom/vanniktech/emoji/Emoji;", "variants", "", "dismiss", "initView", "context", "Landroid/content/Context;", "width", "", "Companion", "emoji_release"})
public final class EmojiVariantPopup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View rootView;
    @Nullable
    private final EmojiVariantDelegate delegate;
    @Nullable
    private PopupWindow popupWindow;
    private static final int MARGIN = 2;

    public EmojiVariantPopup(@NotNull View rootView, @Nullable EmojiVariantDelegate delegate) {
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        this.rootView = rootView;
        this.delegate = delegate;
    }

    /*
     * WARNING - void declaration
     */
    public final void show(@NotNull EmojiImageView clickedImage, @NotNull Emoji emoji, @NotNull List<? extends Emoji> variants) {
        void $this$show_u24lambda_u240;
        PopupWindow popupWindow;
        Intrinsics.checkNotNullParameter((Object)((Object)clickedImage), (String)"clickedImage");
        Intrinsics.checkNotNullParameter((Object)emoji, (String)"emoji");
        Intrinsics.checkNotNullParameter(variants, (String)"variants");
        this.dismiss();
        Context context = clickedImage.getContext();
        Intrinsics.checkNotNull((Object)context);
        View content = this.initView(context, emoji, variants, clickedImage.getWidth(), clickedImage);
        content.measure(View.MeasureSpec.makeMeasureSpec((int)0, (int)0), View.MeasureSpec.makeMeasureSpec((int)0, (int)0));
        Point location = Utils.INSTANCE.locationOnScreen$emoji_release((View)clickedImage);
        Point desiredLocation = new Point(location.x - content.getMeasuredWidth() / 2 + clickedImage.getWidth() / 2, location.y - content.getMeasuredHeight());
        PopupWindow popupWindow2 = popupWindow = new PopupWindow(content, -2, -2);
        EmojiVariantPopup emojiVariantPopup = this;
        boolean bl = false;
        $this$show_u24lambda_u240.setFocusable(true);
        $this$show_u24lambda_u240.setOutsideTouchable(true);
        $this$show_u24lambda_u240.setInputMethodMode(2);
        $this$show_u24lambda_u240.setBackgroundDrawable((Drawable)new BitmapDrawable(context.getResources(), null));
        $this$show_u24lambda_u240.showAtLocation(this.rootView, 0, desiredLocation.x, desiredLocation.y);
        Utils.INSTANCE.fixPopupLocation$emoji_release((PopupWindow)$this$show_u24lambda_u240, desiredLocation);
        emojiVariantPopup.popupWindow = popupWindow;
        clickedImage.getParent().requestDisallowInterceptTouchEvent(true);
    }

    public final void dismiss() {
        PopupWindow popupWindow = this.popupWindow;
        if (popupWindow != null) {
            popupWindow.dismiss();
        }
        this.popupWindow = null;
    }

    private final View initView(Context context, Emoji emoji, List<? extends Emoji> variants, int width, EmojiImageView clickedImage) {
        View result = View.inflate((Context)context, (int)R.layout.emoji_popup_window_skin, null);
        LinearLayout imageContainer = (LinearLayout)result.findViewById(R.id.emojiPopupWindowSkinPopupContainer);
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        List emojis = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)emoji), (Iterable)variants);
        for (Emoji variant : emojis) {
            View view = inflater.inflate(R.layout.emoji_adapter_item_emoji, (ViewGroup)imageContainer, false);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.ImageView");
            ImageView emojiImage = (ImageView)view;
            ViewGroup.LayoutParams layoutParams = emojiImage.getLayoutParams();
            Intrinsics.checkNotNull((Object)layoutParams, (String)"null cannot be cast to non-null type android.view.ViewGroup.MarginLayoutParams");
            ViewGroup.MarginLayoutParams layoutParams2 = (ViewGroup.MarginLayoutParams)layoutParams;
            int margin = Utils.INSTANCE.dpToPx$emoji_release(context, 2.0f);
            layoutParams2.width = width;
            layoutParams2.setMargins(margin, margin, margin, margin);
            emojiImage.setImageDrawable(UtilsKt.emojiDrawableProvider(EmojiManager.INSTANCE).getDrawable(variant, context));
            emojiImage.setOnClickListener(arg_0 -> EmojiVariantPopup.initView$lambda$1(this, clickedImage, variant, arg_0));
            imageContainer.addView((View)emojiImage);
        }
        Intrinsics.checkNotNull((Object)result);
        return result;
    }

    private static final void initView$lambda$1(EmojiVariantPopup this$0, EmojiImageView $clickedImage, Emoji $variant, View it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)((Object)$clickedImage), (String)"$clickedImage");
            Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
            EmojiVariantDelegate emojiVariantDelegate = this$0.delegate;
            if (emojiVariantDelegate == null) break block0;
            emojiVariantDelegate.onEmojiClick($clickedImage, $variant);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vanniktech/emoji/internal/EmojiVariantPopup$Companion;", "", "<init>", "()V", "MARGIN", "", "emoji_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

